/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.jdevimpl.runner.debug.JDebugger;

final class SavedBreakpoints {
    static final String FILENAME = "breakpoints.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"breakpoints");
    static final String ROOT_TAG = "breakpoints";
    private ArrayList _breakpoints = new ArrayList();

    SavedBreakpoints() {
    }

    ArrayList getBreakpoints() {
        return this._breakpoints;
    }

    boolean save() {
        boolean success = false;
        try {
            URL url = SavedBreakpoints.getXMLURL();
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(NAMESPACE_URI);
            o2d.toDocument((Object)this._breakpoints, ROOT_TAG, url);
            success = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return success;
    }

    boolean load() {
        boolean success = false;
        try {
            URL url = SavedBreakpoints.getXMLURL();
            Object2Dom o2d = Object2Dom.newInstance();
            ArrayList breakpoints = (ArrayList)o2d.toObject(url);
            this._breakpoints.clear();
            this._breakpoints.addAll(breakpoints);
            success = true;
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._breakpoints.clear();
        }
        return success;
    }

    static URL getXMLURL() {
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        URL url = er.getSystemDirectory(JDebugger.getExtensionID());
        return URLFactory.newURL((URL)url, (String)FILENAME);
    }
}

