/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.runner.debug.JDebugger;

final class ObjectPreferences {
    static final String FILENAME = "debuggerObjectPreferences.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-object-preferences");
    static final String ROOT_TAG = "debugger-object-preferences";
    static final String DATAFILTERS_FILENAME = "dataFilters.xml";
    static final String DATAFILTERS_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-data-filters");
    static final String DATAFILTERS_ROOT_TAG = "data-filters";
    static final String DATAVALUES_FILENAME = "dataValues.xml";
    static final String DATAVALUES_NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"debugger-data-values");
    static final String DATAVALUES_ROOT_TAG = "data-values";
    static final String REMOVE_ENTRY = "debugger-object-preferences-remove-entry";
    private TreeMap _valueExpressions = new TreeMap();
    private TreeMap _valueExpressionSuggestions = new TreeMap();
    private TreeMap _hiddenFields = new TreeMap();
    private TreeSet _hideAllFields = new TreeSet();
    private TreeMap _expandExpressions = new TreeMap();
    private TreeMap _expandExpressionSuggestions = new TreeMap();
    private HashMap<String, String> _icons = new HashMap();
    private HashMap<String, Icon> _cachedIcons = new HashMap();
    private TreeMap _changedValueExpressions;
    private TreeMap _changedValueExpressionSuggestions;
    private TreeMap _changedHiddenFields;
    private TreeSet _changedHideAllFields;
    private TreeMap _changedExpandExpressions;
    private TreeMap _changedExpandExpressionSuggestions;
    private static String EXPAND_EXPRESSION_DELIMITERS = ";";

    ObjectPreferences() {
        this.loadChangedSettings();
    }

    TreeMap deepCloneValueExpressions() {
        return this.deepCloneExpressions(this._valueExpressions, this._changedValueExpressions);
    }

    void setChangedValueExpressions(TreeMap valueExpressions) {
        this._changedValueExpressions = this.setChangedExpressions(this._valueExpressions, valueExpressions);
    }

    private String getValueExpression(String className) {
        return this.getExpression(className, this._valueExpressions, this._changedValueExpressions);
    }

    String getValueExpression(DebugDataObjectInfo dataObject) {
        for (DebugClassInfo clazz = dataObject.getClassInfo(); clazz != null; clazz = clazz.getSuperClass(1)) {
            String className = clazz.getName();
            String expression = this.getValueExpression(className);
            if (expression != null) {
                return expression;
            }
            DebugClassInfo[] interfaces = clazz.getInterfaces();
            if (interfaces == null) continue;
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                String interfaceName = interfaces[i].getName();
                expression = this.getValueExpression(interfaceName);
                if (expression == null) continue;
                return expression;
            }
        }
        return null;
    }

    void setValueExpression(String className, String expression) {
        this._valueExpressions.put(className, expression);
    }

    String[] getValueExpressionSuggestions(String className) {
        return this.getSuggestions(className, this._valueExpressionSuggestions, this._changedValueExpressionSuggestions);
    }

    void addValueExpressionSuggestion(String className, String suggestion) {
        this.addSuggestion(this._valueExpressionSuggestions, className, suggestion);
    }

    void addChangedValueExpressionSuggestion(String className, String suggestion) {
        this.addSuggestion(this._changedValueExpressionSuggestions, className, suggestion);
    }

    boolean isHiddenFieldsEmpty() {
        return this._hiddenFields.isEmpty() && this._changedHiddenFields.isEmpty();
    }

    TreeMap deepCloneHiddenFields() {
        TreeMap<String, String[]> clone = new TreeMap<String, String[]>();
        for (String className : this._hiddenFields.keySet()) {
            String[] array = (String[])this._hiddenFields.get(className);
            String[] changedArray = (String[])this._changedHiddenFields.get(className);
            if (changedArray == null) {
                clone.put(className, array);
                continue;
            }
            if (changedArray.length == 0) continue;
            clone.put(className, changedArray);
        }
        for (String className : this._changedHiddenFields.keySet()) {
            String[] userArray;
            if (this._hiddenFields.get(className) != null || (userArray = (String[])this._changedHiddenFields.get(className)).length <= 0) continue;
            clone.put(className, userArray);
        }
        return clone;
    }

    void setChangedHiddenFields(TreeMap changedHiddenFields) {
        for (String className : this._hiddenFields.keySet()) {
            if (changedHiddenFields.get(className) != null) continue;
            changedHiddenFields.put(className, new String[0]);
        }
        this._changedHiddenFields = changedHiddenFields;
    }

    List getHiddenFields(String className) {
        String[] finalArray = null;
        String[] userArray = (String[])this._changedHiddenFields.get(className);
        if (userArray == null) {
            finalArray = (String[])this._hiddenFields.get(className);
        } else if (userArray.length > 0) {
            finalArray = userArray;
        }
        if (finalArray != null) {
            return Arrays.asList(finalArray);
        }
        return null;
    }

    void addHideField(String className, String fieldName) {
        String[] fieldNames = (String[])this._hiddenFields.get(className);
        if (fieldNames == null) {
            fieldNames = new String[]{className};
        } else {
            HashSet<String> fields = new HashSet<String>();
            for (String name : fieldNames) {
                fields.add(name);
            }
            fields.add(fieldName);
            fieldNames = fields.toArray(new String[fields.size()]);
        }
        this._hiddenFields.put(className, fieldNames);
    }

    boolean isHideAllFieldsEmpty() {
        return this._hideAllFields.isEmpty() && this._changedHideAllFields.isEmpty();
    }

    TreeSet deepCloneHideAllFields() {
        TreeSet<String> clone = new TreeSet<String>();
        for (String className : this._hideAllFields) {
            if (this._changedHideAllFields.contains(REMOVE_ENTRY + className)) continue;
            clone.add(className);
        }
        for (String className : this._changedHideAllFields) {
            if (className.startsWith(REMOVE_ENTRY) || this._hideAllFields.contains(className)) continue;
            clone.add(className);
        }
        return clone;
    }

    void setChangedHideAllFields(TreeSet hideAllFields) {
        for (String className : this._hideAllFields) {
            if (hideAllFields.contains(className)) continue;
            hideAllFields.add(REMOVE_ENTRY + className);
        }
        this._changedHideAllFields = hideAllFields;
    }

    void addHideAllFields(String className) {
        this._hideAllFields.add(className);
    }

    private boolean getHideAllFields(String className) {
        if (this._changedHideAllFields.contains(REMOVE_ENTRY + className)) {
            return false;
        }
        if (this._changedHideAllFields.contains(className)) {
            return true;
        }
        return this._hideAllFields.contains(className);
    }

    boolean getHideAllFields(DebugDataObjectInfo dataObject) {
        if (!this.isHideAllFieldsEmpty()) {
            for (DebugClassInfo clazz = dataObject.getClassInfo(); clazz != null; clazz = clazz.getSuperClass(1)) {
                String className = clazz.getName();
                if (this.getHideAllFields(className)) {
                    return true;
                }
                DebugClassInfo[] interfaces = clazz.getInterfaces();
                if (interfaces == null) continue;
                int length = interfaces.length;
                for (int i = 0; i < length; ++i) {
                    String interfaceName = interfaces[i].getName();
                    if (!this.getHideAllFields(interfaceName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    TreeMap deepCloneExpandExpressions() {
        return this.deepCloneExpressions(this._expandExpressions, this._changedExpandExpressions);
    }

    void setChangedExpandExpressions(TreeMap expandExpressions) {
        this._changedExpandExpressions = this.setChangedExpressions(this._expandExpressions, expandExpressions);
    }

    private String getExpandExpression(String className) {
        return this.getExpression(className, this._expandExpressions, this._changedExpandExpressions);
    }

    String getExpandExpression(DebugDataObjectInfo dataObject) {
        for (DebugClassInfo clazz = dataObject.getClassInfo(); clazz != null; clazz = clazz.getSuperClass(1)) {
            String className = clazz.getName();
            String expression = this.getExpandExpression(className);
            if (expression != null) {
                return expression;
            }
            DebugClassInfo[] interfaces = clazz.getInterfaces();
            if (interfaces == null) continue;
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                String interfaceName = interfaces[i].getName();
                expression = this.getExpandExpression(interfaceName);
                if (expression == null) continue;
                return expression;
            }
        }
        return null;
    }

    void setExpandExpression(String className, String expression) {
        this._expandExpressions.put(className, expression);
    }

    String[] getExpandExpressionSuggestions(String className) {
        return this.getSuggestions(className, this._expandExpressionSuggestions, this._changedExpandExpressionSuggestions);
    }

    void addExpandExpressionSuggestion(String className, String suggestion) {
        this.addSuggestion(this._expandExpressionSuggestions, className, suggestion);
    }

    void addChangedExpandExpressionSuggestion(String className, String suggestion) {
        this.addSuggestion(this._changedExpandExpressionSuggestions, className, suggestion);
    }

    void addIcon(String className, String iconName) {
        this._icons.put(className, iconName);
    }

    Icon getIcon(String className) {
        String iconName = this._icons.get(className);
        if (iconName != null) {
            URL iconURL;
            Icon icon;
            if (this._cachedIcons.containsKey(iconName)) {
                return this._cachedIcons.get(iconName);
            }
            String loadName = iconName;
            if (loadName.startsWith("res:")) {
                loadName = loadName.substring(4);
            }
            if ((icon = this.loadIcon(iconName, iconURL = this.getClass().getClassLoader().getResource(loadName))) != null) {
                return icon;
            }
            iconURL = URLFactory.newURL((String)iconName);
            icon = this.loadIcon(iconName, iconURL);
            if (icon != null) {
                return icon;
            }
            if (iconName.startsWith("uri:") && (icon = this.loadIcon(loadName = iconName.substring(4), iconURL = URLFactory.newURL((String)loadName))) != null) {
                return icon;
            }
            this._cachedIcons.put(iconName, null);
        }
        return null;
    }

    private Icon loadIcon(String iconName, URL iconURL) {
        if (iconURL != null) {
            ImageIcon icon = new ImageIcon(iconURL);
            this._cachedIcons.put(iconName, icon);
            return icon;
        }
        return null;
    }

    private TreeMap deepCloneExpressions(TreeMap added, TreeMap changed) {
        TreeMap<String, String> clone = new TreeMap<String, String>();
        for (String className : added.keySet()) {
            String value = (String)added.get(className);
            String changedValue = (String)changed.get(className);
            if (changedValue == null) {
                clone.put(className, value);
                continue;
            }
            if (changedValue.equals(REMOVE_ENTRY)) continue;
            clone.put(className, changedValue);
        }
        for (String className : changed.keySet()) {
            String changedValue;
            if (added.get(className) != null || (changedValue = (String)changed.get(className)).equals(REMOVE_ENTRY)) continue;
            clone.put(className, changedValue);
        }
        return clone;
    }

    private TreeMap setChangedExpressions(TreeMap added, TreeMap changed) {
        for (String className : added.keySet()) {
            if (changed.get(className) != null) continue;
            changed.put(className, REMOVE_ENTRY);
        }
        return changed;
    }

    private String getExpression(String className, TreeMap added, TreeMap changed) {
        String value = (String)changed.get(className);
        if (value == null) {
            return (String)added.get(className);
        }
        if (!value.equals(REMOVE_ENTRY)) {
            return value;
        }
        return null;
    }

    private String[] getSuggestions(String className, TreeMap added, TreeMap changed) {
        List addedList;
        ArrayList list = new ArrayList();
        List changedList = (List)changed.get(className);
        if (changedList != null) {
            list.addAll(changedList);
        }
        if ((addedList = (List)added.get(className)) != null) {
            list.addAll(addedList);
        }
        if (list.size() > 0) {
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    private void addSuggestion(TreeMap suggestions, String className, String suggestion) {
        ArrayList<String> list = (ArrayList<String>)suggestions.get(className);
        if (list == null) {
            list = new ArrayList<String>();
            suggestions.put(className, list);
        }
        if (!list.contains(suggestion)) {
            list.add(suggestion);
        }
    }

    static String[] tokenizeExpandExpression(String expression) {
        ArrayList<String> temp = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(expression, EXPAND_EXPRESSION_DELIMITERS);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            temp.add(token);
        }
        return temp.toArray(new String[temp.size()]);
    }

    void saveChangedSettings() {
        try {
            if (this._changedValueExpressions.isEmpty() && this._changedValueExpressionSuggestions.isEmpty() && this._changedHiddenFields.isEmpty() && this._changedHideAllFields.isEmpty() && this._changedExpandExpressions.isEmpty() && this._changedExpandExpressionSuggestions.isEmpty()) {
                return;
            }
            URL url = ObjectPreferences.getXMLURL(FILENAME);
            Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(NAMESPACE_URI);
            Object[] save = new Object[]{this._changedValueExpressions, this._changedValueExpressionSuggestions, this._changedHiddenFields, this._changedHideAllFields, this._changedExpandExpressions, this._changedExpandExpressionSuggestions};
            o2d.toDocument((Object)save, ROOT_TAG, url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadChangedSettings() {
        try {
            this._changedValueExpressions = new TreeMap();
            this._changedValueExpressionSuggestions = new TreeMap();
            this._changedHiddenFields = new TreeMap();
            this._changedHideAllFields = new TreeSet();
            this._changedExpandExpressions = new TreeMap();
            this._changedExpandExpressionSuggestions = new TreeMap();
            URL url = ObjectPreferences.getXMLURL(FILENAME);
            Object2Dom o2d = Object2Dom.newInstance();
            Object[] load = (Object[])o2d.toObject(url);
            int loadLength = load.length;
            if (loadLength > 0 && load[0] instanceof TreeMap) {
                this._changedValueExpressions.putAll((TreeMap)load[0]);
            }
            if (loadLength > 1 && load[1] instanceof TreeMap) {
                this._changedValueExpressionSuggestions.putAll((TreeMap)load[1]);
            }
            if (loadLength > 2 && load[2] instanceof TreeMap) {
                this._changedHiddenFields.putAll((TreeMap)load[2]);
            }
            if (loadLength > 3 && load[3] instanceof TreeSet) {
                this._changedHideAllFields.addAll((TreeSet)load[3]);
            }
            if (loadLength > 4 && load[4] instanceof TreeMap) {
                this._changedExpandExpressions.putAll((TreeMap)load[4]);
            }
            if (loadLength > 5 && load[5] instanceof TreeMap) {
                this._changedExpandExpressionSuggestions.putAll((TreeMap)load[5]);
            }
        }
        catch (FileNotFoundException ex) {
            this.loadDataFilters();
            this.loadDataValues();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void loadDataFilters() {
        try {
            URL url = ObjectPreferences.getXMLURL(DATAFILTERS_FILENAME);
            Object2Dom o2d = Object2Dom.newInstance();
            TreeMap dataFilters = (TreeMap)o2d.toObject(url);
            this._changedHiddenFields.putAll(dataFilters);
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void loadDataValues() {
        try {
            URL url = ObjectPreferences.getXMLURL(DATAVALUES_FILENAME);
            Object2Dom o2d = Object2Dom.newInstance();
            TreeMap dataValues = (TreeMap)o2d.toObject(url);
            this._changedValueExpressions.putAll(dataValues);
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void processFinished() {
        this._cachedIcons.clear();
    }

    private static URL getXMLURL(String filename) {
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        URL url = er.getSystemDirectory(JDebugger.getExtensionID());
        return URLFactory.newURL((URL)url, (String)filename);
    }
}

