/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptStackFrameInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxVariableInfo;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEvaluateExpression;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;

class MozillaFireFoxJavaScriptEvaluator
extends BaseEvaluator {
    public MozillaFireFoxJavaScriptEvaluator(DebugContext debugContext) {
        super(debugContext);
    }

    @Override
    public int evaluateConditionResult(Object o) {
        if (o instanceof DebugDataInfo) {
            DebugDataInfo info = (DebugDataInfo)o;
            return info.getValue() != null ? 1 : 0;
        }
        return -1;
    }

    @Override
    public Object evaluate(String exp) {
        exp = exp.trim();
        DebugMozillaFireFoxJavaScript da = (DebugMozillaFireFoxJavaScript)this.debugContext.vm;
        DebugMozillaFireFoxJavaScriptStackFrameInfo sfi = null;
        if (da != null) {
            sfi = (DebugMozillaFireFoxJavaScriptStackFrameInfo)da.getCurrentStackFrame();
        }
        if (sfi == null) {
            sfi = (DebugMozillaFireFoxJavaScriptStackFrameInfo)da.getCurrentThread().getStackFrame(0);
        }
        if (sfi != null) {
            if (!exp.equals("this") && !exp.equals("this;") && sfi.getThisValueId() != -1L) {
                MozillaFireFoxEvaluateExpression req = da.getRequestManager().createEvaluateExpressionRequest(exp, 3000L, sfi, 0L);
                req.setEnabled(true);
                req.sendSyncRequest();
                if (req.isSuccessful()) {
                    DebugMozillaFireFoxVariableInfo varInfo = new DebugMozillaFireFoxVariableInfo(sfi, exp, true, 0, req.getStringValue(), req.getType(), req.getValueId(), false, false);
                    return varInfo.getDataInfo();
                }
            } else {
                DebugMozillaFireFoxVariableInfo varInfo = new DebugMozillaFireFoxVariableInfo(sfi, exp, true, 0, sfi.getThisString(), sfi.getThisType(), sfi.getThisValueId(), false, false);
                return varInfo.getDataInfo();
            }
        }
        return null;
    }
}

