/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;

final class ModifyValueDialog
extends JPanel
implements ActionListener,
DocumentListener,
ItemListener {
    private static final String JAVA_LANG_BOOLEAN_STRING = "java.lang.Boolean";
    private static final String JAVA_LANG_BYTE_STRING = "java.lang.Byte";
    private static final String JAVA_LANG_CHARACTER_STRING = "java.lang.Character";
    private static final String JAVA_LANG_DOUBLE_STRING = "java.lang.Double";
    private static final String JAVA_LANG_FLOAT_STRING = "java.lang.Float";
    private static final String JAVA_LANG_INTEGER_STRING = "java.lang.Integer";
    private static final String JAVA_LANG_LONG_STRING = "java.lang.Long";
    private static final String JAVA_LANG_SHORT_STRING = "java.lang.Short";
    private JEWTDialog dlg;
    private DebugClassInfo clazz;
    private int primitive;
    private DebugDataInfo data;
    private boolean canSetAddressOfObject;
    private boolean canSetAddressOfObjectToNull;
    private String currentText = null;
    private boolean isEnum = false;
    private boolean isBoolean = false;
    private boolean isByte = false;
    private boolean isCharacter = false;
    private boolean isDouble = false;
    private boolean isFloat = false;
    private boolean isInteger = false;
    private boolean isLong = false;
    private boolean isShort = false;
    private String currentEnumValue;
    private Map<Integer, DebugFieldInfo> enumHashCode2ValuesMap;
    private Map<String, DebugFieldInfo> enumName2ValuesMap;
    private List<String> enumValueNames;
    private HistoryList newValueHistoryList;
    private JComboBox newValueComboBox;
    private JTextField newValueEditor;
    private JCheckBox addressCheckBox;
    private static final String newValueHistoryName = "DebuggerModifyValue";
    private static final int PRIMITIVE_byte = 0;
    private static final int PRIMITIVE_char = 1;
    private static final int PRIMITIVE_double = 2;
    private static final int PRIMITIVE_float = 3;
    private static final int PRIMITIVE_int = 4;
    private static final int PRIMITIVE_long = 5;
    private static final int PRIMITIVE_short = 6;
    private static final int PRIMITIVE_boolean = 7;

    static boolean showModifyValueDialog(String type, String name, String currentValue, String currentAddress, DebugClassInfo clazz, DebugDataInfo data, boolean canModifyDataWithString, boolean canSetAddressOfObject, boolean canSetAddressOfObjectToNull) {
        ModifyValueDialog panel = new ModifyValueDialog(type, name, currentValue, currentAddress, clazz, data, canModifyDataWithString, canSetAddressOfObject, canSetAddressOfObjectToNull);
        String title = DbgArb.getString(539);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.newValueEditor, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_modifyvaluedialog_html");
        return WizardLauncher.runDialog((JDialog)dlg);
    }

    static boolean toggleValue(DebugDataInfo data, String newValue) {
        if (data.modifyDataWithString(newValue)) {
            return true;
        }
        String title = DbgArb.getString(549);
        String[] messages = new String[]{DbgArb.getString(550), DbgArb.getString(551), DbgArb.getString(552)};
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), messages, title, 0);
        return false;
    }

    private ModifyValueDialog(String type, String name, String currentValue, String currentAddress, DebugClassInfo clazz, DebugDataInfo data, boolean canModifyDataWithString, boolean canSetAddressOfObject, boolean canSetAddressOfObjectToNull) {
        super(new GridBagLayout());
        String text;
        this.clazz = clazz;
        this.data = data;
        this.canSetAddressOfObject = canSetAddressOfObject;
        this.canSetAddressOfObjectToNull = canSetAddressOfObjectToNull;
        this.primitive = -1;
        if (clazz.isPrimitive()) {
            String primitiveType = clazz.getName();
            if (primitiveType.equals("byte")) {
                this.primitive = 0;
            } else if (primitiveType.equals("char")) {
                this.primitive = 1;
            } else if (primitiveType.equals("double")) {
                this.primitive = 2;
            } else if (primitiveType.equals("float")) {
                this.primitive = 3;
            } else if (primitiveType.equals("int")) {
                this.primitive = 4;
            } else if (primitiveType.equals("long")) {
                this.primitive = 5;
            } else if (primitiveType.equals("short")) {
                this.primitive = 6;
            } else if (primitiveType.equals("boolean")) {
                this.primitive = 7;
            }
        }
        if (clazz != null && clazz.isEnum()) {
            this.isEnum = true;
            this.currentEnumValue = null;
            DebugFieldInfo[] fields = clazz.getEnumConstants();
            this.enumHashCode2ValuesMap = new HashMap<Integer, DebugFieldInfo>();
            this.enumName2ValuesMap = new HashMap<String, DebugFieldInfo>();
            this.enumValueNames = new ArrayList<String>();
            for (int i = 0; i < fields.length; ++i) {
                DebugDataInfo ddi1 = fields[i].getDataInfo();
                if (ddi1 == null) continue;
                String fieldName = fields[i].getName();
                this.enumHashCode2ValuesMap.put(new Integer(ddi1.hashCode()), fields[i]);
                this.enumName2ValuesMap.put(fieldName, fields[i]);
                this.enumValueNames.add(fieldName);
                if (data == null || data.hashCode() != ddi1.hashCode()) continue;
                this.currentEnumValue = currentValue = fieldName;
            }
        }
        if (clazz.getName().equals(JAVA_LANG_BOOLEAN_STRING)) {
            this.isBoolean = true;
        } else if (clazz.getName().equals(JAVA_LANG_BYTE_STRING)) {
            this.isByte = true;
        } else if (clazz.getName().equals(JAVA_LANG_CHARACTER_STRING)) {
            this.isCharacter = true;
        } else if (clazz.getName().equals(JAVA_LANG_DOUBLE_STRING)) {
            this.isDouble = true;
        } else if (clazz.getName().equals(JAVA_LANG_FLOAT_STRING)) {
            this.isFloat = true;
        } else if (clazz.getName().equals(JAVA_LANG_INTEGER_STRING)) {
            this.isInteger = true;
        } else if (clazz.getName().equals(JAVA_LANG_LONG_STRING)) {
            this.isLong = true;
        } else if (clazz.getName().equals(JAVA_LANG_SHORT_STRING)) {
            this.isShort = true;
        }
        JLabel topLabel = new JLabel(type + " " + name);
        JLabel currentLabel = new JLabel();
        JTextArea currentTextArea = new JTextArea();
        this.currentText = text = this.makeCurrentValue(currentValue, currentAddress);
        currentTextArea.setText(text);
        currentTextArea.setBorder(new JTextField().getBorder());
        currentTextArea.setEditable(false);
        currentTextArea.setLineWrap(false);
        currentTextArea.setMinimumSize(new Dimension(20, 20));
        currentTextArea.setForeground(currentTextArea.getDisabledTextColor());
        JLabel newValueLabel = new JLabel();
        if (!this.isEnum && !this.isBoolean) {
            this.newValueHistoryList = Ide.loadHistoryList((String)newValueHistoryName);
            String[] choices = JDebugger.filterBlanksFromHistoryList(this.newValueHistoryList.getHistory());
            this.newValueComboBox = new JComboBox<String>(choices);
        } else if (this.isEnum) {
            ArrayList<String> lst1 = new ArrayList<String>(this.enumValueNames);
            lst1.add("null");
            this.newValueComboBox = new JComboBox<Object>(lst1.toArray());
            this.newValueComboBox.setSelectedItem(currentValue);
        } else if (this.isBoolean) {
            this.newValueComboBox = new JComboBox<String>(new String[]{"true", "false", "null"});
            this.newValueComboBox.setSelectedItem(currentValue);
        }
        this.newValueComboBox.setEditable(!this.isEnum && !this.isBoolean);
        this.newValueEditor = (JTextField)this.newValueComboBox.getEditor().getEditorComponent();
        this.newValueComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)newValueLabel, (Component)this.newValueEditor, (String)DbgArb.getString(542));
        this.addressCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.addressCheckBox, (String)DbgArb.getString(543));
        this.addressCheckBox.setSelected(!canModifyDataWithString);
        this.addressCheckBox.setEnabled(canModifyDataWithString && (canSetAddressOfObject || canSetAddressOfObjectToNull));
        JScrollPane scrollPane = new JScrollPane(currentTextArea);
        currentTextArea.setRows(4);
        ResourceUtils.resLabel((JLabel)currentLabel, (Component)scrollPane, (String)DbgArb.getString(540));
        String newValue = this.addressCheckBox.isSelected() && !this.isEnum && !this.isBoolean && !this.isByte && !this.isCharacter && !this.isDouble && !this.isFloat && !this.isInteger && !this.isLong && !this.isShort ? currentAddress : currentValue;
        if (newValue == null) {
            newValue = "";
        }
        JDebugger.selectHistoryString(this.newValueComboBox, newValue);
        int y = 0;
        this.add((Component)topLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)currentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)scrollPane, new GridBagConstraints(0, y++, 0, 2, 1.0, 2.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)newValueLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.newValueComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.addressCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.newValueComboBox, (DocumentListener)this);
        this.newValueComboBox.addItemListener(this);
        this.addressCheckBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && !ModifyValueDialog.this.setDataNewValue()) {
                    throw new PropertyVetoException("no", evt);
                }
            }
        });
    }

    private String makeCurrentValue(String currentValue, String currentAddress) {
        if (currentValue != null) {
            if (currentAddress != null) {
                return currentValue + "\n" + DbgArb.format(541, currentAddress);
            }
            return currentValue;
        }
        if (currentAddress != null) {
            return DbgArb.format(541, currentAddress);
        }
        return "";
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        block40: {
            try {
                String newValue = this.newValueEditor.getText();
                if (!(!this.addressCheckBox.isSelected() || this.isEnum || this.isBoolean || this.isByte || this.isCharacter || this.isDouble || this.isFloat || this.isInteger || this.isLong || this.isShort)) {
                    long address = ModifyValueDialog.parseAddress(newValue);
                    if (this.canSetAddressOfObject) {
                        return true;
                    }
                    if (this.canSetAddressOfObjectToNull && address == 0L) {
                        return true;
                    }
                    break block40;
                }
                switch (this.primitive) {
                    default: {
                        if (this.isEnum && this.currentEnumValue.equals(this.newValueEditor.getText())) {
                            return false;
                        }
                        if (this.isBoolean && this.currentText.equals(this.newValueEditor.getText())) {
                            return false;
                        }
                        if (this.isByte || this.isCharacter || this.isDouble || this.isFloat || this.isInteger || this.isLong || this.isShort) {
                            if (this.currentText.equals(this.newValueEditor.getText()) || !(this.data instanceof DebugDataObjectInfo)) {
                                return false;
                            }
                            String newValString = this.newValueEditor.getText();
                            if (this.isByte) {
                                try {
                                    new Byte(DebugSharedPrimitives.byteDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                            if (this.isCharacter) {
                                try {
                                    new Character(DebugSharedPrimitives.charDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                            if (this.isDouble) {
                                try {
                                    new Double(DebugSharedPrimitives.doubleDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                            if (this.isFloat) {
                                try {
                                    new Float(DebugSharedPrimitives.floatDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                            if (this.isInteger) {
                                try {
                                    new Integer(DebugSharedPrimitives.intDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                            if (this.isLong) {
                                try {
                                    new Long(DebugSharedPrimitives.longDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                            if (this.isShort) {
                                try {
                                    new Short(DebugSharedPrimitives.shortDecode(newValString));
                                }
                                catch (Throwable th) {
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                    case 0: {
                        DebugSharedPrimitives.byteDecode(newValue);
                        return true;
                    }
                    case 1: {
                        DebugSharedPrimitives.charDecode(newValue);
                        return true;
                    }
                    case 2: {
                        DebugSharedPrimitives.doubleDecode(newValue);
                        return true;
                    }
                    case 3: {
                        DebugSharedPrimitives.floatDecode(newValue);
                        return true;
                    }
                    case 4: {
                        DebugSharedPrimitives.intDecode(newValue);
                        return true;
                    }
                    case 5: {
                        DebugSharedPrimitives.longDecode(newValue);
                        return true;
                    }
                    case 6: {
                        DebugSharedPrimitives.shortDecode(newValue);
                        return true;
                    }
                    case 7: 
                }
                DebugSharedPrimitives.booleanDecode(newValue);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static long parseAddress(String newValue) throws NumberFormatException {
        if ("null".equals(newValue)) {
            return 0L;
        }
        return DebugSharedPrimitives.longDecode(newValue);
    }

    private boolean setDataNewValue() {
        Object valueToSet;
        String newValue = this.isEnum || this.isBoolean ? this.newValueComboBox.getSelectedItem().toString() : this.newValueHistoryList.comboBoxGetSelectedItem(this.newValueComboBox);
        String errorMessage = null;
        boolean valueSet = false;
        if (this.isBoolean) {
            DebugFieldInfo[] flds;
            DebugFieldInfo newBooleanValueField = null;
            if (newValue.equals("true")) {
                flds = this.clazz.getFields(0);
                for (int i2 = 0; i2 < flds.length; ++i2) {
                    if (!flds[i2].getName().equals("TRUE")) continue;
                    newBooleanValueField = flds[i2];
                    break;
                }
            } else if (newValue.equals("false")) {
                flds = this.clazz.getFields(0);
                for (int i2 = 0; i2 < flds.length; ++i2) {
                    if (!flds[i2].getName().equals("FALSE")) continue;
                    newBooleanValueField = flds[i2];
                    break;
                }
            }
            if (newBooleanValueField != null) {
                valueSet = true;
                if (!this.data.modifyDataWithData(newBooleanValueField.getDataInfo())) {
                    errorMessage = DbgArb.getString(548);
                }
            }
        } else if (this.isEnum) {
            DebugFieldInfo newEnumValueField = this.enumName2ValuesMap.get(newValue);
            if (newEnumValueField != null) {
                valueSet = true;
                if (!this.data.modifyDataWithData(newEnumValueField.getDataInfo())) {
                    errorMessage = DbgArb.getString(548);
                }
            }
        } else if (this.isByte && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Byte", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        } else if (this.isCharacter && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Character", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        } else if (this.isDouble && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Double", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        } else if (this.isFloat && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Float", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        } else if (this.isInteger && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Integer", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        } else if (this.isLong && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Long", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        } else if (this.isShort && this.data instanceof DebugDataObjectInfo) {
            boolean set = false;
            try {
                valueToSet = this.evaluateNewValue("Short", newValue, (DebugDataObjectInfo)this.data);
                valueSet = true;
                if (valueToSet != null && valueToSet instanceof DebugDataInfo) {
                    set = this.data.modifyDataWithData((DebugDataInfo)valueToSet);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!set) {
                errorMessage = DbgArb.getString(548);
            }
        }
        if (!valueSet) {
            if (this.addressCheckBox.isSelected()) {
                long address = ModifyValueDialog.parseAddress(newValue);
                if (!((DebugDataCompositeInfo)this.data).setAddressOfObject(address)) {
                    errorMessage = DbgArb.getString(547);
                }
            } else if (!this.data.modifyDataWithString(newValue)) {
                errorMessage = DbgArb.getString(548);
            }
        }
        if (errorMessage != null) {
            String title = DbgArb.getString(539);
            String[] messages = new String[]{DbgArb.getString(544), DbgArb.getString(545), DbgArb.getString(546), errorMessage};
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), messages, title, 0);
            return false;
        }
        return true;
    }

    private Object evaluateNewValue(String typeString, String newValue, DebugDataObjectInfo data) {
        Evaluator evaluator = new Evaluator(true);
        evaluator.setDebugContext(data);
        StringBuffer buf = new StringBuffer("new java.lang.");
        buf.append(typeString);
        buf.append('(');
        buf.append(newValue);
        buf.append(')');
        Object valueToSet = evaluator.evaluate(buf.toString());
        JDebugger.getInstance().getStackWindow(true).everythingChanged();
        JDebugger.getInstance().refreshSmartWindow();
        return valueToSet;
    }

    public void cancel() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.newValueComboBox) {
            this.newValueEditor.setText((String)this.newValueComboBox.getSelectedItem());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.processChange();
    }
}

