/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.model.Node;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.model.JavaSourceNode;

class JavaExpressionProvider
implements DebuggerInspectorExpressionProvider,
ToolTipExpressionProvider {
    JavaExpressionProvider() {
    }

    public boolean canProvideInspectorExpression(Node node) {
        return node instanceof JavaSourceNode;
    }

    public String getInspectorExpression(String string, int i) {
        return JavaExpressionProvider.getJavaInspectorExpression(string, i);
    }

    public boolean canUnderstand(Node node) {
        return node instanceof JavaSourceNode;
    }

    public boolean isLanguageCaseInsensitive() {
        return false;
    }

    public String getExpression(String lineOfText, int mouseOffset) {
        return JavaExpressionProvider.getJavaTooltipExpression(lineOfText, mouseOffset);
    }

    static String getJavaInspectorExpression(String lineOfText, int cursorOffset) {
        return JavaExpressionProvider.getJavaExpression(lineOfText, cursorOffset, true);
    }

    static String getJavaTooltipExpression(String lineOfText, int cursorOffset) {
        return JavaExpressionProvider.getJavaExpression(lineOfText, cursorOffset, false);
    }

    private static String getJavaExpression(String lineOfText, int cursorOffset, boolean includeMethodArguments) {
        int token;
        int length = lineOfText.length();
        char[] ca = new char[length];
        lineOfText.getChars(0, length, ca, 0);
        ReadTextBuffer tb = TextBufferFactory.createReadTextBuffer((String)lineOfText);
        JavaLexer javaLexer = new JavaLexer();
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setTextBuffer(tb);
        javaLexer.setPosition(0);
        javaLexer.setSkipComments(true);
        while ((token = javaLexer.lex(lexerToken)) != 0) {
            int start = lexerToken.getStartOffset();
            if (start < 0) continue;
            if (start > cursorOffset) break;
            int end = lexerToken.getEndOffset();
            if (end < 0 || end <= cursorOffset || token != 4 && token != 136) continue;
            int exprStart = JavaExpressionProvider.findStartOfJavaExpression(ca, start, includeMethodArguments);
            int exprEnd = JavaExpressionProvider.findEndOfJavaExpression(ca, length, end, includeMethodArguments);
            return tb.getString(exprStart, exprEnd - exprStart);
        }
        return null;
    }

    private static int findStartOfJavaExpression(char[] ca, int start, boolean includeMethodArguments) {
        int bracketDepth = 0;
        int parenDepth = 0;
        int angleDepth = 0;
        int angleStart = -1;
        for (int i = start - 1; i >= 0; --i) {
            char c = ca[i];
            if (bracketDepth > 0) {
                if (c == ']') {
                    ++bracketDepth;
                    continue;
                }
                if (c == '[') {
                    --bracketDepth;
                    continue;
                }
                if (includeMethodArguments || JavaExpressionProvider.nonMethodExpressionPart(c)) continue;
                return start;
            }
            if (includeMethodArguments && parenDepth > 0) {
                if (c == ')') {
                    ++parenDepth;
                    continue;
                }
                if (c != '(') continue;
                --parenDepth;
                continue;
            }
            if (includeMethodArguments && angleDepth > 0) {
                if (c == '>') {
                    ++angleDepth;
                    continue;
                }
                if (c != '<' || --angleDepth != 0 || i != 0 && ca[i - 1] == '.') continue;
                return angleStart;
            }
            if (c == ']') {
                ++bracketDepth;
                continue;
            }
            if (c == ')') {
                if (!includeMethodArguments) {
                    return start;
                }
                ++parenDepth;
                continue;
            }
            if (c == '>') {
                if (!includeMethodArguments) {
                    return start;
                }
                ++angleDepth;
                angleStart = i + 1;
                continue;
            }
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            return i + 1;
        }
        if (bracketDepth != 0) {
            return start;
        }
        if (includeMethodArguments && parenDepth != 0) {
            return start;
        }
        if (includeMethodArguments && angleDepth != 0) {
            return angleStart;
        }
        return 0;
    }

    private static int findEndOfJavaExpression(char[] ca, int length, int end, boolean includeMethodArguments) {
        int bracketDepth = 0;
        int parenDepth = 0;
        for (int i = end; i < length; ++i) {
            char c = ca[i];
            if (bracketDepth > 0) {
                if (c == ']') {
                    --bracketDepth;
                    continue;
                }
                if (c == '[') {
                    ++bracketDepth;
                    continue;
                }
                if (includeMethodArguments || JavaExpressionProvider.nonMethodExpressionPart(c)) continue;
                return end;
            }
            if (includeMethodArguments && parenDepth > 0) {
                if (c == ')') {
                    --parenDepth;
                    continue;
                }
                if (c != '(') continue;
                ++parenDepth;
                continue;
            }
            if (c == '[') {
                ++bracketDepth;
                continue;
            }
            if (c == '(') {
                if (!includeMethodArguments) {
                    return end;
                }
                ++parenDepth;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return i;
        }
        if (bracketDepth != 0) {
            return end;
        }
        if (includeMethodArguments && parenDepth != 0) {
            return end;
        }
        return length;
    }

    private static boolean nonMethodExpressionPart(char c) {
        return c == '.' || Character.isJavaIdentifierPart(c) || Character.isWhitespace(c);
    }
}

