/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.Version;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;

public final class HeapWindowSettingsPanel
extends DefaultTraversablePanel {
    private DataPanelSettingsPanel dataPanel = new DataPanelSettingsPanel();
    private JCheckBox hideUnrelatedCheckBox = new JCheckBox();
    private JCheckBox ignoreSoftWeakCheckBox = new JCheckBox();
    private JCheckBox rootsOnlyCheckBox = new JCheckBox();
    private JLabel maximumDepthLabel = new JLabel();
    private NumericSpinBox maximumDepthBox = new NumericSpinBox(-1, 1000);
    private JLabel spacerLabel = new JLabel();

    public HeapWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_heapwinsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.hideUnrelatedCheckBox, (String)DbgArb.getString(767));
        ResourceUtils.resButton((AbstractButton)this.ignoreSoftWeakCheckBox, (String)DbgArb.getString(768));
        ResourceUtils.resButton((AbstractButton)this.rootsOnlyCheckBox, (String)DbgArb.getString(769));
        ResourceUtils.resLabel((JLabel)this.maximumDepthLabel, (Component)this.maximumDepthBox, (String)DbgArb.getString(770));
        SpinBuddy buddy = this.maximumDepthBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        this.spacerLabel.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets borderInsets = new Insets(0, 0, 0, 0);
        this.add(this.dataPanel.makeChooseColumnsPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.insets.top = 8;
        this.add(this.dataPanel.makeSortPanel(null), constraints);
        ++constraints.gridy;
        this.add(this.dataPanel.makeShowPanel(null), constraints);
        ++constraints.gridy;
        this.add(this.dataPanel.makeHidePanel(this.hideUnrelatedCheckBox), constraints);
        ++constraints.gridy;
        this.add(this.makeExtraPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add(this.spacerLabel, constraints);
    }

    private JPanel makeExtraPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        int y = 0;
        panel.add((Component)this.ignoreSoftWeakCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        if (Version.DEBUG_BUILD != 0) {
            panel.add((Component)this.rootsOnlyCheckBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
            panel.add((Component)this.maximumDepthLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
            panel.add((Component)this.maximumDepthBox, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        }
        return panel;
    }

    private HeapWindowSettings getData(TraversableContext tc) {
        return HeapWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        HeapWindowSettings settings = this.getData(tc);
        DataPanelSettings dataPanelSettings = settings.getDataPanelSettings();
        this.dataPanel.onEntry(dataPanelSettings);
        this.hideUnrelatedCheckBox.setSelected(dataPanelSettings.isHideUnrelated());
        this.ignoreSoftWeakCheckBox.setSelected(settings.isIgnoreSoftWeak());
        if (Version.DEBUG_BUILD != 0) {
            this.rootsOnlyCheckBox.setSelected(dataPanelSettings.isShowOnlyRootAncestors());
            this.maximumDepthBox.setIntValue(settings.getMaximumDepth());
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        HeapWindowSettings settings = this.getData(tc);
        DataPanelSettings dataPanelSettings = settings.getDataPanelSettings();
        this.dataPanel.onExit(dataPanelSettings);
        dataPanelSettings.setHideUnrelated(this.hideUnrelatedCheckBox.isSelected());
        settings.setIgnoreSoftWeak(this.ignoreSoftWeakCheckBox.isSelected());
        if (Version.DEBUG_BUILD != 0) {
            dataPanelSettings.setShowOnlyRootAncestors(this.rootsOnlyCheckBox.isSelected());
            settings.setMaximumDepth(this.maximumDepthBox.getIntValue());
        }
    }
}

