/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointPanel;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerExtender;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointDefinitionPanel;
import oracle.jdevimpl.runner.debug.BreakpointDetails;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.ExtenderCallback;

class ExtenderManager {
    private Map<String, ExtenderCallback> extenderMap = new HashMap<String, ExtenderCallback>();
    private static ExtenderManager _instance = new ExtenderManager();

    private ExtenderManager() {
    }

    static ExtenderManager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtenderCallback addExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return null;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
        ExtenderCallback callback = new ExtenderCallback(extender, ID);
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            this.extenderMap.put(ID, callback);
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            this.extenderMap.remove(ID);
        }
    }

    boolean isExtenderBreakpoint(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.IS_EXTENDER_BREAKPOINT, null, breakpoint);
    }

    boolean stoppedAtExtenderBreakpoint(BreakpointDetails breakpointDetails) {
        return breakpointDetails != null && breakpointDetails.getDebuggerBreakpoint() != null;
    }

    void breakpointAdded(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_ADDED, null, breakpoint);
    }

    void breakpointChanged(DebuggingProcess debuggingProcess, Breakpoint breakpoint) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint);
        if (details != null) {
            DebuggerBreakpoint.BreakpointState newState;
            switch (breakpoint.getActiveStatus(debuggingProcess)) {
                case 0: {
                    newState = DebuggerBreakpoint.BreakpointState.DISABLED;
                    break;
                }
                case 1: {
                    newState = DebuggerBreakpoint.BreakpointState.ENABLED;
                    break;
                }
                case 2: {
                    newState = DebuggerBreakpoint.BreakpointState.UNVERIFIED;
                    break;
                }
                case 3: {
                    newState = DebuggerBreakpoint.BreakpointState.VERIFIED;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                details.extender.breakpointChanged((DebuggerBreakpoint)details.extenderBreakpoint, newState);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void breakpointMoved(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_MOVED, null, breakpoint);
    }

    void breakpointRefactored(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_REFACTORED, null, breakpoint);
    }

    void breakpointDeleted(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_DELETED, null, breakpoint);
    }

    void breakpointEdited(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_EDITED, null, breakpoint);
    }

    void breakpointScopeChanged(Breakpoint breakpoint) {
        this.doExtenderAction(ExtenderAction.BREAKPOINT_SCOPE_CHANGED, null, breakpoint);
    }

    void debuggeeStoppedAtBreakpoint(Context context, BreakpointDetails breakpointDetails) {
        ExtenderActionDetails actionDetails = this.getExtenderActionDetails(breakpointDetails.getBreakpoint());
        if (actionDetails != null) {
            breakpointDetails.setDebuggerBreakpoint((DebuggerBreakpoint)actionDetails.extenderBreakpoint);
            breakpointDetails.setDebuggerExtender(actionDetails.extender);
            breakpointDetails.setExtenderCallback(actionDetails.callback);
            actionDetails.extender.debuggeeStoppedAtBreakpoint(context, (DebuggerBreakpoint)actionDetails.extenderBreakpoint);
        }
    }

    boolean canShowBreakpointLocation(Context context, Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_BREAKPOINT_LOCATION, context, breakpoint);
    }

    boolean showBreakpointLocation(Context context, Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.SHOW_BREAKPOINT_LOCATION, context, breakpoint);
    }

    void newDebugSession(Context context) {
        this.callAllExtenders(ExtenderAction.NEW_DEBUG_SESSION, context);
    }

    boolean canShowIPLocation(Context context, BreakpointDetails breakpointDetails) {
        return this.doExtenderAction(ExtenderAction.CAN_SHOW_IP_LOCATION, context, breakpointDetails);
    }

    boolean showIPLocation(Context context, BreakpointDetails breakpointDetails) {
        return this.doExtenderAction(ExtenderAction.SHOW_IP_LOCATION, context, breakpointDetails);
    }

    void setEvaluator(DebuggingProcess process, Breakpoint breakpoint, Evaluator evaluator) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint);
        if (details != null) {
            EvaluatorHandle debuggerEvaluator = new EvaluatorHandle(evaluator, process, details.callback.getCustomDataProvider());
            try {
                details.extender.setEvaluator(process.getContext(), (DebuggerEvaluator)debuggerEvaluator);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    Breakpoint stepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_OVER);
    }

    boolean canStepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_OVER);
    }

    Breakpoint stepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_INTO);
    }

    boolean canStepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_INTO);
    }

    Breakpoint stepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_OUT);
    }

    boolean canStepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_OUT);
    }

    Breakpoint stepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    boolean canStepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    Breakpoint runToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.overrideStepping(process, breakpointDetails, ExtenderAction.RUN_TO_CURSOR);
    }

    boolean canRunToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.canOverrideStepping(process, breakpointDetails, ExtenderAction.RUN_TO_CURSOR);
    }

    boolean updateBreakpointIcon(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.UPDATE_BREAKPOINT_ICON, null, breakpoint);
    }

    boolean showBreakpointIcon(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.SHOW_BREAKPOINT_ICON, null, breakpoint);
    }

    boolean hideBreakpointIcon(Breakpoint breakpoint) {
        return this.doExtenderAction(ExtenderAction.HIDE_BREAKPOINT_ICON, null, breakpoint);
    }

    void breakpointsLoaded() {
        this.callAllExtenders(ExtenderAction.BREAKPOINTS_LOADED, null);
    }

    void temporaryBreakpointSet(Context context, Breakpoint breakpoint) {
        ExtenderCallback callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        if (callback != null) {
            ExtenderBreakpoint extenderBreakpoint = new ExtenderBreakpoint(breakpoint);
            callback.addExtenderBreakpoint(extenderBreakpoint);
            try {
                callback.getExtender().temporaryBreakpointSet(context, (DebuggerBreakpoint)extenderBreakpoint);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    DebuggerBreakpoint getDebuggerBreakpoint(Breakpoint breakpoint) {
        ExtenderActionDetails details;
        if (breakpoint != null && (details = this.getExtenderActionDetails(breakpoint)) != null) {
            return details.extenderBreakpoint;
        }
        return null;
    }

    boolean canCreateCustomBreakpoint(String customBreakpointType, Workspace workspace, Project project) {
        ExtenderCallback callback = this.getExtenderFromCustomBreakpointType(customBreakpointType);
        if (callback != null) {
            try {
                return callback.getExtender().canCreateCustomBreakpoint(customBreakpointType, workspace, project);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    BreakpointDefinitionPanel getCustomBreakpointPanel(String customBreakpointType, Breakpoint breakpoint, ChangeListener changeListener) {
        ExtenderCallback callback = null;
        ExtenderBreakpoint debuggerBreakpoint = null;
        if (breakpoint != null) {
            ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint);
            if (details != null) {
                callback = details.callback;
                debuggerBreakpoint = details.extenderBreakpoint;
            }
        } else {
            callback = this.getExtenderFromCustomBreakpointType(customBreakpointType);
        }
        if (callback != null) {
            try {
                DebuggerBreakpointPanel dbp = callback.getExtender().getCustomBreakpointPanel(customBreakpointType, (DebuggerBreakpoint)debuggerBreakpoint, changeListener);
                if (dbp != null) {
                    return new BreakpointDefinitionPanel(dbp, breakpoint, callback);
                }
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ExtenderCallback.CustomBreakpointDetails> getCustomBreakpointTypes() {
        ArrayList<ExtenderCallback.CustomBreakpointDetails> customBreakpointTypes = new ArrayList<ExtenderCallback.CustomBreakpointDetails>();
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                customBreakpointTypes.addAll(callback.getCustomBreakpointTypes());
            }
        }
        return customBreakpointTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtenderCallback getExtenderFromCustomBreakpointType(String customBreakpointType) {
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                if (!callback.knowsCustomBreakpointType(customBreakpointType)) continue;
                return callback;
            }
        }
        return null;
    }

    private Breakpoint overrideStepping(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = breakpointDetails.getDebuggerExtender();
        ExtenderCallback callback = breakpointDetails.getExtenderCallback();
        if (extender != null && callback != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        debuggerBreakpoint = extender.stepOver(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_INTO: {
                        debuggerBreakpoint = extender.stepInto(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_OUT: {
                        debuggerBreakpoint = extender.stepOut(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case STEP_TO_END_OF_METHOD: {
                        debuggerBreakpoint = extender.stepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    case RUN_TO_CURSOR: {
                        debuggerBreakpoint = extender.runToCursor(process.getContext(), debuggerBreakpoint);
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
                if (debuggerBreakpoint != null) {
                    return callback.createBreakpoint(debuggerBreakpoint);
                }
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return null;
    }

    private boolean canOverrideStepping(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderAction action) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = breakpointDetails.getDebuggerExtender();
        if (extender != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case STEP_OVER: {
                        return extender.canStepOver(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_INTO: {
                        return extender.canStepInto(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_OUT: {
                        return extender.canStepOut(process.getContext(), debuggerBreakpoint);
                    }
                    case STEP_TO_END_OF_METHOD: {
                        return extender.canStepToEndOfMethod(process.getContext(), debuggerBreakpoint);
                    }
                    case RUN_TO_CURSOR: {
                        return extender.canRunToCursor(process.getContext(), debuggerBreakpoint);
                    }
                }
                throw new Exception();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, BreakpointDetails breakpointDetails) {
        DebuggerBreakpoint debuggerBreakpoint;
        DebuggerExtender extender = breakpointDetails.getDebuggerExtender();
        if (extender != null && (debuggerBreakpoint = breakpointDetails.getDebuggerBreakpoint()) != null) {
            try {
                switch (action) {
                    case CAN_SHOW_IP_LOCATION: {
                        return extender.canShowIPLocation(context, debuggerBreakpoint);
                    }
                    case SHOW_IP_LOCATION: {
                        return extender.showIPLocation(context, debuggerBreakpoint);
                    }
                }
                throw new Exception();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    private boolean doExtenderAction(ExtenderAction action, Context context, Breakpoint breakpoint) {
        ExtenderActionDetails details = this.getExtenderActionDetails(breakpoint);
        if (details != null) {
            try {
                DebuggerExtender extender = details.extender;
                ExtenderBreakpoint extenderBreakpoint = details.extenderBreakpoint;
                ExtenderCallback callback = details.callback;
                switch (action) {
                    case SHOW_BREAKPOINT_LOCATION: {
                        return extender.showBreakpointLocation(context, (DebuggerBreakpoint)extenderBreakpoint);
                    }
                    case CAN_SHOW_BREAKPOINT_LOCATION: {
                        return extender.canShowBreakpointLocation(context, (DebuggerBreakpoint)extenderBreakpoint);
                    }
                    case BREAKPOINT_DELETED: {
                        callback.deleteExtenderBreakpoint(extenderBreakpoint);
                        extender.breakpointDeleted((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case IS_EXTENDER_BREAKPOINT: {
                        return true;
                    }
                    case UPDATE_BREAKPOINT_ICON: {
                        extender.updateBreakpointIcon((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case SHOW_BREAKPOINT_ICON: {
                        extender.breakpointInScope((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case HIDE_BREAKPOINT_ICON: {
                        extender.breakpointOutOfScope((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_MOVED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.MOVED);
                        return true;
                    }
                    case BREAKPOINT_REFACTORED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.REFACTORED);
                        return true;
                    }
                    case BREAKPOINT_EDITED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.EDITED);
                        return true;
                    }
                    case BREAKPOINT_ADDED: {
                        extender.breakpointAdded((DebuggerBreakpoint)extenderBreakpoint);
                        return true;
                    }
                    case BREAKPOINT_SCOPE_CHANGED: {
                        extender.breakpointChanged((DebuggerBreakpoint)extenderBreakpoint, DebuggerBreakpoint.BreakpointState.SCOPE_CHANGED);
                        return true;
                    }
                }
                throw new Exception();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callAllExtenders(ExtenderAction action, Context context) {
        ArrayList<ExtenderCallback> callbacks = new ArrayList<ExtenderCallback>();
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            for (ExtenderCallback callback : this.extenderMap.values()) {
                callbacks.add(callback);
            }
        }
        for (ExtenderCallback callback : callbacks) {
            try {
                switch (action) {
                    case NEW_DEBUG_SESSION: {
                        callback.getExtender().newDebugSession(context);
                        break;
                    }
                    case BREAKPOINTS_LOADED: {
                        callback.getExtender().breakpointsLoaded();
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtenderActionDetails getExtenderActionDetails(Breakpoint breakpoint) {
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;
        if (breakpoint == null) {
            return null;
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        }
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            return new ExtenderActionDetails(callback, extenderBreakpoint);
        }
        return null;
    }

    static enum ExtenderAction {
        CAN_SHOW_IP_LOCATION,
        SHOW_IP_LOCATION,
        CAN_SHOW_BREAKPOINT_LOCATION,
        SHOW_BREAKPOINT_LOCATION,
        BREAKPOINT_DELETED,
        IS_EXTENDER_BREAKPOINT,
        STEP_OVER,
        STEP_INTO,
        RUN_TO_CURSOR,
        STEP_OUT,
        STEP_TO_END_OF_METHOD,
        SHOW_BREAKPOINT_ICON,
        HIDE_BREAKPOINT_ICON,
        UPDATE_BREAKPOINT_ICON,
        BREAKPOINTS_LOADED,
        NEW_DEBUG_SESSION,
        BREAKPOINT_MOVED,
        BREAKPOINT_REFACTORED,
        BREAKPOINT_EDITED,
        BREAKPOINT_ADDED,
        BREAKPOINT_SCOPE_CHANGED;

    }

    private class ExtenderActionDetails {
        DebuggerExtender extender;
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;

        ExtenderActionDetails(ExtenderCallback callback, ExtenderBreakpoint breakpoint) {
            this.callback = callback;
            this.extender = callback.getExtender();
            this.extenderBreakpoint = breakpoint;
        }
    }
}

