/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.URL;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerExceptionBreakpoint;
import oracle.ide.runner.DebuggerFileLineBreakpoint;
import oracle.ide.runner.DebuggerMethodBreakpoint;
import oracle.ide.runner.DebuggerURLLineBreakpoint;
import oracle.jdevimpl.runner.debug.Breakpoint;

class ExtenderBreakpoint
implements DebuggerMethodBreakpoint,
DebuggerFileLineBreakpoint,
DebuggerExceptionBreakpoint,
DebuggerURLLineBreakpoint {
    private Breakpoint breakpoint;
    private ExtenderBreakpointLogEntry logEntry;

    ExtenderBreakpoint(Breakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Need valid breakpoint");
        }
        this.breakpoint = breakpoint;
    }

    Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    String getDebuggerExtenderID() {
        return this.breakpoint.getDebuggerExtenderID();
    }

    void enableBreakpoint(boolean enable) {
        this.breakpoint.setEnabled(enable);
    }

    DebuggerBreakpoint.BreakpointState getActiveState() {
        int state = this.breakpoint.getActiveStatus();
        switch (state) {
            case 0: {
                return DebuggerBreakpoint.BreakpointState.DISABLED;
            }
            case 1: {
                return DebuggerBreakpoint.BreakpointState.ENABLED;
            }
            case 2: {
                return DebuggerBreakpoint.BreakpointState.UNVERIFIED;
            }
            case 3: {
                return DebuggerBreakpoint.BreakpointState.VERIFIED;
            }
        }
        return null;
    }

    Icon getIcon() {
        return this.breakpoint.getIcon();
    }

    public boolean isEnabled() {
        return this.breakpoint.isEnabled();
    }

    public URL getScope() {
        return this.breakpoint.getOwnerURL();
    }

    public String getCondition() {
        return this.breakpoint.getCondition();
    }

    public boolean canEditCondition() {
        return this.breakpoint.canEditCondition();
    }

    public String getHiddenCondition() {
        return this.breakpoint.getHiddenCondition();
    }

    public int getPassCount() {
        return this.breakpoint.getPassCount();
    }

    public boolean canEditPassCount() {
        return this.breakpoint.canEditPassCount();
    }

    public String getGroupName() {
        return this.breakpoint.getGroupName();
    }

    public boolean canEditGroupName() {
        return this.breakpoint.canEditGroupName();
    }

    public String getCustomDescription() {
        return this.breakpoint.getCustomDescription();
    }

    public String getCustomTypeString() {
        return this.breakpoint.getCustomTypeString();
    }

    public String getBreakForThreadNamed() {
        return this.breakpoint.getThreadName();
    }

    public String getBreakForThreadNotNamed() {
        return this.breakpoint.getThreadNameNot();
    }

    public boolean canEditBreakForThreads() {
        return this.breakpoint.canEditBreakForThreads();
    }

    public boolean isHaltOnBreakpointHit() {
        return this.breakpoint.isActionHalt();
    }

    public boolean isBeepOnBreakpointHit() {
        return this.breakpoint.isActionBeep();
    }

    public DebuggerBreakpointLogEntry getLogEntryOnBreakpointHit() {
        if (this.logEntry == null) {
            this.logEntry = new ExtenderBreakpointLogEntry();
        }
        return this.logEntry;
    }

    public String getEnableBreakpointGroupOnBreakpointHit() {
        return this.breakpoint.getActionEnableOther();
    }

    public String getDisableBreakpointGroupOnBreakpointHit() {
        return this.breakpoint.getActionDisableOther();
    }

    public boolean canEditBreakpointHitActions() {
        return this.breakpoint.canEditBreakpointHitActions();
    }

    public Map<String, String> getProperties() {
        return this.breakpoint.getProperties();
    }

    public DebuggerBreakpoint.BreakpointKind getKind() {
        switch (this.breakpoint.getType()) {
            case 2: {
                return DebuggerBreakpoint.BreakpointKind.EXCEPTION;
            }
            case 0: {
                return DebuggerBreakpoint.BreakpointKind.FILE_LINE;
            }
            case 5: {
                return DebuggerBreakpoint.BreakpointKind.URL_LINE;
            }
            case 1: {
                return DebuggerBreakpoint.BreakpointKind.METHOD;
            }
        }
        return null;
    }

    public String getMethodName() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.METHOD) {
            return this.breakpoint.getMethod();
        }
        return null;
    }

    public String getPackage() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE) {
            return this.breakpoint.getPackage();
        }
        return null;
    }

    public String getFileName() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE) {
            return this.breakpoint.getFile();
        }
        return null;
    }

    public int getLine() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE || this.getKind() == DebuggerBreakpoint.BreakpointKind.URL_LINE) {
            return this.breakpoint.getLine();
        }
        return -1;
    }

    public String getExceptionName() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.getException();
        }
        return null;
    }

    public boolean isBreakOnCaughtExceptions() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.isCaught();
        }
        return false;
    }

    public boolean isBreakOnUncaughtExceptions() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.isUncaught();
        }
        return false;
    }

    public URL getURL() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.URL_LINE) {
            return this.breakpoint.getURL();
        }
        return null;
    }

    private class ExtenderBreakpointLogEntry
    implements DebuggerBreakpointLogEntry {
        private ExtenderBreakpointLogEntry() {
        }

        public boolean isEnabled() {
            return ExtenderBreakpoint.this.breakpoint.isActionLog();
        }

        public boolean isLogStackTrace() {
            return ExtenderBreakpoint.this.breakpoint.isActionLogStack();
        }

        public String getLogTag() {
            return ExtenderBreakpoint.this.breakpoint.getActionLogTag();
        }

        public String getLogExpression() {
            return ExtenderBreakpoint.this.breakpoint.getActionLogExpression();
        }
    }
}

