/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockableWindow;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.EditWatchDialog;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.Expression;

abstract class EvaluatorPanel
extends DataPanel {
    protected Evaluator evaluator = new Evaluator(true);
    protected IdeAction _actionPin;
    protected IdeAction _actionUnpin;
    protected JMenuItem _menuitemPin;
    protected JMenuItem _menuitemUnpin;
    protected int _PIN_CMD_ID;
    protected int _UNPIN_CMD_ID;

    EvaluatorPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        super(dockableWindow, dataPanelSettings);
    }

    @Override
    protected void debugContextChanged() {
        super.debugContextChanged();
        this.evaluator.setDebugContext(this.vm, this.thread, this.frame);
    }

    @Override
    void everythingChanged() {
        DebugStackFrameInfo curFrame = this.frame;
        DebugThreadInfo curThread = this.thread;
        if (curFrame != null && curThread != null) {
            this.frame = curThread.getStackFrame(curFrame.getFrameNumber());
            this.debugContextChanged();
        }
        this.evaluator.clearCache();
        super.everythingChanged(true);
    }

    @Override
    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        if (this._actionPin != null) {
            this.update(this._actionPin, context);
            if (this._actionPin.isEnabled()) {
                if (this._menuitemPin == null) {
                    this._menuitemPin = popup.createMenuItem((ToggleAction)this._actionPin);
                }
                popup.add((Component)this._menuitemPin, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionUnpin != null) {
            this.update(this._actionUnpin, context);
            if (this._actionUnpin.isEnabled()) {
                if (this._menuitemUnpin == null) {
                    this._menuitemUnpin = popup.createMenuItem((ToggleAction)this._actionUnpin);
                }
                popup.add((Component)this._menuitemUnpin, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        super.addPopupMenuItemsForDataItem(popup, context);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._PIN_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                action.setEnabled(evaluatorDataItem.canPin());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._UNPIN_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem instanceof EvaluatorDataItem) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                action.setEnabled(evaluatorDataItem.canUnpin());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return super.update(action, context);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._PIN_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof EvaluatorDataItem && treePath != null) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                evaluatorDataItem.pin(treePath);
            }
            return true;
        }
        if (cmdId == this._UNPIN_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem instanceof EvaluatorDataItem && treePath != null) {
                EvaluatorDataItem evaluatorDataItem = (EvaluatorDataItem)dataItem;
                evaluatorDataItem.unpin(treePath);
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    protected void addDataItem(List root, EvaluatorItem ei, boolean skipIfBad, boolean skipIfClass) {
        Object info;
        if (this.thread != null && this.frame != null) {
            this.frame = this.thread.getStackFrame(this.frame.getFrameNumber());
            this.debugContextChanged();
        }
        if ((info = ei.evaluate(this.debuggingProcess, this.evaluator)) == null) {
            if (skipIfBad) {
                return;
            }
            info = ei;
        }
        if (info instanceof DebugClassInfo && skipIfClass) {
            return;
        }
        String name = ei.getName(this.debuggingProcess);
        EvaluatorDataItem evaluatorDataItem = new EvaluatorDataItem(ei, name, info);
        if (root != null) {
            root.add(evaluatorDataItem);
        } else {
            this.addTopDataItem(evaluatorDataItem);
        }
    }

    protected final class EvaluatorDataItem
    extends DataItem {
        EvaluatorItem ei;

        EvaluatorDataItem(EvaluatorItem ei, String name, Object info) {
            super(EvaluatorPanel.this, info, name, ei.isPinned(EvaluatorPanel.this.debuggingProcess) ? null : ei.getExpression());
            this.ei = ei;
        }

        private void reEvaluateExpression(TreePath treePath) {
            Object info = this.ei.evaluate(EvaluatorPanel.this.debuggingProcess, EvaluatorPanel.this.evaluator);
            if (info == null) {
                info = this.ei;
            }
            String name = this.ei.getName(EvaluatorPanel.this.debuggingProcess);
            String originalExpression = this.ei.isPinned(EvaluatorPanel.this.debuggingProcess) ? null : this.ei.getExpression();
            this.modifyInfo(info, name, originalExpression, treePath);
        }

        @Override
        protected boolean prepareExpression(Object[] path, int i, Expression expression) {
            if (super.prepareExpression(path, i, expression)) {
                String name = this.ei.getName();
                if (name != null) {
                    expression.setName(name);
                }
                expression.setShowPinnedDiscarded(this.ei.isShowPinnedDiscarded());
                expression.setTemporary(this.ei.getTemporary());
                return true;
            }
            return false;
        }

        protected boolean canEditExpression() {
            return this.ei.getExpression() != null;
        }

        protected boolean editExpression(String title, String prompt, String expHistoryName, TreePath treePath) {
            String expression = this.ei.getExpression();
            if ((expression = EditWatchDialog.showEditWatchDialog(title, prompt, expHistoryName, expression)) != null) {
                if (EvaluatorPanel.this.thread != null && EvaluatorPanel.this.frame != null) {
                    EvaluatorPanel.this.frame = EvaluatorPanel.this.thread.getStackFrame(EvaluatorPanel.this.frame.getFrameNumber());
                    EvaluatorPanel.this.debugContextChanged();
                }
                this.ei.setExpression(expression);
                this.reEvaluateExpression(treePath);
                return true;
            }
            return false;
        }

        boolean canPin() {
            return EvaluatorPanel.this.vm != null && EvaluatorPanel.this.vm.getCapabilities().canPin() && this.data instanceof DebugDataCompositeInfo && !((DebugDataCompositeInfo)this.data).isNull() && !this.ei.isPinned(EvaluatorPanel.this.debuggingProcess);
        }

        void pin(TreePath treePath) {
            DebugDataCompositeInfo datac;
            if (EvaluatorPanel.this.vm != null && EvaluatorPanel.this.vm.getCapabilities().canPin() && this.data instanceof DebugDataCompositeInfo && !(datac = (DebugDataCompositeInfo)this.data).isNull()) {
                this.ei.pin(EvaluatorPanel.this.debuggingProcess, datac);
                this.reEvaluateExpression(treePath);
            }
        }

        boolean canUnpin() {
            return this.ei.canUnpin(EvaluatorPanel.this.debuggingProcess);
        }

        void unpin(TreePath treePath) {
            this.ei.unpin(EvaluatorPanel.this.debuggingProcess);
            this.reEvaluateExpression(treePath);
        }
    }
}

