/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.Runner;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebuggingListener
extends BaseElement
implements DebugConnectionListener {
    private DebuggingProcess debuggingProcess;
    private boolean keepListening;
    private Workspace workspace;
    private Project project;
    private RunConfiguration runConfiguration;
    private DebugConfiguration debugConfiguration;
    private DebugConnector connector;
    private DebugConnectArg[] connectArgs;
    private String connectArgsLabel;

    DebuggingListener(DebuggingProcess debuggingProcess, boolean keepListening) {
        JDebugger.getInstance().makeDebuggingListenerActions();
        this.debuggingProcess = debuggingProcess;
        this.keepListening = keepListening;
        this.project = debuggingProcess.getProject();
        this.workspace = debuggingProcess.getWorkspace();
        this.runConfiguration = debuggingProcess.getRunConfiguration();
        this.debugConfiguration = debuggingProcess.getDebugConfiguration();
        this.setIcon(OracleIcons.getIcon((String)"debugger/deb_ltnr.gif"));
    }

    boolean startListening() {
        return this.startListening(null);
    }

    boolean startListening(String listenPort) {
        this.connector = DebugFactory.newInstance(1);
        this.connectArgs = this.connector.getConnectArgs();
        int count = this.connectArgs.length;
        boolean errorOccurred = false;
        while (true) {
            DebugConnectArg connectArg;
            int i;
            if (this.runConfiguration.isRemoteDebuggingProfiling()) {
                boolean needDialog = this.debugConfiguration.isPromptForRemoteDebugging();
                for (i = 0; i < count; ++i) {
                    connectArg = this.connectArgs[i];
                    String value = this.debugConfiguration.getRemoteParameterValue("jpdaListen", connectArg.getName());
                    if (value != null) {
                        connectArg.setValue(value);
                        if (value.length() != 0 || connectArg.allowBlank()) continue;
                        needDialog = true;
                        continue;
                    }
                    needDialog = true;
                }
                if (errorOccurred) {
                    needDialog = true;
                }
                if (needDialog) {
                    String[] labels = new String[count];
                    String[] values = new String[count];
                    boolean[] allowBlanks = new boolean[count];
                    for (int i2 = 0; i2 < count; ++i2) {
                        DebugConnectArg connectArg2 = this.connectArgs[i2];
                        labels[i2] = connectArg2.getLabel();
                        values[i2] = connectArg2.getValue();
                        allowBlanks[i2] = connectArg2.allowBlank();
                    }
                    String title = DbgArb.getString(200);
                    String helpId = "f1_deb_listen_jpda_html";
                    boolean[] save = !Product.isRaptor() ? new boolean[1] : null;
                    boolean ok = RemoteConnectDialog.showRemoteConnectDialog(title, labels, values, allowBlanks, save, helpId);
                    if (!ok) {
                        return false;
                    }
                    for (int i3 = 0; i3 < count; ++i3) {
                        DebugConnectArg connectArg3 = this.connectArgs[i3];
                        connectArg3.setValue(values[i3]);
                        if (save != null && !save[0] && !this.debugConfiguration.isCustom()) continue;
                        this.debugConfiguration.putRemoteParameterValue("jpdaListen", connectArg3.getName(), values[i3]);
                    }
                    if (save == null || save[0]) {
                        this.debugConfiguration.setPromptForRemoteDebugging(false);
                    }
                }
            } else {
                DebugConnectArg connectArg4 = DebugShared.findConnectArg(this.connectArgs, "port");
                if (connectArg4 != null) {
                    connectArg4.setValue(listenPort);
                }
            }
            try {
                this.connector.startListening(this.connectArgs, this);
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < count; ++i) {
                    connectArg = this.connectArgs[i];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(connectArg.getLabel());
                    sb.append("=");
                    sb.append(connectArg.getValue());
                }
                this.connectArgsLabel = sb.toString();
                return true;
            }
            catch (Exception e) {
                block16: {
                    int answer;
                    if (!this.runConfiguration.isRemoteDebuggingProfiling()) break block16;
                    errorOccurred = true;
                    String[] messages = new String[]{DbgArb.getString(202), DbgArb.getString(203)};
                    if ((answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), messages, DbgArb.getString(204), 0)) != 1) continue;
                }
                return false;
            }
            break;
        }
    }

    void stopListening() {
        try {
            this.connector.stopListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void listeningStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDebugger.getInstance().listenerStarted(DebuggingListener.this);
                Runner.getRunner().getRunManagerFolder().add((Element)DebuggingListener.this);
            }
        });
    }

    @Override
    public boolean connectionEstablished(final DebugVirtualMachine vm) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingProcess debuggingProcessForAccept = DebuggingListener.this.debuggingProcess;
                DebuggingListener.this.debuggingProcess = null;
                if (debuggingProcessForAccept == null) {
                    Context context = ContextBuilder.buildContext(null, (View)Runner.getRunner().getRunManagerWindow(), null, DebuggingListener.this.workspace, DebuggingListener.this.project);
                    debuggingProcessForAccept = new DebuggingProcess(context);
                }
                debuggingProcessForAccept.accept(vm, DebuggingListener.this.connectArgs);
            }
        });
        return this.keepListening;
    }

    @Override
    public void listeningStopped() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DebuggingListener.this.debuggingProcess != null) {
                    DebuggingListener.this.debuggingProcess.listenerStopped();
                    DebuggingListener.this.debuggingProcess = null;
                }
                JDebugger.getInstance().listenerStopped(DebuggingListener.this);
                Runner.getRunner().getRunManagerFolder().remove((Element)DebuggingListener.this);
            }
        });
    }

    @Override
    public String getShortLabel() {
        if (this.connectArgsLabel != null && this.connectArgsLabel.length() > 0) {
            return DbgArb.format(163, this.connectArgsLabel);
        }
        return DbgArb.getString(162);
    }
}

