/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;
import oracle.bali.inspector.swing.AbstractTableCellEditor;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JFastTreeTable;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.runner.debug.DataArrayNavigationPanel;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTipDisplayer;

class DataValueCellEditor
extends AbstractTableCellEditor
implements Controller {
    private JPanel valueColumnPanel;
    private JPanel dataTipColumnPanel;
    private JLabel label;
    private final DataPanel dataPanel;
    private final DataArrayNavigationPanel buttonPanel;
    private int lastRowRendered;

    DataValueCellEditor(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
        this.lastRowRendered = -1;
        this.valueColumnPanel = new JPanel(new BorderLayout(0, 0));
        this.valueColumnPanel.setOpaque(true);
        this.valueColumnPanel.addMouseListener(new MouseAdapter(){

            public void MousePressed(MouseEvent me) {
                DataValueCellEditor.this.cancelCellEditing();
            }
        });
        this.buttonPanel = new DataArrayNavigationPanel();
        this.buttonPanel.setOpaque(true);
        this.label = new JLabel();
        this.label.setOpaque(true);
        this.label.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.valueColumnPanel.add((Component)this.label, "Center");
        this.valueColumnPanel.add((Component)this.buttonPanel, "East");
        this.buttonPanel.addObjectPreferencesActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataValueCellEditor.this.dataPanel.showObjectPreferences(e);
            }
        });
        this.buttonPanel.addFirstButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangeFirst();
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.buttonPanel.addLastButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangeLast();
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.buttonPanel.addPreviousButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangePrevious();
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.buttonPanel.addNextButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataValueCellEditor.this.cancelCellEditing();
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    dataItem.adjustRangeNext();
                    DataValueCellEditor.this.buttonPanel.enableNavigationButtons(dataItem);
                }
            }
        });
        this.dataTipColumnPanel = new JPanel(new BorderLayout());
        this.dataTipColumnPanel.setOpaque(false);
        JButton button = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"green_dot.png"));
        this.dataTipColumnPanel.add((Component)button, "Center");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataItem dataItem = DataValueCellEditor.this.getCurrentDataItem();
                if (dataItem != null) {
                    DataTipDisplayer dataTipDisplayer = new DataTipDisplayer(DataValueCellEditor.this.dataPanel, dataItem, DataValueCellEditor.this.dataPanel.getDataTipModelIndices());
                    dataTipDisplayer.prepareAndShowQuickInspect();
                }
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.lastRowRendered = row;
        int modelIndex = table.convertColumnIndexToModel(column);
        if (modelIndex == 1) {
            this.label.setForeground(table.getSelectionForeground());
            this.label.setBackground(table.getSelectionBackground());
            this.label.setFont(table.getFont());
            this.label.setText(value == null ? "" : value.toString());
            JFastTreeTable treeTable = (JFastTreeTable)table;
            DataPanel.DataTreeTableModel model = (DataPanel.DataTreeTableModel)((Object)treeTable.getTree().getModel());
            TreePath treePath = treeTable.getTree().getPathForRow(row);
            DataItem dataItem = model.getDataItemForTreePath(treePath);
            this.buttonPanel.updatePanel(dataItem);
            this.buttonPanel.setForeground(treeTable.getSelectionForeground());
            this.buttonPanel.setBackground(treeTable.getSelectionBackground());
            this.valueColumnPanel.revalidate();
            return this.valueColumnPanel;
        }
        if (modelIndex == 7) {
            return this.dataTipColumnPanel;
        }
        return new JPanel();
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    private DataItem getCurrentDataItem() {
        DataItem dataItem = this.dataPanel.getSelectedDataItem();
        if (dataItem != null) {
            return dataItem;
        }
        if (this.lastRowRendered >= 0) {
            return this.dataPanel.getDataItemForRow(this.lastRowRendered);
        }
        return null;
    }
}

