/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.controls.TreeTableModel;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DataTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private TreePath treePath;
    private DataItem dataItem;
    private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();

    public DataTreeCellRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.defaultRenderer, "Center");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.defaultRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DataItem) {
            this.dataItem = (DataItem)value;
            this.treePath = tree.getPathForRow(row);
            this.defaultRenderer.setIcon(this.dataItem.getIcon());
            this.defaultRenderer.setFont(this.dataItem.getFont(0));
            this.defaultRenderer.setEnabled(!this.dataItem.isUnrelated());
            this.defaultRenderer.setToolTipText(this.dataItem.getToolTipText());
            try {
                AccessibleContext ac = this.defaultRenderer.getAccessibleContext();
                String accessibleName = DataTreeCellRenderer.getAccessibleNameAt((TreeTableModel)tree.getModel(), this.dataItem, 0);
                if (this.dataItem.mayHaveChildren()) {
                    accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                }
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
            }
            catch (DataExpiredException e) {}
        } else {
            this.dataItem = null;
            this.defaultRenderer.setIcon(null);
            this.defaultRenderer.setFont(tree.getFont());
            this.defaultRenderer.setEnabled(true);
            this.defaultRenderer.setToolTipText(null);
        }
        return this.defaultRenderer;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.dataItem != null && this.treePath != null) {
            return this.dataItem.getToolTip(0, this.treePath);
        }
        return null;
    }

    void clear() {
        this.treePath = null;
        this.dataItem = null;
    }

    static String getAccessibleNameAt(TreeTableModel model, DataItem dataItem, int column) {
        int id = 265;
        if (column == 7) {
            return DbgArb.getString(909);
        }
        String columnName = model.getColumnName(column);
        String value = (String)model.getValueAt((Object)dataItem, column);
        if (value == null || value.length() == 0) {
            value = DbgArb.getString(842);
        }
        return DbgArb.format(id, columnName, value);
    }
}

