/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.runner.debug.DataArrayNavigationPanel;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTreeCellRenderer;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DataTableCellRenderer
implements TableCellRenderer {
    private TreePath treePath;
    private DataItem dataItem;
    private int modelColumn;
    private DataArrayNavigationPanel buttonPanel;
    private DefaultTableCellRenderer defaultRenderer;
    private DefaultTableCellRenderer valueRenderer = new DefaultTableCellRenderer();
    private JPanel valueColumnPanel;
    private JPanel dataTipColumnPanel;
    private final JButton dataTipButton;

    DataTableCellRenderer() {
        this.defaultRenderer = new DefaultTableCellRenderer(){

            @Override
            public String getToolTipText() {
                return DataTableCellRenderer.this.getToolTipText();
            }
        };
        this.valueColumnPanel = new JPanel(new BorderLayout()){

            @Override
            public String getToolTipText() {
                return DataTableCellRenderer.this.getToolTipText();
            }
        };
        this.valueColumnPanel.add((Component)this.valueRenderer, "Center");
        this.buttonPanel = new DataArrayNavigationPanel();
        this.buttonPanel.setOpaque(true);
        this.valueColumnPanel.add((Component)this.buttonPanel, "East");
        this.dataTipColumnPanel = new JPanel(new BorderLayout()){

            @Override
            public String getToolTipText() {
                return DbgArb.getString(909);
            }
        };
        this.dataTipColumnPanel.setOpaque(false);
        this.dataTipButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"green_dot.png"));
        this.dataTipColumnPanel.add((Component)this.dataTipButton, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.modelColumn = table.convertColumnIndexToModel(column);
        Component result = this.modelColumn == 1 ? this.valueRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JFastTreeTable treeTable = (JFastTreeTable)table;
        DataPanel.DataTreeTableModel model = (DataPanel.DataTreeTableModel)((Object)treeTable.getTree().getModel());
        this.treePath = treeTable.getTree().getPathForRow(row);
        this.dataItem = model.getDataItemForTreePath(this.treePath);
        if (this.dataItem != null) {
            result.setFont(this.dataItem.getFont(this.modelColumn));
        }
        if (this.dataItem != null) {
            AccessibleContext ac = result.getAccessibleContext();
            String accessibleName = DataTreeCellRenderer.getAccessibleNameAt((TreeTableModel)model, this.dataItem, this.modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
        }
        if (this.modelColumn == 1) {
            this.buttonPanel.setOpaque(true);
            this.buttonPanel.updatePanel(this.dataItem);
            this.buttonPanel.setForeground(treeTable.getSelectionForeground());
            this.buttonPanel.setBackground(isSelected ? treeTable.getSelectionBackground() : treeTable.getBackground());
            return this.valueColumnPanel;
        }
        if (this.modelColumn == 7) {
            this.dataTipButton.setVisible(this.dataItem != null && this.dataItem.mayHaveChildren());
            return this.dataTipColumnPanel;
        }
        return result;
    }

    public String getToolTipText() {
        if (this.dataItem != null && this.treePath != null) {
            return this.dataItem.getToolTip(this.modelColumn, this.treePath);
        }
        return null;
    }

    void clear() {
        this.treePath = null;
        this.dataItem = null;
    }
}

