/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataArrayRange;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTableCellRenderer;
import oracle.jdevimpl.runner.debug.DataTreeCellRenderer;
import oracle.jdevimpl.runner.debug.DataValueCellEditor;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.ObjectPreferencesPanel;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.debug.Utils;

abstract class DataPanel
implements TreeExpansionListener,
TreeSelectionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
Controller,
ContextMenuListener,
ColumnMenuListener,
UpdateableDataWindow {
    protected DockableWindow dockableWindow;
    protected String title;
    protected DataTreeTableModel model;
    protected JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private DataTreeCellRenderer dataTreeCellRenderer;
    private DataTableCellRenderer dataTableCellRenderer;
    private boolean skippedUpdate = true;
    protected DebuggingProcess debuggingProcess;
    protected DebugVirtualMachine vm;
    protected DebugThreadInfo thread;
    protected DebugStackFrameInfo frame;
    protected boolean useFilters;
    private ObjectPreferences objectPreferences;
    private static final String BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX = "DebugDataInstanceFilter";
    private Map breakpointInstanceFilterActions;
    protected Map arrayRanges;
    protected boolean selectFirstRowIfNoPreviousSelection;
    protected DataPanelSettings dataPanelSettings;
    protected int preferredVisibleRowCount = 6;
    protected Font ancestorDepthZeroFont = null;
    protected Font heapAncestorOutsideHeapFont = null;
    protected IdeAction _actionViewWhole;
    protected IdeAction _actionViewAnnotations;
    protected IdeAction _actionViewAnnotationsForClass;
    protected IdeAction _actionAdjustRange;
    protected IdeAction _actionToggleValue;
    protected IdeAction _actionModifyValue;
    protected IdeAction _actionDiagram;
    protected IdeAction _actionWatch;
    protected IdeAction _actionInspect;
    protected IdeAction _actionWatchClassLoader;
    protected IdeAction _actionInspectClassLoader;
    protected IdeAction _actionGoto;
    protected IdeAction _actionGotoDeclared;
    protected IdeAction _actionGotoField;
    protected IdeAction _actionUseFilters;
    protected IdeAction _actionObjectPreferences;
    protected IdeAction _actionCollapseAll;
    protected IdeAction _actionSave;
    protected JMenuItem _menuitemViewWhole;
    protected JMenuItem _menuitemViewAnnotations;
    protected JMenuItem _menuitemViewAnnotationsForClass;
    protected JMenuItem _menuitemAdjustRange;
    protected JMenuItem _menuitemToggleValue;
    protected JMenuItem _menuitemModifyValue;
    protected JMenuItem _menuitemDiagram;
    protected JMenuItem _menuitemWatch;
    protected JMenuItem _menuitemInspect;
    protected JMenuItem _menuitemWatchClassLoader;
    protected JMenuItem _menuitemInspectClassLoader;
    protected JMenuItem _menuitemGoto;
    protected JMenuItem _menuitemGotoDeclared;
    protected JMenuItem _menuitemGotoField;
    protected JMenuItem _menuitemUseFilters;
    protected JMenuItem _menuitemObjectPreferences;
    protected JMenuItem _menuitemCollapseAll;
    protected JMenuItem _menuitemSave;
    protected int _VIEW_WHOLE_CMD_ID;
    protected int _VIEW_ANNOTATIONS_CMD_ID;
    protected int _VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    protected int _ADJUST_RANGE_CMD_ID;
    protected int _TOGGLE_VALUE_CMD_ID;
    protected int _MODIFY_VALUE_CMD_ID;
    protected int _DIAGRAM_CMD_ID;
    protected int _WATCH_CMD_ID;
    protected int _INSPECT_CMD_ID;
    protected int _WATCH_CLASSLOADER_CMD_ID;
    protected int _INSPECT_CLASSLOADER_CMD_ID;
    protected int _GOTO_CMD_ID;
    protected int _GOTO_DECLARED_CMD_ID;
    protected int _GOTO_FIELD_CMD_ID;
    protected int _USE_FILTERS_CMD_ID;
    protected int _OBJECT_PREFERENCES_CMD_ID;
    protected int _COLLAPSE_ALL_CMD_ID;
    protected int _SAVE_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_VALUE = 1;
    static final int COLUMN_ACTUAL_TYPE = 2;
    static final int COLUMN_DECLARED_TYPE = 3;
    static final int COLUMN_HEX_VALUE = 4;
    static final int COLUMN_ADDRESS = 5;
    static final int COLUMN_ID = 6;
    static final int COLUMN_DATA_TIP = 7;
    static final int NUMBER_OF_COLUMNS = 8;
    protected TableColumn[] column = new TableColumn[8];
    protected int[] columnDefaultWidth = new int[8];
    protected boolean[] columnShowing = new boolean[8];
    private Object modelUpdateLock = new Object();
    private static final ExecutorService UPDATE_SCHEDULER = Executors.newSingleThreadExecutor(new WorkerThreadFactory());
    protected boolean canUpdateData = true;
    private boolean adjustColumnsAlreadyDone = false;
    private Font normalFont;
    private Font boldFont;
    private Font boldItalicFont;

    static void showAnnotationsDialog(String title, DataPanelSettings dataPanelSettings, DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame, final DebugAnnotationInfo[] annotations) {
        TreePath treePath;
        if (dataPanelSettings == null) {
            dataPanelSettings = LocalsWindowSettings.getInstance().getDataPanelSettings();
        }
        DataPanel dataPanel = new DataPanel(title, dataPanelSettings){

            @Override
            protected void addDataItems() {
                List root = this.getRoot();
                int i = 0;
                for (DebugAnnotationInfo annotation : annotations) {
                    DebugClassInfo annotationType = annotation.getClassInfo();
                    String displayName = "@" + DataItem.makeType(null, annotationType, false);
                    root.add(new DataItem(this, annotation, displayName, null));
                    ++i;
                }
            }
        };
        Component dataPanelGUI = dataPanel.getGUI();
        dataPanel.loadSettings();
        dataPanel.debugWindowSettingsChanged(DebugWindowSettings.getInstance());
        dataPanel.dataPanelSettingsChanged(false);
        dataPanel.updateData(debuggingProcess, vm, thread, frame);
        if (annotations.length == 1 && dataPanel.treeTable.getModel().getRowCount() > 0 && (treePath = dataPanel.treeTable.getTree().getPathForRow(0)) != null) {
            dataPanel.treeTable.getTree().expandPath(treePath);
        }
        OnePageWizardDialogFactory.runDialog((Component)dataPanelGUI, (Component)dataPanel.treeTable, (String)title, (int)1);
    }

    DataPanel(String title, DataPanelSettings dataPanelSettings) {
        this(dataPanelSettings);
        this.title = title;
    }

    DataPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        this(dataPanelSettings);
        this.dockableWindow = dockableWindow;
        this.title = dockableWindow.getTitleName();
    }

    private DataPanel(DataPanelSettings dataPanelSettings) {
        this.dataPanelSettings = dataPanelSettings;
        JDebugger jdebugger = JDebugger.getInstance();
        this.objectPreferences = jdebugger.getObjectPreferences();
        this.breakpointInstanceFilterActions = new HashMap(10);
        this.arrayRanges = new HashMap();
        jdebugger.getContextMenu().addContextMenuListener((ContextMenuListener)this);
        dataPanelSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                if (Utils.structureReallyChanged(e)) {
                    DataPanel.this.dataPanelSettingsChanged(true);
                }
            }
        });
    }

    private boolean isParentVisible() {
        if (this.dockableWindow != null) {
            return this.dockableWindow.isVisible();
        }
        return this.scrollPane != null;
    }

    @Override
    public void showColumn(int modelIndex) {
        if (modelIndex != 0) {
            this.columnShowing[modelIndex] = true;
            if (this.dataPanelSettings != null) {
                this.dataPanelSettings.setColumnVisible(modelIndex, true);
            }
            this.treeTable.addColumn(this.column[modelIndex]);
            this.setColumnOrder();
        }
    }

    @Override
    public void hideColumn(int modelIndex) {
        if (modelIndex != 0) {
            this.columnShowing[modelIndex] = false;
            if (this.dataPanelSettings != null) {
                this.dataPanelSettings.setColumnVisible(modelIndex, false);
            }
            this.treeTable.removeColumn(this.column[modelIndex]);
        }
    }

    private void createGUI() {
        List modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new DataTreeTableModel(modelRoot);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.title);
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < 8; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
        }
        boolean[] showColumnInMenu = new boolean[8];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
        this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
        this.columnDefaultWidth[7] = 10;
        this.column[7].setPreferredWidth(10);
        this.column[7].setMaxWidth(10);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        tree.addTreeExpansionListener(this);
        tree.addTreeSelectionListener(this);
        this.dataTreeCellRenderer = new DataTreeCellRenderer();
        tree.setCellRenderer(this.dataTreeCellRenderer);
        this.dataTableCellRenderer = new DataTableCellRenderer();
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)this.dataTableCellRenderer);
        this.treeTable.setDefaultRenderer(JButton.class, (TableCellRenderer)this.dataTableCellRenderer);
        DataValueCellEditor dataValueCellEditor = new DataValueCellEditor(this);
        this.column[1].setCellEditor((TableCellEditor)((Object)dataValueCellEditor));
        this.column[7].setCellEditor((TableCellEditor)((Object)dataValueCellEditor));
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                int modelIndex = table.convertColumnIndexToModel(column);
                if (modelIndex == 7) {
                    value = " ";
                }
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    defaultTableCellRenderer.setHorizontalAlignment(2);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(326, DataPanel.this.title));
                }
                if (JDebugger.isDoubleClickInTreeTable(DataPanel.this.treeTable, e)) {
                    DataItem dataItem;
                    int columnAtX = DataPanel.this.treeTable.getColumnModel().getColumnIndexAtX(e.getX());
                    int column = DataPanel.this.treeTable.convertColumnIndexToModel(columnAtX);
                    boolean ignoreDoubleClick = false;
                    if (column == 1 && (dataItem = DataPanel.this.getSelectedDataItem()) != null && dataItem.shouldShowArrayNavigationButtons()) {
                        int row = DataPanel.this.treeTable.rowAtPoint(e.getPoint());
                        int col = DataPanel.this.treeTable.columnAtPoint(e.getPoint());
                        Rectangle r = DataPanel.this.treeTable.getCellRect(row, col, true);
                        if (e.getPoint().getX() > (double)(r.x + r.width - 64)) {
                            ignoreDoubleClick = true;
                        }
                    }
                    if (!ignoreDoubleClick) {
                        DataPanel.this.handleDoubleClickOrEnter(e, column);
                    }
                }
            }
        });
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(326, DataPanel.this.title));
                }
            }
        });
        this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 10: {
                        int column;
                        int selectedColumn = DataPanel.this.treeTable.getSelectedColumn();
                        if (selectedColumn == -1 || !DataPanel.this.handleDoubleClickOrEnter(e, column = DataPanel.this.treeTable.convertColumnIndexToModel(selectedColumn))) break;
                        e.consume();
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    DataPanel.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(326, DataPanel.this.title));
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DataPanel.this.adjustColumnsAfterResize();
            }
        });
        this.treeTable.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && (DataPanel.this.treeTable.isShowing() || DataPanel.this.dockableWindow == null)) {
                    DataPanel.this.nowShown();
                }
            }
        });
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 1, this);
        new DropTarget((Component)this.treeTable, 1, this);
        new DropTarget(this.scrollPane.getViewport(), 1, this);
        new DropTarget(this.scrollPane, 1, this);
        this.adjustGUI();
    }

    protected void adjustGUI() {
    }

    private boolean handleDoubleClickOrEnter(EventObject e, int column) {
        IdeAction action = null;
        switch (column) {
            case 0: {
                action = this._actionGotoField;
                break;
            }
            case 2: {
                action = this._actionGoto;
                break;
            }
            case 3: {
                action = this._actionGotoDeclared;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                action = this._actionModifyValue;
            }
        }
        if (action != null) {
            Context context = this.getContext(e);
            this.update(action, context);
            if (action.isEnabled()) {
                this.handleEvent(action, context);
                return true;
            }
        }
        return false;
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    protected Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.treeTable.getTree().getFont();
        }
        return this.normalFont;
    }

    protected Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getNormalFont().deriveFont(1);
        }
        return this.boldFont;
    }

    protected Font getBoldItalicFont() {
        if (this.boldItalicFont == null) {
            this.boldItalicFont = this.getNormalFont().deriveFont(3);
        }
        return this.boldItalicFont;
    }

    Component getGUI() {
        if (this.scrollPane == null) {
            this.createGUI();
        }
        return this.scrollPane;
    }

    void loadSettings() {
        for (int i = 0; i < 8; ++i) {
            int width = this.dataPanelSettings.getColumnWidth(i);
            if (width == 0) continue;
            this.adjustColumnsAlreadyDone = true;
            this.column[i].setPreferredWidth(width);
        }
        this.setColumnOrder();
    }

    private void setColumnOrder() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = this.dataPanelSettings.getColumnOrder();
        boolean orderedQuickInspect = false;
        if (order != null) {
            String[] orderedColumns = order.split(",");
            int currentColumn = 0;
            for (int i = 0; i < 8 && i < orderedColumns.length; ++i) {
                String identifier = orderedColumns[i];
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (tableColumnModel.getColumn(from).getModelIndex() == 7) {
                        orderedQuickInspect = true;
                    }
                    if (from != currentColumn) {
                        this.treeTable.moveColumn(from, currentColumn);
                    }
                    ++currentColumn;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        if (!orderedQuickInspect) {
            for (int i = 0; i < this.treeTable.getColumnCount(); ++i) {
                if (this.treeTable.getColumnModel().getColumn(i).getModelIndex() != 7) continue;
                if (i == 0) break;
                this.treeTable.moveColumn(i, 0);
                break;
            }
        }
    }

    void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        if (this.treeTable == null) {
            return;
        }
        this.useFilters = dbgSettings.isUseFilters();
    }

    void dataPanelSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            boolean show = this.dataPanelSettings.getColumnVisible(i);
            if (this.columnShowing[i] == show) continue;
            this.columnShowing[i] = show;
            if (show) {
                this.treeTable.addColumn(this.column[i]);
                continue;
            }
            this.treeTable.removeColumn(this.column[i]);
        }
        this.setColumnOrder();
        if (changed && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataPanel.this.everythingChanged();
                }
            });
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            this.dataPanelSettings.setColumnWidth(i, this.column[i].getWidth());
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = "";
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.dataPanelSettings.setColumnOrder(order);
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject event) {
        Object info;
        DebugDataInfo dataInfo;
        DataItem dataItem = this.getSelectedDataItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (dataItem != null && (dataInfo = dataItem.getDataInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)((Object)dataInfo);
        }
        Context context = ContextBuilder.buildContext((Element)dataItem, (View)this.dockableWindow, event, this.debuggingProcess, jdiInformationProvider);
        if (this.frame instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)((Object)this.frame));
        }
        if (dataItem != null && (info = dataItem.getInfo()) instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)info);
        }
        return context;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.model.branchExpanded(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.model.branchCollapsed(event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point pt;
        TreePath treePath;
        DataItem dataItem;
        DataFlavor[] transferFlavors;
        if (e.getDragAction() == 1 && (transferFlavors = (dataItem = this.model.getDataItemForTreePath(treePath = this.model.getTreePathAtPoint(pt = e.getDragOrigin()))).canDrag(treePath)) != null) {
            try {
                BufferedImage dragImage = new BufferedImage(1, 1, 6);
                dragImage.setRGB(0, 0, -16777216);
                Point imageOffset = new Point(0, 0);
                e.startDrag(null, dragImage, imageOffset, dataItem, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.checkDrop(e);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    protected void checkDrag(DropTargetDragEvent e) {
        e.rejectDrag();
    }

    protected void checkDrop(DropTargetDropEvent e) {
        e.rejectDrop();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewWhole();
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewAnnotations(this.debuggingProcess, this.vm, this.thread, this.frame);
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewAnnotationsForClass(this.debuggingProcess, this.vm, this.thread, this.frame);
            }
            return true;
        }
        if (cmdId == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.adjustRange(treePath);
            }
            return true;
        }
        if (cmdId == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.toggleValue();
            }
            return true;
        }
        if (cmdId == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.modifyValue(this.vm);
            }
            return true;
        }
        if (cmdId == this._WATCH_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.watch(treePath);
            }
            return true;
        }
        if (cmdId == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.inspect(treePath);
            }
            return true;
        }
        if (cmdId == this._WATCH_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.watchClassLoader(this.debuggingProcess);
            }
            return true;
        }
        if (cmdId == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.inspectClassLoader(this.debuggingProcess);
            }
            return true;
        }
        if (cmdId == this._GOTO_CMD_ID || cmdId == this._GOTO_DECLARED_CMD_ID || cmdId == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.showSource(cmdId, this.debuggingProcess);
            }
            return true;
        }
        if (cmdId == this._USE_FILTERS_CMD_ID) {
            JDebugger.getInstance().setUseFilters(action.getState());
            return true;
        }
        if (cmdId == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
                ObjectPreferencesPanel.showObjectPreferencesDialog(dataItem.actualClassInfo, this.dataPanelSettings.isSortFieldsByName());
            }
            return true;
        }
        if (cmdId == this._COLLAPSE_ALL_CMD_ID) {
            this.model.collapseAll();
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = dataItem.getValueOfColumn(column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        DebugBreakpoint dbp = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(action);
        if (dbp != null) {
            DebugDataInfo ddi;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (ddi = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                DebugDataObjectInfo data = (DebugDataObjectInfo)ddi;
                Boolean isInstanceFilterSet = (Boolean)action.getValue("UserData");
                if (isInstanceFilterSet.booleanValue()) {
                    dbp.removeInstanceFilter(data);
                } else {
                    dbp.addInstanceFilter(data);
                }
                JDebugger.getInstance().updateBreakpointsWindowInstanceFilters();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.isParentVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canViewWhole());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String name = dataItem.canViewAnnotations();
                if (name != null) {
                    action.setEnabled(true);
                    action.putValue("Name", (Object)name);
                } else {
                    action.setEnabled(false);
                    action.putValue("Name", action.getValue("NoCtxName"));
                }
            } else {
                action.setEnabled(false);
                action.putValue("Name", action.getValue("NoCtxName"));
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canViewAnnotationsForClass());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canAdjustRange());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canToggleValue());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canModifyValue());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._DIAGRAM_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                action.setEnabled(dataItem.canDiagram(treePath));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._WATCH_CMD_ID || cmdId == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                action.setEnabled(dataItem.canWatchAndInspect(treePath));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._WATCH_CLASSLOADER_CMD_ID || cmdId == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._GOTO_CMD_ID || cmdId == this._GOTO_DECLARED_CMD_ID || cmdId == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String name = dataItem.canShowSource(cmdId);
                if (name != null) {
                    action.setEnabled(true);
                    action.putValue("Name", (Object)name);
                } else {
                    action.setEnabled(false);
                    action.putValue("Name", action.getValue("NoCtxName"));
                }
            } else {
                action.setEnabled(false);
                action.putValue("Name", action.getValue("NoCtxName"));
            }
            return true;
        }
        if (cmdId == this._USE_FILTERS_CMD_ID) {
            action.setState(this.useFilters);
            action.setEnabled(!this.objectPreferences.isHiddenFieldsEmpty());
            return true;
        }
        if (cmdId == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            DataItem dataItem = this.getSelectedDataItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(dataItem != null && column != -1);
            return true;
        }
        DebugBreakpoint dbp = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(action);
        if (dbp != null) {
            DebugDataInfo ddi;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (ddi = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            this.addPopupMenuItemsForNew(popup, context);
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                this.addPopupMenuItemsForDataItem(popup, context);
            }
            this.addPopupMenuItemsForData(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        this.update(this._actionViewWhole, context);
        if (this._actionViewWhole.isEnabled()) {
            if (this._menuitemViewWhole == null) {
                this._menuitemViewWhole = popup.createMenuItem((ToggleAction)this._actionViewWhole);
            }
            popup.add((Component)this._menuitemViewWhole, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionViewAnnotations, context);
        if (this._actionViewAnnotations.isEnabled()) {
            if (this._menuitemViewAnnotations == null) {
                this._menuitemViewAnnotations = popup.createMenuItem((ToggleAction)this._actionViewAnnotations);
            }
            popup.add((Component)this._menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionViewAnnotationsForClass, context);
        if (this._actionViewAnnotationsForClass.isEnabled()) {
            if (this._menuitemViewAnnotationsForClass == null) {
                this._menuitemViewAnnotationsForClass = popup.createMenuItem((ToggleAction)this._actionViewAnnotationsForClass);
            }
            popup.add((Component)this._menuitemViewAnnotationsForClass, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionAdjustRange, context);
        if (this._actionAdjustRange.isEnabled()) {
            if (this._menuitemAdjustRange == null) {
                this._menuitemAdjustRange = popup.createMenuItem((ToggleAction)this._actionAdjustRange);
            }
            popup.add((Component)this._menuitemAdjustRange, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionToggleValue, context);
        if (this._actionToggleValue.isEnabled()) {
            if (this._menuitemToggleValue == null) {
                this._menuitemToggleValue = popup.createMenuItem((ToggleAction)this._actionToggleValue);
            }
            popup.add((Component)this._menuitemToggleValue, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionModifyValue, context);
        if (this._actionModifyValue.isEnabled()) {
            if (this._menuitemModifyValue == null) {
                this._menuitemModifyValue = popup.createMenuItem((ToggleAction)this._actionModifyValue);
            }
            popup.add((Component)this._menuitemModifyValue, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        if (this._actionDiagram != null) {
            this.update(this._actionDiagram, context);
            if (this._actionDiagram.isEnabled()) {
                if (this._menuitemDiagram == null) {
                    this._menuitemDiagram = popup.createMenuItem((ToggleAction)this._actionDiagram);
                }
                popup.add((Component)this._menuitemDiagram, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionWatch != null) {
            this.update(this._actionWatch, context);
            if (this._actionWatch.isEnabled()) {
                if (this._menuitemWatch == null) {
                    this._menuitemWatch = popup.createMenuItem((ToggleAction)this._actionWatch);
                }
                popup.add((Component)this._menuitemWatch, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionInspect != null) {
            this.update(this._actionInspect, context);
            if (this._actionInspect.isEnabled()) {
                if (this._menuitemInspect == null) {
                    this._menuitemInspect = popup.createMenuItem((ToggleAction)this._actionInspect);
                }
                popup.add((Component)this._menuitemInspect, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        this.update(this._actionWatchClassLoader, context);
        if (this._actionWatchClassLoader.isEnabled()) {
            if (this._menuitemWatchClassLoader == null) {
                this._menuitemWatchClassLoader = popup.createMenuItem((ToggleAction)this._actionWatchClassLoader);
            }
            popup.add((Component)this._menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionInspectClassLoader, context);
        if (this._actionInspectClassLoader.isEnabled()) {
            if (this._menuitemInspectClassLoader == null) {
                this._menuitemInspectClassLoader = popup.createMenuItem((ToggleAction)this._actionInspectClassLoader);
            }
            popup.add((Component)this._menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionGoto, context);
        if (this._actionGoto.isEnabled()) {
            if (this._menuitemGoto == null) {
                this._menuitemGoto = popup.createMenuItem((ToggleAction)this._actionGoto);
            }
            popup.add((Component)this._menuitemGoto, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(this._actionGotoDeclared, context);
        if (this._actionGotoDeclared.isEnabled()) {
            if (this._menuitemGotoDeclared == null) {
                this._menuitemGotoDeclared = popup.createMenuItem((ToggleAction)this._actionGotoDeclared);
            }
            popup.add((Component)this._menuitemGotoDeclared, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(this._actionGotoField, context);
        if (this._actionGotoField.isEnabled()) {
            if (this._menuitemGotoField == null) {
                this._menuitemGotoField = popup.createMenuItem((ToggleAction)this._actionGotoField);
            }
            popup.add((Component)this._menuitemGotoField, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.addBreakpointInstanceFilterActions(popup, context);
    }

    private void addBreakpointInstanceFilterActions(ContextMenu popup, Context context) {
        DebugDataInfo data;
        this.breakpointInstanceFilterActions.clear();
        DataItem dataItem = this.getSelectedDataItem();
        if (dataItem != null && (data = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
            Boolean isInstanceFilterSet;
            DebugDataObjectInfo dataObject = (DebugDataObjectInfo)data;
            HashSet classNames = new HashSet();
            HashMap<Breakpoint, Boolean> appropriate = new HashMap<Breakpoint, Boolean>();
            List[] breakpoints = Breakpoint.getBreakpoints(context.getWorkspace(), context.getProject());
            int length = breakpoints.length;
            for (int i = 0; i < length; ++i) {
                for (Breakpoint bp : breakpoints[i]) {
                    DebugBreakpoint dbp = bp.getDebugBreakpoint(this.debuggingProcess);
                    if (dbp == null || !dbp.isInstanceFilterAppropriate(dataObject, classNames)) continue;
                    isInstanceFilterSet = dbp.isInstanceFilterSet(dataObject) ? Boolean.TRUE : Boolean.FALSE;
                    appropriate.put(bp, isInstanceFilterSet);
                }
            }
            if (!appropriate.isEmpty()) {
                JMenu subMenu = popup.createSubMenu(DbgArb.getString(309), DbgArb.getInteger(310));
                int count = 0;
                for (Breakpoint bp : appropriate.keySet()) {
                    isInstanceFilterSet = (Boolean)appropriate.get(bp);
                    String label = DbgArb.format(311, bp.getTypeString(), bp.getDescription());
                    int cmdId = Ide.findOrCreateCmdID((String)(BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX + count++));
                    IdeAction action = IdeAction.get((int)cmdId, null, (String)label, null, null, null, (Object)isInstanceFilterSet, (boolean)true);
                    action.putValue("Name", (Object)label);
                    action.putValue("UserData", (Object)isInstanceFilterSet);
                    action.putValue("Check", (Object)Boolean.TRUE);
                    action.setState(isInstanceFilterSet.booleanValue());
                    action.addController((Controller)this);
                    this.breakpointInstanceFilterActions.put(action, bp.getDebugBreakpoint(this.debuggingProcess));
                    JMenuItem menuitem = popup.createMenuItem((ToggleAction)action);
                    subMenu.add(menuitem);
                }
                popup.add((Component)subMenu, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
    }

    protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
        this.update(this._actionUseFilters, context);
        if (this._actionUseFilters.isEnabled()) {
            if (this._menuitemUseFilters == null) {
                this._menuitemUseFilters = popup.createMenuItem((ToggleAction)this._actionUseFilters);
            }
            popup.add((Component)this._menuitemUseFilters, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(this._actionObjectPreferences, context);
        if (this._actionObjectPreferences.isEnabled()) {
            if (this._menuitemObjectPreferences == null) {
                this._menuitemObjectPreferences = popup.createMenuItem((ToggleAction)this._actionObjectPreferences);
            }
            popup.add((Component)this._menuitemObjectPreferences, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.update(this._actionCollapseAll, context);
        if (this._actionCollapseAll.isEnabled()) {
            if (this._menuitemCollapseAll == null) {
                this._menuitemCollapseAll = popup.createMenuItem((ToggleAction)this._actionCollapseAll);
            }
            popup.add((Component)this._menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(this._actionSave, context);
        if (this._actionSave.isEnabled()) {
            if (this._menuitemSave == null) {
                this._menuitemSave = popup.createMenuItem((ToggleAction)this._actionSave);
            }
            popup.add((Component)this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, this.dockableWindow, this.treeTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(104, this.title);
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        chooser.setHelpID("f1_deb_exportdialog_html");
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, this.title) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                this.model.save(out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            finally {
                wc.hide();
            }
            if (exceptionOccurred != null) {
                String message = DbgArb.format(816, this.title, URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        this.everythingChanged(false);
    }

    void everythingChanged(boolean offThread) {
        if (this.model != null) {
            this.model.updateDataForModel(offThread);
        }
    }

    private void updateColumn(int column) {
        this.model.clearCacheForColumn(column);
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, column);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
        if (column == 0) {
            this.model.saveHighlight();
            this.model.fireChanged();
            this.model.restoreHighlight(false);
        }
    }

    void setUseFilters(boolean useFilters) {
        this.useFilters = useFilters;
        this.everythingChanged();
    }

    protected void debugContextChanged() {
    }

    @Override
    public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.debuggingProcess = debuggingProcess;
        this.vm = vm;
        this.thread = thread;
        this.frame = frame;
        this.debugContextChanged();
        this.canUpdateData = true;
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
            this.everythingChanged();
        }
    }

    @Override
    public void clearData() {
        this.canUpdateData = false;
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.setEnabled(false);
        this.model.clearDataForModel();
        this.vm = null;
        this.thread = null;
        this.frame = null;
        this.debugContextChanged();
    }

    protected abstract void addDataItems();

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            this.thread = null;
            this.frame = null;
            this.debugContextChanged();
            this.canUpdateData = true;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.everythingChanged();
            }
        }
    }

    protected DataArrayRange getArrayRange(DebugDataArrayInfo array) {
        DataArrayRange arrayRange = (DataArrayRange)this.arrayRanges.get(array);
        if (arrayRange != null) {
            this.arrayRanges.remove(array);
            this.arrayRanges.put(array, arrayRange);
        } else {
            arrayRange = new DataArrayRange(this.debuggingProcess, array);
        }
        return arrayRange;
    }

    protected int getNumberOfColumns() {
        return 8;
    }

    protected static String getNameOfColumn(int column) {
        switch (column) {
            case 0: {
                return DbgArb.getString(266);
            }
            case 2: {
                return DbgArb.getString(267);
            }
            case 3: {
                return DbgArb.getString(268);
            }
            case 1: {
                return DbgArb.getString(269);
            }
            case 4: {
                return DbgArb.getString(270);
            }
            case 5: {
                return DbgArb.getString(271);
            }
            case 6: {
                return DbgArb.getString(272);
            }
            case 7: {
                return DbgArb.getString(909);
            }
        }
        return "";
    }

    protected List<Integer> getDataTipModelIndices() {
        ArrayList<Integer> dataTipModelIndexList = new ArrayList<Integer>();
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            int i = column.getModelIndex();
            if (i == 7 || !this.columnShowing[i]) continue;
            dataTipModelIndexList.add(i);
        }
        return dataTipModelIndexList;
    }

    protected int getColumnWidth(int modelIndex) {
        return this.column[modelIndex].getWidth();
    }

    protected List getRoot() {
        return (List)this.model.getRoot();
    }

    protected void addTopDataItem(DataItem dataItem) {
        this.model.addTopDataItem(dataItem);
    }

    protected void addTopDataItem(DataItem dataItem, boolean highlight) {
        this.model.addTopDataItem(dataItem, highlight);
    }

    protected void removeTopDataItem(int i) {
        this.model.removeTopDataItem(i);
    }

    protected void selectTopDataItem(int i) {
        this.model.selectTopDataItem(i);
    }

    TreePath getSelectedTreePath() {
        return this.treeTable.getTree().getSelectionPath();
    }

    Rectangle getSelectedCellBoundsForScreen() {
        int col = this.treeTable.getSelectedColumn();
        int row = this.treeTable.getSelectedRow();
        Rectangle r = this.treeTable.getCellRect(row, col, true);
        Point screen = this.treeTable.getLocationOnScreen();
        r.translate(screen.x, screen.y);
        return r;
    }

    DataItem getSelectedDataItem() {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            return this.model.getDataItemForTreePath(treePath);
        }
        return null;
    }

    DataItem getDataItemForRow(int row) {
        TreePath treePath = this.treeTable.getTree().getPathForRow(row);
        if (treePath != null) {
            return this.model.getDataItemForTreePath(treePath);
        }
        return null;
    }

    void showObjectPreferences(ActionEvent e) {
        Context context = this.getContext(e);
        this.update(this._actionObjectPreferences, context);
        if (this._actionObjectPreferences.isEnabled()) {
            this.handleEvent(this._actionObjectPreferences, context);
        }
    }

    private static String evaluateDataValue(DebugDataObjectInfo dataObject, Set setOfEvaluatedDataObjects, String[] expressionUsed) {
        ObjectPreferences objectPreferences;
        String expression;
        if (setOfEvaluatedDataObjects.add(dataObject) && (expression = (objectPreferences = JDebugger.getInstance().getObjectPreferences()).getValueExpression(dataObject)) != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(dataObject);
            Object info = evaluator.evaluate(expression);
            if (info != null) {
                String actualClassName;
                DebugDataInfo data = Evaluator.getDataInfo(info);
                String s = DataPanel.makeDataValue(info, data, setOfEvaluatedDataObjects);
                if (s != null && s.startsWith("\"") && s.endsWith("\"") && !(actualClassName = dataObject.getClassInfo().getName()).equals("java.lang.String") && !actualClassName.equals("java.lang.StringBuffer")) {
                    s = s.substring(1, s.length() - 1);
                }
                if (expressionUsed != null && expressionUsed.length == 1) {
                    expressionUsed[0] = expression;
                }
                return s;
            }
        }
        return null;
    }

    static String makeDataValue(DebugDataInfo data) {
        return DataPanel.makeDataValue(null, data);
    }

    static String makeDataValue(Object info, DebugDataInfo data) {
        return DataPanel.makeDataValue(info, data, new HashSet(), null);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects) {
        return DataPanel.makeDataValue(info, data, setOfEvaluatedDataObjects, null);
    }

    static String makeDataValue(Object info, DebugDataInfo data, String[] expressionUsed) {
        return DataPanel.makeDataValue(info, data, new HashSet(), expressionUsed, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed) {
        return DataPanel.makeDataValue(info, data, setOfEvaluatedDataObjects, expressionUsed, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, String[] expressionUsed, boolean getExtendedValue) {
        return DataPanel.makeDataValue(info, data, new HashSet(), expressionUsed, getExtendedValue);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed, boolean getExtendedValue) {
        if (data != null) {
            String v = null;
            if (data instanceof DebugDataCompositeInfo) {
                if (data instanceof DebugDataObjectInfo) {
                    v = DataPanel.evaluateDataValue((DebugDataObjectInfo)data, setOfEvaluatedDataObjects, expressionUsed);
                }
                if (v == null) {
                    v = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)data, true, false);
                }
                if (v == null) {
                    v = data.getValue();
                }
            } else {
                v = data.getValue();
                if (data instanceof DebugDataPrimitiveInfo && getExtendedValue && getExtendedValue) {
                    try {
                        DebugClassInfo ci = data.getClassInfo();
                        if (ci != null) {
                            byte[] b;
                            String s;
                            String hex;
                            String className = ci.getName();
                            if (className.equals("char")) {
                                String hex2 = data.getHexValue();
                                if (hex2 != null && hex2.length() > 0) {
                                    int num = Integer.parseInt(hex2, 16);
                                    v = v + "    " + num;
                                }
                            } else if (className.equals("byte") && (hex = data.getHexValue()) != null && hex.length() > 0 && (s = new String(b = new byte[]{Byte.parseByte(hex, 16)}, Encodings.getDefaultEncoding())).length() == 1) {
                                FastStringBuffer fsb = new FastStringBuffer(v);
                                fsb.append(' ');
                                for (int i = v.length() + 1; i < 7; ++i) {
                                    fsb.append(' ');
                                }
                                fsb.append('\'');
                                fsb.append(s);
                                fsb.append('\'');
                                v = fsb.toString();
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (v != null) {
                return v;
            }
        } else {
            if (info instanceof EvaluationInfo) {
                return ((EvaluationInfo)info).getValue();
            }
            if (info instanceof DebugVariableInfo) {
                return DbgArb.getString(273);
            }
            if (info instanceof DebugStackSlotInfo) {
                return ((DebugStackSlotInfo)info).getValue();
            }
        }
        return "";
    }

    private final class DataInfoPath {
        private DebuggingProcess debuggingProcess;
        private List list;

        DataInfoPath(DebuggingProcess debuggingProcess, Object[] dataInfoArray) {
            this.debuggingProcess = debuggingProcess;
            this.list = Arrays.asList(dataInfoArray);
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int size() {
            return this.list.size();
        }

        Object getDataInfo(int index) {
            return this.list.get(index);
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + ((Object)this.list).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DataInfoPath) {
                DataInfoPath other = (DataInfoPath)o;
                return this.debuggingProcess == other.debuggingProcess && ((Object)this.list).equals(other.list);
            }
            return false;
        }
    }

    private class DataPopulationWorker
    implements Runnable {
        private DataPopulationWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = DataPanel.this.modelUpdateLock;
                synchronized (object) {
                    DataPanel.this.model.saveHighlight();
                    DataPanel.this.model.root.clear();
                    if (DataPanel.this.treeTable.isShowing() || DataPanel.this.dockableWindow == null) {
                        DataPanel.this.skippedUpdate = false;
                        if (DataPanel.this.debuggingProcess != null && DataPanel.this.vm != null) {
                            DataPanel.this.addDataItems();
                        }
                    } else {
                        DataPanel.this.skippedUpdate = true;
                    }
                }
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DataPanel.this.dataTreeCellRenderer.clear();
                        DataPanel.this.dataTableCellRenderer.clear();
                        try {
                            Object object = DataPanel.this.modelUpdateLock;
                            synchronized (object) {
                                DataPanel.this.model.fireChanged();
                                DataPanel.this.model.restoreHighlight(false);
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class WorkerThreadFactory
    implements ThreadFactory {
        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "DataPopulation Thread");
            t.setDaemon(true);
            return t;
        }
    }

    final class DataTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List expanded;
        private DataInfoPath highlight;

        DataTreeTableModel(List root) {
            super((Object)root);
            this.root = root;
            this.expanded = Collections.synchronizedList(new ArrayList());
        }

        void updateDataForModel() {
            this.updateDataForModel(false);
        }

        void updateDataForModel(boolean offThread) {
            DataPopulationWorker worker = new DataPopulationWorker();
            if (offThread) {
                UPDATE_SCHEDULER.submit(worker);
            } else {
                worker.run();
            }
        }

        void fireChanged() {
            TreePath rootTreePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
            this.restoreExpanded(rootTreePath);
        }

        void fireChanged(TreePath path) {
            this.fireTreeStructureChanged((Object)this, path.getPath(), null, null);
        }

        void clearDataForModel() {
            this.saveHighlight();
            this.clearAll();
        }

        void addTopDataItem(DataItem dataItem) {
            this.addTopDataItem(dataItem, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTopDataItem(DataItem dataItem, boolean highlight) {
            Object object = DataPanel.this.modelUpdateLock;
            synchronized (object) {
                if (!highlight) {
                    this.saveHighlight();
                }
                int i = this.root.size();
                this.root.add(dataItem);
                this.fireChanged();
                if (highlight) {
                    this.selectTopDataItem(i);
                } else {
                    this.restoreHighlight(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTopDataItem(int i) {
            Object object = DataPanel.this.modelUpdateLock;
            synchronized (object) {
                this.saveHighlight();
                this.root.remove(i);
                this.fireChanged();
                this.restoreHighlight(false);
            }
        }

        void selectTopDataItem(int i) {
            Object[] path = new Object[]{this.root, this.root.get(i)};
            TreePath treePath = new TreePath(path);
            JDebugger.getInstance().selectTreeTablePath(DataPanel.this.treeTable, treePath, true);
        }

        /*
         * WARNING - void declaration
         */
        void processFinished(DebuggingProcess debuggingProcess) {
            void var4_9;
            ArrayList<DataInfoPath> remove = new ArrayList<DataInfoPath>();
            for (DataInfoPath dataInfoPath : this.expanded) {
                if (dataInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                remove.add(dataInfoPath);
            }
            for (Object e : remove) {
                this.expanded.remove(e);
            }
            this.highlight = null;
            ArrayList needToRemove = new ArrayList();
            for (Object key : DataPanel.this.arrayRanges.keySet()) {
                DataArrayRange arrayRange = (DataArrayRange)DataPanel.this.arrayRanges.get(key);
                if (arrayRange.getDebuggingProcess() != debuggingProcess) continue;
                needToRemove.add(key);
            }
            int n = needToRemove.size() - 1;
            while (var4_9 >= 0) {
                DataPanel.this.arrayRanges.remove(needToRemove.get((int)var4_9));
                --var4_9;
            }
        }

        private void clearAll() {
            this.clearAll(DataPanel.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof DataItem) {
                ((DataItem)node).clearDataForItem();
            }
            Iterator children = this.getLazyChildren(node);
            while (children.hasNext()) {
                Object child = children.next();
                this.clearAll(tree, treePath.pathByAddingChild(child));
            }
        }

        private void clearCacheForColumn(int column) {
            this.clearCacheForColumn(DataPanel.this.treeTable.getTree(), new TreePath(this.root), column);
        }

        private void clearCacheForColumn(JTree tree, TreePath treePath, int column) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof DataItem) {
                ((DataItem)node).clearCacheForColumn(column);
            }
            Iterator children = this.getLazyChildren(node);
            while (children.hasNext()) {
                Object child = children.next();
                this.clearCacheForColumn(tree, treePath.pathByAddingChild(child), column);
            }
        }

        void restoreExpanded(TreePath treePath) {
            JTree tree = DataPanel.this.treeTable.getTree();
            if (tree.isExpanded(treePath)) {
                Object node = treePath.getLastPathComponent();
                Iterator children = this.getChildren(node);
                while (children.hasNext()) {
                    Object child = children.next();
                    TreePath childTreePath = treePath.pathByAddingChild(child);
                    DataInfoPath dataInfoPath = this.convertTreePathToDataInfoPath(childTreePath);
                    if (!this.expanded.contains(dataInfoPath)) continue;
                    tree.expandPath(childTreePath);
                }
            }
        }

        void branchExpanded(TreePath treePath) {
            DataInfoPath dataInfoPath;
            DataItem dataItem = this.getDataItemForTreePath(treePath);
            if (dataItem != null) {
                dataItem.isExpanded = true;
            }
            if ((dataInfoPath = this.convertTreePathToDataInfoPath(treePath)) != null) {
                int i = this.expanded.indexOf(dataInfoPath);
                if (i != -1) {
                    this.expanded.remove(i);
                }
                this.expanded.add(dataInfoPath);
                this.restoreExpanded(treePath);
            }
        }

        void branchCollapsed(TreePath treePath) {
            DataInfoPath dataInfoPath;
            DataItem dataItem = this.getDataItemForTreePath(treePath);
            if (dataItem != null) {
                dataItem.isExpanded = false;
            }
            if ((dataInfoPath = this.convertTreePathToDataInfoPath(treePath)) != null) {
                this.expanded.remove(dataInfoPath);
            }
        }

        void saveHighlight() {
            DataInfoPath highlight = this.getCurrentHighlight();
            if (highlight != null) {
                this.highlight = highlight;
            }
        }

        void restoreHighlight(boolean scrollToVisible) {
            TreePath treePath = null;
            if (this.highlight != null) {
                treePath = this.makeVisible(this.highlight);
            }
            if (treePath == null && DataPanel.this.selectFirstRowIfNoPreviousSelection) {
                treePath = DataPanel.this.treeTable.getTree().getPathForRow(0);
            }
            if (treePath != null) {
                JDebugger.getInstance().selectTreeTablePath(DataPanel.this.treeTable, treePath, scrollToVisible);
            }
        }

        TreePath makeVisible(DataInfoPath dataInfoPath) {
            TreePath treePath = this.convertDataInfoPathToTreePath(dataInfoPath);
            if (treePath != null) {
                DataPanel.this.treeTable.getTree().makeVisible(treePath);
            }
            return treePath;
        }

        DataInfoPath getCurrentHighlight() {
            TreePath treePath = DataPanel.this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToDataInfoPath(treePath);
            }
            return null;
        }

        TreePath getTreePathAtPoint(Point pt) {
            int row = DataPanel.this.treeTable.rowAtPoint(pt);
            return DataPanel.this.treeTable.getTree().getPathForRow(row);
        }

        DataItem getDataItemForTreePath(TreePath treePath) {
            Object node;
            if (treePath != null && (node = treePath.getLastPathComponent()) instanceof DataItem) {
                return (DataItem)node;
            }
            return null;
        }

        DataInfoPath convertTreePathToDataInfoPath(TreePath treePath) {
            boolean foundOneDataInfo = false;
            Object[] path = treePath.getPath();
            int pathLength = path.length;
            Object[] dataInfoArray = new Object[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                Object node = path[i];
                if (!(node instanceof DataItem)) continue;
                dataInfoArray[i] = ((DataItem)node).getInfo();
                if (dataInfoArray[i] == null) continue;
                foundOneDataInfo = true;
            }
            if (foundOneDataInfo) {
                return new DataInfoPath(DataPanel.this.debuggingProcess, dataInfoArray);
            }
            return null;
        }

        TreePath convertDataInfoPathToTreePath(DataInfoPath dataInfoPath) {
            int dataInfoPathSize = dataInfoPath.size();
            if (dataInfoPathSize == 0) {
                return null;
            }
            List node = this.root;
            TreePath treePath = new TreePath(node);
            for (int i = 1; i < dataInfoPathSize; ++i) {
                Object dataInfo = dataInfoPath.getDataInfo(i);
                Object nextNode = null;
                Iterator iChild = this.getChildren(node);
                while (iChild.hasNext()) {
                    Object nextDataInfo;
                    Object child = iChild.next();
                    if (!(child instanceof DataItem) || !((nextDataInfo = ((DataItem)child).getInfo()) == null ? dataInfo == null : nextDataInfo.equals(dataInfo))) continue;
                    nextNode = child;
                    break;
                }
                if (nextNode == null) {
                    return null;
                }
                node = nextNode;
                treePath = treePath.pathByAddingChild(node);
            }
            return treePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collapseAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                this.collapseAll(DataPanel.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            Iterator children = this.getLazyChildren(node);
            while (children.hasNext()) {
                Object child = children.next();
                this.collapseAll(tree, treePath.pathByAddingChild(child));
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(DataPanel.this.treeTable.getTree(), new TreePath(this.root), out, html, "");
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = DataPanel.this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                if (i == 7) continue;
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                for (int ii = columnName.length(); ii >= 0; --ii) {
                    sb2.append('-');
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof DataItem) {
                    DataItem dataItem = (DataItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = DataPanel.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        if (i == 7) continue;
                        Object columnValue = this.getValueAt(node, i);
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (dataItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (dataItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                Iterator children = this.getLazyChildren(node);
                while (children.hasNext()) {
                    Object child = children.next();
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node == this.root) {
                    return false;
                }
                DataItem dataItem = (DataItem)node;
                return !dataItem.mayHaveChildren();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Iterator getChildren(Object parent) {
            if (parent == this.root) {
                Object object = DataPanel.this.modelUpdateLock;
                synchronized (object) {
                    ArrayList copy = new ArrayList(this.root);
                    return copy.iterator();
                }
            }
            DataItem dataItem = (DataItem)parent;
            return dataItem.getChildren();
        }

        Iterator getLazyChildren(Object parent) {
            if (parent == this.root) {
                return this.root.iterator();
            }
            DataItem dataItem = (DataItem)parent;
            return dataItem.getLazyChildren();
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent == this.root) {
                    return this.root.get(index);
                }
                DataItem dataItem = (DataItem)parent;
                return dataItem.getChildNodes(false)[index];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent == this.root) {
                    return this.root.size();
                }
                DataItem dataItem = (DataItem)parent;
                return dataItem.countChildNodes();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return DataPanel.this.getNumberOfColumns();
        }

        public String getColumnName(int column) {
            return DataPanel.getNameOfColumn(column);
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            if (column == 7) {
                return JButton.class;
            }
            return String.class;
        }

        public boolean isCellEditable(Object node, int column) {
            try {
                DataItem dataItem;
                if (node != this.root && (column == 1 ? (dataItem = (DataItem)node).getValueExpressionUsed() != null || dataItem.shouldShowArrayNavigationButtons() : column == 7 && (dataItem = (DataItem)node).mayHaveChildren())) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return super.isCellEditable(node, column);
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node == this.root) {
                    return "";
                }
                DataItem item = (DataItem)node;
                return item.getValueOfColumn(column);
            }
            catch (DataExpiredException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

