/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DbgArb;

class DataArrayNavigationPanel
extends JPanel {
    private JButton firstButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"first.png"));
    private JButton previousButton;
    private JButton nextButton;
    private JButton lastButton;
    private JButton objectPreferencesButton;

    DataArrayNavigationPanel() {
        super(new GridLayout(1, 4, 0, 0));
        this.firstButton.setToolTipText(DbgArb.getString(910));
        this.add(this.firstButton);
        this.previousButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"previous.png"));
        this.previousButton.setToolTipText(DbgArb.getString(913));
        this.add(this.previousButton);
        this.nextButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"next.png"));
        this.nextButton.setToolTipText(DbgArb.getString(912));
        this.add(this.nextButton);
        this.lastButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"last.png"));
        this.lastButton.setToolTipText(DbgArb.getString(911));
        this.add(this.lastButton);
        this.objectPreferencesButton = DataArrayNavigationPanel.createButton(OracleIcons.getIcon((String)"edit.png"));
        this.objectPreferencesButton.setToolTipText(DbgArb.getString(318));
        this.add(this.objectPreferencesButton);
        this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.setVisible(false);
    }

    void addObjectPreferencesActionListener(ActionListener listener) {
        this.objectPreferencesButton.addActionListener(listener);
    }

    void addFirstButtonActionListener(ActionListener listener) {
        this.firstButton.addActionListener(listener);
    }

    void addLastButtonActionListener(ActionListener listener) {
        this.lastButton.addActionListener(listener);
    }

    void addPreviousButtonActionListener(ActionListener listener) {
        this.previousButton.addActionListener(listener);
    }

    void addNextButtonActionListener(ActionListener listener) {
        this.nextButton.addActionListener(listener);
    }

    private void setNavigationButtonsVisible(boolean visible) {
        this.firstButton.setVisible(visible);
        this.lastButton.setVisible(visible);
        this.previousButton.setVisible(visible);
        this.nextButton.setVisible(visible);
    }

    void enableNavigationButtons(DataItem dataItem) {
        this.firstButton.setEnabled(dataItem.canAdjustRangeFirst());
        this.lastButton.setEnabled(dataItem.canAdjustRangeLast());
        this.previousButton.setEnabled(dataItem.canAdjustRangePrevious());
        this.nextButton.setEnabled(dataItem.canAdjustRangeNext());
    }

    private void setObjectPreferencesButtonVisible(boolean visible) {
        this.objectPreferencesButton.setVisible(visible);
    }

    static JButton createButton(Icon icon) {
        JButton b = new JButton(icon);
        b.setBorder(null);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setOpaque(false);
        return b;
    }

    void updatePanel(DataItem dataItem) {
        try {
            boolean noButtons = true;
            if (dataItem != null && dataItem.shouldShowArrayNavigationButtons()) {
                noButtons = false;
                this.setNavigationButtonsVisible(true);
                this.setObjectPreferencesButtonVisible(false);
                this.setVisible(true);
                this.enableNavigationButtons(dataItem);
            }
            if (dataItem != null && dataItem.getValueExpressionUsed() != null) {
                noButtons = false;
                this.setObjectPreferencesButtonVisible(true);
                this.setNavigationButtonsVisible(false);
                this.setVisible(true);
            }
            if (noButtons) {
                this.setVisible(false);
            }
        }
        catch (DataExpiredException dataExpiredException) {
            // empty catch block
        }
    }
}

