/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.ObjectPreferencesPanel;

class CustomDataProvider
extends DataPanel {
    CustomDataProvider() {
        super("", DataPanelSettings.getInstance(HashStructure.newInstance()));
    }

    void updateContext(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo stackFrame) {
        this.debuggingProcess = debuggingProcess;
        this.vm = vm;
        this.thread = thread;
        this.frame = stackFrame;
    }

    DataItem makeDataItem(Object info, String expressionOverride) {
        return new DataItem(this, info, null, expressionOverride);
    }

    Object getDataInfo(DataItem dataItem) {
        return dataItem.getDataInfo();
    }

    @Override
    protected void addDataItems() {
    }

    boolean mayHaveChildren(DataItem dataItem) {
        return dataItem.mayHaveChildren();
    }

    Iterator<DataItem> getChildren(DataItem dataItem) {
        dataItem.isExpanded = true;
        return dataItem.getChildren();
    }

    String getName(DataItem dataItem) {
        return dataItem.getDisplayName();
    }

    String getValue(DataItem dataItem) {
        return dataItem.getValue();
    }

    Icon getIcon(DataItem dataItem) {
        return dataItem.getIcon();
    }

    String getActualType(DataItem dataItem) {
        return dataItem.getActualType();
    }

    String getFullyQualifiedActualType(DataItem dataItem) {
        return dataItem.getFullyQualifiedActualType();
    }

    String getDeclaredType(DataItem dataItem) {
        return dataItem.getDeclaredType();
    }

    String getFullyQualifiedDeclaredType(DataItem dataItem) {
        return dataItem.getFullyQualifiedDeclaredType();
    }

    String getHexValue(DataItem dataItem) {
        return dataItem.getHexValue();
    }

    String getAddress(DataItem dataItem) {
        return dataItem.getAddress();
    }

    void inspect(TreePath treePath, DataItem dataItem) {
        dataItem.inspect(treePath, dataItem.getDisplayName());
    }

    boolean canInspect(TreePath treePath, DataItem dataItem) {
        return dataItem.canWatchAndInspect(treePath);
    }

    void watch(TreePath treePath, DataItem dataItem) {
        dataItem.watch(treePath, dataItem.getDisplayName());
    }

    boolean canWatch(TreePath treePath, DataItem dataItem) {
        return dataItem.canWatchAndInspect(treePath);
    }

    void inspectClassLoader(DataItem dataItem) {
        dataItem.inspectClassLoader(this.debuggingProcess);
    }

    boolean canInspectClassLoader(DataItem dataItem) {
        return dataItem.canWatchInspectClassLoader();
    }

    void watchClassLoader(DataItem dataItem) {
        dataItem.watchClassLoader(this.debuggingProcess);
    }

    boolean canWatchClassLoader(DataItem dataItem) {
        return dataItem.canWatchInspectClassLoader();
    }

    void viewWholeValue(DataItem dataItem) {
        dataItem.viewWhole();
    }

    boolean canViewWholeValue(DataItem dataItem) {
        return dataItem.canViewWhole();
    }

    void gotoDeclaredType(DataItem dataItem) {
        dataItem.showSource(this._GOTO_DECLARED_CMD_ID, this.debuggingProcess);
    }

    String canGotoDeclaredType(DataItem dataItem) {
        return dataItem.canShowSource(this._GOTO_DECLARED_CMD_ID);
    }

    void gotoActualType(DataItem dataItem) {
        dataItem.showSource(this._GOTO_CMD_ID, this.debuggingProcess);
    }

    String canGotoActualType(DataItem dataItem) {
        return dataItem.canShowSource(this._GOTO_CMD_ID);
    }

    void gotoField(DataItem dataItem) {
        dataItem.showSource(this._GOTO_FIELD_CMD_ID, this.debuggingProcess);
    }

    String canGotoField(DataItem dataItem) {
        return dataItem.canShowSource(this._GOTO_FIELD_CMD_ID);
    }

    void adjustRange(TreePath treePath, DataItem dataItem) {
        dataItem.adjustRange(treePath);
    }

    boolean canAdjustRange(DataItem dataItem) {
        return dataItem.canAdjustRange();
    }

    void showObjectPreferences(DataItem dataItem) {
        if (dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
            ObjectPreferencesPanel.showObjectPreferencesDialog(dataItem.actualClassInfo, this.dataPanelSettings.isSortFieldsByName());
        }
    }

    boolean canShowObjectPreferences(DataItem dataItem) {
        return dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null;
    }

    void toggleValue(DataItem dataItem) {
        dataItem.toggleValue();
    }

    boolean canToggleValue(DataItem dataItem) {
        return dataItem.canToggleValue();
    }

    void viewAnnotations(DataItem dataItem) {
        dataItem.viewAnnotations(this.debuggingProcess, this.vm, this.thread, this.frame);
    }

    String canViewAnnotations(DataItem dataItem) {
        return dataItem.canViewAnnotations();
    }

    void viewAnnotationsForClass(DataItem dataItem) {
        dataItem.viewAnnotationsForClass(this.debuggingProcess, this.vm, this.thread, this.frame);
    }

    boolean canViewAnnotationsForClass(DataItem dataItem) {
        return dataItem.canViewAnnotationsForClass();
    }

    void modifyValue(DataItem dataItem) {
        dataItem.modifyValue(this.vm);
    }

    boolean canModifyValue(DataItem dataItem) {
        return dataItem.canModifyValue();
    }

    void setDisplayShowPackages(boolean setting) {
        this.dataPanelSettings.setShowPackages(setting);
    }

    void setDisplaySortFieldsByName(boolean setting) {
        this.dataPanelSettings.setSortFieldsByName(setting);
    }

    void setDisplayHideStaticFields(boolean setting) {
        this.dataPanelSettings.setHideStaticFields(setting);
    }

    void setDisplayHideFinalFields(boolean setting) {
        this.dataPanelSettings.setHideFinalFields(setting);
    }

    void setDisplayHideSyntheticFields(boolean setting) {
        this.dataPanelSettings.setHideSyntheticFields(setting);
    }

    void setDisplayHideNullArrayElements(boolean setting) {
        this.dataPanelSettings.setHideNullArrayElements(setting);
    }

    List<DataItem> getFields(DataItem dataItem) {
        dataItem.isExpanded = true;
        return dataItem.getFields();
    }

    List<DataItem> getDeclaredFields(DataItem dataItem) {
        dataItem.isExpanded = true;
        return dataItem.getFields();
    }

    DataItem getField(DataItem dataItem, String fieldName) {
        dataItem.isExpanded = true;
        return dataItem.getField(fieldName);
    }
}

