/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DbgArb;

abstract class ClassesPanel
extends JPanel {
    private final JComboBox classComboBox = new JComboBox();
    private DefaultTreeModel classComboBoxTreeModel;
    private DebugClassInfo currentClass;

    protected ClassesPanel() {
    }

    protected final void createPanel(DebugClassInfo clazz) {
        JLabel classLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)classLabel, (Component)this.classComboBox, (String)DbgArb.getString(773));
        NonNullableComboBoxModel classModel = new NonNullableComboBoxModel();
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        this.addToModel(classModel, treeRoot, clazz);
        this.setSelectedClass((ComboBoxModel)classModel);
        this.classComboBox.setModel(classModel);
        this.classComboBoxTreeModel = new DefaultTreeModel(treeRoot);
        this.classComboBox.setRenderer(new ClassComboBoxRenderer(this.classComboBoxTreeModel, this.classComboBox));
        JPanel body = this.createBody();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(this.getAppropriateSize());
        int y = 0;
        this.add((Component)classLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.classComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)body, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.classComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ClassesPanel.this.update();
            }
        });
        this.update();
    }

    private void addToModel(NonNullableComboBoxModel classModel, DefaultMutableTreeNode treeNode, DebugClassInfo clazz) {
        if (clazz != null) {
            ClassComboBoxItem classComboBoxItem = this.createClassComboBoxItem(clazz, classModel.getSize());
            classModel.addElement((Object)classComboBoxItem);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(classComboBoxItem);
            treeNode.add(childNode);
            this.addToModel(classModel, childNode, clazz.getSuperClass(1));
            DebugClassInfo[] interfaces = clazz.getInterfaces();
            if (interfaces != null) {
                Arrays.sort(interfaces, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String name1 = ((DebugClassInfo)o1).getName();
                        String name2 = ((DebugClassInfo)o2).getName();
                        return name1.compareToIgnoreCase(name2);
                    }
                });
                int length = interfaces.length;
                for (int i = 0; i < length; ++i) {
                    classComboBoxItem = this.createClassComboBoxItem(interfaces[i], classModel.getSize());
                    classModel.addElement((Object)classComboBoxItem);
                    childNode.add(new DefaultMutableTreeNode(classComboBoxItem));
                }
            }
        }
    }

    private void update() {
        if (this.currentClass != null) {
            this.saveBody(this.currentClass);
        }
        this.clearBody();
        this.currentClass = ((ClassComboBoxItem)this.classComboBox.getSelectedItem()).clazz;
        this.loadBody(this.currentClass);
        this.updateNodes(this.classComboBoxTreeModel.getRoot());
    }

    private void updateNodes(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            Object userObject = node.getUserObject();
            if (userObject instanceof ClassComboBoxItem) {
                ClassComboBoxItem classComboBoxItem = (ClassComboBoxItem)userObject;
                if (classComboBoxItem.isSpecial()) {
                    if (!classComboBoxItem.isBold) {
                        classComboBoxItem.isBold = true;
                        this.classComboBoxTreeModel.nodeChanged(node);
                    }
                } else if (classComboBoxItem.isBold) {
                    classComboBoxItem.isBold = false;
                    this.classComboBoxTreeModel.nodeChanged(node);
                }
            }
            for (int x = 0; x < node.getChildCount(); ++x) {
                this.updateNodes(node.getChildAt(x));
            }
        }
    }

    protected Component getInitialFocus() {
        return this.classComboBox;
    }

    protected final DebugClassInfo getCurrentClass() {
        return this.currentClass;
    }

    protected ClassComboBoxItem createClassComboBoxItem(DebugClassInfo clazz, int row) {
        return new ClassComboBoxItem(clazz, row);
    }

    protected void setSelectedClass(ComboBoxModel classModel) {
        classModel.setSelectedItem(classModel.getElementAt(0));
    }

    abstract JPanel createBody();

    abstract Dimension getAppropriateSize();

    abstract void saveBody(DebugClassInfo var1);

    abstract void clearBody();

    abstract void loadBody(DebugClassInfo var1);

    private class ClassComboBoxRenderer
    extends JTree
    implements ListCellRenderer {
        private final int preferredHeight;
        private final ClassTreeCellRenderer classTreeCellRenderer;
        private ClassComboBoxItem classComboBoxItem;
        private int row;
        private boolean overrideBackground;

        private ClassComboBoxRenderer(TreeModel treeModel, JComboBox comboBox) {
            super(treeModel);
            this.preferredHeight = comboBox.getPreferredSize().height;
            this.setRowHeight(this.preferredHeight);
            this.setOpaque(false);
            this.setFocusable(false);
            this.setRootVisible(false);
            this.setShowsRootHandles(false);
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.expandRow(i);
            }
            TreeUI treeUI = this.getUI();
            if (treeUI instanceof BasicTreeUI) {
                BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
                basicTreeUI.setCollapsedIcon(null);
                basicTreeUI.setExpandedIcon(null);
            }
            this.classTreeCellRenderer = new ClassTreeCellRenderer();
            this.setCellRenderer(this.classTreeCellRenderer);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.classComboBoxItem = (ClassComboBoxItem)value;
            this.row = this.classComboBoxItem.row;
            if (index == -1) {
                this.overrideBackground = true;
                this.classTreeCellRenderer.overrideBackground = true;
            } else {
                this.overrideBackground = false;
                this.classTreeCellRenderer.overrideBackground = false;
            }
            if (isSelected) {
                this.setSelectionRow(this.row);
            } else {
                this.clearSelection();
            }
            return this;
        }

        @Override
        public Color getBackground() {
            if (this.overrideBackground) {
                return null;
            }
            return super.getBackground();
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.row * this.getRowHeight());
            super.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = this.preferredHeight;
            return d;
        }

        class ClassTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private boolean overrideBackground;

            private ClassTreeCellRenderer() {
                this.setOpaque(false);
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                Font font = tree.getFont();
                Icon icon = null;
                if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof ClassComboBoxItem) {
                    ClassComboBoxItem classComboBoxItem = (ClassComboBoxItem)userObject;
                    if (classComboBoxItem.isSpecial() && font != null) {
                        font = font.deriveFont(1);
                    }
                    icon = classComboBoxItem.getIcon();
                }
                this.setFont(font);
                this.setIcon(icon);
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                return this;
            }

            @Override
            public Color getBackground() {
                if (this.overrideBackground) {
                    return null;
                }
                return super.getBackground();
            }

            @Override
            public Color getBackgroundNonSelectionColor() {
                if (this.overrideBackground) {
                    return null;
                }
                return super.getBackgroundNonSelectionColor();
            }
        }
    }

    protected class ClassComboBoxItem {
        private final DebugClassInfo clazz;
        private final int row;
        private final String toString;
        private boolean isBold = false;

        protected ClassComboBoxItem(DebugClassInfo clazz, int row) {
            this.clazz = clazz;
            this.row = row;
            this.toString = clazz.getName();
        }

        Icon getIcon() {
            if (this.clazz.isInterface()) {
                return ClassesWindow.getInterfaceIcon();
            }
            return ClassesWindow.getClassIcon();
        }

        protected boolean isSpecial() {
            return false;
        }

        public String toString() {
            return this.toString;
        }
    }
}

