/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class BreakpointsWindowSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "BreakpointsWindowOptions";
    public static final String BREAKPOINT_SCOPE_GLOBAL = "global";
    public static final String BREAKPOINT_SCOPE_WORKSPACE = "workspace";
    public static final String BREAKPOINT_SCOPE_PROJECT = "project";
    private static final String COLUMN_VISIBLE = "columnVisible";
    private static final String COLUMN_WIDTH = "columnWidth";

    static BreakpointsWindowSettings getInstance() {
        return BreakpointsWindowSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    @Deprecated
    public BreakpointsWindowSettings() {
        super(HashStructure.newInstance());
    }

    private BreakpointsWindowSettings(HashStructure hs) {
        super(hs);
    }

    public static BreakpointsWindowSettings getInstance(PropertyStorage ps) {
        return new BreakpointsWindowSettings(BreakpointsWindowSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    @Deprecated
    public boolean[] getColumnVisible() {
        boolean[] columnVisible = new boolean[10];
        for (int x = 0; x < 10; ++x) {
            columnVisible[x] = this.getColumnVisible(x);
        }
        return columnVisible;
    }

    @Deprecated
    public void setColumnVisible(boolean[] columnVisible) {
        for (int x = 0; x < columnVisible.length; ++x) {
            this.setColumnVisible(x, columnVisible[x]);
        }
    }

    boolean getColumnVisible(int columnIndex) {
        boolean defaultValue = columnIndex == 0 || columnIndex == 1;
        return this._hash.getBoolean(COLUMN_VISIBLE + columnIndex, defaultValue);
    }

    void setColumnVisible(int columnIndex, boolean columnVisible) {
        this._hash.putBoolean(COLUMN_VISIBLE + columnIndex, columnVisible);
    }

    @Deprecated
    public int[] getColumnWidth() {
        int[] columnWidth = new int[10];
        for (int x = 0; x < 10; ++x) {
            columnWidth[x] = this.getColumnWidth(x);
        }
        return columnWidth;
    }

    @Deprecated
    public void setColumnWidth(int[] columnWidth) {
        for (int x = 0; x < columnWidth.length; ++x) {
            this.setColumnWidth(x, columnWidth[x]);
        }
    }

    int getColumnWidth(int columnIndex) {
        return this._hash.getInt(COLUMN_WIDTH + columnIndex, 0);
    }

    void setColumnWidth(int columnIndex, int columnWidth) {
        this._hash.putInt(COLUMN_WIDTH + columnIndex, columnWidth);
    }

    public String getColumnOrder() {
        return this._hash.getString("columnOrder");
    }

    public void setColumnOrder(String columnOrder) {
        this._hash.putString("columnOrder", columnOrder);
    }

    public String getBreakpointScope() {
        return this._hash.getString("breakpointScope", BREAKPOINT_SCOPE_WORKSPACE);
    }

    public void setBreakpointScope(String breakpointScope) {
        this._hash.putString("breakpointScope", breakpointScope);
    }

    public boolean getDefaultActionHalt() {
        return this._hash.getBoolean("defaultActionHalt", true);
    }

    public void setDefaultActionHalt(boolean defaultActionHalt) {
        this._hash.putBoolean("defaultActionHalt", defaultActionHalt);
    }

    public boolean getDefaultActionBeep() {
        return this._hash.getBoolean("defaultActionBeep", false);
    }

    public void setDefaultActionBeep(boolean defaultActionBeep) {
        this._hash.putBoolean("defaultActionBeep", defaultActionBeep);
    }

    public boolean getDefaultActionLog() {
        return this._hash.getBoolean("defaultActionLog", true);
    }

    public void setDefaultActionLog(boolean defaultActionLog) {
        this._hash.putBoolean("defaultActionLog", defaultActionLog);
    }

    public String getDefaultActionLogTag() {
        return this._hash.getString("defaultActionLogTag", "");
    }

    public void setDefaultActionLogTag(String defaultActionLogTag) {
        this._hash.putString("defaultActionTagLog", defaultActionLogTag);
    }

    public String getDefaultActionLogExpr() {
        return this._hash.getString("defaultActionLogExpr", "");
    }

    public void setDefaultActionLogExpr(String defaultActionLogExpr) {
        this._hash.putString("defaultActionLogExpr", defaultActionLogExpr);
    }

    public boolean getDefaultActionLogStack() {
        return this._hash.getBoolean("defaultActionLogStack", false);
    }

    public void setDefaultActionLogStack(boolean defaultActionLogStack) {
        this._hash.putBoolean("defaultActionLogStack", defaultActionLogStack);
    }

    public String getDefaultActionEnableOther() {
        return this._hash.getString("defaultActionEnableOther", "");
    }

    public void setDefaultActionEnableOther(String defaultActionEnableOther) {
        this._hash.putString("defaultActionEnableOther", defaultActionEnableOther);
    }

    public String getDefaultActionDisableOther() {
        return this._hash.getString("defaultActionDisableOther", "");
    }

    public void setDefaultActionDisableOther(String defaultActionDisableOther) {
        this._hash.putString("defaultActionDisableOther", defaultActionDisableOther);
    }
}

