/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

public final class BreakpointSettings
implements Copyable {
    static final int BP_PACKAGE_FILE_LINE = 0;
    static final int BP_METHOD = 1;
    static final int BP_EXCEPTION = 2;
    static final int BP_DEADLOCK = 3;
    static final int BP_CLASS = 4;
    static final int BP_URL_LINE = 5;
    static final int BP_WATCHPOINT = 6;
    static final int BP_METHOD_OFFSET = 7;
    private URL _ownerURL;
    private boolean _persistent;
    private int _type;
    private String _pkg;
    private String _file;
    private int _line;
    private String _method;
    private int _offset;
    private String _exception;
    private boolean _caught;
    private boolean _uncaught;
    private String _className;
    private URL _url;
    private String _fieldName;
    private boolean _access;
    private boolean _modify;
    private boolean _enabled;
    private String _groupName;
    private boolean _canEditGroupName;
    private String _condition;
    private boolean _canEditCondition;
    private String _hiddenCondition;
    private String _threadName;
    private String _threadNameNot;
    private boolean _canEditBreakForThreads;
    private int _passCount;
    private boolean _canEditPassCount;
    private boolean _actionHalt;
    private boolean _actionBeep;
    private boolean _actionLog;
    private String _actionLogTag;
    private String _actionLogExpr;
    private boolean _actionLogStack;
    private String _actionEnableOther;
    private String _actionDisableOther;
    private boolean _canEditBreakpointHitActions;
    private String _customTypeString;
    private String _customDescription;
    private String _debuggerExtenderID;
    private String[] _propertyKeys;
    private String[] _propertyValues;

    public BreakpointSettings() {
        this.defaultInit();
    }

    public BreakpointSettings(BreakpointSettings that) {
        if (that == null) {
            this.defaultInit();
        } else {
            that.copyToImpl(this);
        }
    }

    private void defaultInit() {
        this._ownerURL = null;
        this._persistent = false;
        this._type = -1;
        this._method = "";
        this._offset = -1;
        this._pkg = "";
        this._file = "";
        this._line = 0;
        this._exception = "";
        this._caught = true;
        this._uncaught = true;
        this._className = "";
        this._url = null;
        this._fieldName = "";
        this._access = false;
        this._modify = true;
        this._enabled = true;
        this._groupName = "";
        this._condition = "";
        this._hiddenCondition = "";
        this._threadName = "";
        this._threadNameNot = "";
        this._passCount = 0;
        BreakpointsWindowSettings bpWindowSettings = BreakpointsWindowSettings.getInstance();
        this._actionHalt = bpWindowSettings.getDefaultActionHalt();
        this._actionBeep = bpWindowSettings.getDefaultActionBeep();
        this._actionLog = bpWindowSettings.getDefaultActionLog();
        this._actionLogTag = bpWindowSettings.getDefaultActionLogTag();
        this._actionLogExpr = bpWindowSettings.getDefaultActionLogExpr();
        this._actionLogStack = bpWindowSettings.getDefaultActionLogStack();
        this._actionEnableOther = bpWindowSettings.getDefaultActionEnableOther();
        this._actionDisableOther = bpWindowSettings.getDefaultActionDisableOther();
        this._canEditBreakForThreads = true;
        this._canEditBreakpointHitActions = true;
        this._canEditCondition = true;
        this._canEditGroupName = true;
        this._canEditPassCount = true;
        this._debuggerExtenderID = null;
        this._propertyKeys = null;
        this._propertyValues = null;
        this._customTypeString = null;
        this._customDescription = null;
    }

    void setActions() {
        BreakpointsWindowSettings bpSettings = BreakpointsWindowSettings.getInstance();
        this._actionHalt = bpSettings.getDefaultActionHalt();
        this._actionBeep = bpSettings.getDefaultActionBeep();
        this._actionLog = bpSettings.getDefaultActionLog();
        this._actionLogTag = bpSettings.getDefaultActionLogTag();
        this._actionLogExpr = bpSettings.getDefaultActionLogExpr();
        this._actionLogStack = bpSettings.getDefaultActionLogStack();
        this._actionEnableOther = bpSettings.getDefaultActionEnableOther();
        this._actionDisableOther = bpSettings.getDefaultActionDisableOther();
    }

    static String getTypeString(int type) {
        switch (type) {
            case 0: {
                return DbgArb.getString(354);
            }
            case 1: {
                return DbgArb.getString(352);
            }
            case 7: {
                return DbgArb.getString(366);
            }
            case 2: {
                return DbgArb.getString(356);
            }
            case 3: {
                return DbgArb.getString(358);
            }
            case 4: {
                return DbgArb.getString(360);
            }
            case 5: {
                return DbgArb.getString(362);
            }
            case 6: {
                return DbgArb.getString(364);
            }
        }
        return "";
    }

    static int getTypeStringMnemonic(int type) {
        switch (type) {
            case 0: {
                return DbgArb.getInteger(355);
            }
            case 1: {
                return DbgArb.getInteger(353);
            }
            case 2: {
                return DbgArb.getInteger(357);
            }
            case 3: {
                return DbgArb.getInteger(359);
            }
            case 4: {
                return DbgArb.getInteger(361);
            }
            case 5: {
                return DbgArb.getInteger(363);
            }
            case 6: {
                return DbgArb.getInteger(365);
            }
        }
        return -1;
    }

    public Object copyTo(Object object) {
        BreakpointSettings copy = object != null ? (BreakpointSettings)object : new BreakpointSettings();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(BreakpointSettings copy) {
        int len;
        copy._ownerURL = this._ownerURL;
        copy._persistent = this._persistent;
        copy._type = this._type;
        copy._pkg = this._pkg;
        copy._file = this._file;
        copy._line = this._line;
        copy._method = this._method;
        copy._offset = this._offset;
        copy._exception = this._exception;
        copy._caught = this._caught;
        copy._uncaught = this._uncaught;
        copy._className = this._className;
        copy._url = this._url;
        copy._fieldName = this._fieldName;
        copy._access = this._access;
        copy._modify = this._modify;
        copy._enabled = this._enabled;
        copy._groupName = this._groupName;
        copy._canEditGroupName = this._canEditGroupName;
        copy._condition = this._condition;
        copy._hiddenCondition = this._hiddenCondition;
        copy._canEditCondition = this._canEditCondition;
        copy._threadName = this._threadName;
        copy._threadNameNot = this._threadNameNot;
        copy._canEditBreakForThreads = this._canEditBreakForThreads;
        copy._passCount = this._passCount;
        copy._canEditPassCount = this._canEditPassCount;
        copy._actionHalt = this._actionHalt;
        copy._actionBeep = this._actionBeep;
        copy._actionLog = this._actionLog;
        copy._actionLogTag = this._actionLogTag;
        copy._actionLogExpr = this._actionLogExpr;
        copy._actionLogStack = this._actionLogStack;
        copy._actionEnableOther = this._actionEnableOther;
        copy._actionDisableOther = this._actionDisableOther;
        copy._canEditBreakpointHitActions = this._canEditBreakpointHitActions;
        copy._customDescription = this._customDescription;
        copy._customTypeString = this._customTypeString;
        copy._debuggerExtenderID = this._debuggerExtenderID;
        if (this._propertyKeys == null) {
            copy._propertyKeys = null;
        } else {
            len = this._propertyKeys.length;
            copy._propertyKeys = new String[len];
            System.arraycopy(this._propertyKeys, 0, copy._propertyKeys, 0, len);
        }
        if (this._propertyValues == null) {
            copy._propertyValues = null;
        } else {
            len = this._propertyValues.length;
            copy._propertyValues = new String[len];
            System.arraycopy(this._propertyValues, 0, copy._propertyValues, 0, len);
        }
    }

    public URL getOwnerURL() {
        return this._ownerURL;
    }

    public void setOwnerURL(URL ownerURL) {
        this._ownerURL = ownerURL;
    }

    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public String getPkg() {
        return this._pkg;
    }

    public void setPkg(String pkg) {
        this._pkg = pkg;
    }

    public String getFile() {
        return this._file;
    }

    public void setFile(String file) {
        this._file = file;
    }

    public int getLine() {
        return this._line;
    }

    public void setLine(int line) {
        this._line = line;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public String getException() {
        return this._exception;
    }

    public void setException(String exception) {
        this._exception = exception;
    }

    public boolean isCaught() {
        return this._caught;
    }

    public void setCaught(boolean caught) {
        this._caught = caught;
    }

    public boolean isUncaught() {
        return this._uncaught;
    }

    public void setUncaught(boolean uncaught) {
        this._uncaught = uncaught;
    }

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public void setFieldName(String fieldName) {
        this._fieldName = fieldName;
    }

    public boolean isAccess() {
        return this._access;
    }

    public void setAccess(boolean access) {
        this._access = access;
    }

    public boolean isModify() {
        return this._modify;
    }

    public void setModify(boolean modify) {
        this._modify = modify;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public String getGroupName() {
        return this._groupName;
    }

    public void setGroupName(String groupName) {
        this._groupName = groupName;
    }

    public boolean canEditGroupName() {
        return this._canEditGroupName;
    }

    public void setCanEditGroupName(boolean canEditGroupName) {
        this._canEditGroupName = canEditGroupName;
    }

    public String getCondition() {
        return this._condition;
    }

    public void setCondition(String condition) {
        this._condition = condition;
    }

    public boolean canEditCondition() {
        return this._canEditCondition;
    }

    public void setCanEditCondition(boolean canEditCondition) {
        this._canEditCondition = canEditCondition;
    }

    public String getHiddenCondition() {
        return this._hiddenCondition;
    }

    public void setHiddenCondition(String hiddenCondition) {
        this._hiddenCondition = hiddenCondition;
    }

    public String getThreadName() {
        return this._threadName;
    }

    public void setThreadName(String threadName) {
        this._threadName = threadName;
    }

    public String getThreadNameNot() {
        return this._threadNameNot;
    }

    public void setThreadNameNot(String threadNameNot) {
        this._threadNameNot = threadNameNot;
    }

    public boolean canEditBreakForThreads() {
        return this._canEditBreakForThreads;
    }

    public void setCanEditBreakForThreads(boolean canEditBreakForThreads) {
        this._canEditBreakForThreads = canEditBreakForThreads;
    }

    public int getPassCount() {
        return this._passCount;
    }

    public void setPassCount(int passCount) {
        this._passCount = passCount;
    }

    public boolean canEditPassCount() {
        return this._canEditPassCount;
    }

    public void setCanEditPassCount(boolean canEditPassCount) {
        this._canEditPassCount = canEditPassCount;
    }

    public boolean isActionHalt() {
        return this._actionHalt;
    }

    public void setActionHalt(boolean actionHalt) {
        this._actionHalt = actionHalt;
    }

    public boolean isActionBeep() {
        return this._actionBeep;
    }

    public void setActionBeep(boolean actionBeep) {
        this._actionBeep = actionBeep;
    }

    public boolean isActionLog() {
        return this._actionLog;
    }

    public void setActionLog(boolean actionLog) {
        this._actionLog = actionLog;
    }

    public String getActionLogTag() {
        return this._actionLogTag;
    }

    public void setActionLogTag(String actionLogTag) {
        this._actionLogTag = actionLogTag;
    }

    public String getActionLogExpr() {
        return this._actionLogExpr;
    }

    public void setActionLogExpr(String actionLogExpr) {
        this._actionLogExpr = actionLogExpr;
    }

    public boolean isActionLogStack() {
        return this._actionLogStack;
    }

    public void setActionLogStack(boolean actionLogStack) {
        this._actionLogStack = actionLogStack;
    }

    public String getActionEnableOther() {
        return this._actionEnableOther;
    }

    public void setActionEnableOther(String actionEnableOther) {
        this._actionEnableOther = actionEnableOther;
    }

    public String getActionDisableOther() {
        return this._actionDisableOther;
    }

    public void setActionDisableOther(String actionDisableOther) {
        this._actionDisableOther = actionDisableOther;
    }

    public boolean canEditBreakpointHitActions() {
        return this._canEditBreakpointHitActions;
    }

    public void setCanEditBreakpointHitActions(boolean canEditBreakpointHitActions) {
        this._canEditBreakpointHitActions = canEditBreakpointHitActions;
    }

    public String getCustomDescription() {
        return this._customDescription;
    }

    public void setCustomDescription(String customDescription) {
        this._customDescription = customDescription;
    }

    public String getCustomTypeString() {
        return this._customTypeString;
    }

    public void setCustomTypeString(String customTypeString) {
        this._customTypeString = customTypeString;
    }

    boolean isCustom() {
        return this._customTypeString != null;
    }

    String getTypeString() {
        if (this.getCustomTypeString() != null) {
            return this.getCustomTypeString();
        }
        return BreakpointSettings.getTypeString(this.getType());
    }

    public String getDebuggerExtenderID() {
        return this._debuggerExtenderID;
    }

    public void setDebuggerExtenderID(String debuggerExtenderID) {
        this._debuggerExtenderID = debuggerExtenderID;
    }

    public String[] getPropertyKeys() {
        return this._propertyKeys;
    }

    public void setPropertyKeys(String[] propertyKeys) {
        this._propertyKeys = propertyKeys != null && propertyKeys.length > 0 ? (String[])propertyKeys.clone() : null;
    }

    public String[] getPropertyValues() {
        return this._propertyValues;
    }

    public void setPropertyValues(String[] propertyValues) {
        this._propertyValues = propertyValues != null && propertyValues.length > 0 ? (String[])propertyValues.clone() : null;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((BreakpointSettings)o);
    }

    protected final boolean equalsImpl(BreakpointSettings that) {
        return URLFileSystem.equals((URL)this._ownerURL, (URL)that._ownerURL) && this._persistent == that._persistent && this._type == that._type && ModelUtil.areEqual((Object)this._pkg, (Object)that._pkg) && ModelUtil.areEqual((Object)this._file, (Object)that._file) && this._line == that._line && ModelUtil.areEqual((Object)this._method, (Object)that._method) && this._offset == that._offset && ModelUtil.areEqual((Object)this._exception, (Object)that._exception) && this._caught == that._caught && this._uncaught == that._uncaught && ModelUtil.areEqual((Object)this._className, (Object)that._className) && URLFileSystem.equals((URL)this._url, (URL)that._url) && ModelUtil.areEqual((Object)this._fieldName, (Object)that._fieldName) && this._access == that._access && this._modify == that._modify && this._enabled == that._enabled && ModelUtil.areEqual((Object)this._groupName, (Object)that._groupName) && this._canEditGroupName == that._canEditGroupName && ModelUtil.areEqual((Object)this._condition, (Object)that._condition) && this._canEditCondition == that._canEditCondition && ModelUtil.areEqual((Object)this._hiddenCondition, (Object)that._hiddenCondition) && ModelUtil.areEqual((Object)this._threadName, (Object)that._threadName) && ModelUtil.areEqual((Object)this._threadNameNot, (Object)that._threadNameNot) && this._canEditBreakForThreads == that._canEditBreakForThreads && this._passCount == that._passCount && this._canEditPassCount == that.canEditPassCount() && this._actionHalt == that._actionHalt && this._actionBeep == that._actionBeep && this._actionLog == that._actionLog && ModelUtil.areEqual((Object)this._actionLogTag, (Object)that._actionLogTag) && ModelUtil.areEqual((Object)this._actionLogExpr, (Object)that._actionLogExpr) && this._actionLogStack == that._actionLogStack && ModelUtil.areEqual((Object)this._actionEnableOther, (Object)that._actionEnableOther) && ModelUtil.areEqual((Object)this._actionDisableOther, (Object)that._actionDisableOther) && this._canEditBreakpointHitActions == that._canEditBreakpointHitActions && ModelUtil.areEqual((Object)this._customTypeString, (Object)that._customTypeString) && ModelUtil.areEqual((Object)this._customDescription, (Object)that._customDescription) && ModelUtil.areEqual((Object)this._debuggerExtenderID, (Object)that._debuggerExtenderID) && Arrays.equals(this._propertyKeys, that._propertyKeys) && Arrays.equals(this._propertyValues, that._propertyValues);
    }
}

