/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FastStringBuffer;
import oracle.ideri.util.Product;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxBreakpoint;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.BreakpointSettings;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SavedBreakpoints;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

final class Breakpoint
extends BaseElement
implements DebugBreakpointCondition,
GutterColumnListener {
    private BreakpointSettings breakpointSettings;
    private SourceIcon sourceIcon;
    private boolean breakpointShowing;
    private boolean shallow;
    private Map debugBreakpointForDebuggingProcess;
    private Map debuggingProcessForDebugBreakpoint;
    static final int STATUS_DISABLED = 0;
    static final int STATUS_ENABLED = 1;
    static final int STATUS_UNVERIFIED = 2;
    static final int STATUS_VERIFIED = 3;
    static final Object GlobalBreakpointsKey = "217";
    private static SavedBreakpoints savedBreakpoints;
    private static Map allBreakpoints;

    Breakpoint(BreakpointSettings breakpointSettings) {
        this.breakpointSettings = breakpointSettings;
        this.init();
    }

    Breakpoint() {
        this.breakpointSettings = new BreakpointSettings();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String pkg, String file, int line) {
        if (type != 0) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setPkg(pkg);
        this.breakpointSettings.setFile(file);
        this.breakpointSettings.setLine(line);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String methodOrClassName) {
        if (type != 1 && type != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        if (type == 1) {
            this.breakpointSettings.setMethod(methodOrClassName);
        } else {
            this.breakpointSettings.setClassName(methodOrClassName);
        }
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String methodName, int offset) {
        if (type != 7) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setMethod(methodName);
        this.breakpointSettings.setOffset(offset);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String exception, boolean caught, boolean uncaught) {
        if (type != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setException(exception);
        this.breakpointSettings.setCaught(caught);
        this.breakpointSettings.setUncaught(uncaught);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type) {
        if (type != 3) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, URL url, int line) {
        if (type != 5) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setURL(url);
        this.breakpointSettings.setLine(line);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String className, String fieldName, boolean access, boolean modify) {
        if (type != 6) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setClassName(className);
        this.breakpointSettings.setFieldName(fieldName);
        this.breakpointSettings.setAccess(access);
        this.breakpointSettings.setModify(modify);
        this.breakpointSettings.setActions();
        this.init();
    }

    private void init() {
        this.debugBreakpointForDebuggingProcess = new HashMap();
        this.debuggingProcessForDebugBreakpoint = new HashMap();
    }

    BreakpointSettings getBreakpointSettings() {
        return this.breakpointSettings;
    }

    void copyInto(Breakpoint otherBp) {
        otherBp.breakpointSettings.copyToImpl(this.breakpointSettings);
    }

    DebugBreakpoint getDebugBreakpoint(DebuggingProcess debuggingProcess) {
        return (DebugBreakpoint)this.debugBreakpointForDebuggingProcess.get(debuggingProcess);
    }

    URL getOwnerURL() {
        return this.breakpointSettings.getOwnerURL();
    }

    void setOwnerURL(URL ownerURL) {
        boolean iconWasShowing = this.hideBreakpointIcon();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (iconWasShowing) {
            this.showBreakpointIcon();
        }
    }

    boolean isPersistent() {
        return this.breakpointSettings.isPersistent();
    }

    int getType() {
        return this.breakpointSettings.getType();
    }

    String getPackage() {
        return this.breakpointSettings.getPkg();
    }

    String getFile() {
        return this.breakpointSettings.getFile();
    }

    int getLine() {
        return this.breakpointSettings.getLine();
    }

    void setPackageFileLine(String pkgArg, String fileArg, int lineArg) {
        this.setPackageFileLine(pkgArg, fileArg, lineArg, true);
    }

    private void setPackageFileLine(final String pkgArg, final String fileArg, final int lineArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 0) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setPkg(pkgArg);
        this.breakpointSettings.setFile(fileArg);
        this.breakpointSettings.setLine(lineArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpointPackageFileLine dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointPackageFileLine)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setPackageFileLine(pkgArg, fileArg, lineArg);
                    }
                }
            };
            Runnable runOnceLater = new Runnable(){

                @Override
                public void run() {
                    Breakpoint.this.updateBreakpointIcon();
                }
            };
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        int bpType = this.breakpointSettings.getType();
        if (bpType == 0) {
            String pkg = this.breakpointSettings.getPkg();
            String file = this.breakpointSettings.getFile();
            this.setPackageFileLine(pkg, file, newLine, false);
            JDebugger.getInstance().breakpointHasBeenMoved(this);
        } else if (bpType == 5) {
            URL url = this.breakpointSettings.getURL();
            this.setURLLine(url, newLine, false);
            JDebugger.getInstance().breakpointHasBeenMoved(this);
        } else if (bpType == 6 && this.hideBreakpointIcon()) {
            this.showBreakpointIcon();
        }
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
        this.removeBreakpoint();
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this.removeBreakpoint();
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
        return this.getShortLabel();
    }

    String getMethod() {
        return this.breakpointSettings.getMethod();
    }

    void setMethod(final String methodArg) {
        if (this.breakpointSettings.getType() != 1) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setMethod(methodArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpointMethod dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointMethod)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setMethod(methodArg);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    int getOffset() {
        return this.breakpointSettings.getOffset();
    }

    void setMethodOffset(String methodArg, int offsetArg) {
        this.setMethodOffset(methodArg, offsetArg, true);
    }

    void setMethodOffset(final String methodArg, final int offsetArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 7) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setMethod(methodArg);
        this.breakpointSettings.setOffset(offsetArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpointMethodBytecode dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointMethodBytecode)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setMethodBytecodeOffset(methodArg, offsetArg);
                    }
                }
            };
            Runnable runOnceLater = new Runnable(){

                @Override
                public void run() {
                    Breakpoint.this.updateBreakpointIcon();
                }
            };
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    String getException() {
        return this.breakpointSettings.getException();
    }

    boolean isCaught() {
        return this.breakpointSettings.isCaught();
    }

    boolean isUncaught() {
        return this.breakpointSettings.isUncaught();
    }

    void setException(final String exceptionArg, final boolean caughtArg, final boolean uncaughtArg) {
        if (this.breakpointSettings.getType() != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setException(exceptionArg);
        this.breakpointSettings.setCaught(caughtArg);
        this.breakpointSettings.setUncaught(uncaughtArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpointException dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointException)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setExceptionClassname(exceptionArg, caughtArg, uncaughtArg);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getClassName() {
        return this.breakpointSettings.getClassName();
    }

    void setClassName(final String classNameArg) {
        if (this.breakpointSettings.getType() != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setClassName(classNameArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpointClass dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointClass)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setClassname(classNameArg);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    URL getURL() {
        return this.breakpointSettings.getURL();
    }

    void setURLLine(URL urlArg, int lineArg) {
        this.setURLLine(urlArg, lineArg, true);
    }

    private void setURLLine(final URL urlArg, final int lineArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 5) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setURL(urlArg);
        this.breakpointSettings.setLine(lineArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    String[] packageAndFile;
                    DebugBreakpointPackageFileLine dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointPackageFileLine)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null && (packageAndFile = debuggingProcess.url_to_packageAndFile(urlArg)) != null && packageAndFile.length == 2) {
                        dbp.setPackageFileLine(packageAndFile[0], packageAndFile[1], lineArg);
                    }
                }
            };
            Runnable runOnceLater = new Runnable(){

                @Override
                public void run() {
                    Breakpoint.this.updateBreakpointIcon();
                }
            };
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    String getFieldName() {
        return this.breakpointSettings.getFieldName();
    }

    boolean isAccess() {
        return this.breakpointSettings.isAccess();
    }

    boolean isModify() {
        return this.breakpointSettings.isModify();
    }

    void setWatchpoint(final String classNameArg, final String fieldNameArg, final boolean accessArg, final boolean modifyArg) {
        if (this.breakpointSettings.getType() != 6) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = this.hideBreakpointIcon();
        this.breakpointSettings.setClassName(classNameArg);
        this.breakpointSettings.setFieldName(fieldNameArg);
        this.breakpointSettings.setAccess(accessArg);
        this.breakpointSettings.setModify(modifyArg);
        if (iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpointWatchpoint dbp;
                    if (debuggingProcess != null && live && (dbp = (DebugBreakpointWatchpoint)Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setWatchpoint(classNameArg, fieldNameArg, accessArg, modifyArg);
                    }
                }
            };
            Runnable runOnceLater = new Runnable(){

                @Override
                public void run() {
                    Breakpoint.this.updateBreakpointIcon();
                }
            };
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    boolean isEnabled() {
        return this.breakpointSettings.isEnabled();
    }

    boolean isEnabledNow() {
        DebugBreakpoint dbp;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (dbp = this.getDebugBreakpoint(debuggingProcess)) != null) {
            return dbp.getEnabled();
        }
        return this.breakpointSettings.isEnabled();
    }

    void setEnabled(final boolean enabledArg) {
        this.breakpointSettings.setEnabled(enabledArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setEnabled(enabledArg);
                    }
                }
            };
            Runnable runOnceLater = new Runnable(){

                @Override
                public void run() {
                    Breakpoint.this.updateBreakpointIcon();
                    JDebugger.getInstance().updateBreakpointsWindowStatus(Breakpoint.this);
                }
            };
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    String getGroupName() {
        return this.breakpointSettings.getGroupName();
    }

    void setGroupName(String groupNameArg) {
        if (groupNameArg == null) {
            groupNameArg = "";
        }
        this.breakpointSettings.setGroupName(groupNameArg);
        final String groupName = groupNameArg;
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setName(groupName);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditGroupName() {
        return this.breakpointSettings.canEditGroupName();
    }

    void setCanEditGroupName(boolean canEditGroupName) {
        this.breakpointSettings.setCanEditGroupName(canEditGroupName);
    }

    String getHiddenCondition() {
        return this.breakpointSettings.getHiddenCondition();
    }

    void setHiddenCondition(String hiddenConditionArg) {
        if (hiddenConditionArg == null) {
            hiddenConditionArg = "";
        }
        this.breakpointSettings.setHiddenCondition(hiddenConditionArg.trim());
        this.propagateCondition();
    }

    boolean hasCondition() {
        return this.getCondition().length() > 0 || this.getHiddenCondition().length() > 0;
    }

    String getCondition() {
        return this.breakpointSettings.getCondition();
    }

    void setCondition(String conditionArg) {
        if (conditionArg == null) {
            conditionArg = "";
        }
        this.breakpointSettings.setCondition(conditionArg.trim());
        this.propagateCondition();
    }

    private void propagateCondition() {
        Breakpoint bpCondition;
        Breakpoint breakpoint = bpCondition = this.hasCondition() ? this : null;
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setCondition(bpCondition);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditCondition() {
        return this.breakpointSettings.canEditCondition();
    }

    void setCanEditCondition(boolean canEditCondition) {
        this.breakpointSettings.setCanEditCondition(canEditCondition);
    }

    @Override
    public boolean checkBreakpointCondition(DebugBreakpoint dbp, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        block8: {
            try {
                if (stack.length > 0) {
                    String condition = this.getConditionText();
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    int result = evaluator.evaluateCondition(condition);
                    switch (result) {
                        default: {
                            String msg = DbgArb.format(531, condition);
                            DebuggingProcess debuggingProcess = (DebuggingProcess)this.debuggingProcessForDebugBreakpoint.get(dbp);
                            debuggingProcess.addMessage(msg);
                            return true;
                        }
                        case -1: {
                            String msg = DbgArb.format(532, condition);
                            DebuggingProcess debuggingProcess = (DebuggingProcess)this.debuggingProcessForDebugBreakpoint.get(dbp);
                            debuggingProcess.addMessage(msg);
                            return true;
                        }
                        case 0: {
                            return false;
                        }
                        case 1: 
                    }
                    return true;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block8;
                throw (ThreadDeath)e;
            }
        }
        return false;
    }

    @Override
    public String getConditionText() {
        String condition = this.breakpointSettings.getCondition();
        String hiddenCondition = this.getHiddenCondition();
        if (hiddenCondition.length() == 0) {
            return condition;
        }
        if (condition.length() == 0) {
            return hiddenCondition;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("((");
        buf.append(hiddenCondition);
        buf.append(") && (");
        buf.append(condition);
        buf.append("))");
        return buf.toString();
    }

    String getThreadName() {
        return this.breakpointSettings.getThreadName();
    }

    void setThreadName(String threadNameArg) {
        if (threadNameArg == null) {
            threadNameArg = "";
        }
        this.breakpointSettings.setThreadName(threadNameArg);
        final String threadName = threadNameArg;
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setThreadname(threadName);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getThreadNameNot() {
        return this.breakpointSettings.getThreadNameNot();
    }

    void setThreadNameNot(String threadNameNotArg) {
        if (threadNameNotArg == null) {
            threadNameNotArg = "";
        }
        this.breakpointSettings.setThreadNameNot(threadNameNotArg);
        final String threadNameNot = threadNameNotArg;
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setThreadnameNot(threadNameNot);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditBreakForThreads() {
        return this.breakpointSettings.canEditBreakForThreads();
    }

    void setCanEditBreakForThreads(boolean canEditBreakForThreads) {
        this.breakpointSettings.setCanEditBreakForThreads(canEditBreakForThreads);
    }

    int getPassCount() {
        return this.breakpointSettings.getPassCount();
    }

    void setPassCount(final int passCountArg) {
        this.breakpointSettings.setPassCount(passCountArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setPassCount(passCountArg);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditPassCount() {
        return this.breakpointSettings.canEditPassCount();
    }

    void setCanEditPassCount(boolean canEditPassCount) {
        this.breakpointSettings.setCanEditPassCount(canEditPassCount);
    }

    String getPassCountInfo() {
        int activePassCount;
        DebugBreakpoint dbp;
        int passCount = this.breakpointSettings.getPassCount();
        String s = Integer.toString(passCount);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (dbp = this.getDebugBreakpoint(debuggingProcess)) != null && (activePassCount = dbp.getPassCount()) != passCount) {
            s = s + " " + DbgArb.format(373, Integer.toString(activePassCount));
        }
        return s;
    }

    private long[] getInstanceFiltersArray(DebuggingProcess debuggingProcess) {
        DebugBreakpoint dbp = this.getDebugBreakpoint(debuggingProcess);
        if (dbp != null) {
            return dbp.getInstanceFilters();
        }
        return null;
    }

    String getInstanceFilters() {
        int instanceFiltersLength;
        long[] instanceFilters;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (instanceFilters = this.getInstanceFiltersArray(debuggingProcess)) != null && (instanceFiltersLength = instanceFilters.length) > 0) {
            FastStringBuffer fsb = new FastStringBuffer();
            for (int i = 0; i < instanceFiltersLength; ++i) {
                fsb.append(Long.toString(instanceFilters[i]));
                if (i >= instanceFiltersLength - 1) continue;
                fsb.append(", ");
            }
            return DbgArb.format(393, fsb.toString());
        }
        return "";
    }

    boolean isActionHalt() {
        return this.breakpointSettings.isActionHalt();
    }

    void setActionHalt(final boolean actionHaltArg) {
        this.breakpointSettings.setActionHalt(actionHaltArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setStop(actionHaltArg);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean isActionBeep() {
        return this.breakpointSettings.isActionBeep();
    }

    void setActionBeep(boolean actionBeepArg) {
        this.breakpointSettings.setActionBeep(actionBeepArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setLog(Breakpoint.this.breakpointSettings.isActionBeep() || Breakpoint.this.breakpointSettings.isActionLog());
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean isActionLog() {
        return this.breakpointSettings.isActionLog();
    }

    void setActionLog(boolean actionLogArg) {
        this.breakpointSettings.setActionLog(actionLogArg);
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setLog(Breakpoint.this.breakpointSettings.isActionBeep() || Breakpoint.this.breakpointSettings.isActionLog());
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getActionLogTag() {
        return this.breakpointSettings.getActionLogTag();
    }

    void setActionLogTag(String actionLogTagArg) {
        if (actionLogTagArg == null) {
            actionLogTagArg = "";
        }
        this.breakpointSettings.setActionLogTag(actionLogTagArg);
    }

    String getActionLogExpression() {
        return this.breakpointSettings.getActionLogExpr();
    }

    void setActionLogExpression(String actionLogExprArg) {
        if (actionLogExprArg == null) {
            actionLogExprArg = "";
        }
        this.breakpointSettings.setActionLogExpr(actionLogExprArg);
    }

    boolean isActionLogStack() {
        return this.breakpointSettings.isActionLogStack();
    }

    void setActionLogStack(boolean actionLogStackArg) {
        this.breakpointSettings.setActionLogStack(actionLogStackArg);
    }

    String getAction() {
        String actionDisableOther;
        String actionEnableOther;
        String action = "";
        String delimiter = "";
        if (this.breakpointSettings.isActionHalt()) {
            action = action + delimiter + DbgArb.getString(374);
            delimiter = ", ";
        }
        if (this.breakpointSettings.isActionBeep()) {
            action = action + delimiter + DbgArb.getString(375);
            delimiter = ", ";
        }
        if (this.breakpointSettings.isActionLog()) {
            action = action + delimiter + DbgArb.getString(377);
            delimiter = ", ";
        }
        if ((actionEnableOther = this.breakpointSettings.getActionEnableOther()).length() > 0) {
            action = action + delimiter + DbgArb.getString(378) + actionEnableOther;
            delimiter = ", ";
        }
        if ((actionDisableOther = this.breakpointSettings.getActionDisableOther()).length() > 0) {
            action = action + delimiter + DbgArb.getString(379) + actionDisableOther;
        }
        return action;
    }

    String logBreakpoint(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return this.prepareLog(vm, thread, stack, null, null);
    }

    String logException(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String classname, String detail) {
        return this.prepareLog(vm, thread, stack, classname, detail);
    }

    String logDeadlock(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return this.prepareLog(vm, thread, stack, null, null);
    }

    String logWatchpoint(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, DebugFieldInfo field, DebugDataInfo futureValue) {
        String sFutureValue;
        String msg1 = futureValue == null ? DbgArb.format(520, this.getFieldName()) : DbgArb.format(521, this.getFieldName());
        DebugDataInfo currentValue = field.getDataInfo();
        String sCurrentValue = DataPanel.makeDataValue(field, currentValue);
        if ((sCurrentValue == null || sCurrentValue.length() == 0) && currentValue instanceof DebugDataCompositeInfo) {
            sCurrentValue = Breakpoint.makeStupidValue(vm, (DebugDataCompositeInfo)currentValue);
        }
        if (sCurrentValue != null && sCurrentValue.length() > 0) {
            msg1 = msg1 + " " + DbgArb.format(522, sCurrentValue);
        }
        if (((sFutureValue = DataPanel.makeDataValue(field, futureValue)) == null || sFutureValue.length() == 0) && futureValue instanceof DebugDataCompositeInfo) {
            sFutureValue = Breakpoint.makeStupidValue(vm, (DebugDataCompositeInfo)futureValue);
        }
        if (sFutureValue != null && sFutureValue.length() > 0) {
            msg1 = msg1 + " " + DbgArb.format(523, sFutureValue);
        }
        return this.prepareLog(vm, thread, stack, msg1, null);
    }

    private static String makeStupidValue(DebugVirtualMachine vm, DebugDataCompositeInfo data) {
        long number = JDebugger.getObjectNumber(data);
        return "@" + Long.toHexString(number).toUpperCase();
    }

    private String prepareLog(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String extra1, String extra2) {
        if (this.breakpointSettings.isActionBeep()) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.breakpointSettings.isActionLog()) {
            String stackMsg;
            String exprMsg;
            String expr;
            String msg = this.getMessage(stack, extra1, extra2);
            String tag = this.breakpointSettings.getActionLogTag();
            if (tag != null && tag.length() > 0) {
                msg = msg + tag + "\n";
            }
            if ((expr = this.breakpointSettings.getActionLogExpr()) != null && expr.length() > 0 && (exprMsg = this.evaluateLogExpression(vm, thread, stack, expr)) != null && exprMsg.length() > 0) {
                msg = msg + exprMsg;
            }
            if (this.breakpointSettings.isActionLogStack() && (stackMsg = this.getLogStack(stack)) != null && stackMsg.length() > 0) {
                msg = msg + stackMsg;
            }
            return msg;
        }
        return null;
    }

    private String evaluateLogExpression(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String actionLogExpr) {
        String evaluation;
        block5: {
            evaluation = "?";
            try {
                if (stack.length > 0) {
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    Object info = evaluator.evaluate(actionLogExpr);
                    if (info != null) {
                        DebugDataInfo data = Evaluator.getDataInfo(info);
                        evaluation = DataPanel.makeDataValue(info, data);
                        String type = DataItem.makeType(data, true);
                        if (type != null && type.length() > 0) {
                            evaluation = evaluation + " (" + type + ")";
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)e;
            }
        }
        String msg = DbgArb.format(530, actionLogExpr, evaluation);
        return msg;
    }

    private String getLogStack(DebugStackFrameInfo[] stack) {
        int stackLength = stack.length;
        if (stackLength > 0) {
            FastStringBuffer sb = new FastStringBuffer();
            for (int i = 0; i < stackLength; ++i) {
                DebugMethodInfo method;
                DebugStackFrameInfo frame = stack[i];
                DebugLocation location = frame.getLocation();
                if (location == null || (method = location.getMethod()) == null) continue;
                String methodName = DebugShared.makeCourtesyMethodName(method, true, false, frame);
                String filename = location.getFilename();
                int line = location.getLine();
                sb.append('\t');
                sb.append("at ");
                sb.append(methodName);
                if ((method.getAccess() & 0x100) != 0) {
                    sb.append("(Native Method)");
                } else if (filename != null) {
                    sb.append('(');
                    sb.append(filename);
                    if (line > 0) {
                        sb.append(':');
                        sb.append(Integer.toString(line));
                    }
                    sb.append(')');
                }
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    private String getMessage(DebugStackFrameInfo[] stack, String extra1, String extra2) {
        int msgId;
        boolean logFileLine = false;
        boolean logMethodName = false;
        switch (this.breakpointSettings.getType()) {
            default: {
                msgId = 514;
                logFileLine = true;
                break;
            }
            case 1: {
                msgId = 515;
                logMethodName = true;
                logFileLine = true;
                break;
            }
            case 7: {
                msgId = 516;
                logMethodName = true;
                logFileLine = false;
                break;
            }
            case 2: {
                msgId = 517;
                logFileLine = true;
                break;
            }
            case 3: {
                msgId = 518;
                logFileLine = true;
                break;
            }
            case 4: {
                msgId = 524;
                logMethodName = true;
                logFileLine = true;
                break;
            }
            case 5: {
                msgId = 525;
                logMethodName = true;
                logFileLine = true;
                break;
            }
            case 6: {
                msgId = 519;
                logMethodName = true;
                logFileLine = true;
            }
        }
        String locationInfo = "";
        DebugLocation location = DebuggingProcess.getNonNativeLocation(stack);
        if (location != null) {
            DebugMethodInfo method = location.getMethod();
            if (logFileLine) {
                String filename = location.getFilename();
                int line = location.getLine();
                if (logMethodName && method != null) {
                    DebugClassInfo clazz = method.getClassInfo();
                    int index = clazz != null && clazz.getLanguage() == 8 ? 855 : (XSLTRunnerAddin.isXSLTStylesheet(clazz) ? 528 : 527);
                    String methodName = DebugShared.makeCourtesyMethodName(method, true, true, null);
                    locationInfo = DbgArb.format(index, Integer.toString(line), filename, methodName);
                } else {
                    locationInfo = DbgArb.format(526, Integer.toString(line), filename);
                }
            } else if (logMethodName && method != null) {
                String methodName = DebugShared.makeCourtesyMethodName(method, true, true, null);
                int offset = location.getBytecodeOffset();
                locationInfo = DbgArb.format(529, Integer.toString(offset), methodName);
            }
        }
        Object[] params = new String[]{locationInfo, extra1 != null ? extra1 : "", extra2 != null ? extra2 : ""};
        return DbgArb.format(msgId, params);
    }

    String getActionEnableOther() {
        return this.breakpointSettings.getActionEnableOther();
    }

    void setActionEnableOther(String actionEnableOtherArg) {
        if (actionEnableOtherArg == null) {
            actionEnableOtherArg = "";
        }
        this.breakpointSettings.setActionEnableOther(actionEnableOtherArg);
        final String actionEnableOther = actionEnableOtherArg;
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setEnableOtherBPs(actionEnableOther);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getActionDisableOther() {
        return this.breakpointSettings.getActionDisableOther();
    }

    void setActionDisableOther(String actionDisableOtherArg) {
        if (actionDisableOtherArg == null) {
            actionDisableOtherArg = "";
        }
        this.breakpointSettings.setActionDisableOther(actionDisableOtherArg);
        final String actionDisableOther = actionDisableOtherArg;
        if (!this.shallow) {
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        dbp.setDisableOtherBPs(actionDisableOther);
                    }
                }
            };
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditBreakpointHitActions() {
        return this.breakpointSettings.canEditBreakpointHitActions();
    }

    void setCanEditBreakpointHitActions(boolean canEditBreakpointHitActions) {
        this.breakpointSettings.setCanEditBreakpointHitActions(canEditBreakpointHitActions);
    }

    Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] keys = this.breakpointSettings.getPropertyKeys();
        String[] values = this.breakpointSettings.getPropertyValues();
        if (keys != null && values != null && keys.length == values.length) {
            for (int x = 0; x < keys.length; ++x) {
                properties.put(keys[x], values[x]);
            }
        }
        return properties;
    }

    void setProperties(Map<String, String> newProperties) {
        if (newProperties != null && !newProperties.isEmpty()) {
            String[] keys = newProperties.keySet().toArray(new String[newProperties.size()]);
            String[] values = newProperties.values().toArray(new String[newProperties.size()]);
            this.breakpointSettings.setPropertyKeys(keys);
            this.breakpointSettings.setPropertyValues(values);
        } else {
            this.breakpointSettings.setPropertyKeys(null);
            this.breakpointSettings.setPropertyValues(null);
        }
    }

    String getCustomDescription() {
        return this.breakpointSettings.getCustomDescription();
    }

    void setCustomDescription(String customDescription) {
        this.breakpointSettings.setCustomDescription(customDescription);
    }

    String getCustomTypeString() {
        return this.breakpointSettings.getCustomTypeString();
    }

    void setCustomTypeString(String customTypeString) {
        this.breakpointSettings.setCustomTypeString(customTypeString);
    }

    boolean isCustom() {
        return this.breakpointSettings.isCustom();
    }

    String getDebuggerExtenderID() {
        return this.breakpointSettings.getDebuggerExtenderID();
    }

    void setDebuggerExtenderID(String debuggerExtenderID) {
        this.breakpointSettings.setDebuggerExtenderID(debuggerExtenderID);
    }

    void pauseAndApplyChanges(final Runnable runOnceLater) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    try {
                        DebugBreakpoint dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess);
                        if (dbp != null) {
                            switch (Breakpoint.this.breakpointSettings.getType()) {
                                case 0: {
                                    String pkg = Breakpoint.this.breakpointSettings.getPkg();
                                    String file = Breakpoint.this.breakpointSettings.getFile();
                                    int line = Breakpoint.this.breakpointSettings.getLine();
                                    ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(pkg, file, line);
                                    break;
                                }
                                case 1: {
                                    String method = Breakpoint.this.breakpointSettings.getMethod();
                                    ((DebugBreakpointMethod)dbp).setMethod(method);
                                    break;
                                }
                                case 7: {
                                    String method = Breakpoint.this.breakpointSettings.getMethod();
                                    int offset = Breakpoint.this.breakpointSettings.getOffset();
                                    ((DebugBreakpointMethodBytecode)dbp).setMethodBytecodeOffset(method, offset);
                                    break;
                                }
                                case 2: {
                                    String exception = Breakpoint.this.breakpointSettings.getException();
                                    boolean caught = Breakpoint.this.breakpointSettings.isCaught();
                                    boolean uncaught = Breakpoint.this.breakpointSettings.isUncaught();
                                    ((DebugBreakpointException)dbp).setExceptionClassname(exception, caught, uncaught);
                                    break;
                                }
                                case 4: {
                                    String className = Breakpoint.this.breakpointSettings.getClassName();
                                    ((DebugBreakpointClass)dbp).setClassname(className);
                                    break;
                                }
                                case 5: {
                                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                                        ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(null, Breakpoint.this.breakpointSettings.getURL().toString(), Breakpoint.this.breakpointSettings.getLine());
                                        break;
                                    }
                                    String[] packageAndFile = debuggingProcess.url_to_packageAndFile(Breakpoint.this.breakpointSettings.getURL());
                                    if (packageAndFile == null || packageAndFile.length != 2) break;
                                    int line = Breakpoint.this.breakpointSettings.getLine();
                                    ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(packageAndFile[0], packageAndFile[1], line);
                                    break;
                                }
                                case 6: {
                                    String className = Breakpoint.this.breakpointSettings.getClassName();
                                    String fieldName = Breakpoint.this.breakpointSettings.getFieldName();
                                    boolean access = Breakpoint.this.breakpointSettings.isAccess();
                                    boolean modify = Breakpoint.this.breakpointSettings.isModify();
                                    ((DebugBreakpointWatchpoint)dbp).setWatchpoint(className, fieldName, access, modify);
                                    break;
                                }
                            }
                            dbp.setEnabled(Breakpoint.this.breakpointSettings.isEnabled());
                            dbp.setName(Breakpoint.this.breakpointSettings.getGroupName());
                            dbp.setCondition(Breakpoint.this.hasCondition() ? Breakpoint.this : null);
                            dbp.setThreadname(Breakpoint.this.breakpointSettings.getThreadName());
                            dbp.setThreadnameNot(Breakpoint.this.breakpointSettings.getThreadNameNot());
                            dbp.setPassCount(Breakpoint.this.breakpointSettings.getPassCount());
                            dbp.setStop(Breakpoint.this.breakpointSettings.isActionHalt());
                            dbp.setLog(Breakpoint.this.breakpointSettings.isActionBeep() || Breakpoint.this.breakpointSettings.isActionLog());
                            dbp.setEnableOtherBPs(Breakpoint.this.breakpointSettings.getActionEnableOther());
                            dbp.setDisableOtherBPs(Breakpoint.this.breakpointSettings.getActionDisableOther());
                            dbp.changeBreakpoint();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        Runnable runOnceLaterWrapper = new Runnable(){

            @Override
            public void run() {
                Breakpoint.this.updateBreakpointIcon();
                if (runOnceLater != null) {
                    runOnceLater.run();
                }
            }
        };
        this.pauseAndInvoke(runWhilePaused, runOnceLaterWrapper);
    }

    DebugBreakpoint putBreakpoint(DebuggingProcess debuggingProcess, boolean isTemporary) {
        try {
            DebugBreakpoint dbp = null;
            String error = null;
            int bpType = this.breakpointSettings.getType();
            switch (bpType) {
                case 0: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    String pkg = this.breakpointSettings.getPkg();
                    String file = this.breakpointSettings.getFile();
                    int line = this.breakpointSettings.getLine();
                    dbp = debuggingProcess.getVM().putBreakpointPackageFileLine(pkg, file, line);
                    break;
                }
                case 1: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    String method = this.breakpointSettings.getMethod();
                    dbp = debuggingProcess.getVM().putBreakpointMethod(method);
                    break;
                }
                case 7: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    String method = this.breakpointSettings.getMethod();
                    int offset = this.breakpointSettings.getOffset();
                    dbp = debuggingProcess.getVM().putBreakpointMethodBytecode(method, offset);
                    break;
                }
                case 2: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    String exception = this.breakpointSettings.getException();
                    boolean caught = this.breakpointSettings.isCaught();
                    boolean uncaught = this.breakpointSettings.isUncaught();
                    dbp = debuggingProcess.getVM().putBreakpointException(exception, caught, uncaught);
                    break;
                }
                case 3: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    dbp = debuggingProcess.getVM().putBreakpointDeadlock();
                    break;
                }
                case 4: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    String className = this.breakpointSettings.getClassName();
                    dbp = debuggingProcess.getVM().putBreakpointClass(className);
                    break;
                }
                case 5: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        dbp = debuggingProcess.getVM().putBreakpointFileLine(this.breakpointSettings.getURL().toString(), this.breakpointSettings.getLine());
                        break;
                    }
                    String[] packageAndFile = debuggingProcess.url_to_packageAndFile(this.breakpointSettings.getURL());
                    if (packageAndFile != null && packageAndFile.length == 2) {
                        int line = this.breakpointSettings.getLine();
                        dbp = debuggingProcess.getVM().putBreakpointPackageFileLine(packageAndFile[0], packageAndFile[1], line);
                        break;
                    }
                    error = DbgArb.format(555, this.getDescription());
                    break;
                }
                case 6: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return null;
                    }
                    String className = this.breakpointSettings.getClassName();
                    String fieldName = this.breakpointSettings.getFieldName();
                    boolean access = this.breakpointSettings.isAccess();
                    boolean modify = this.breakpointSettings.isModify();
                    dbp = debuggingProcess.getVM().putBreakpointWatchpoint(className, fieldName, access, modify);
                    break;
                }
            }
            if (dbp != null) {
                String actionDisableOther;
                String groupName;
                if (!isTemporary) {
                    this.debugBreakpointForDebuggingProcess.put(debuggingProcess, dbp);
                    this.debuggingProcessForDebugBreakpoint.put(dbp, debuggingProcess);
                    JDebugger.getInstance().breakpointHasBeenPut(this, dbp);
                }
                if (!this.breakpointSettings.isEnabled()) {
                    dbp.setEnabled(false);
                }
                if ((groupName = this.breakpointSettings.getGroupName()).length() > 0) {
                    dbp.setName(groupName);
                }
                dbp.setCondition(this.hasCondition() ? this : null);
                String threadName = this.breakpointSettings.getThreadName();
                String threadNameNot = this.breakpointSettings.getThreadNameNot();
                if (threadName.length() > 0) {
                    dbp.setThreadname(threadName);
                } else if (threadNameNot.length() > 0) {
                    dbp.setThreadnameNot(threadNameNot);
                }
                dbp.setPassCount(this.breakpointSettings.getPassCount());
                dbp.setStop(this.breakpointSettings.isActionHalt());
                dbp.setLog(this.breakpointSettings.isActionBeep() || this.breakpointSettings.isActionLog());
                String actionEnableOther = this.breakpointSettings.getActionEnableOther();
                if (actionEnableOther.length() > 0) {
                    dbp.setEnableOtherBPs(actionEnableOther);
                }
                if ((actionDisableOther = this.breakpointSettings.getActionDisableOther()).length() > 0) {
                    dbp.setDisableOtherBPs(actionDisableOther);
                }
                if (!isTemporary) {
                    this.changed(dbp, debuggingProcess);
                }
                dbp.setBreakpoint();
                return dbp;
            }
            if (!isTemporary && this.breakpointSettings.isEnabled()) {
                String msg = null;
                if (error != null) {
                    msg = error;
                } else if (bpType == 3) {
                    if ((debuggingProcess.getVM().getLanguages() & 1) != 0) {
                        msg = DbgArb.getString(556);
                    }
                } else {
                    msg = bpType == 6 ? DbgArb.format(557, this.getDescription()) : DbgArb.format(554, this.getDescription());
                }
                if (msg != null) {
                    debuggingProcess.log(msg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    void putBreakpoint(Runnable runOnceLater) {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    Breakpoint.this.putBreakpoint(debuggingProcess, false);
                }
            }
        };
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
    }

    void removeBreakpoint() {
        if (!this.breakpointSettings.isPersistent()) {
            this.hideBreakpointIcon();
            JDebugger.getInstance().breakpointHasBeenRemoved(this);
            RunWhilePaused runWhilePaused = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    DebugBreakpoint dbp;
                    if (debuggingProcess != null && live && (dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess)) != null) {
                        JDebugger.getInstance().breakpointHasBeenRemoved(dbp);
                        dbp.remove();
                    }
                }
            };
            Runnable runOnceLater = new Runnable(){

                @Override
                public void run() {
                    Breakpoint.this.debuggingProcessForDebugBreakpoint.clear();
                    Breakpoint.this.debugBreakpointForDebuggingProcess.clear();
                }
            };
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
            Breakpoint.removeBreakpointFromOwner(this);
        }
    }

    void setShallow(boolean shallow) {
        this.shallow = shallow;
    }

    private void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        DebuggingProcess[] processes = JDebugger.getInstance().getDebuggingProcessesForBreakpoint(this);
        JDebugger.pauseAndInvoke(processes, runWhilePaused, runOnceLater);
    }

    void changed(DebugBreakpoint dbp, DebuggingProcess debuggingProcess) {
        if (JDebugger.getInstance().isActiveDebuggingProcess(debuggingProcess)) {
            this.updateBreakpointIcon();
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        DebugBreakpoint dbp = this.getDebugBreakpoint(debuggingProcess);
        if (dbp != null) {
            JDebugger.getInstance().breakpointHasBeenRemoved(dbp);
            this.debuggingProcessForDebugBreakpoint.remove(dbp);
        }
        this.debugBreakpointForDebuggingProcess.remove(debuggingProcess);
    }

    String getTypeString() {
        return this.breakpointSettings.getTypeString();
    }

    int getActiveStatus() {
        return this.getActiveStatus(null);
    }

    int getActiveStatus(DebuggingProcess debuggingProcess) {
        if (debuggingProcess == null) {
            debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        }
        if (debuggingProcess != null) {
            DebugBreakpoint dbp = this.getDebugBreakpoint(debuggingProcess);
            if (dbp != null) {
                if (!dbp.getEnabled()) {
                    return 0;
                }
                if (dbp instanceof DebugBreakpointClass || dbp instanceof DebugBreakpointMethod || dbp instanceof DebugBreakpointMethodBytecode || dbp instanceof DebugBreakpointPackageFileLine) {
                    if (dbp instanceof DebugMozillaFireFoxBreakpoint) {
                        return ((DebugMozillaFireFoxBreakpoint)dbp).isSet() ? 3 : 2;
                    }
                    DebugLocation[] locations = dbp.getLocations();
                    return locations.length > 0 ? 3 : 2;
                }
                if (dbp instanceof DebugMozillaFireFoxBreakpoint) {
                    return ((DebugMozillaFireFoxBreakpoint)dbp).isSet() ? 3 : 2;
                }
            } else {
                return this.breakpointSettings.isEnabled() ? 2 : 0;
            }
        }
        return this.breakpointSettings.isEnabled() ? 1 : 0;
    }

    @Override
    public String getShortLabel() {
        return DbgArb.format(367, this.getTypeString(), this.getDescription());
    }

    @Override
    public Icon getIcon() {
        if (this.breakpointSettings.getType() == 6) {
            if (this.isEnabledNow()) {
                return OracleIcons.getIcon((String)"debugger/enabledwatchpoint.gif");
            }
            return OracleIcons.getIcon((String)"debugger/disabledwatchpoint.gif");
        }
        switch (this.getActiveStatus()) {
            case 0: {
                return OracleIcons.getIcon((String)"disabledbreakpoint.png");
            }
            case 1: 
            case 2: {
                return OracleIcons.getIcon((String)"unverifiedbreakpoint.png");
            }
            case 3: {
                return OracleIcons.getIcon((String)"verifiedbreakpoint.png");
            }
        }
        return null;
    }

    HighlightStyle getHighlightStyle() {
        switch (this.getActiveStatus()) {
            case 0: {
                return SourceIcon.disabledBPStyle;
            }
            case 1: 
            case 2: 
            case 3: {
                return SourceIcon.enabledBPStyle;
            }
        }
        return null;
    }

    private void makeSourceIcon(String pkg, String file, int line) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon(null, null, pkg, file, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon(null, ownerURL, pkg, file, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, null, pkg, file, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(URL url, int line) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, url, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, url, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, url, line, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(String className, String fieldName) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, className, fieldName, null, this.getIcon(), this.getHighlightStyle(), 1, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, className, fieldName, null, this.getIcon(), this.getHighlightStyle(), 1, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, className, fieldName, null, this.getIcon(), this.getHighlightStyle(), 1, this);
            }
        }
    }

    private void makeSourceIcon(String fqMethod, int offset) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, fqMethod, offset, null, this.getIcon(), this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, fqMethod, offset, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, fqMethod, offset, null, this.getIcon(), this.getHighlightStyle(), 0, this);
            }
        }
    }

    void showBreakpointIcon() {
        this.breakpointShowing = true;
        ExtenderManager.getInstance().showBreakpointIcon(this);
        int bpType = this.breakpointSettings.getType();
        switch (bpType) {
            case 0: {
                String pkg = this.breakpointSettings.getPkg();
                String file = this.breakpointSettings.getFile();
                int line = this.breakpointSettings.getLine();
                this.makeSourceIcon(pkg, file, line);
                break;
            }
            case 5: {
                URL url = this.breakpointSettings.getURL();
                int line = this.breakpointSettings.getLine();
                this.makeSourceIcon(url, line);
                break;
            }
            case 6: {
                String className = this.breakpointSettings.getClassName();
                String fieldName = this.breakpointSettings.getFieldName();
                this.makeSourceIcon(className, fieldName);
                break;
            }
            case 7: {
                String fqMethodName = this.breakpointSettings.getMethod();
                int offset = this.breakpointSettings.getOffset();
                this.makeSourceIcon(fqMethodName, offset);
                break;
            }
        }
    }

    boolean matchesIconLocation(CodeEditor codeEditor, int line) {
        if (this.sourceIcon != null) {
            return this.sourceIcon.matchesIconLocation(codeEditor, line);
        }
        return false;
    }

    boolean hideBreakpointIcon() {
        if (this.breakpointShowing) {
            ExtenderManager.getInstance().hideBreakpointIcon(this);
            if (this.sourceIcon != null) {
                this.sourceIcon.hide();
                this.sourceIcon = null;
            }
            this.breakpointShowing = false;
            return true;
        }
        return false;
    }

    private void updateBreakpointIcon() {
        ExtenderManager.getInstance().updateBreakpointIcon(this);
        if (this.sourceIcon != null) {
            this.sourceIcon.changeIcon(this.getIcon(), this.getHighlightStyle());
        }
    }

    String getDescription() {
        if (this.breakpointSettings.getCustomDescription() != null) {
            return this.breakpointSettings.getCustomDescription();
        }
        String desc = "";
        switch (this.breakpointSettings.getType()) {
            case 0: {
                String pkg = this.breakpointSettings.getPkg();
                String file = this.breakpointSettings.getFile();
                if (Product.isRaptor() && file.endsWith(".pls")) {
                    file = file.substring(0, file.length() - 4);
                }
                int line = this.breakpointSettings.getLine();
                desc = pkg + " " + file + " " + line;
                break;
            }
            case 1: {
                String method;
                desc = method = this.breakpointSettings.getMethod();
                break;
            }
            case 7: {
                String method = this.breakpointSettings.getMethod();
                int offset = this.breakpointSettings.getOffset();
                desc = method + " " + offset;
                break;
            }
            case 2: {
                String exception = this.breakpointSettings.getException();
                if (Product.isRaptor() && this.breakpointSettings.isPersistent() && exception.equals("java.lang.Exception")) {
                    desc = DbgArb.getString(505);
                    break;
                }
                boolean caught = this.breakpointSettings.isCaught();
                boolean uncaught = this.breakpointSettings.isUncaught();
                if (caught) {
                    if (uncaught) {
                        desc = DbgArb.format(510, exception);
                        break;
                    }
                    desc = DbgArb.format(508, exception);
                    break;
                }
                if (uncaught) {
                    desc = DbgArb.format(509, exception);
                    break;
                }
                desc = exception;
                break;
            }
            case 3: {
                desc = DbgArb.getString(506);
                break;
            }
            case 4: {
                String className;
                desc = className = this.breakpointSettings.getClassName();
                break;
            }
            case 5: {
                URL url = this.breakpointSettings.getURL();
                int line = this.breakpointSettings.getLine();
                desc = URLFileSystem.getPlatformPathName((URL)url) + " " + line;
                break;
            }
            case 6: {
                String classNameFieldName = this.breakpointSettings.getClassName() + " " + this.breakpointSettings.getFieldName();
                boolean access = this.breakpointSettings.isAccess();
                boolean modify = this.breakpointSettings.isModify();
                if (access) {
                    if (modify) {
                        desc = DbgArb.format(513, classNameFieldName);
                        break;
                    }
                    desc = DbgArb.format(511, classNameFieldName);
                    break;
                }
                if (modify) {
                    desc = DbgArb.format(512, classNameFieldName);
                    break;
                }
                desc = classNameFieldName;
                break;
            }
        }
        if (this.breakpointSettings.isPersistent()) {
            desc = DbgArb.format(507, desc);
        }
        return desc;
    }

    String getStatusInfo() {
        String s = this.breakpointSettings.isEnabled() ? DbgArb.getString(369) : DbgArb.getString(368);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null) {
            String activeStatus = null;
            switch (this.getActiveStatus()) {
                case 0: {
                    activeStatus = DbgArb.getString(368);
                    break;
                }
                case 1: {
                    activeStatus = DbgArb.getString(369);
                    break;
                }
                case 2: {
                    activeStatus = DbgArb.getString(370);
                    break;
                }
                case 3: {
                    activeStatus = DbgArb.getString(371);
                }
            }
            if (activeStatus != null && !activeStatus.equals(s)) {
                s = s + " " + DbgArb.format(372, activeStatus);
            }
        }
        return s;
    }

    static Map allBreakpoints() {
        return allBreakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean breakpointsLoaded() {
        Map map = allBreakpoints;
        synchronized (map) {
            return savedBreakpoints != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadBreakpoints() {
        Map map = allBreakpoints;
        synchronized (map) {
            if (savedBreakpoints == null) {
                savedBreakpoints = new SavedBreakpoints();
                savedBreakpoints.load();
                ArrayList breakpoints = savedBreakpoints.getBreakpoints();
                int count = breakpoints.size();
                if (count == 0) {
                    Breakpoint.createPersistentBreakpoints();
                } else {
                    for (int i = 0; i < count; ++i) {
                        BreakpointSettings breakpointSettings = (BreakpointSettings)breakpoints.get(i);
                        Breakpoint bp = new Breakpoint(breakpointSettings);
                        List keyBreakpoints = Breakpoint.getBreakpoints(bp.getOwnerURL());
                        keyBreakpoints.add(bp);
                    }
                }
            }
        }
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)new BreakpointNodeListener());
    }

    private static void createPersistentBreakpoints() {
        Breakpoint bpUncaughtException = new Breakpoint((URL)null, 2, "java.lang.Exception", false, true);
        Breakpoint.initializePersistentOptions(bpUncaughtException);
        Breakpoint.addBreakpointToOwner(bpUncaughtException);
        if (!Product.isRaptor()) {
            String osNameLower = System.getProperty("os.name").toLowerCase();
            if (osNameLower.indexOf("linux") != -1) {
                bpUncaughtException.setEnabled(false);
            }
            Breakpoint bpAssertionError = new Breakpoint((URL)null, 2, "java.lang.AssertionError", false, true);
            Breakpoint.initializePersistentOptions(bpAssertionError);
            Breakpoint.addBreakpointToOwner(bpAssertionError);
            Breakpoint bpDeadlock = new Breakpoint(null, 3);
            Breakpoint.initializePersistentOptions(bpDeadlock);
            Breakpoint.addBreakpointToOwner(bpDeadlock);
            if (osNameLower.indexOf("sunos") != -1) {
                bpDeadlock.setEnabled(false);
            }
        }
    }

    private static void initializePersistentOptions(Breakpoint bp) {
        bp.breakpointSettings.setPersistent(true);
        bp.breakpointSettings.setActionHalt(true);
        bp.breakpointSettings.setActionLog(true);
        bp.breakpointSettings.setActionLogTag("");
        bp.breakpointSettings.setActionLogExpr("");
        bp.breakpointSettings.setActionLogStack(false);
        bp.breakpointSettings.setActionEnableOther("");
        bp.breakpointSettings.setActionDisableOther("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveBreakpoints() {
        ArrayList breakpoints = savedBreakpoints.getBreakpoints();
        breakpoints.clear();
        Map map = allBreakpoints;
        synchronized (map) {
            for (Object key : allBreakpoints.keySet()) {
                URL ownerURL;
                boolean saveKeyBreakpoints = true;
                if (key instanceof URL && !URLFileSystem.exists((URL)(ownerURL = (URL)key))) {
                    saveKeyBreakpoints = false;
                }
                if (!saveKeyBreakpoints) continue;
                List keyBreakpoints = (List)allBreakpoints.get(key);
                for (Breakpoint bp : keyBreakpoints) {
                    BreakpointSettings breakpointSettings = bp.breakpointSettings;
                    breakpoints.add(breakpointSettings);
                }
            }
        }
        savedBreakpoints.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getBreakpoints(URL ownerURL) {
        ArrayList breakpoints;
        Object key = ownerURL == null ? GlobalBreakpointsKey : ownerURL;
        Map map = allBreakpoints;
        synchronized (map) {
            breakpoints = (ArrayList)allBreakpoints.get(key);
            if (breakpoints == null) {
                breakpoints = new ArrayList();
                allBreakpoints.put(key, breakpoints);
            }
        }
        return breakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void breakpointOwnerRenamed(UpdateMessage rename) {
        URL oldKey = RenameMessage.getOldURL((UpdateMessage)rename);
        Node renamedNode = RenameMessage.getRenamedNode((UpdateMessage)rename);
        if (renamedNode != null) {
            URL newKey = renamedNode.getURL();
            Map map = allBreakpoints;
            synchronized (map) {
                List breakpoints = (List)allBreakpoints.remove(oldKey);
                if (breakpoints != null) {
                    for (Breakpoint bp : breakpoints) {
                        bp.setOwnerURL(newKey);
                    }
                    allBreakpoints.put(newKey, breakpoints);
                }
            }
        }
    }

    static List[] getBreakpoints(Workspace workspace, Project project) {
        ArrayList<List> breakpoints = new ArrayList<List>();
        breakpoints.add(Breakpoint.getBreakpoints(null));
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            breakpoints.add(Breakpoint.getBreakpoints(workspace.getURL()));
        }
        if (project != null && project != Ide.getDefaultProject()) {
            breakpoints.add(Breakpoint.getBreakpoints(project.getURL()));
        }
        return breakpoints.toArray(new List[breakpoints.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Breakpoint> getExtenderBreakpoints(String debuggerExtenderID) {
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        Map map = allBreakpoints;
        synchronized (map) {
            for (Object key : allBreakpoints.keySet()) {
                List keyBreakpoints = (List)allBreakpoints.get(key);
                for (Breakpoint bp : keyBreakpoints) {
                    if (!debuggerExtenderID.equals(bp.getDebuggerExtenderID())) continue;
                    breakpoints.add(bp);
                }
            }
        }
        return breakpoints;
    }

    static void removeBreakpointFromOwner(Breakpoint bp) {
        URL ownerURL = bp.getOwnerURL();
        List breakpoints = Breakpoint.getBreakpoints(ownerURL);
        breakpoints.remove(bp);
    }

    static void addBreakpointToOwner(Breakpoint bp) {
        URL ownerURL = bp.getOwnerURL();
        List breakpoints = Breakpoint.getBreakpoints(ownerURL);
        breakpoints.add(bp);
    }

    static void showBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.showBreakpointIcon();
            }
        }
    }

    static void hideBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.hideBreakpointIcon();
            }
        }
    }

    static void updateBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.updateBreakpointIcon();
            }
        }
    }

    static {
        allBreakpoints = new HashMap();
    }

    private static final class BreakpointNodeListener
    extends NodeListener {
        private BreakpointNodeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            Map map = allBreakpoints;
            synchronized (map) {
                for (Object o : allBreakpoints.values()) {
                    for (Breakpoint bp : (List)o) {
                        if (bp.getType() != 5 || !URLFileSystem.equals((URL)oldURL, (URL)bp.getURL())) continue;
                        bp.setURLLine(newURL, bp.getLine());
                        JDebugger.getInstance().breakpointHasBeenRefactored(bp);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeDeleted(NodeEvent e) {
            Map map = allBreakpoints;
            synchronized (map) {
                for (Object o : allBreakpoints.values()) {
                    for (Breakpoint bp : (List)o) {
                        if (bp.getType() != 5 || !URLFileSystem.equals((URL)e.getNodeURL(), (URL)bp.getURL())) continue;
                        bp.removeBreakpoint();
                        JDebugger.getInstance().updateBreakpointsWindow();
                    }
                }
            }
        }
    }
}

