/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.ide.menu.ItemFactory;
import javax.ide.view.GUIPanel;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.model.Project;
import oracle.ide.view.View;
import oracle.ideimpl.runner.TerminateRunProcessButtons;
import oracle.ideri.util.Product;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.SharedActions;
import oracle.jdevimpl.runner.run.JRunner;

public class RunItemFactory
extends ItemFactory {
    private static final String TERMINATE_ALL = "TerminateCommandAll";
    private static final String TERMINATE_ONE = "TerminateCommandOne";
    private Map commandMap = new HashMap();

    public RunItemFactory() {
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/RunProjectCommand", JRunner.getInstance().getActionRunProject());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugProjectCommand", JDebugger.getInstance().getActionDebugProject());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugShowIPCommand", JDebugger.getInstance().getActionDebugShowIP());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugStepOverCommand", JDebugger.getInstance().getActionDebugStepOver());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugStepIntoCommand", JDebugger.getInstance().getActionDebugStepInto());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugStepOutCommand", JDebugger.getInstance().getActionDebugStepOut());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugStepToEndOfMethodCommand", JDebugger.getInstance().getActionDebugStepToEndOfMethod());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugStepOverBCCommand", JDebugger.getInstance().getActionDebugStepOverBC());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugStepIntoBCCommand", JDebugger.getInstance().getActionDebugStepIntoBC());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugResumeCommand", SharedActions.getInstance().getResumeAction());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugPauseCommand", SharedActions.getInstance().getSuspendAction());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/DebugGCCommand", SharedActions.getInstance().getGcAction());
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/TerminateCommandOne", TERMINATE_ONE);
        this.commandMap.put("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID/oracle.jdeveloper.TB_RUN_DEBUG_SECTION/TerminateCommandAll", TERMINATE_ALL);
    }

    public GUIPanel createItem(String path) {
        Object object = this.commandMap.get(path);
        if (object instanceof String) {
            if (object.toString().equals(TERMINATE_ONE)) {
                return new GUIPanel((Object)TerminateRunProcessButtons.getTerminateRunProcessesButton((boolean)true), null);
            }
            if (object.toString().equals(TERMINATE_ALL)) {
                return new GUIPanel((Object)TerminateRunProcessButtons.getTerminateRunProcessesButton((boolean)false), null);
            }
        }
        if (object instanceof Action) {
            if (path.endsWith("RunProjectCommand") || path.endsWith("DebugProjectCommand")) {
                return new GUIPanel((Object)new RunDebugButton((Action)object), null);
            }
            return new GUIPanel((Object)new DebugActionButton((Action)object));
        }
        return null;
    }

    private class RunDebugButton
    extends ActionMenuToolButton
    implements PopupMenuListener {
        public RunDebugButton(Action action) {
            super(action);
            if (Product.isRaptor()) {
                this.setVisible(false);
            }
        }

        protected JPopupMenu createPopupMenu() {
            super.createPopupMenu();
            this._popup.addPopupMenuListener(this);
            return this._popup;
        }

        protected void releasePopupMenu() {
            if (this._popup != null) {
                this._popup.removePopupMenuListener(this);
            }
            super.releasePopupMenu();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            View activeView;
            Project activeProject = Ide.getActiveProject();
            if (activeProject != null && !activeProject.isOpen()) {
                try {
                    activeProject.open();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            Context context = (activeView = Ide.getMainWindow().getLastActiveView()) != null ? activeView.getContext((EventObject)e) : Context.newIdeContext();
            int count = this._popup.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Action action;
                Component c = this._popup.getComponent(i);
                if (!(c instanceof JMenuItem) || !((action = ((JMenuItem)c).getAction()) instanceof IdeAction)) continue;
                IdeAction ideAction = (IdeAction)action;
                ideAction.updateAction(context);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private class DebugActionButton
    extends ToolButton {
        DebugActionButton(Action action) {
            super(action);
            this.setVisible(false);
        }
    }
}

