/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.Container;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.runner.Runner;
import oracle.ide.util.Namespace;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.RunConfigurationLaunchPanel;
import oracle.jdevimpl.runner.RunConfigurationToolPanel;
import oracle.jdevimpl.runner.RunMgrArb;

public class RunConfigurationEditor {
    private final RunConfiguration runConfigurationOriginal;
    private final boolean allowEdit;
    private static final String RUN_CONFIGURATION_KEY = "run-configuration";

    public RunConfigurationEditor(RunConfiguration runConfigurationOriginal, boolean allowEdit) {
        this.runConfigurationOriginal = runConfigurationOriginal;
        this.allowEdit = allowEdit;
    }

    public boolean showDialog() {
        int index = this.allowEdit ? 23 : 24;
        String title = RunMgrArb.format(index, this.runConfigurationOriginal.getName());
        MDDPanel mddPanel = new MDDPanel(RunConfigurationEditor.getNavigables());
        mddPanel.addMDDListener((MDDListener)new MDDAdapter(){

            public void traversableEntered(MDDEvent e) {
                Traversable traversable;
                if (!RunConfigurationEditor.this.allowEdit && (traversable = e.getTraversable()) instanceof Container) {
                    RunConfigurationEditor.setPanelEnabled((Container)traversable, false);
                }
            }
        });
        Namespace namespace = new Namespace();
        RunConfiguration runConfigurationCopy = new RunConfiguration();
        this.runConfigurationOriginal.copyTo((Object)runConfigurationCopy);
        RunConfigurationEditor.setRunConfiguration(namespace, runConfigurationCopy);
        TDialogLauncher launcher = new TDialogLauncher((Component)SwingUtils.getMainWindow(), title, (Traversable)mddPanel, namespace);
        mddPanel.expandTree1ToDepth(3);
        launcher.setInitialSize(700, 500);
        if (launcher.showDialog() && this.allowEdit) {
            runConfigurationCopy.copyTo((Object)this.runConfigurationOriginal);
            return true;
        }
        return false;
    }

    private static void setPanelEnabled(Container container, boolean enable) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Container) || !children[i].isVisible()) continue;
            try {
                RunConfigurationEditor.setPanelEnabled((Container)children[i], enable);
            }
            catch (Exception e) {
                // empty catch block
            }
            children[i].setEnabled(enable);
        }
    }

    private static Navigable[] getNavigables() {
        Runner runner = Runner.getRunner();
        Navigable launchNavigable = new Navigable(RunMgrArb.getString(25), RunConfigurationLaunchPanel.class);
        Navigable[] launchChildNavigables = runner.getRunConfigurationLaunchNavigables();
        int launchChildNavigablesLength = launchChildNavigables.length;
        for (int i = 0; i < launchChildNavigablesLength; ++i) {
            launchNavigable.addChildNavigable(launchChildNavigables[i]);
        }
        Navigable toolNavigable = new Navigable(RunMgrArb.getString(42), RunConfigurationToolPanel.class);
        Navigable[] toolChildNavigables = runner.getRunConfigurationToolNavigables();
        int toolChildNavigablesLength = toolChildNavigables.length;
        for (int i = 0; i < toolChildNavigablesLength; ++i) {
            toolNavigable.addChildNavigable(toolChildNavigables[i]);
        }
        Navigable[] navigables = new Navigable[]{launchNavigable, toolNavigable};
        return navigables;
    }

    public static RunConfiguration getRunConfiguration(Namespace namespace) {
        return (RunConfiguration)((Object)namespace.find(RUN_CONFIGURATION_KEY));
    }

    private static void setRunConfiguration(Namespace namespace, RunConfiguration runConfiguration) {
        namespace.put(RUN_CONFIGURATION_KEY, (Object)runConfiguration);
    }
}

