/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.runner.RunMgrArb;

final class ApplicationStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    ApplicationStarterFactory() {
    }

    public String getName() {
        return RunMgrArb.getString(63);
    }

    public Object canStart(RunProcess runProcess, Node node, List errors) {
        String[] target;
        if (runProcess instanceof JRunProcess && (target = ApplicationStarterFactory.findApplicationTarget(runProcess, node, errors)) != null && runProcess.canRun("Java", null, node, errors)) {
            return target;
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object o) {
        String[] target = (String[])o;
        return new ApplicationStarter((JRunProcess)runProcess, target);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object o) {
        return new DefaultDisplayable(){

            public String getShortLabel() {
                return RunMgrArb.getString(64);
            }

            public Icon getIcon() {
                return BuilderArb.getIcon((int)137);
            }
        };
    }

    private static String[] findApplicationTarget(RunProcess runProcess, Node node, List errors) {
        if (node instanceof JavaNode) {
            JavaNode javaNode = (JavaNode)node;
            Project jproject = runProcess.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
            JavaFile javaFile = javaManager.getFile(javaNode.getURL());
            if (javaFile != null) {
                JavaType[] params = new JavaType[]{javaManager.getArrayType((JavaType)javaManager.getClass("java.lang.String"), 1)};
                PrimitiveType voidType = CommonUtilities.getPrimitiveType((String)"void");
                Collection classes = javaFile.getClasses();
                if (!classes.isEmpty()) {
                    classes = ApplicationStarterFactory.reorderClasses(classes, javaNode.getShortLabel());
                    for (JavaClass clazz : classes) {
                        if (!ApplicationStarterFactory.isApplicationTarget(node, clazz, params, (JavaClass)voidType, errors)) continue;
                        return ApplicationStarterFactory.makeTargetStrings(clazz.getQualifiedName());
                    }
                } else {
                    String error = RunMgrArb.format(65, node.getShortLabel());
                    errors.add(error);
                }
            } else {
                String error = RunMgrArb.format(66, node.getShortLabel());
                errors.add(error);
            }
        }
        return null;
    }

    private static List reorderClasses(Collection c, String filename) {
        ArrayList classes = new ArrayList(c);
        int i = filename.indexOf(".");
        if (i != -1) {
            filename = filename.substring(0, i);
        }
        final String name = filename;
        Collections.sort(classes, new Comparator<JavaClass>(){

            @Override
            public int compare(JavaClass class1, JavaClass class2) {
                String name2;
                String name1 = class1.getName();
                int i = name1.indexOf(".");
                if (i != -1) {
                    name1 = name1.substring(i + 1);
                }
                if ((i = (name2 = class2.getName()).indexOf(".")) != -1) {
                    name2 = name2.substring(i + 1);
                }
                if (name1.equals(name) && !name2.equals(name)) {
                    return -1;
                }
                if (!name1.equals(name) && name2.equals(name)) {
                    return 1;
                }
                int mod1 = class1.getModifiers();
                int mod2 = class2.getModifiers();
                if (Modifier.isPublic(mod1) && !Modifier.isPublic(mod2)) {
                    return -1;
                }
                if (!Modifier.isPublic(mod1) && Modifier.isPublic(mod2)) {
                    return 1;
                }
                return 0;
            }
        });
        return classes;
    }

    private static boolean isApplicationTarget(Node node, JavaClass clazz, JavaType[] params, JavaClass voidType, List errors) {
        JavaClass superClass;
        ArrayList<JavaClass> classesAlreadyChecked = new ArrayList<JavaClass>();
        classesAlreadyChecked.add(clazz);
        if (ApplicationStarterFactory.findMainMethod(node, clazz, params, voidType, errors)) {
            return true;
        }
        JavaType superType = clazz.getSuperclass();
        while (superType instanceof JavaClass && !classesAlreadyChecked.contains(superClass = (JavaClass)superType)) {
            classesAlreadyChecked.add(superClass);
            if (ApplicationStarterFactory.findMainMethod(node, superClass, params, voidType, null)) {
                return true;
            }
            superType = superClass.getSuperclass();
        }
        return false;
    }

    private static boolean findMainMethod(Node node, JavaClass clazz, JavaType[] params, JavaClass voidType, List errors) {
        Collection methods;
        String className = clazz.getName();
        int classModifiers = clazz.getModifiers();
        JavaMethod mainMethod = clazz.getDeclaredMethod("main", params);
        if (mainMethod != null) {
            JavaType returnType = mainMethod.getReturnType();
            if (returnType.equals(voidType)) {
                int methodModifiers = mainMethod.getModifiers();
                if (Modifier.isPublic(methodModifiers)) {
                    if (Modifier.isStatic(methodModifiers)) {
                        return true;
                    }
                    if (errors != null) {
                        String error = RunMgrArb.format(67, node.getShortLabel(), className);
                        errors.add(error);
                        errors.add(RunMgrArb.getString(72));
                    }
                } else if (errors != null) {
                    String error = RunMgrArb.format(68, node.getShortLabel(), className);
                    errors.add(error);
                    errors.add(RunMgrArb.getString(72));
                }
            } else if (errors != null) {
                String error = RunMgrArb.format(69, node.getShortLabel(), className);
                errors.add(error);
                errors.add(RunMgrArb.getString(72));
            }
        } else if (Modifier.isPublic(classModifiers) && !(methods = clazz.getDeclaredMethods()).isEmpty()) {
            String error;
            boolean foundMain = false;
            for (JavaMethod method : methods) {
                if (!method.getName().equals("main")) continue;
                foundMain = true;
                break;
            }
            if (foundMain) {
                if (errors != null) {
                    error = RunMgrArb.format(70, node.getShortLabel(), className);
                    errors.add(error);
                    errors.add(RunMgrArb.getString(72));
                }
            } else if (errors != null) {
                error = RunMgrArb.format(71, node.getShortLabel(), className);
                errors.add(error);
            }
        }
        return false;
    }

    private static String[] makeTargetStrings(String className) {
        String[] s = new String[]{className};
        return s;
    }

    class ApplicationStarter
    extends JStarter {
        ApplicationStarter(JRunProcess jrunProcess, String[] target) {
            super(jrunProcess, target);
        }
    }
}

