/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.shared;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.shared.GenericSignature;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public final class DebugShared {
    private static Map defaultConnectArgValues = null;

    public static DebugThreadInfo[][] getDeadlockedThreads(DebugVirtualMachine vm) {
        ArrayList<DebugThreadInfo[]> v = new ArrayList<DebugThreadInfo[]>();
        DebugThreadInfo[] allThreads = vm.listThreads();
        ArrayList<DebugThreadInfo> threads = new ArrayList<DebugThreadInfo>();
        for (int i = 0; i < allThreads.length; ++i) {
            threads.add(allThreads[i]);
        }
        ArrayList<DebugThreadInfo> vt = new ArrayList<DebugThreadInfo>();
        while (threads.size() > 0) {
            DebugThreadInfo t = (DebugThreadInfo)threads.get(0);
            DebugMonitorInfo m = null;
            do {
                vt.add(t);
                m = t.getMonitorThreadBlockedFor();
            } while (m != null && (t = m.getOwnerThread()) != null && !vt.contains(t));
            if (t != null && m != null) {
                int index = vt.indexOf(t);
                DebugThreadInfo[] deadlock = new DebugThreadInfo[vt.size() - index];
                boolean alreadyDone = false;
                for (int i = index; i < vt.size(); ++i) {
                    DebugThreadInfo thread = (DebugThreadInfo)vt.get(i);
                    if (!threads.contains(thread)) {
                        alreadyDone = true;
                        break;
                    }
                    deadlock[i - index] = thread;
                }
                if (!alreadyDone) {
                    v.add(deadlock);
                }
            }
            for (int i = 0; i < vt.size(); ++i) {
                threads.remove(vt.get(i));
            }
            vt.clear();
        }
        DebugThreadInfo[][] array = new DebugThreadInfo[v.size()][];
        return (DebugThreadInfo[][])v.toArray((T[])array);
    }

    public static String getPackage(String classname) {
        int lastDot;
        String justPackage = "";
        if (classname != null && classname.length() > 0 && (lastDot = classname.lastIndexOf(".")) != -1) {
            justPackage = classname.substring(0, lastDot);
        }
        return justPackage;
    }

    public static String getPackagePath(String classname) {
        return DebugShared.getPackage(classname).replace('.', File.separatorChar);
    }

    public static String getNameWithoutPackage(String classname) {
        String justClass = "";
        if (classname != null && classname.length() > 0) {
            int lastDot = classname.lastIndexOf(".");
            justClass = lastDot != -1 ? classname.substring(lastDot + 1) : classname;
        }
        return justClass;
    }

    public static String getNameWithoutClass(String methodname) {
        int iSignature = methodname.indexOf("(");
        int iClass = methodname.lastIndexOf(" ", iSignature) + 1;
        int iMethod = methodname.lastIndexOf(".", iSignature) + 1;
        return methodname.substring(0, iClass) + methodname.substring(iMethod);
    }

    public static String getMethodClassName(String methodname) {
        int iSignature = methodname.indexOf("(");
        int iClass = methodname.lastIndexOf(" ", iSignature) + 1;
        int iDot = methodname.lastIndexOf(".", iSignature);
        return methodname.substring(iClass, iDot);
    }

    public static String getNameWithoutSignature(String methodname) {
        int iSignature = methodname.indexOf("(");
        int iClass = methodname.lastIndexOf(" ", iSignature) + 1;
        return methodname.substring(iClass, iSignature);
    }

    public static String getNameWithoutClassOrSignature(String methodname) {
        int iSignature = methodname.indexOf("(");
        int iMethod = methodname.lastIndexOf(".", iSignature) + 1;
        return methodname.substring(iMethod, iSignature);
    }

    public static String getMethodParameterSignature(String methodname) {
        int iSignature = methodname.indexOf("(");
        return methodname.substring(iSignature);
    }

    public static void putClass(Map map, String key, DebugClassInfo clazz) {
        Object o = map.get(key);
        if (o != null) {
            if (o instanceof DebugClassInfo) {
                ArrayList<DebugClassInfo> list = new ArrayList<DebugClassInfo>();
                list.add(clazz);
                list.add((DebugClassInfo)o);
                map.put(key, list);
            } else if (o instanceof List) {
                List list = (List)o;
                list.add(0, clazz);
            }
        } else {
            map.put(key, clazz);
        }
    }

    public static void removeClass(Map map, String key, DebugClassInfo clazz) {
        Object o = map.get(key);
        if (o != null) {
            if (o instanceof DebugClassInfo) {
                map.remove(key);
            } else if (o instanceof List) {
                List list = (List)o;
                list.remove(clazz);
            }
        }
    }

    public static DebugClassInfo getFirstClass(Map map, String key) {
        Object o = map.get(key);
        if (o != null) {
            if (o instanceof DebugClassInfo) {
                return (DebugClassInfo)o;
            }
            if (o instanceof List) {
                List list = (List)o;
                return (DebugClassInfo)list.get(0);
            }
        }
        return null;
    }

    public static String prepadOrTrunc(String s, char c, int len) {
        int slen = s.length();
        if (slen > len) {
            return s.substring(slen - len);
        }
        return DebugShared.prepad(s, '0', len);
    }

    public static String prepad(String s, char c, int len) {
        return IdeUtil.prepad((String)s, (char)c, (int)len);
    }

    public static String makeCourtesyName(Object o) {
        try {
            DebugDataInfo _keyFieldData;
            DebugArrayElementInfo arrayElement;
            DebugDataInfo data;
            DebugClassInfo ci;
            String className;
            if (o instanceof DebugArrayElementInfo && (className = (ci = (data = (arrayElement = (DebugArrayElementInfo)o).getDataInfo()).getClassInfo()).getName()).startsWith("$Oracle.") && className.endsWith("$element") && (_keyFieldData = DebugShared.findFieldData((DebugDataObjectInfo)data, "_key", null)) instanceof DebugDataCompositeInfo) {
                String key;
                DebugDataCompositeInfo _keyData = (DebugDataCompositeInfo)_keyFieldData;
                String string = key = _keyData.isNull() ? "NULL" : DebugShared.makeCourtesyValueInternal(_keyData, true, false);
                if (key != null && key.length() > 0) {
                    FastStringBuffer sb = new FastStringBuffer();
                    sb.append("[");
                    sb.append(key);
                    sb.append("]");
                    return sb.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String makeCourtesyValue(DebugDataCompositeInfo data) {
        try {
            if (data != null) {
                return DebugShared.makeCourtesyValueInternal(data, true, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String makeCourtesyValue(DebugDataCompositeInfo data, boolean quotes, boolean truncate) {
        try {
            if (data != null) {
                return DebugShared.makeCourtesyValueInternal(data, quotes, truncate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String makeCourtesyValueInternal(DebugDataCompositeInfo data, boolean quotes, boolean truncate) throws Exception {
        boolean[] omitQuotes = new boolean[]{false};
        boolean[] dontTruncate = new boolean[]{false};
        String s = DebugShared.prepareCourtesyValue(data, omitQuotes, dontTruncate);
        if (s != null) {
            DebugClassInfo clazz;
            if (truncate && !dontTruncate[0] && s.length() > 100) {
                s = s.substring(0, 100);
            }
            if (quotes && !omitQuotes[0] && (clazz = data.getClassInfo()) != null) {
                String className = clazz.getName();
                if (className.equals("java.lang.String") || className.equals("java.lang.StringBuffer") || className.equals("char[]") || className.equals("byte[]") || className.equals("$oracle.xml.xslt.XMLString")) {
                    FastStringBuffer sb = new FastStringBuffer(s.length() + 2);
                    sb.append('\"').append(s).append('\"');
                    s = sb.toString();
                } else if (className.equals("$Oracle.Builtin.VARCHAR2") || className.equals("$Oracle.Builtin.CLOB") || className.equals("$Oracle.Builtin.BLOB") || className.equals("$Oracle.Builtin.BFILE") || className.equals("$Oracle.Builtin.CHAR") || className.equals("$Oracle.Builtin.NCHAR")) {
                    FastStringBuffer sb = new FastStringBuffer(s.length() + 2);
                    sb.append('\'').append(s).append('\'');
                    s = sb.toString();
                }
            }
        }
        return s;
    }

    private static String prepareCourtesyValue(DebugDataCompositeInfo data, boolean[] omitQuotes, boolean[] dontTruncate) throws Exception {
        String s = data.getCourtesyValue();
        if (s != null) {
            return s;
        }
        DebugDataObjectInfo objectData = null;
        if (data instanceof DebugDataObjectInfo) {
            objectData = (DebugDataObjectInfo)data;
        }
        block27: for (DebugClassInfo ci = data.getClassInfo(); ci != null; ci = ci.getSuperClass(1)) {
            DebugDataCompositeInfo valueData;
            DebugDataInfo typeData;
            String prefix;
            Constructor<?> constructor;
            byte[] bytes;
            DebugDataInfo sizeData;
            Long fastTime;
            DebugDataCompositeInfo nameData;
            DebugDataInfo valueData2;
            String className = ci.getName();
            if (className.equals("byte[]")) {
                DebugDataArrayInfo dataArray = (DebugDataArrayInfo)data;
                byte[] b = null;
                if (dontTruncate[0] || dataArray.getArrayCount() <= 100) {
                    Object whole = dataArray.getWholeThing();
                    if (whole instanceof byte[]) {
                        b = (byte[])whole;
                    }
                } else {
                    DebugArrayElementInfo[] array = dataArray.getArrayElements(0, 100);
                    int length = array.length;
                    b = new byte[length];
                    for (int i = 0; i < length; ++i) {
                        b[i] = DebugSharedPrimitives.byteFromHexString(array[i].getDataInfo().getHexValue());
                    }
                }
                if (b == null) continue;
                s = new String(b, Encodings.getDefaultEncoding());
                if (!dontTruncate[0] && s.length() > 100) {
                    s = s.substring(0, 100);
                }
                return s;
            }
            if (className.equals("java.awt.Label") || className.equals("java.awt.TextComponent") || className.equals("java.awt.TextField") || className.equals("javax.swing.JLabel") || className.equals("javax.swing.AbstractButton") || className.equals("javax.swing.JTextField")) {
                DebugDataCompositeInfo textData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "text", "java.lang.String");
                if (textData == null || textData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(textData, false, false);
            }
            if (className.equals("java.awt.Button") || className.equals("java.awt.Checkbox") || className.equals("java.awt.MenuItem")) {
                DebugDataCompositeInfo labelData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "label", "java.lang.String");
                if (labelData == null || labelData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(labelData, false, false);
            }
            if (className.equals("java.io.File")) {
                dontTruncate[0] = true;
                DebugDataCompositeInfo pathData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "path", "java.lang.String", ci);
                if (pathData == null || pathData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(pathData, false, false);
            }
            if (className.equals("java.lang.Boolean")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "boolean", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Byte")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "byte", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Character")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "char", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Double")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "double", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Float")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "float", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Integer")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "int", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Long")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "long", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Short")) {
                valueData2 = DebugShared.findFieldData(objectData, "value", "short", ci);
                if (valueData2 == null) continue;
                return valueData2.getValue();
            }
            if (className.equals("java.lang.Thread")) {
                nameData = (DebugDataArrayInfo)DebugShared.findFieldData(objectData, "name", "char[]", ci);
                if (nameData == null || nameData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(nameData, false, false);
            }
            if (className.equals("java.lang.ThreadGroup")) {
                nameData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "name", "java.lang.String", ci);
                if (nameData == null || nameData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(nameData, false, false);
            }
            if (className.equals("java.lang.Throwable")) {
                DebugDataCompositeInfo detailMessageData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "detailMessage", "java.lang.String", ci);
                if (detailMessageData == null || detailMessageData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(detailMessageData, false, false);
            }
            if (className.equals("java.lang.ref.Reference")) {
                DebugDataCompositeInfo referentData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "referent", null, ci);
                if (referentData == null || referentData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(referentData, false, false);
            }
            if (className.equals("java.math.BigDecimal")) {
                BigInteger bi;
                DebugDataObjectInfo intValData = (DebugDataObjectInfo)DebugShared.findFieldData(objectData, "intVal", "java.math.BigInteger", ci);
                DebugDataInfo scaleData = DebugShared.findFieldData(objectData, "scale", "int", ci);
                if (intValData == null || intValData.isNull() || scaleData == null || (bi = DebugShared.makeBigInteger(intValData)) == null) continue;
                int scale = DebugSharedPrimitives.intFromHexString(scaleData.getHexValue());
                BigDecimal bd = new BigDecimal(bi, scale);
                return bd.toString();
            }
            if (className.equals("java.math.BigInteger")) {
                BigInteger bi = DebugShared.makeBigInteger(objectData);
                if (bi == null) continue;
                return bi.toString();
            }
            if (className.equals("java.net.URL")) {
                dontTruncate[0] = true;
                return DebugShared.urlToString(objectData);
            }
            if (className.equals("java.sql.Date")) {
                fastTime = DebugShared.findDateFastTime(objectData);
                if (fastTime == null) continue;
                Date d = new Date(fastTime);
                return d.toString();
            }
            if (className.equals("java.sql.Time")) {
                fastTime = DebugShared.findDateFastTime(objectData);
                if (fastTime == null) continue;
                Time t = new Time(fastTime);
                return t.toString();
            }
            if (className.equals("java.sql.Timestamp")) {
                fastTime = DebugShared.findDateFastTime(objectData);
                DebugDataInfo nanosData = DebugShared.findFieldData(objectData, "nanos", "int");
                if (fastTime == null || nanosData == null) continue;
                int nanos = DebugSharedPrimitives.intFromHexString(nanosData.getHexValue());
                Timestamp ts = new Timestamp(fastTime);
                ts.setNanos(nanos);
                return ts.toString();
            }
            if (className.equals("java.util.Date")) {
                fastTime = DebugShared.findDateFastTime(objectData);
                if (fastTime == null) continue;
                java.util.Date d = new java.util.Date(fastTime);
                return d.toString();
            }
            if (className.equals("java.util.ArrayList") || className.equals("java.util.LinkedList") || className.equals("java.util.TreeMap")) {
                sizeData = DebugShared.findFieldData(objectData, "size", "int");
                if (sizeData == null) continue;
                return "size " + sizeData.getValue();
            }
            if (className.equals("java.util.Vector")) {
                DebugDataInfo elementCountData = DebugShared.findFieldData(objectData, "elementCount", "int", ci);
                if (elementCountData == null) continue;
                return "size " + elementCountData.getValue();
            }
            if (className.equals("java.util.HashMap")) {
                sizeData = DebugShared.findFieldData(objectData, "size", "int", ci);
                if (sizeData == null) continue;
                return "size " + sizeData.getValue();
            }
            if (className.equals("java.util.Hashtable")) {
                DebugDataInfo countData = DebugShared.findFieldData(objectData, "count", "int", ci);
                if (countData == null) continue;
                return "size " + countData.getValue();
            }
            if (className.equals("java.util.HashSet")) {
                DebugDataCompositeInfo mapData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "map", "java.util.HashMap", ci);
                if (mapData == null || mapData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(mapData, false, false);
            }
            if (className.equals("java.util.TreeSet")) {
                DebugDataCompositeInfo mData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "m", "java.util.SortedMap", ci);
                if (mData == null || mData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(mData, false, false);
            }
            if (className.equals("java.util.WeakHashMap")) {
                DebugDataCompositeInfo hashData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "hash", "java.util.Map", ci);
                if (hashData == null || hashData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(hashData, false, false);
            }
            if (className.equals("java.util.HashMap$Entry") || className.equals("java.util.Hashtable$Entry") || className.equals("java.util.WeakHashMap$Entry")) {
                String value;
                String key;
                DebugDataCompositeInfo valueData3;
                DebugDataCompositeInfo keyData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "key", "java.lang.Object");
                if (keyData == null || keyData.isNull() || (valueData3 = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "value", "java.lang.Object")) == null || valueData3.isNull() || (key = DebugShared.makeCourtesyValueInternal(keyData, true, false)) == null || key.length() <= 0 || (value = DebugShared.makeCourtesyValueInternal(valueData3, true, false)) == null || value.length() <= 0) continue;
                return key + " -> " + value;
            }
            if (className.equals("oracle.jbo.domain.Char")) {
                try {
                    bytes = DebugShared.getByteArrayField(objectData, "data");
                    if (bytes == null) {
                        return null;
                    }
                    Class<?> characterSetClazz = Class.forName("oracle.sql.CharacterSet");
                    Object cs = null;
                    DebugDataInfo oracleIdData = DebugShared.findFieldData(objectData, "oracleId", "int");
                    if (oracleIdData != null) {
                        int oracleId = DebugSharedPrimitives.intFromHexString(oracleIdData.getHexValue());
                        Method method = characterSetClazz.getMethod("make", Integer.TYPE);
                        cs = method.invoke(null, oracleId);
                    }
                    Class<?> charClazz = Class.forName("oracle.sql.CHAR");
                    if (cs == null) {
                        Field field = charClazz.getField("DEFAULT_CHARSET");
                        cs = field.get(null);
                    }
                    Constructor<?> constructor2 = charClazz.getConstructor(byte[].class, characterSetClazz);
                    Object c = constructor2.newInstance(bytes, cs);
                    Method stringValue = charClazz.getMethod("stringValue", null);
                    Object result = stringValue.invoke(c, null);
                    if (result == null) {
                        return null;
                    }
                    return "\"" + result.toString() + "\"";
                }
                catch (Error e) {
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            if (className.equals("oracle.jbo.domain.Date")) {
                Long fastTime2;
                bytes = DebugShared.getByteArrayField(objectData, "data");
                if (bytes != null) {
                    try {
                        Class<?> dateClazz = Class.forName("oracle.sql.DATE");
                        constructor = dateClazz.getConstructor(byte[].class);
                        Object d = constructor.newInstance(new Object[]{bytes});
                        Method stringValue = dateClazz.getMethod("stringValue", null);
                        Object result = stringValue.invoke(d, null);
                        return result == null ? null : result.toString();
                    }
                    catch (Error e) {
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        continue;
                    }
                }
                DebugDataObjectInfo m_dataData = (DebugDataObjectInfo)DebugShared.findFieldData(objectData, "m_data", "java.sql.Timestamp");
                if (m_dataData == null || m_dataData.isNull() || (fastTime2 = DebugShared.findDateFastTime(m_dataData)) == null) continue;
                Date d = new Date(fastTime2);
                return d.toString();
            }
            if (className.equals("oracle.jbo.domain.Number")) {
                bytes = DebugShared.getByteArrayField(objectData, "data");
                if (bytes != null) {
                    try {
                        Class<?> numberClazz = Class.forName("oracle.sql.NUMBER");
                        constructor = numberClazz.getConstructor(byte[].class);
                        Object n = constructor.newInstance(new Object[]{bytes});
                        Method stringValue = numberClazz.getMethod("stringValue", null);
                        Object result = stringValue.invoke(n, null);
                        return result == null ? null : result.toString();
                    }
                    catch (Error e) {
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        continue;
                    }
                }
                DebugDataCompositeInfo m_dataData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "m_data", "java.lang.Number");
                if (m_dataData == null || m_dataData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(m_dataData, false, false);
            }
            if (className.equals("javax.xml.namespace.QName")) {
                DebugDataCompositeInfo prefixData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "prefix", "java.lang.String");
                DebugDataCompositeInfo localPartData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "localPart", "java.lang.String");
                if (prefixData == null || localPartData == null) continue;
                prefix = (String)prefixData.getWholeThing();
                String localPart = (String)localPartData.getWholeThing();
                if (prefix != null && prefix.length() > 0) {
                    return prefix + ":" + localPart;
                }
                return localPart;
            }
            if (className.equals("oracle.xml.parser.v2.XMLElement")) {
                DebugDataCompositeInfo arrayElementData;
                int ELEM_QXNAME;
                long nodeId;
                int index;
                DebugArrayElementInfo[] arrayElement;
                DebugDataArrayInfo dataData = (DebugDataArrayInfo)DebugShared.findFieldData(objectData, "data", "java.lang.Object[]");
                DebugDataInfo nodeIdData = DebugShared.findFieldData(objectData, "nodeId", "long");
                DebugDataInfo ELEM_QXNAMEData = DebugShared.findStaticFieldData(objectData, "ELEM_QXNAME", "int");
                if (dataData == null || nodeIdData == null || ELEM_QXNAMEData == null || (arrayElement = dataData.getArrayElements(index = (int)(nodeId = DebugSharedPrimitives.longFromHexString(nodeIdData.getHexValue())) + (ELEM_QXNAME = DebugSharedPrimitives.intFromHexString(ELEM_QXNAMEData.getHexValue())), 1)) == null || arrayElement.length != 1 || (arrayElementData = (DebugDataCompositeInfo)arrayElement[0].getDataInfo()).isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(arrayElementData, false, false);
            }
            if (className.startsWith("$Oracle.Builtin.") && objectData != null) {
                DebugDataCompositeInfo _valueData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "_value", "java.lang.String");
                if (_valueData == null) continue;
                if (!_valueData.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(_valueData, false, false);
                }
                omitQuotes[0] = true;
                return "NULL";
            }
            if (className.startsWith("$Oracle.") && className.endsWith("$element")) {
                DebugDataInfo _valueFieldData = DebugShared.findFieldData(objectData, "_value", null);
                if (!(_valueFieldData instanceof DebugDataCompositeInfo)) continue;
                DebugDataCompositeInfo _valueData = (DebugDataCompositeInfo)_valueFieldData;
                if (!_valueData.isNull()) {
                    return DebugShared.makeCourtesyValueInternal(_valueData, true, false);
                }
                omitQuotes[0] = true;
                return "NULL";
            }
            if (className.startsWith("$Oracle.") && objectData != null) {
                DebugDataCompositeInfo _typeData;
                DebugDataInfo _valuesFieldData = DebugShared.findFieldData(objectData, "_values", null);
                if (!(_valuesFieldData instanceof DebugDataArrayInfo) || (_typeData = (DebugDataCompositeInfo)DebugShared.findStaticFieldData(objectData, "_type", "java.lang.String")) == null || _typeData.isNull()) continue;
                return DebugShared.makeCourtesyValueInternal(_typeData, false, false);
            }
            if (className.equals("$oracle.xml.xslt.XMLString")) {
                Object wholeThing;
                valueData2 = (DebugDataArrayInfo)DebugShared.findFieldData(objectData, "value", "char[]");
                if (valueData2 == null || valueData2.isNull() || !((wholeThing = valueData2.getWholeThing()) instanceof String)) continue;
                String value = (String)wholeThing;
                DebugDataInfo lengthData = DebugShared.findFieldData(objectData, "length", "int");
                if (lengthData == null) continue;
                int length = DebugSharedPrimitives.intFromHexString(lengthData.getHexValue());
                if (length < value.length()) {
                    value = value.substring(0, length);
                }
                return value;
            }
            if (!className.equals("$oracle.xml.xslt.XMLNode") || (typeData = DebugShared.findFieldData(objectData, "type", "short")) == null) continue;
            int type = -1;
            try {
                String sType = typeData.getValue();
                type = Short.decode(sType).shortValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (type == -1) continue;
            prefix = null;
            String localName = null;
            if (type == 1 || type == 2) {
                DebugDataCompositeInfo localNameData;
                DebugDataCompositeInfo prefixData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "prefix", "$oracle.xml.xslt.XMLString");
                if (prefixData != null && !prefixData.isNull()) {
                    prefix = DebugShared.makeCourtesyValueInternal(prefixData, false, false);
                }
                if ((localNameData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "localName", "$oracle.xml.xslt.XMLString")) != null && !localNameData.isNull()) {
                    localName = DebugShared.makeCourtesyValueInternal(localNameData, false, false);
                }
            }
            String value = null;
            if (!(type != 2 && type != 3 && type != 4 && type != 7 && type != 8 || (valueData = (DebugDataCompositeInfo)DebugShared.findFieldData(objectData, "value", "$oracle.xml.xslt.XMLString")) == null || valueData.isNull())) {
                value = DebugShared.makeCourtesyValueInternal(valueData, false, false);
            }
            switch (type) {
                case 1: {
                    if (localName == null || localName.length() <= 0) continue block27;
                    if (prefix != null && prefix.length() > 0) {
                        return '<' + prefix + ':' + localName + '>';
                    }
                    return '<' + localName + '>';
                }
                case 2: {
                    if (localName == null || localName.length() <= 0 || value == null || value.length() <= 0) continue block27;
                    if (prefix != null && prefix.length() > 0) {
                        return prefix + ':' + localName + "=\"" + value + '\"';
                    }
                    return localName + "=\"" + value + '\"';
                }
                case 3: {
                    if (value == null || value.length() <= 0) continue block27;
                    return '\"' + value + '\"';
                }
                case 4: {
                    if (value == null || value.length() <= 0) continue block27;
                    return '\"' + value + '\"';
                }
                case 5: {
                    continue block27;
                }
                case 6: {
                    continue block27;
                }
                case 7: {
                    if (value == null || value.length() <= 0) continue block27;
                    return '\"' + value + '\"';
                }
                case 8: {
                    if (value == null || value.length() <= 0) continue block27;
                    return '\"' + value + '\"';
                }
                case 9: {
                    continue block27;
                }
                case 10: {
                    continue block27;
                }
                case 11: {
                    continue block27;
                }
            }
        }
        return null;
    }

    public static String makeCourtesyClassName(DebugClassInfo clazz, boolean showPackage) {
        String s = DebugShared.makeCourtesyClassNameInternal(clazz, showPackage);
        if (s != null) {
            return s;
        }
        if (showPackage) {
            return clazz.getName();
        }
        return clazz.getNameWithoutPackage();
    }

    private static String makeCourtesyClassNameInternal(DebugClassInfo clazz, boolean showPackage) {
        String pkg;
        int language = clazz.getLanguage();
        if (language == 4 && XSLTRunnerAddin.isXSLTStylesheet(clazz)) {
            return XSLTRunnerAddin.getStylesheetName(clazz, showPackage);
        }
        if (language == 2 && (pkg = clazz.getPackage()).startsWith("$Oracle.Block.")) {
            String anonymous = DebugJDIArb.getString(3);
            if (showPackage) {
                return pkg + "." + anonymous;
            }
            return anonymous;
        }
        return null;
    }

    public static String makeCourtesyPackage(DebugClassInfo clazz) {
        if (XSLTRunnerAddin.isXSLTStylesheet(clazz)) {
            return "";
        }
        return clazz.getPackage();
    }

    public static String makeCourtesyMethodName(DebugMethodInfo method, boolean showClass, boolean showSignature, DebugStackFrameInfo stackFrame) {
        if (XSLTRunnerAddin.isXSLTStylesheet(method.getClassInfo())) {
            return XSLTRunnerAddin.getTemplateName(method, stackFrame);
        }
        if (showClass) {
            if (showSignature) {
                return method.getName();
            }
            return method.getNameWithoutSignature();
        }
        if (showSignature) {
            return method.getNameWithoutClass();
        }
        return method.getNameWithoutClassOrSignature();
    }

    public static String makeCourtesyMethodSignature(DebugMethodInfo method, DebugVirtualMachine vm) {
        String methodSignature = method.getParameterSignature();
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (methodSignature.startsWith("(") && methodSignature.endsWith(")")) {
            methodSignature = methodSignature.substring(1, methodSignature.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(methodSignature, ",");
        while (st.hasMoreTokens()) {
            parameterTypes.add(st.nextToken().trim());
        }
        FastStringBuffer result = new FastStringBuffer(methodSignature.length() + 1);
        result.append("(");
        int size = parameterTypes.size();
        for (int i = 0; i < size; ++i) {
            String parameterType = (String)parameterTypes.get(i);
            DebugClassInfo clazz = vm.findFirstClassByName(parameterType);
            if (clazz != null) {
                String prettyParameterType = DebugShared.makeCourtesyClassName(clazz, true);
                result.append(prettyParameterType);
            } else {
                result.append(parameterType);
            }
            if (i >= size - 1) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    public static String makeCourtesyType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, Object fieldOrVariable) {
        return DebugShared.makeCourtesyType(data, clazz, showPackage, fieldOrVariable, null);
    }

    public static String makeCourtesyType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, Object fieldOrVariable, String typeParams) {
        String className = null;
        String classNameWithoutPackage = null;
        String typeArguments = null;
        if (clazz != null) {
            String genericSignature = null;
            if (fieldOrVariable instanceof DebugFieldInfo) {
                genericSignature = ((DebugFieldInfo)fieldOrVariable).getGenericSignature();
            } else if (fieldOrVariable instanceof DebugVariableInfo) {
                genericSignature = ((DebugVariableInfo)fieldOrVariable).getGenericSignature();
            }
            if (typeParams != null) {
                typeArguments = typeParams;
            } else if (data != null && genericSignature == null) {
                DebugClassInfo dci = data.getClassInfo();
                if (dci != null) {
                    genericSignature = dci.getGenericSignature();
                }
                if (genericSignature != null) {
                    typeArguments = GenericSignature.processTypeArguments(genericSignature, true);
                    genericSignature = null;
                }
            }
            if (genericSignature != null) {
                className = GenericSignature.processGenericSignature(genericSignature, true);
                classNameWithoutPackage = GenericSignature.processGenericSignature(genericSignature, false);
                if (className == null) {
                    // empty if block
                }
            }
            if (className == null) {
                className = DebugShared.namePlusTypeArguments(clazz.getName(), typeArguments);
                classNameWithoutPackage = DebugShared.namePlusTypeArguments(clazz.getNameWithoutPackage(), typeArguments);
            }
            try {
                String s;
                DebugDataObjectInfo objectData = null;
                if (data instanceof DebugDataObjectInfo) {
                    objectData = (DebugDataObjectInfo)data;
                }
                DebugDataArrayInfo arrayData = null;
                if (data instanceof DebugDataArrayInfo) {
                    arrayData = (DebugDataArrayInfo)data;
                }
                if (className.startsWith("$Oracle.") && className.endsWith("$element[]") && arrayData != null && !arrayData.isNull()) {
                    int count = arrayData.getArrayCount();
                    FastStringBuffer sb = new FastStringBuffer(showPackage ? className : classNameWithoutPackage);
                    int dollar = sb.lastIndexOf(new FastStringBuffer('$', 1), sb.length() - 1);
                    if (dollar != -1) {
                        sb.replaceCharAt(dollar, ' ');
                    }
                    sb.insert(sb.length() - 1, Integer.toString(count));
                    return sb.toString();
                }
                if (className.endsWith("[]") && arrayData != null && !arrayData.isNull()) {
                    return DebugShared.makeArrayType(arrayData, showPackage ? className : classNameWithoutPackage);
                }
                if (className.startsWith("$Oracle.Builtin.") && objectData != null && !objectData.isNull()) {
                    if (className.equals("$Oracle.Builtin.PLS_INTEGER")) {
                        String type = "PLS_INTEGER";
                        DebugDataInfo min = DebugShared.findFieldData(objectData, "_minValue", "int");
                        DebugDataInfo max = DebugShared.findFieldData(objectData, "_maxValue", "int");
                        if (min != null && max != null) {
                            String minValue = min.getValue();
                            String maxValue = max.getValue();
                            if (minValue.equals("0") && maxValue.equals("0")) {
                                return type;
                            }
                            FastStringBuffer sb = new FastStringBuffer(type);
                            sb.append("(");
                            sb.append(minValue);
                            sb.append("..");
                            sb.append(maxValue);
                            sb.append(")");
                            return sb.toString();
                        }
                    } else if (className.equals("$Oracle.Builtin.NUMBER")) {
                        String type = "NUMBER";
                        DebugDataInfo precision = DebugShared.findFieldData(objectData, "_precision", "int");
                        DebugDataInfo scale = DebugShared.findFieldData(objectData, "_scale", "int");
                        if (precision != null && scale != null) {
                            String precisionValue = precision.getValue();
                            String scaleValue = scale.getValue();
                            if (precisionValue.equals("0") && scaleValue.equals("0")) {
                                return type;
                            }
                            FastStringBuffer sb = new FastStringBuffer(type);
                            sb.append("(");
                            sb.append(precisionValue);
                            sb.append(",");
                            sb.append(scaleValue);
                            sb.append(")");
                            return sb.toString();
                        }
                    } else if (className.equals("$Oracle.Builtin.FLOAT")) {
                        String type = "FLOAT";
                        DebugDataInfo binaryPrecision = DebugShared.findFieldData(objectData, "_binaryPrecision", "int");
                        if (binaryPrecision != null) {
                            FastStringBuffer sb = new FastStringBuffer(type);
                            sb.append("(");
                            sb.append(binaryPrecision.getValue());
                            sb.append(")");
                            return sb.toString();
                        }
                    } else if (className.equals("$Oracle.Builtin.CHAR") || className.equals("$Oracle.Builtin.NCHAR")) {
                        int lastDot = className.lastIndexOf(".");
                        String type = className.substring(lastDot + 1);
                        DebugDataInfo length = DebugShared.findFieldData(objectData, "_length", "int");
                        if (length != null) {
                            String lengthValue = length.getValue();
                            if (lengthValue.equals("0")) {
                                return type;
                            }
                            FastStringBuffer sb = new FastStringBuffer(type);
                            sb.append("(");
                            sb.append(lengthValue);
                            sb.append(")");
                            return sb.toString();
                        }
                    } else if (className.equals("$Oracle.Builtin.VARCHAR2") || className.equals("$Oracle.Builtin.NVARCHAR2") || className.equals("$Oracle.Builtin.RAW") || className.equals("$Oracle.Builtin.LONGRAW") || className.equals("$Oracle.Builtin.LONG")) {
                        int lastDot = className.lastIndexOf(".");
                        String type = className.substring(lastDot + 1);
                        DebugDataInfo maxLength = DebugShared.findFieldData(objectData, "_maxLength", "int");
                        if (maxLength != null) {
                            String maxLengthValue = maxLength.getValue();
                            if (maxLengthValue.equals("0")) {
                                return type;
                            }
                            FastStringBuffer sb = new FastStringBuffer(type);
                            sb.append("(");
                            sb.append(maxLengthValue);
                            sb.append(")");
                            return sb.toString();
                        }
                    }
                } else {
                    String sType;
                    short type;
                    String typeName;
                    DebugDataInfo typeData;
                    if (className.startsWith("$Oracle.") && className.endsWith("$element")) {
                        FastStringBuffer sb = new FastStringBuffer(showPackage ? className : classNameWithoutPackage);
                        int dollar = sb.lastIndexOf(new FastStringBuffer('$', 1), sb.length() - 1);
                        if (dollar != -1) {
                            sb.replaceCharAt(dollar, ' ');
                        }
                        return sb.toString();
                    }
                    if (className.equals("$oracle.xml.xslt.XMLNode") && objectData != null && (typeData = DebugShared.findFieldData(objectData, "type", "short")) != null && (typeName = XSLTRunnerAddin.getXMLNodeTypeName(type = Short.decode(sType = typeData.getValue()).shortValue())) != null) {
                        FastStringBuffer sb = new FastStringBuffer(showPackage ? className : classNameWithoutPackage);
                        sb.append(" (");
                        sb.append(typeName);
                        sb.append(")");
                        return sb.toString();
                    }
                }
                if ((s = DebugShared.makeCourtesyClassNameInternal(clazz, showPackage)) != null) {
                    return s;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return showPackage ? className : classNameWithoutPackage;
    }

    private static String namePlusTypeArguments(String className, String typeArguments) {
        if (typeArguments == null || typeArguments.length() == 0) {
            return className;
        }
        String name = className;
        int nameIndex = name.length();
        boolean appendBrackets = false;
        while (name.endsWith("[]")) {
            name = name.substring(0, nameIndex -= 2);
            appendBrackets = true;
        }
        StringBuilder buf = new StringBuilder(name);
        buf.append(typeArguments);
        if (appendBrackets && !typeArguments.endsWith("[]")) {
            buf.append(className.substring(nameIndex));
        }
        return buf.toString();
    }

    private static String makeArrayType(DebugDataArrayInfo dataArrayInfo, String className) {
        boolean appendBrackets = false;
        String name = className;
        int nameIndex = name.length();
        while (name.endsWith("[]")) {
            appendBrackets = true;
            name = name.substring(0, nameIndex -= 2);
        }
        if (appendBrackets) {
            StringBuilder buf = new StringBuilder(className);
            buf.insert(nameIndex + 1, dataArrayInfo.getArrayCount());
            return buf.toString();
        }
        return className;
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo data, String fieldName) {
        return DebugShared.findFieldData(data, fieldName, null, (DebugClassInfo)null);
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo data, String fieldName, String fieldClassName) {
        return DebugShared.findFieldData(data, fieldName, fieldClassName, (DebugClassInfo)null);
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo data, String fieldName, String fieldClassName, String declaringClassName) {
        DebugClassInfo declaringClass = null;
        if (declaringClassName != null) {
            for (DebugClassInfo ci = data.getClassInfo(); ci != null; ci = ci.getSuperClass(1)) {
                if (!ci.getName().equals(declaringClassName)) continue;
                declaringClass = ci;
                break;
            }
        }
        return DebugShared.findFieldData(data, fieldName, fieldClassName, declaringClass);
    }

    public static DebugDataInfo findFieldData(DebugDataObjectInfo data, String fieldName, String fieldClassName, DebugClassInfo declaringClass) {
        DebugFieldInfo field;
        if (data.canGetFieldByName() && (field = declaringClass != null ? data.getField(fieldName, declaringClass) : data.getField(fieldName)) != null) {
            if (fieldClassName == null) {
                return field.getDataInfo();
            }
            if (field.getClassInfo().getName().equals(fieldClassName)) {
                return field.getDataInfo();
            }
        }
        for (DebugFieldInfo field2 : data.getFields(-1, false, true)) {
            if (!field2.getName().equals(fieldName)) continue;
            if (fieldClassName == null) {
                return field2.getDataInfo();
            }
            if (!field2.getClassInfo().getName().equals(fieldClassName)) continue;
            return field2.getDataInfo();
        }
        return null;
    }

    private static DebugDataInfo findStaticFieldData(DebugDataObjectInfo data, String fieldName, String fieldClassName) {
        DebugClassInfo clazz;
        DebugFieldInfo field;
        if (data.canGetFieldByName() && (field = data.getField(fieldName)) != null && field.isStatic()) {
            if (fieldClassName == null) {
                return field.getDataInfo();
            }
            if (field.getClassInfo().getName().equals(fieldClassName)) {
                return field.getDataInfo();
            }
        }
        if ((clazz = data.getClassInfo()) != null) {
            return DebugShared.findStaticFieldData(clazz, fieldName, fieldClassName);
        }
        return null;
    }

    public static DebugDataInfo findStaticFieldData(DebugClassInfo clazz, String fieldName) {
        return DebugShared.findStaticFieldData(clazz, fieldName, null);
    }

    private static DebugDataInfo findStaticFieldData(DebugClassInfo clazz, String fieldName, String fieldClassName) {
        for (DebugFieldInfo field : clazz.getStaticFields(-1)) {
            if (!field.getName().equals(fieldName)) continue;
            if (fieldClassName == null) {
                return field.getDataInfo();
            }
            if (!field.getClassInfo().getName().equals(fieldClassName)) continue;
            return field.getDataInfo();
        }
        return null;
    }

    private static byte[] getByteArrayField(DebugDataObjectInfo data, String name) {
        DebugDataArrayInfo dataData = (DebugDataArrayInfo)DebugShared.findFieldData(data, name, "byte[]");
        if (dataData != null && !dataData.isNull()) {
            DebugArrayElementInfo[] array = dataData.getArrayElements();
            int length = array.length;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = DebugSharedPrimitives.byteFromHexString(array[i].getDataInfo().getHexValue());
            }
            return bytes;
        }
        return null;
    }

    private static BigInteger makeBigInteger(DebugDataObjectInfo data) {
        DebugDataInfo signumData = DebugShared.findFieldData(data, "signum", "int", "java.math.BigInteger");
        if (signumData != null) {
            int signum = DebugSharedPrimitives.intFromHexString(signumData.getHexValue());
            DebugDataArrayInfo magData = (DebugDataArrayInfo)DebugShared.findFieldData(data, "mag", "int[]", "java.math.BigInteger");
            if (magData != null && !magData.isNull()) {
                DebugArrayElementInfo[] array = magData.getArrayElements();
                int length = array.length;
                byte[] magnitude = new byte[length * 4];
                for (int i = 0; i < length; ++i) {
                    int i4 = DebugSharedPrimitives.intFromHexString(array[i].getDataInfo().getHexValue());
                    magnitude[i * 4] = (byte)(i4 >> 24 & 0xFF);
                    magnitude[i * 4 + 1] = (byte)(i4 >> 16 & 0xFF);
                    magnitude[i * 4 + 2] = (byte)(i4 >> 8 & 0xFF);
                    magnitude[i * 4 + 3] = (byte)(i4 & 0xFF);
                }
                return new BigInteger(signum, magnitude);
            }
            byte[] magnitude = DebugShared.getByteArrayField(data, "magnitude");
            if (magnitude != null) {
                return new BigInteger(signum, magnitude);
            }
        }
        return null;
    }

    private static Long findDateFastTime(DebugDataObjectInfo data) {
        DebugDataObjectInfo calData = (DebugDataObjectInfo)DebugShared.findFieldData(data, "cal", "java.util.Calendar");
        DebugDataInfo fastTimeData = DebugShared.findFieldData(data, "fastTime", "long");
        if (calData != null && fastTimeData != null && calData.isNull()) {
            long fastTime = DebugSharedPrimitives.longFromHexString(fastTimeData.getHexValue());
            return new Long(fastTime);
        }
        return null;
    }

    private static String urlToString(DebugDataObjectInfo url) {
        DebugDataCompositeInfo p = (DebugDataCompositeInfo)DebugShared.findFieldData(url, "protocol", "java.lang.String", "java.net.URL");
        DebugDataCompositeInfo a = (DebugDataCompositeInfo)DebugShared.findFieldData(url, "authority", "java.lang.String", "java.net.URL");
        DebugDataCompositeInfo f = (DebugDataCompositeInfo)DebugShared.findFieldData(url, "file", "java.lang.String", "java.net.URL");
        DebugDataCompositeInfo r = (DebugDataCompositeInfo)DebugShared.findFieldData(url, "ref", "java.lang.String", "java.net.URL");
        if (p != null && a != null && f != null && r != null) {
            String protocol = (String)p.getWholeThing();
            String authority = (String)a.getWholeThing();
            String file = (String)f.getWholeThing();
            String ref = (String)r.getWholeThing();
            FastStringBuffer result = new FastStringBuffer(protocol);
            result.append(":");
            if (authority != null && authority.length() > 0) {
                result.append("//");
                result.append(authority);
            }
            if (file != null) {
                result.append(file);
            }
            if (ref != null) {
                result.append("#");
                result.append(ref);
            }
            return result.toString();
        }
        return null;
    }

    private static boolean findNameInPackageList(String name, List v) {
        int namelength = name.length();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            String s = (String)v.get(i);
            int slength = s.length();
            if (!name.startsWith(s) || namelength != slength && name.charAt(slength) != '.') continue;
            return true;
        }
        return false;
    }

    public static boolean isClassOrPackageDebuggable(String name, List debuggable, List nonDebuggable) {
        if (debuggable.size() == 0 || DebugShared.findNameInPackageList(name, debuggable)) {
            return !DebugShared.findNameInPackageList(name, nonDebuggable);
        }
        return false;
    }

    public static DebugDataObjectInfo getContextClassLoaderObject(DebugThreadInfo thread) {
        DebugDataObjectInfo data;
        DebugDataObjectInfo threadObject = thread.getThreadObject();
        if (threadObject != null && !threadObject.isNull() && (data = (DebugDataObjectInfo)DebugShared.findFieldData(threadObject, "contextClassLoader", "java.lang.ClassLoader", "java.lang.Thread")) != null) {
            return data;
        }
        return null;
    }

    public static DebugDataObjectInfo getParentClassLoaderObject(DebugDataObjectInfo dataClassLoaderObject) {
        DebugDataObjectInfo data = (DebugDataObjectInfo)DebugShared.findFieldData(dataClassLoaderObject, "parent", "java.lang.ClassLoader", "java.lang.ClassLoader");
        if (data != null) {
            return data;
        }
        return null;
    }

    public static DebugDataObjectInfo getSystemClassLoaderObject(DebugClassInfo classLoaderClass) {
        DebugDataObjectInfo data = (DebugDataObjectInfo)DebugShared.findStaticFieldData(classLoaderClass, "scl", "java.lang.ClassLoader");
        if (data != null) {
            return data;
        }
        return null;
    }

    public static void exploreClassLoaderParents(DebugClassLoaderInfo classLoader) {
        while (classLoader != null) {
            classLoader = classLoader.getParent();
        }
    }

    public static DebugConnectArg findConnectArg(DebugConnectArg[] connectArgs, String name) {
        for (DebugConnectArg connectArg : connectArgs) {
            if (!connectArg.getName().equals(name)) continue;
            return connectArg;
        }
        return null;
    }

    public static synchronized String getDefaultConnectArgValue(int factory, String name) {
        if (defaultConnectArgValues == null) {
            defaultConnectArgValues = new HashMap();
            defaultConnectArgValues.put("hostname", "");
            defaultConnectArgValues.put("port", "4000");
            defaultConnectArgValues.put("timeout", "2");
        }
        if (factory == 1 && name.equals("timeout")) {
            return "0";
        }
        return (String)defaultConnectArgValues.get(name);
    }
}

