/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;

class DebugJDIBreakpoint
extends DebugSharedBreakpoint
implements DebugBreakpoint {
    DebugJDI dj;
    List requests;
    List locations;
    String name;
    boolean enabled;
    List instanceFilters;
    String threadname;
    String threadnameNot;
    DebugBreakpointCondition condition;
    int passCount;
    boolean stop;
    boolean log;
    String enableOtherBPs;
    String disableOtherBPs;
    int tempDisabled;

    DebugJDIBreakpoint(DebugJDI dj) {
        this.dj = dj;
        this.requests = new ArrayList();
        this.locations = new ArrayList();
        this.stop = true;
        this.enabled = true;
        this.instanceFilters = new ArrayList();
        this.passCount = 1;
    }

    @Override
    public void remove() {
        this.prepareForChange();
        if (this.dj != null) {
            this.dj.removeBreakpoint(this);
        }
    }

    @Override
    public String getThreadname() {
        return this.threadname;
    }

    @Override
    public void setThreadname(String threadname) {
        if (threadname != null && threadname.length() == 0) {
            threadname = null;
        }
        this.threadname = threadname;
        if (threadname != null && this.threadnameNot != null) {
            this.threadnameNot = null;
        }
    }

    @Override
    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    @Override
    public void setThreadnameNot(String threadnameNot) {
        if (threadnameNot != null && threadnameNot.length() == 0) {
            threadnameNot = null;
        }
        this.threadnameNot = threadnameNot;
        if (threadnameNot != null && this.threadname != null) {
            this.threadname = null;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.prepareForChange();
            this.enabled = enabled;
            int size = this.requests.size();
            for (int i = 0; i < size; ++i) {
                EventRequest er = (EventRequest)this.requests.get(i);
                er.setEnabled(enabled);
            }
            this.afterChange();
        }
    }

    @Override
    public boolean getStop() {
        return this.stop;
    }

    @Override
    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public boolean getLog() {
        return this.log;
    }

    @Override
    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    @Override
    public void setEnableOtherBPs(String enableOtherBPs) {
        this.enableOtherBPs = enableOtherBPs;
    }

    @Override
    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    @Override
    public void setDisableOtherBPs(String disableOtherBPs) {
        this.disableOtherBPs = disableOtherBPs;
    }

    @Override
    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(DebugBreakpointCondition condition) {
        this.condition = condition;
    }

    @Override
    public int getPassCount() {
        return this.passCount;
    }

    @Override
    public void setPassCount(int passCount) {
        this.passCount = passCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstanceFilter(DebugDataObjectInfo data) {
        DebugJDIDataObjectInfo d = (DebugJDIDataObjectInfo)data;
        if (d.value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)d.value;
            List list = this.instanceFilters;
            synchronized (list) {
                if (!this.instanceFilters.contains(or)) {
                    this.instanceFilters.add(or);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstanceFilter(DebugDataObjectInfo data) {
        DebugJDIDataObjectInfo d = (DebugJDIDataObjectInfo)data;
        if (d.value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)d.value;
            List list = this.instanceFilters;
            synchronized (list) {
                this.instanceFilters.remove(or);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstanceFilter(long uniqueID) {
        List list = this.instanceFilters;
        synchronized (list) {
            for (ObjectReference or : this.instanceFilters) {
                if (or.uniqueID() != uniqueID) continue;
                this.instanceFilters.remove(or);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInstanceFilterSet(DebugDataObjectInfo data) {
        DebugJDIDataObjectInfo d = (DebugJDIDataObjectInfo)data;
        if (d.value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)d.value;
            List list = this.instanceFilters;
            synchronized (list) {
                if (this.instanceFilters.contains(or)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getInstanceFilters() {
        List list = this.instanceFilters;
        synchronized (list) {
            long[] array = new long[this.instanceFilters.size()];
            int i = 0;
            Iterator it = this.instanceFilters.iterator();
            while (it.hasNext()) {
                array[i++] = ((ObjectReference)it.next()).uniqueID();
            }
            return array;
        }
    }

    @Override
    public DebugLocation[] getLocations() {
        DebugLocation[] array = new DebugLocation[this.locations.size()];
        return this.locations.toArray(array);
    }

    protected void setOptions(EventRequest er) {
        er.setSuspendPolicy(2);
        if (this.tempDisabled == 0) {
            er.setEnabled(this.enabled);
        }
    }

    private boolean threadMatches(ThreadReference tr) {
        if (this.threadname != null) {
            return this.threadname.equals(tr.name());
        }
        if (this.threadnameNot != null) {
            return !this.threadnameNot.equals(tr.name());
        }
        return true;
    }

    private boolean conditionSatisfied(Event e, ThreadReference tr) {
        boolean result = true;
        if (this.condition != null) {
            this.dj.incrementStoppedCount(false);
            DebugJDIThreadInfo thread = DebugJDIThreadInfo.makeThreadInfo(this.dj, tr);
            DebugStackFrameInfo[] stack = thread.listStack();
            result = this.condition.checkBreakpointCondition(this, this.dj, thread, stack);
            this.dj.incrementStoppedCount(false);
        }
        return result;
    }

    private boolean checkPassCount() {
        if (this.passCount > 0) {
            --this.passCount;
            if (this.dj.debugListener != null) {
                this.dj.debugListener.breakpointChanged(this);
            }
        }
        return this.passCount == 0;
    }

    protected ObjectReference getInstanceForEvent(Event e, ThreadReference tr) {
        if (e instanceof BreakpointEvent) {
            try {
                return tr.frame(0).thisObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean checkConditions(Event e, ThreadReference tr) {
        ObjectReference or;
        if (!this.instanceFilters.isEmpty() && (or = this.getInstanceForEvent(e, tr)) != null && !this.instanceFilters.contains(or)) {
            return false;
        }
        if (!this.threadMatches(tr)) {
            return false;
        }
        if (!this.conditionSatisfied(e, tr)) {
            return false;
        }
        return this.checkPassCount();
    }

    boolean isThisYourEvent(Event e, ThreadReference tr) {
        if (this.enabled) {
            EventRequest er = e.request();
            int size = this.requests.size();
            for (int i = 0; i < size; ++i) {
                if (!this.requests.get(i).equals(er)) continue;
                return this.checkConditions(e, tr);
            }
        }
        return false;
    }

    void prepareForChange() {
        this.dj.breakpointBeforeChange(this);
        int size = this.requests.size();
        for (int i = 0; i < size; ++i) {
            EventRequest er = (EventRequest)this.requests.get(i);
            er.disable();
            this.dj.erm.deleteEventRequest(er);
        }
        this.clearRequests();
        this.locations.clear();
    }

    void afterChange() {
        this.dj.breakpointAfterChange(this);
    }

    String getClassPrepareFilter() {
        return null;
    }

    void redefiningClass(ReferenceType rt) {
        int i;
        for (i = this.locations.size() - 1; i >= 0; --i) {
            DebugLocation loc = (DebugLocation)this.locations.get(i);
            DebugJDIClassInfo clazz = (DebugJDIClassInfo)loc.getClassInfo();
            if (clazz.getReferenceType() != rt) continue;
            this.locations.remove(i);
        }
        for (i = this.requests.size() - 1; i >= 0; --i) {
            BreakpointRequest br;
            Location location;
            EventRequest er = (EventRequest)this.requests.get(i);
            if (!(er instanceof BreakpointRequest) || (location = (br = (BreakpointRequest)er).location()).declaringType() != rt) continue;
            br.disable();
            this.dj.erm.deleteEventRequest(br);
            this.removeRequest(er);
        }
    }

    boolean verify(ReferenceType rt) {
        return false;
    }

    protected void locationIdentified(Location location) {
        DebugJDILocation loc = this.dj.makeLocation(location);
        if (loc != null) {
            this.locations.add(loc);
            BreakpointRequest er = this.dj.erm.createBreakpointRequest(location);
            this.setOptions(er);
            this.addRequest(er);
        }
    }

    protected final void addRequest(EventRequest er) {
        this.dj.addBPRequest(er);
        this.requests.add(er);
    }

    protected final void removeRequest(EventRequest er) {
        this.dj.removeBPRequest(er);
        this.requests.remove(er);
    }

    protected final void clearRequests() {
        for (int i = this.requests.size() - 1; i >= 0; --i) {
            this.dj.removeBPRequest((EventRequest)this.requests.get(i));
        }
        this.requests.clear();
    }

    void tempDisableRequests() {
        if (this.tempDisabled == 0) {
            int size = this.requests.size();
            for (int i = 0; i < size; ++i) {
                EventRequest er = (EventRequest)this.requests.get(i);
                er.disable();
            }
        }
        ++this.tempDisabled;
    }

    void tempReenableRequests() {
        --this.tempDisabled;
        if (this.tempDisabled == 0) {
            for (int i = this.requests.size() - 1; i >= 0; --i) {
                ReferenceType rt;
                EventRequest er = (EventRequest)this.requests.get(i);
                boolean collected = false;
                if (er instanceof BreakpointRequest) {
                    BreakpointRequest br = (BreakpointRequest)er;
                    rt = br.location().declaringType();
                    collected = this.dj.isClassCollected(rt);
                } else if (er instanceof ExceptionRequest) {
                    ExceptionRequest xr = (ExceptionRequest)er;
                    rt = xr.exception();
                    collected = this.dj.isClassCollected(rt);
                }
                if (collected) {
                    this.removeRequest(er);
                    continue;
                }
                er.setEnabled(this.enabled);
            }
        }
    }

    @Override
    public void setBreakpoint() {
    }

    @Override
    public void changeBreakpoint() {
    }
}

