/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxFileLineBreakpoint;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnector;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptStackFrameInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.Command;
import oracle.jdevimpl.debugger.javascript.event.CommandGroup;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxClearAllBreakpoints;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxDetachRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEnableDebugStatementRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEnableRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxErrorMessagesRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEvaluateExpression;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxExceptionsRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxFetchFramesRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxGarbageCollectRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxGetPropertiesRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxGetSourceRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxGetVersionRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxInitDoneRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxJavaScriptStepRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxLineBreakpointRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxLoadUrl;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxPinObjectRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRemoveBreakpointRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxResumeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxScriptRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxStopInChromeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxStopOnErrorRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxSuspendRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxTerminateRequest;

public class MozillaFireFoxRequestManager {
    private DebugMozillaFireFoxJavaScriptTransport transport;
    private DebugMozillaFireFoxJavaScriptConnector connector;
    private Map<Integer, MozillaFireFoxRequest> requestId2RequestMap = new HashMap<Integer, MozillaFireFoxRequest>();
    private MozillaFireFoxScriptRequest oldScriptRequest = null;
    private MozillaFireFoxErrorMessagesRequest oldErrorMessageRequest = null;
    private MozillaFireFoxEnableDebugStatementRequest oldDebugStatementRequest = null;
    private MozillaFireFoxExceptionsRequest oldExceptionRequest = null;
    private MozillaFireFoxStopOnErrorRequest oldStopOnErrorRequest = null;

    public MozillaFireFoxRequestManager(DebugMozillaFireFoxJavaScriptTransport transport, DebugMozillaFireFoxJavaScriptConnector connector) {
        this.transport = transport;
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSynchRequest(MozillaFireFoxRequest request) {
        MozillaFireFoxRequest mozillaFireFoxRequest = request;
        synchronized (mozillaFireFoxRequest) {
            assert (!request.isSent()) : "Trying to send a MozillaFireFoxRequest second time!";
            request.setSyncRequest(true);
            this.sendAsynchRequest(request);
            try {
                request.wait(3000L);
                if (!request.isResponded()) {
                    System.out.println("Timeout! Response didn't come within HANDSHAKE_TIMEOUT time!");
                    request.setResponded(true);
                }
            }
            catch (InterruptedException e) {
                this.transport.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAsynchRequest(MozillaFireFoxRequest request) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            request.setSent();
            this.requestId2RequestMap.put(new Integer(request.getRequestId()), request);
            this.writePacketHeader(request);
            this.writePacketSpecifics(request);
            this.transport.flush();
        }
    }

    private void writePacketHeader(MozillaFireFoxRequest request) {
        this.transport.sendByte(request.getCommandGroup().getCommandGroupForWire());
        this.transport.sendByte(request.getCommand().getCommandForWire());
        this.transport.sendInteger(request.getRequestId());
        this.transport.sendByte(request.isEnabled() ? (byte)1 : 0);
        this.transport.sendByte(request.isOneTimeRequest() ? (byte)1 : 0);
    }

    private void writePacketSpecificGenericGroup(MozillaFireFoxRequest request) {
        request.writeSpecificBytes(this.transport);
    }

    private void writePacketSpecifics(MozillaFireFoxRequest request) {
        switch (request.getCommandGroup()) {
            case GENERIC: {
                this.writePacketSpecificGenericGroup(request);
                break;
            }
            default: {
                assert (false) : "Unexpected command group!";
                break;
            }
        }
    }

    public MozillaFireFoxRequest getRequestFromRequestId(int reqId) {
        MozillaFireFoxRequest ret = this.requestId2RequestMap.get(new Integer(reqId));
        assert (ret != null) : "No request in requestId2RequestMap. for reqId = " + reqId;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect(boolean fromShutDown) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            for (MozillaFireFoxRequest request : this.requestId2RequestMap.values()) {
                if (request == null) continue;
                MozillaFireFoxRequest mozillaFireFoxRequest = request;
                synchronized (mozillaFireFoxRequest) {
                    request.notifyAll();
                }
            }
        }
        this.connector.disconnect(fromShutDown);
    }

    public MozillaFireFoxGetVersionRequest createGetVersionRequest() {
        return new MozillaFireFoxGetVersionRequest(this, CommandGroup.GENERIC, Command.GET_VERSION);
    }

    public MozillaFireFoxTerminateRequest createTerminateRequest() {
        return new MozillaFireFoxTerminateRequest(this, CommandGroup.GENERIC, Command.TERMINATE);
    }

    public MozillaFireFoxDetachRequest createDetachRequest() {
        return new MozillaFireFoxDetachRequest(this, CommandGroup.GENERIC, Command.DETACH);
    }

    public MozillaFireFoxSuspendRequest createSuspendRequest() {
        return new MozillaFireFoxSuspendRequest(this, CommandGroup.GENERIC, Command.SUSPEND);
    }

    public MozillaFireFoxResumeRequest createResumeRequest() {
        return new MozillaFireFoxResumeRequest(this, CommandGroup.GENERIC, Command.RESUME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MozillaFireFoxEnableDebugStatementRequest createEnableDebugStatementRequest(boolean enableDebugStatement) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            Iterator<MozillaFireFoxRequest> values;
            if (this.requestId2RequestMap != null && (values = this.requestId2RequestMap.values().iterator()) != null) {
                while (values.hasNext()) {
                    MozillaFireFoxRequest next = values.next();
                    if (next == null || !(next instanceof MozillaFireFoxEnableDebugStatementRequest)) continue;
                    this.oldDebugStatementRequest = (MozillaFireFoxEnableDebugStatementRequest)next;
                    break;
                }
            }
        }
        MozillaFireFoxEnableDebugStatementRequest ret = new MozillaFireFoxEnableDebugStatementRequest(this, CommandGroup.GENERIC, Command.ENABLE_DEBUG_STATEMENT, enableDebugStatement);
        return ret;
    }

    public MozillaFireFoxInitDoneRequest createInitDoneRequest() {
        return new MozillaFireFoxInitDoneRequest(this, CommandGroup.GENERIC, Command.INIT_DONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MozillaFireFoxErrorMessagesRequest createErrorMessagesRequest(boolean enable) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            Iterator<MozillaFireFoxRequest> values;
            if (this.requestId2RequestMap != null && (values = this.requestId2RequestMap.values().iterator()) != null) {
                while (values.hasNext()) {
                    MozillaFireFoxRequest next = values.next();
                    if (next == null || !(next instanceof MozillaFireFoxErrorMessagesRequest)) continue;
                    this.oldErrorMessageRequest = (MozillaFireFoxErrorMessagesRequest)next;
                    break;
                }
            }
        }
        return new MozillaFireFoxErrorMessagesRequest(this, CommandGroup.GENERIC, Command.REQUEST_ERRORS, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MozillaFireFoxScriptRequest createScriptMessagesRequest(boolean enable) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            Iterator<MozillaFireFoxRequest> values;
            if (this.requestId2RequestMap != null && (values = this.requestId2RequestMap.values().iterator()) != null) {
                while (values.hasNext()) {
                    MozillaFireFoxRequest next = values.next();
                    if (next == null || !(next instanceof MozillaFireFoxScriptRequest)) continue;
                    this.oldScriptRequest = (MozillaFireFoxScriptRequest)next;
                    break;
                }
            }
        }
        return new MozillaFireFoxScriptRequest(this, CommandGroup.GENERIC, Command.SCRIPT_REQUEST, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MozillaFireFoxExceptionsRequest createExceptionsRequest(boolean enable) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            Iterator<MozillaFireFoxRequest> values;
            if (this.requestId2RequestMap != null && (values = this.requestId2RequestMap.values().iterator()) != null) {
                while (values.hasNext()) {
                    MozillaFireFoxRequest next = values.next();
                    if (next == null || !(next instanceof MozillaFireFoxExceptionsRequest)) continue;
                    this.oldExceptionRequest = (MozillaFireFoxExceptionsRequest)next;
                    break;
                }
            }
        }
        return new MozillaFireFoxExceptionsRequest(this, CommandGroup.GENERIC, Command.EXCEPTION_REQUEST, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MozillaFireFoxStopOnErrorRequest createStopOnErrorRequest(boolean enable) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            Iterator<MozillaFireFoxRequest> values;
            if (this.requestId2RequestMap != null && (values = this.requestId2RequestMap.values().iterator()) != null) {
                while (values.hasNext()) {
                    MozillaFireFoxRequest next = values.next();
                    if (next == null || !(next instanceof MozillaFireFoxStopOnErrorRequest)) continue;
                    this.oldStopOnErrorRequest = (MozillaFireFoxStopOnErrorRequest)next;
                    break;
                }
            }
        }
        return new MozillaFireFoxStopOnErrorRequest(this, CommandGroup.GENERIC, Command.STOP_ON_ERROR, enable);
    }

    public MozillaFireFoxLineBreakpointRequest createLineBreakpointRequest(DebugMozillaFireFoxFileLineBreakpoint breakpoint) {
        return new MozillaFireFoxLineBreakpointRequest(this, CommandGroup.GENERIC, Command.BREAKPOINT_LINE_REQUEST, breakpoint);
    }

    public MozillaFireFoxFetchFramesRequest createFetchStackFrames() {
        return new MozillaFireFoxFetchFramesRequest(this, CommandGroup.GENERIC, Command.FETCH_STACK_FRAMES);
    }

    public MozillaFireFoxJavaScriptStepRequest createStepRequest(byte stepType) {
        return new MozillaFireFoxJavaScriptStepRequest(this, CommandGroup.GENERIC, Command.STEP, stepType);
    }

    public MozillaFireFoxGetPropertiesRequest createGetPropertiesRequest(long address) {
        return new MozillaFireFoxGetPropertiesRequest(this, CommandGroup.GENERIC, Command.GET_PROPERTIES, address);
    }

    public MozillaFireFoxEnableRequest createEnableRequest(int reqId) {
        return new MozillaFireFoxEnableRequest(this, CommandGroup.GENERIC, Command.ENABLE_REQUEST, reqId);
    }

    public MozillaFireFoxRemoveBreakpointRequest createRemoveBreakpointRequest(int reqId) {
        return new MozillaFireFoxRemoveBreakpointRequest(this, CommandGroup.GENERIC, Command.REMOVE_BREAKPOINT, reqId);
    }

    public MozillaFireFoxClearAllBreakpoints createClearAllBreakpoints() {
        return new MozillaFireFoxClearAllBreakpoints(this, CommandGroup.GENERIC, Command.CLEAR_ALL_BREAKPOINTS);
    }

    public MozillaFireFoxGetSourceRequest createGetSourceRequest(String sourceName, int scriptPointer) {
        return new MozillaFireFoxGetSourceRequest(this, CommandGroup.GENERIC, Command.GET_SOURCE, sourceName, scriptPointer);
    }

    public MozillaFireFoxLoadUrl createLoadUrlRequest(String url) {
        return new MozillaFireFoxLoadUrl(this, CommandGroup.GENERIC, Command.LOAD_URL, url);
    }

    public MozillaFireFoxEvaluateExpression createEvaluateExpressionRequest(String expression, long timeout, DebugMozillaFireFoxJavaScriptStackFrameInfo si, long valueId) {
        return new MozillaFireFoxEvaluateExpression(this, CommandGroup.GENERIC, Command.EVALUATE_EXPRESSION, expression, timeout, si, valueId);
    }

    public MozillaFireFoxGarbageCollectRequest createGarbageRequest() {
        return new MozillaFireFoxGarbageCollectRequest(this, CommandGroup.GENERIC, Command.GARBAGE_COLLECT);
    }

    public MozillaFireFoxPinObjectRequest createPinObjectRequest(boolean pin, long valueId) {
        return new MozillaFireFoxPinObjectRequest(this, CommandGroup.GENERIC, Command.PIN_OBJECT, pin, valueId);
    }

    public MozillaFireFoxStopInChromeRequest createStopInChromeRequest(boolean stopInChrome) {
        return new MozillaFireFoxStopInChromeRequest(this, CommandGroup.GENERIC, Command.STOP_IN_CHROME, stopInChrome);
    }

    public DebugMozillaFireFoxJavaScript getDebugger() {
        return this.connector.getDebugger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(MozillaFireFoxRequest req) {
        MozillaFireFoxRequestManager mozillaFireFoxRequestManager = this;
        synchronized (mozillaFireFoxRequestManager) {
            if (req != null) {
                int reqId = req.getRequestId();
                this.requestId2RequestMap.remove(new Integer(reqId));
                MozillaFireFoxRequest.releaseId(reqId);
            }
        }
    }

    public void scriptEvent() {
        if (this.oldScriptRequest != null) {
            this.removeRequest(this.oldScriptRequest);
        }
        this.oldScriptRequest = null;
    }

    public void errorsEvent() {
        if (this.oldErrorMessageRequest != null) {
            this.removeRequest(this.oldErrorMessageRequest);
        }
        this.oldErrorMessageRequest = null;
    }

    public void debugStatementEvent() {
        if (this.oldDebugStatementRequest != null) {
            this.removeRequest(this.oldDebugStatementRequest);
        }
        this.oldDebugStatementRequest = null;
    }

    public void exceptionEvent() {
        if (this.oldExceptionRequest != null) {
            this.removeRequest(this.oldExceptionRequest);
        }
        this.oldExceptionRequest = null;
    }

    public void stopOnErrorEvent() {
        if (this.oldStopOnErrorRequest != null) {
            this.removeRequest(this.oldStopOnErrorRequest);
        }
        this.oldStopOnErrorRequest = null;
    }

    DebugMozillaFireFoxJavaScriptTransport getTransport() {
        return this.transport;
    }
}

