/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import java.util.HashSet;
import java.util.Set;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.Command;
import oracle.jdevimpl.debugger.javascript.event.CommandGroup;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;

public abstract class MozillaFireFoxRequest {
    private static int nextId = 0;
    private static Object idFinderLock = new Object();
    private static Set<Integer> givenIds = new HashSet<Integer>();
    private int requestId = 0;
    private MozillaFireFoxRequestManager requestManager;
    private boolean enabled;
    private boolean synchRequest;
    private boolean sent;
    private CommandGroup commandGroup;
    private Command command;
    private boolean responded;

    MozillaFireFoxRequest(MozillaFireFoxRequestManager requestManager, CommandGroup commandGroup, Command command) {
        MozillaFireFoxRequest.assignRequestId(this);
        this.requestManager = requestManager;
        this.commandGroup = commandGroup;
        this.command = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assignRequestId(MozillaFireFoxRequest request) {
        Object object = idFinderLock;
        synchronized (object) {
            while (givenIds.contains(new Integer(nextId))) {
                ++nextId;
            }
            request.requestId = nextId++;
            givenIds.add(new Integer(request.requestId));
        }
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void sendAsyncRequest() {
        try {
            this.requestManager.sendAsynchRequest(this);
        }
        catch (Throwable t) {
            this.requestManager.disconnect(false);
        }
    }

    public void sendSyncRequest() {
        try {
            this.requestManager.sendSynchRequest(this);
        }
        catch (Throwable t) {
            this.requestManager.disconnect(false);
        }
    }

    abstract boolean isOneTimeRequest();

    abstract void writeSpecificBytes(DebugMozillaFireFoxJavaScriptTransport var1);

    protected void readResponse(DebugMozillaFireFoxJavaScriptTransport transport) {
        this.setResponded(true);
    }

    public CommandGroup getCommandGroup() {
        return this.commandGroup;
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isSyncRequest() {
        return this.synchRequest;
    }

    public void setSyncRequest(boolean synched) {
        this.synchRequest = synched;
    }

    boolean isSent() {
        return this.sent;
    }

    void setSent() {
        this.sent = true;
    }

    boolean isResponded() {
        return this.responded;
    }

    void setResponded(boolean resp) {
        this.responded = resp;
    }

    public MozillaFireFoxRequestManager getRequestManager() {
        return this.requestManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseId(int reqId) {
        Object object = idFinderLock;
        synchronized (object) {
            givenIds.remove(new Integer(reqId));
        }
    }

    static {
        givenIds.add(new Integer(-1));
    }
}

