/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript.event;

import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptTransport;
import oracle.jdevimpl.debugger.javascript.event.Command;
import oracle.jdevimpl.debugger.javascript.event.CommandGroup;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxOneTimeRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxRequestManager;

public class MozillaFireFoxGetSourceRequest
extends MozillaFireFoxOneTimeRequest {
    private String sourceName = null;
    private int scriptPointer = 0;
    private String source = null;
    private boolean isFunctionSource;

    MozillaFireFoxGetSourceRequest(MozillaFireFoxRequestManager requestManager, CommandGroup commandGroup, Command command, String sourceName, int scriptPointer) {
        super(requestManager, commandGroup, command);
        this.sourceName = sourceName;
        this.scriptPointer = scriptPointer;
    }

    @Override
    void writeSpecificBytes(DebugMozillaFireFoxJavaScriptTransport transport) {
        transport.sendInteger(this.scriptPointer);
        transport.sendString(this.sourceName);
    }

    @Override
    protected void readResponse(DebugMozillaFireFoxJavaScriptTransport transport) {
        super.readResponse(transport);
        this.isFunctionSource = transport.receiveBoolean();
        this.source = !this.isFunctionSource ? transport.receiveString() : transport.receiveUTF16String();
    }

    public String getSource() {
        return this.source;
    }

    public boolean isFunctionSource() {
        return this.isFunctionSource;
    }
}

