/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.util.ArrayList;
import java.util.List;
import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptStackFrameInfo;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxFetchFramesRequest;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

public class DebugMozillaFireFoxThreadInfo
implements DebugThreadInfo {
    DebugThreadGroupInfo parent;
    DebugMozillaFireFoxJavaScript debugger;
    private ArrayList<DebugStackFrameInfo> frames;
    private boolean expiredInfo = false;

    public DebugMozillaFireFoxThreadInfo(DebugThreadGroupInfo parent, DebugMozillaFireFoxJavaScript debugger) {
        this.parent = parent;
        this.debugger = debugger;
    }

    @Override
    public boolean hasExited() {
        return false;
    }

    @Override
    public long getThreadId() {
        return 0L;
    }

    @Override
    public String getName() {
        return DebugJavaScriptArb.getString(9);
    }

    @Override
    public String getGroupName() {
        return this.parent == null ? null : this.parent.getName();
    }

    @Override
    public DebugThreadGroupInfo getThreadGroup() {
        return this.parent;
    }

    @Override
    public int getStatus() {
        return 5;
    }

    @Override
    public boolean isThreadSuspended() {
        return this.debugger.isStopped();
    }

    @Override
    public void suspendThread() {
        this.debugger.pauseProgram();
    }

    @Override
    public void resumeThread() {
        this.debugger.resume();
    }

    @Override
    public void interruptThread() {
    }

    @Override
    public void stopThread() {
    }

    @Override
    public DebugDataObjectInfo getThreadObject() {
        return null;
    }

    @Override
    public void stepInto() {
        this.debugger.stepInto();
    }

    @Override
    public void stepOver() {
        this.debugger.stepOver();
    }

    @Override
    public void stepIntoBC() {
        this.stepInto();
    }

    @Override
    public void stepOverBC() {
        this.stepOver();
    }

    @Override
    public void stepOut() {
        this.debugger.stepOut();
    }

    @Override
    public boolean isAtEndOfMethod() {
        return false;
    }

    @Override
    public void stepToEndOfMethod() {
    }

    @Override
    public void stepIntoMethod(String methodName, String callerPackage, String callerFileName, int callerLine) {
    }

    @Override
    public int getStackFrameCount() {
        this.fillStackFrames();
        return this.frames.size();
    }

    @Override
    public DebugStackFrameInfo getStackFrame(int frame) {
        this.fillStackFrames();
        if (frame >= this.frames.size()) {
            return null;
        }
        return this.frames.get(frame);
    }

    @Override
    public DebugStackFrameInfo[] listStack() {
        this.fillStackFrames();
        return this.frames.toArray(new DebugMozillaFireFoxJavaScriptStackFrameInfo[this.frames.size()]);
    }

    @Override
    public DebugMonitorInfo[] listOwnedMonitors() {
        return new DebugMonitorInfo[0];
    }

    @Override
    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        return null;
    }

    @Override
    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        return null;
    }

    @Override
    public DebugRegisterInfo[] listRegisters() {
        return new DebugRegisterInfo[0];
    }

    @Override
    public DebugRegisterInfo[] listFloatRegisters() {
        return new DebugRegisterInfo[0];
    }

    @Override
    public DebugVariableInfo getReturnValue() {
        return null;
    }

    @Override
    public DebugVariableInfo getReturnedValue() {
        return null;
    }

    @Override
    public boolean setLocation(DebugLocation location) {
        return false;
    }

    @Override
    public DebugDataObjectInfo getContextClassLoaderObject() {
        return null;
    }

    @Override
    public DebugClassLoaderInfo getContextClassLoader() {
        return null;
    }

    @Override
    public boolean isThreadInterrupted() {
        return false;
    }

    @Override
    public boolean isThreadDebuggerStopped() {
        return false;
    }

    @Override
    public boolean canDebuggerStopThread() {
        return false;
    }

    private void fillStackFrames() {
        assert (this.debugger != null) : "Debugger can't be null";
        assert (this.debugger.isStopped()) : "Debugger must be stopped when asking for call stack!";
        if (!this.expiredInfo && this.frames != null) {
            return;
        }
        this.expiredInfo = false;
        MozillaFireFoxFetchFramesRequest mfffsf = this.debugger.getRequestManager().createFetchStackFrames();
        mfffsf.setEnabled(true);
        mfffsf.sendSyncRequest();
        this.frames = new ArrayList();
        List<MozillaFireFoxFetchFramesRequest.StackFrameInfo> internalSFs = mfffsf.getStackFrames();
        if (internalSFs != null) {
            for (int i = 0; i < internalSFs.size(); ++i) {
                this.frames.add(new DebugMozillaFireFoxJavaScriptStackFrameInfo(i, internalSFs.get(i), this.debugger));
            }
        }
    }

    public void invalidate() {
        this.expiredInfo = true;
        this.frames = null;
    }

    void setExpired(boolean b) {
        this.expiredInfo = b;
        this.invalidate();
    }
}

