/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxDataInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptPinnedInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptStackFrameInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxProperty;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxGetPropertiesRequest;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;

public class DebugMozillaFireFoxDataObjectInfo
extends DebugMozillaFireFoxDataInfo
implements DebugDataObjectInfo {
    private long address;
    private long uniqueId;
    private List<DebugMozillaFireFoxProperty> properties;
    private Map<String, DebugMozillaFireFoxProperty> propertiesNameMap = null;
    private DebugMozillaFireFoxJavaScript debugger;

    DebugMozillaFireFoxDataObjectInfo(String name, String value, int type, DebugMozillaFireFoxJavaScript debugger, DebugClassInfo classInfo, long address, long uniqueId, DebugMozillaFireFoxJavaScriptStackFrameInfo stackFrameInfo, DebugMozillaFireFoxDataInfo parent, long valueId) {
        super(name, value, type, classInfo, debugger, stackFrameInfo, parent, valueId);
        this.address = address;
        this.uniqueId = uniqueId;
        this.debugger = debugger;
    }

    @Override
    public int getFieldCount(int classLevel) {
        this.fillProperties();
        return this.properties.size();
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel) {
        this.fillProperties();
        return this.properties.toArray(new DebugMozillaFireFoxProperty[this.properties.size()]);
    }

    @Override
    public DebugFieldInfo getField(int classLevel, int index) {
        this.fillProperties();
        return this.properties.get(index);
    }

    @Override
    public int getFieldCount(int classLevel, boolean noFinal) {
        this.fillProperties();
        return this.properties.size();
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        this.fillProperties();
        return this.properties.toArray(new DebugMozillaFireFoxProperty[this.properties.size()]);
    }

    @Override
    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        this.fillProperties();
        return this.properties.get(index);
    }

    @Override
    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        this.fillProperties();
        return this.properties.size();
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        this.fillProperties();
        return this.properties.toArray(new DebugMozillaFireFoxProperty[this.properties.size()]);
    }

    @Override
    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        this.fillProperties();
        return this.properties.get(index);
    }

    @Override
    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly) {
        this.fillProperties();
        return this.properties.size();
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly) {
        this.fillProperties();
        return this.properties.toArray(new DebugMozillaFireFoxProperty[this.properties.size()]);
    }

    @Override
    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly, int index) {
        this.fillProperties();
        return this.properties.get(index);
    }

    @Override
    public boolean canGetFieldByName() {
        return true;
    }

    @Override
    public DebugFieldInfo getField(String name) {
        return this.propertiesNameMap.get(name);
    }

    @Override
    public DebugFieldInfo getField(String name, DebugClassInfo declaringClass) {
        return this.propertiesNameMap.get(name);
    }

    @Override
    public boolean isNull() {
        return this.getValue() == null;
    }

    @Override
    public long getAddressOfObject() {
        return this.address;
    }

    @Override
    public boolean canSetAddressOfObject() {
        return false;
    }

    @Override
    public boolean canSetAddressOfObjectToNull() {
        return false;
    }

    @Override
    public boolean setAddressOfObject(long address) {
        return false;
    }

    @Override
    public DebugPinnedInfo pinObject(DebugPinListener pinListener) {
        return new DebugMozillaFireFoxJavaScriptPinnedInfo(this.debugger, this, pinListener);
    }

    @Override
    public long getUniqueID() {
        return this.uniqueId;
    }

    @Override
    public String getCourtesyValue() {
        return this.getValue();
    }

    @Override
    public boolean canGetWholeThing() {
        return true;
    }

    @Override
    public Object getWholeThing() {
        return this.getValue();
    }

    @Override
    public DebugMonitorInfo getMonitor() {
        return null;
    }

    @Override
    public void setExpired(boolean expired) {
        super.setExpired(expired);
        if (this.properties != null) {
            Iterator<DebugMozillaFireFoxProperty> iter = this.properties.iterator();
            while (iter.hasNext()) {
                iter.next().setExpired(expired);
            }
        }
        if (expired) {
            this.properties = null;
            this.propertiesNameMap = null;
        }
    }

    private void fillProperties() {
        if (this.properties != null) {
            return;
        }
        MozillaFireFoxGetPropertiesRequest pr = this.getDebugger().getRequestManager().createGetPropertiesRequest(this.address);
        pr.setEnabled(true);
        pr.sendSyncRequest();
        this.properties = new ArrayList<DebugMozillaFireFoxProperty>();
        this.propertiesNameMap = new HashMap<String, DebugMozillaFireFoxProperty>();
        List<MozillaFireFoxGetPropertiesRequest.PropertyInfo> props = pr.getProperties();
        if (props != null) {
            for (MozillaFireFoxGetPropertiesRequest.PropertyInfo pi : props) {
                DebugMozillaFireFoxProperty prop = new DebugMozillaFireFoxProperty(pi, this.debugger, this.stackFrameInfo, this);
                this.properties.add(prop);
                this.propertiesNameMap.put(prop.getName(), prop);
            }
        }
    }
}

