/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxFileLineBreakpoint;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxEnableRequest;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxLineBreakpointRequest;
import oracle.jdevimpl.debugger.shared.DebugSharedBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;

public abstract class DebugMozillaFireFoxBreakpoint
extends DebugSharedBreakpoint
implements DebugBreakpoint {
    DebugMozillaFireFoxJavaScript js;
    String name;
    boolean enabled;
    DebugBreakpointCondition condition;
    int passCount;
    boolean stop;
    boolean log;
    MozillaFireFoxLineBreakpointRequest bptRequest = null;

    DebugMozillaFireFoxBreakpoint(DebugMozillaFireFoxJavaScript js) {
        this.js = js;
        this.stop = true;
        this.enabled = true;
        this.passCount = 0;
    }

    @Override
    public void remove() {
        if (this.js != null) {
            this.js.removeBreakpoint(this);
        }
    }

    @Override
    public String getThreadname() {
        return null;
    }

    @Override
    public void setThreadname(String threadname) {
        if (threadname != null && threadname.length() == 0) {
            threadname = null;
        }
        if (threadname != null) {
            // empty if block
        }
    }

    @Override
    public String getThreadnameNot() {
        return null;
    }

    @Override
    public void setThreadnameNot(String threadnameNot) {
        if (threadnameNot != null && threadnameNot.length() == 0) {
            threadnameNot = null;
        }
        if (threadnameNot != null) {
            // empty if block
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        MozillaFireFoxEnableRequest enableRequest = this.js.getRequestManager().createEnableRequest(this.bptRequest.getRequestId());
        enableRequest.setEnabled(enabled);
        enableRequest.sendSyncRequest();
    }

    @Override
    public boolean getStop() {
        return this.stop;
    }

    @Override
    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public boolean getLog() {
        return this.log;
    }

    @Override
    public void setLog(boolean log) {
        this.log = log;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getEnableOtherBPs() {
        return null;
    }

    @Override
    public void setEnableOtherBPs(String enableOtherBPs) {
    }

    @Override
    public String getDisableOtherBPs() {
        return null;
    }

    @Override
    public void setDisableOtherBPs(String disableOtherBPs) {
    }

    @Override
    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(DebugBreakpointCondition condition) {
        this.condition = condition;
    }

    @Override
    public int getPassCount() {
        return this.passCount;
    }

    @Override
    public void setPassCount(int passCount) {
        this.passCount = passCount;
    }

    @Override
    public void addInstanceFilter(DebugDataObjectInfo data) {
    }

    @Override
    public void removeInstanceFilter(DebugDataObjectInfo data) {
    }

    @Override
    public void removeInstanceFilter(long uniqueID) {
    }

    @Override
    public boolean isInstanceFilterSet(DebugDataObjectInfo data) {
        return false;
    }

    @Override
    public long[] getInstanceFilters() {
        long[] array = new long[]{};
        return array;
    }

    @Override
    public DebugLocation[] getLocations() {
        DebugLocation[] array = new DebugLocation[]{};
        return new DebugLocation[0];
    }

    private boolean checkPassCount() {
        if (this.passCount > 0) {
            --this.passCount;
        }
        return this.passCount == 0;
    }

    void prepareForChange() {
    }

    void afterChange() {
    }

    String getClassPrepareFilter() {
        return null;
    }

    public abstract boolean isSet();

    @Override
    public void setBreakpoint() {
        this.bptRequest = this.js.getRequestManager().createLineBreakpointRequest((DebugMozillaFireFoxFileLineBreakpoint)this);
        this.bptRequest.setEnabled(true);
        this.bptRequest.sendAsyncRequest();
    }

    @Override
    public void changeBreakpoint() {
        this.remove();
        this.setBreakpoint();
    }

    public MozillaFireFoxLineBreakpointRequest getRequest() {
        return this.bptRequest;
    }
}

