/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner.xslt;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.xslt.XSLTStarter;
import oracle.jdevimpl.runner.xslt.XSLTArb;
import oracle.jdevimpl.xml.JDevXmlIntegrationUtils;

public class XSLTStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private static final String XSL_SUFFIX = ".xsl";

    public String getName() {
        return XSLTArb.getString(0);
    }

    public Object canStart(RunProcess runProcess, Node node, List errors) {
        Object target;
        if (runProcess instanceof JRunProcess && (target = XSLTStarterFactory.findXSLTTarget(node, errors)) != null && runProcess.canRun("XSLT", null, node, errors)) {
            return target;
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object o) {
        return new XSLTStarter((JRunProcess)runProcess, (Node)o);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (JDevXmlIntegrationUtils.getInstance().isXmlSource(node)) {
            URL url = node.getURL();
            if (!url.getProtocol().equalsIgnoreCase("file")) {
                return false;
            }
            if (!JDevXmlIntegrationUtils.getInstance().isXSLT(node)) {
                return false;
            }
        }
        return super.enableRunDebugActions(context);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object o) {
        return new DefaultDisplayable(){

            public String getShortLabel() {
                return XSLTArb.getString(4);
            }

            public Icon getIcon() {
                return OracleIcons.getIcon((String)"xmlfile.png");
            }
        };
    }

    private static Object findXSLTTarget(Node node, List errors) {
        try {
            if (JDevXmlIntegrationUtils.getInstance().isXmlSource(node)) {
                String error = null;
                URL url = node.getURL();
                if (url.getProtocol().equalsIgnoreCase("file")) {
                    if (JDevXmlIntegrationUtils.getInstance().isXSLT(node)) {
                        return node;
                    }
                    error = XSLTArb.format(3, node.getShortLabel());
                } else {
                    error = JarUtil.isJarURL((URL)url) ? XSLTArb.format(2, node.getShortLabel()) : XSLTArb.format(1, node.getShortLabel());
                }
                if (error != null && URLFileSystem.hasSuffix((URL)url, (String)XSL_SUFFIX)) {
                    errors.add(error);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

