/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner.xslt;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.FilePath;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;
import oracle.jdevimpl.runner.xslt.XSLTPanel;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public class XSLTStarter
extends JStarter {
    private static final String ORA_COLLATION_JAR = "orai18n-collation.jar";
    private static final String EXTENSION_ID = "oracle.jdeveloper.runner";
    private Node target;
    private XSLTConfiguration xsltConfiguration;

    public XSLTStarter(JRunProcess jrunProcess, Node target) {
        super(jrunProcess, null);
        this.jrunProcess = jrunProcess;
        this.target = target;
        Project project = jrunProcess.getJProject();
        this.xsltConfiguration = XSLTConfiguration.getInstance((PropertyStorage)project);
    }

    public boolean start() {
        if (this.needToShowXSLTSettingsDialog() && !this.showXSLTSettingsDialog()) {
            return false;
        }
        return super.start();
    }

    protected boolean needToShowXSLTSettingsDialog() {
        URL inputFileURL = this.xsltConfiguration.getInputFileURL();
        URL outputFileURL = this.xsltConfiguration.getOutputFileURL();
        return inputFileURL == null || outputFileURL == null;
    }

    protected boolean showXSLTSettingsDialog() {
        return XSLTPanel.showXSLTDialog(this.jrunProcess.getJProject());
    }

    public File getStartDirectory() {
        URL targetDir;
        File startDir = super.getStartDirectory();
        if (startDir == null && (targetDir = URLFileSystem.getParent((URL)this.target.getURL())) != null) {
            startDir = new File(targetDir.getPath());
        }
        return startDir;
    }

    @Override
    public String[] getStartCommand() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.addJavaExecutableName(list)) {
            return null;
        }
        if (!this.addJavaVmOption(list)) {
            return null;
        }
        this.addClassPathOption(list);
        this.addBootClassPathOption(list);
        this.addJavaOptions(list);
        this.addFirstXSLTOptions(list);
        list.add("oracle.xml.parser.v2.oraxsl");
        String s = this.xsltConfiguration.getXSLTOptions();
        String[] a = IdeUtil.convertStringToStringArray((String)s, (boolean)true, (boolean)true);
        XSLTStarter.addArrayToList(list, a);
        this.addLastXSLTOptions(list);
        URL inputFileURL = this.xsltConfiguration.getInputFileURL();
        String inputFilename = URLFileSystem.getPlatformPathName((URL)inputFileURL);
        list.add(inputFilename);
        URL xslURL = this.target.getURL();
        String xslFilename = URLFileSystem.getPlatformPathName((URL)xslURL);
        list.add(xslFilename);
        URL outputFileURL = this.xsltConfiguration.getOutputFileURL();
        String outputFilename = URLFileSystem.getPlatformPathName((URL)outputFileURL);
        list.add(outputFilename);
        return list.toArray(new String[list.size()]);
    }

    @Override
    protected String getClassPath() {
        String cp = super.getClassPath();
        if (cp == null) {
            cp = "";
        } else if (cp.length() > 0) {
            cp = cp + File.pathSeparator;
        }
        FilePath fp = new FilePath();
        File xmlparserv2 = XSLTRunnerAddin.getXSLTJarForDebugging();
        fp.addEntry(xmlparserv2);
        Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(EXTENSION_ID);
        if (ext != null) {
            Iterator urls = ext.getClassPath().iterator();
            String orai18JarPath = "";
            while (urls.hasNext()) {
                String jarPath = ((URI)urls.next()).getPath();
                if (jarPath == null || !jarPath.contains(ORA_COLLATION_JAR)) continue;
                orai18JarPath = jarPath;
                break;
            }
            if (!orai18JarPath.isEmpty()) {
                File orai18nJar = new File(orai18JarPath);
                fp.addEntry(orai18nJar);
            }
        }
        cp = cp + fp.toString();
        return cp;
    }

    private void addFirstXSLTOptions(List list) {
        String[] a = (String[])this.jrunProcess.getValue("XSLT", null, "FirstXSLTCommandOptions");
        if (a != null) {
            XSLTStarter.addArrayToList(list, a);
        }
    }

    private void addLastXSLTOptions(List list) {
        String[] a = (String[])this.jrunProcess.getValue("XSLT", null, "LastXSLTCommandOptions");
        if (a != null) {
            XSLTStarter.addArrayToList(list, a);
        }
    }
}

