/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.SplitPanelLayout;
import oracle.javatools.compare.view.ViewEditEvent;
import oracle.javatools.compare.view.ViewEditListener;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.controls.ThrobberLabel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryModelEvent;
import oracle.javatools.history.HistoryModelListener;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.IdeCompareContributor;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdevimpl.compare.BaseCompareEditor;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.history.BufferHistoryProvider;
import oracle.jdevimpl.history.HistoryAddin;
import oracle.jdevimpl.history.HistoryController;
import oracle.jdevimpl.history.HistoryFilterComponent;
import oracle.jdevimpl.history.HistoryManagerImpl;
import oracle.jdevimpl.resource.CompareArb;
import oracle.jdevimpl.resource.HistoryArb;

public class HistoryViewer
extends BaseCompareEditor
implements DynamicStatusProvider,
ViewEditListener,
FindableEditor,
ComparePopupManager {
    private static final String GUI_BUSY = "busy";
    private static final String GUI_HISTORY = "history";
    private Node _node;
    private JPanel _historyPanel;
    private JPanel _horizontalScrollWrapper;
    private Component _noHistoryPanel;
    private CompareView _compareView;
    private Toolbar _toolbar;
    private JSplitPane _splitPane;
    private HistoryComponent _leftHistoryComponent;
    private HistoryComponent _rightHistoryComponent;
    private JLabel _label;
    private HistoryFilterComponent _filter;
    private MouseListener _mouseListener;
    private JLabel _statusLabel = new JLabel();
    private ChangeListener _providerStatusListener;
    private NodeUpdater _leftUpdater;
    private NodeUpdater _rightUpdater;
    private TableColumnModelListener _lhsColumnModelListener;
    private TableColumnModelListener _rhsColumnModelListener;
    private DefaultHistoryModel _currentHistoryModel;
    private ChangeListener _positionChangeListener;
    private HistorySelectionListener _historySelectionListener;
    private HistoryComponent _lastActiveHistoryComponent;
    private ChangeListener _viewStatusListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent ce) {
            HistoryViewer.this.updateStatusLabel();
        }
    };
    private ActionListener _defaultActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                IdeAction.find((int)CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID).performAction(HistoryViewer.this.getContext());
            }
            catch (Exception e) {
                oracle.javatools.dialogs.ExceptionDialog.showExceptionDialog((Component)HistoryViewer.this.getGUI(), (Throwable)e);
            }
        }
    };
    private final Map<CompareType, CompareView> _compareViewCache = new HashMap<CompareType, CompareView>();
    private final CardLayout _cardLayout;
    private final Component _busyLabel = new ThrobberLabel();
    private JPanel _cardLayoutPanel;
    private boolean _busy;
    private TextBuffer _textBuffer;
    private CompareViewUpdater _compareViewUpdater;

    public HistoryViewer() {
        this._cardLayout = new CardLayout();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public final void propertyChange(PropertyChangeEvent pce) {
                if (HistoryViewer.GUI_BUSY.equals(pce.getPropertyName())) {
                    boolean busy = (Boolean)pce.getNewValue();
                    if (busy) {
                        Ide.getWaitCursor().show(0);
                    } else {
                        Ide.getWaitCursor().hide();
                    }
                    if (HistoryViewer.this._historyPanel != null) {
                        HistoryViewer.this.setHistoryFilterEnabled(!busy);
                        View.updateToolbarActions((Toolbar)HistoryViewer.this.getToolbar());
                    }
                }
            }
        });
        this._busy = false;
    }

    boolean isLocalHistoryView() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager() instanceof HistoryManagerImpl && this.getHistoryProviders().contains(((HistoryManagerImpl)oracle.jdeveloper.history.HistoryManager.getHistoryManager()).getLocalHistoryProvider());
    }

    protected String getTablePersistenceKeyLHS() {
        return "HistoryViewer.LHS.DisplaySettings";
    }

    protected String getTablePersistenceKeyRHS() {
        return "HistoryViewer.RHS.DisplaySettings";
    }

    protected URL getRealURL() {
        return this._node.getURL();
    }

    private void installHistoryModel() {
        this._leftHistoryComponent = this.createHistoryComponent();
        this._rightHistoryComponent = this.createHistoryComponent();
        this._filter = this.createHistoryFilter();
        this._label = this.createHistoryFilterLabel(this._filter);
        if (this._historyPanel == null) {
            this._historyPanel = new JPanel();
        }
        this._historyPanel.removeAll();
        this.layoutHistoryPanel(this._historyPanel);
        this._splitPane.setBorder(BorderFactory.createEmptyBorder());
        this._splitPane.setTopComponent(this._historyPanel);
        this._splitPane.setResizeWeight(this.getDefaultDividerLocation());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryViewer.this.refreshWithThrobber();
            }
        });
    }

    protected Element[] getSelectionFromUI() {
        return this._lastActiveHistoryComponent != null ? this.getSelection(this._lastActiveHistoryComponent) : new HistoryElement[]{};
    }

    HistoryComponent getLastActiveHistoryComponent() {
        return this._lastActiveHistoryComponent;
    }

    boolean isCompareViewComponentFocused() {
        if (this._compareView == null || !(this._compareView instanceof EditorPaneView)) {
            return false;
        }
        BasicEditorPane currentEditorPane = ((EditorPaneView)this._compareView).getCurrentEditorPane();
        return currentEditorPane != null && currentEditorPane.isFocusOwner();
    }

    protected Component createNoHistoryPanel() {
        return new FocusableLabel(oracle.jdeveloper.resource.HistoryArb.getString(25));
    }

    protected void setNoHistoryText(Component noHistoryPanel, String message) {
        ((FocusableLabel)noHistoryPanel).setText(message);
    }

    protected HistoryComponent createHistoryComponent() {
        HistoryComponent historyComponent = oracle.jdeveloper.history.HistoryManager.getHistoryManager().createHistoryComponent();
        historyComponent.setFocusable(false);
        historyComponent.setUseAutoSizeMaximums(true);
        historyComponent.setSingleSelection(true);
        return historyComponent;
    }

    protected JLabel createToolbarLabel() {
        JLabel toolbarLabel = new JLabel();
        toolbarLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        return toolbarLabel;
    }

    protected HistoryFilterComponent createHistoryFilter() {
        return this.createHistoryFilter(this._leftHistoryComponent);
    }

    protected void setHistoryFilterEnabled(boolean enabled) {
        this._label.setEnabled(enabled);
        this._filter.setEnabled(enabled);
    }

    protected HistoryFilterComponent createHistoryFilter(HistoryComponent historyComponent) {
        final HistoryFilterComponent filter = new HistoryFilterComponent(historyComponent, this.getRealURL(), oracle.jdeveloper.history.HistoryManager.getHistoryManager().getAllFilter(), this.getHistoryProviders(this.getRealURL())){

            @Override
            protected HistoryModel createHistoryModel(HistoryFilter historyFilter, HistoryComponent historyComponent) {
                if (HistoryViewer.this._currentHistoryModel == null) {
                    return null;
                }
                DefaultHistoryModel historyModel = new DefaultHistoryModel(HistoryViewer.this._currentHistoryModel);
                HistoryViewer.this.initializeHistoryModel(historyModel, historyComponent);
                if (historyFilter != null) {
                    historyModel.applyFilter(HistoryViewer.this.getRealURL(), historyFilter);
                }
                return historyModel;
            }
        };
        filter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                filter.refilter();
            }
        });
        return filter;
    }

    protected void refilterModel() {
        this._filter.refilter();
    }

    protected JLabel createHistoryFilterLabel(HistoryFilterComponent filter) {
        JLabel label = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)label, (Component)filter, (String)oracle.jdeveloper.resource.HistoryArb.getString(19));
        return label;
    }

    protected void disposeHistoryFilters() {
        this._filter.detachCustomFilterObserver();
    }

    protected void layoutHistoryPanel(JPanel historyPanel) {
        historyPanel.setLayout(new BorderLayout());
        historyPanel.add((Component)this._leftHistoryComponent, "Center");
    }

    public HistoryFilterComponent getLeftFilter() {
        return this._filter;
    }

    public HistoryComponent getLeftHistoryComponent() {
        return this._leftHistoryComponent;
    }

    public HistoryComponent getRightHistoryComponent() {
        return this._rightHistoryComponent;
    }

    public void refresh() {
        this.refresh(this.getContext(), false);
    }

    public void refreshWithThrobber() {
        this.refresh(this.getContext(), true);
    }

    public final boolean isBusy() {
        return this._busy;
    }

    private final void setBusy(boolean busy) {
        this._busy = busy;
        this.firePropertyChangeEvent(GUI_BUSY, !busy, busy);
    }

    public void refresh(final Context context, boolean throbber) {
        this.detachForPersistentSettings();
        this.setBusy(true);
        if (this._cardLayoutPanel != null && throbber) {
            this._cardLayout.show(this._cardLayoutPanel, GUI_BUSY);
        }
        SwingWorker<DefaultHistoryModel, Object> worker = new SwingWorker<DefaultHistoryModel, Object>(){

            @Override
            protected final DefaultHistoryModel doInBackground() throws Exception {
                return (DefaultHistoryModel)oracle.jdeveloper.history.HistoryManager.getHistoryManager().buildModel(HistoryViewer.this.getRealURL(), true, null, HistoryViewer.this.getHistoryProviders());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected final void done() {
                HistoryViewer.this.setBusy(false);
                if (HistoryViewer.this._historyPanel == null) {
                    return;
                }
                try {
                    HistoryViewer.this._currentHistoryModel = (DefaultHistoryModel)((Object)this.get());
                    HistoryModel model = HistoryViewer.this.updateHistoryModel(HistoryViewer.this._leftHistoryComponent, HistoryViewer.this._filter);
                    HistoryViewer.this.updateHistoryModel(HistoryViewer.this._rightHistoryComponent, null);
                    final HistoryEntry selectionLhs = HistoryViewer.this._leftHistoryComponent.getSingleSelection();
                    final HistoryEntry selectionRhs = HistoryViewer.this._rightHistoryComponent.getSingleSelection();
                    final HistoryEntrySelector historyEntrySelectorLhs = HistoryContext.getHistoryEntrySelectorLHS(context);
                    final HistoryEntrySelector historyEntrySelectorRhs = HistoryContext.getHistoryEntrySelectorRHS(context);
                    if (context != null) {
                        HistoryContext.setHistoryEntrySelectorLHS(context, null);
                        HistoryContext.setHistoryEntrySelectorRHS(context, null);
                    }
                    HistoryModel historyModel = model;
                    synchronized (historyModel) {
                        if (model.isComplete()) {
                            HistoryViewer.this.sortHistoryComponentTables();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    HistoryViewer.this.updateStatusCount(selectionLhs, selectionRhs, historyEntrySelectorLhs, historyEntrySelectorRhs);
                                    HistoryViewer.this.attachForPersistentSettings();
                                }
                            });
                        } else {
                            model.addHistoryModelListener((HistoryModelListener)new CompletionListener(){

                                @Override
                                protected void complete() {
                                    HistoryViewer.this.sortHistoryComponentTables();
                                    HistoryViewer.this.updateStatusCount(selectionLhs, selectionRhs, historyEntrySelectorLhs, historyEntrySelectorRhs);
                                    HistoryViewer.this.attachForPersistentSettings();
                                }
                            });
                        }
                    }
                    if (HistoryViewer.this._cardLayoutPanel != null) {
                        HistoryViewer.this._cardLayout.show(HistoryViewer.this._cardLayoutPanel, HistoryViewer.GUI_HISTORY);
                    }
                    if (HistoryViewer.this._splitPane != null) {
                        HistoryViewer.this.delayedDividerInitialization(HistoryViewer.this._splitPane);
                    }
                    if (HistoryViewer.this._leftHistoryComponent != null && HistoryViewer.this._rightHistoryComponent != null) {
                        HistoryViewer.this.scrollToHistorySelections();
                    }
                    if (HistoryViewer.this._leftHistoryComponent != null) {
                        HistoryViewer.this._leftHistoryComponent.getTable().requestFocusInWindow();
                    }
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                }
            }
        };
        worker.execute();
    }

    protected HistoryModel updateHistoryModel(HistoryComponent historyComponent, HistoryFilterComponent filter) {
        if (historyComponent == this._rightHistoryComponent) {
            this._rightHistoryComponent.setModel((HistoryModel)new BufferHistoryModel(this.getRealURL(), BufferHistoryProvider.getInstance().getTypeFilter()));
            return null;
        }
        return this.updateHistoryModelImpl(historyComponent, filter);
    }

    protected HistoryModel updateHistoryModelImpl(HistoryComponent historyComponent, HistoryFilterComponent filter) {
        DefaultHistoryModel model = new DefaultHistoryModel(this._currentHistoryModel);
        this.initializeHistoryModel(model, historyComponent);
        if (filter != null) {
            model.applyFilter(this.getRealURL(), filter.getSelectedFilter());
        }
        historyComponent.setModel((HistoryModel)model);
        return model;
    }

    private void initializeHistoryModel(DefaultHistoryModel model, HistoryComponent historyComponent) {
        if (model instanceof DefaultHistoryModel) {
            if (historyComponent == this._leftHistoryComponent) {
                this.initializeDefaultProperties(this.getTablePersistenceKeyLHS(), model);
            }
            if (historyComponent == this._rightHistoryComponent) {
                this.initializeDefaultProperties(this.getTablePersistenceKeyRHS(), model);
            }
        }
    }

    private void initializeDefaultProperties(String key, DefaultHistoryModel model) {
        Collection hiddenPropertyNames = (Collection)Ide.getDTCache().getData(key);
        if (hiddenPropertyNames == null || hiddenPropertyNames.isEmpty()) {
            this.enableAllDefaultProperties(model);
            return;
        }
        ArrayList<HistoryProperty> defaultProperties = new ArrayList<HistoryProperty>();
        HistoryProperty[] properties = model.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (hiddenPropertyNames.contains(properties[i].getName())) continue;
            defaultProperties.add(properties[i]);
        }
        model.setDefaultProperties(defaultProperties.toArray(new HistoryProperty[0]));
    }

    protected void enableAllDefaultProperties(DefaultHistoryModel model) {
        model.setDefaultProperties(model.getProperties());
    }

    protected Collection getHistoryProviders() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager().getProviders();
    }

    protected Collection getHistoryProviders(URL url) {
        ArrayList<HistoryProvider> forProviders = new ArrayList<HistoryProvider>();
        Collection providers = oracle.jdeveloper.history.HistoryManager.getHistoryManager().getProviders();
        for (HistoryProvider provider : providers) {
            if (!provider.isProviderFor(url)) continue;
            forProviders.add(provider);
        }
        return forProviders;
    }

    private void attachForPersistentSettings() {
        if (this._leftHistoryComponent == null || this._rightHistoryComponent == null) {
            return;
        }
        this._lhsColumnModelListener = new PersistenceTableColumnModelListener(this._leftHistoryComponent, this.getTablePersistenceKeyLHS());
        this._rhsColumnModelListener = new PersistenceTableColumnModelListener(this._rightHistoryComponent, this.getTablePersistenceKeyRHS());
        this._leftHistoryComponent.getTable().getColumnModel().addColumnModelListener(this._lhsColumnModelListener);
        this._rightHistoryComponent.getTable().getColumnModel().addColumnModelListener(this._rhsColumnModelListener);
    }

    private void detachForPersistentSettings() {
        if (this._leftHistoryComponent != null && this._lhsColumnModelListener != null) {
            this._leftHistoryComponent.getTable().getColumnModel().removeColumnModelListener(this._lhsColumnModelListener);
        }
        if (this._rightHistoryComponent != null && this._rhsColumnModelListener != null) {
            this._rightHistoryComponent.getTable().getColumnModel().removeColumnModelListener(this._rhsColumnModelListener);
        }
    }

    private void updateStatusCount(HistoryEntry selectionLhs, HistoryEntry selectionRhs, Object historyEntrySelectorLhs, Object historyEntrySelectorRhs) {
        HistoryEntry selectionRhs0;
        HistoryEntry selectionLhs0;
        if (historyEntrySelectorLhs != null && historyEntrySelectorLhs instanceof HistoryEntrySelector && (selectionLhs0 = ((HistoryEntrySelector)historyEntrySelectorLhs).select(this._leftHistoryComponent.getModel())) != null) {
            selectionLhs = selectionLhs0;
        }
        if (historyEntrySelectorRhs != null && historyEntrySelectorRhs instanceof HistoryEntrySelector && (selectionRhs0 = ((HistoryEntrySelector)historyEntrySelectorRhs).select(this._rightHistoryComponent.getModel())) != null) {
            selectionRhs = selectionRhs0;
        }
        this.updateStatusCount(selectionLhs, selectionRhs);
    }

    private void sortHistoryComponentTables() {
        try {
            this._leftHistoryComponent.sortTableByProperty(SharedProperties.getDateProperty(), false);
            this._rightHistoryComponent.sortTableByProperty(SharedProperties.getDateProperty(), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateStatusCount(HistoryEntry selectionLhs, HistoryEntry selectionRhs) {
        if (this._leftHistoryComponent == null || this._rightHistoryComponent == null) {
            return;
        }
        this.updateStatusCount0(selectionLhs, this._leftHistoryComponent);
        this.updateStatusCount0(selectionRhs, this._rightHistoryComponent);
        this.scrollToHistorySelections();
    }

    private void updateStatusCount0(HistoryEntry selection, HistoryComponent component) {
        if (component == null) {
            return;
        }
        int rows = component.getTable().getModel().getRowCount();
        if (rows > 0) {
            if (selection != null) {
                component.setSingleSelection(selection);
            }
            if (component.getSingleSelection() == null) {
                component.getTable().setRowSelectionInterval(0, 0);
            }
        }
    }

    private void scrollToHistorySelections() {
        if (this._leftHistoryComponent.getTable().getModel().getRowCount() > 0) {
            this._leftHistoryComponent.getTable().scrollToSelection();
        }
        if (this._rightHistoryComponent.getTable().getModel().getRowCount() > 0) {
            this._rightHistoryComponent.getTable().scrollToSelection();
        }
    }

    public Controller getController() {
        return HistoryController.getInstance();
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setMinimumSize(new Dimension(0, 0));
        }
        return this._toolbar;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Component getBottomComponent() {
        return this._horizontalScrollWrapper;
    }

    public Object getEditorAttribute(String attribute) {
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(attribute)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute)) {
            return new Integer(21);
        }
        if ("menu_id".equals(attribute)) {
            return oracle.jdeveloper.resource.HistoryArb.getString(30);
        }
        return super.getEditorAttribute(attribute);
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scslocalhistory_html");
    }

    public ContextMenu getContextMenu() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager().getContextMenu();
    }

    public Component getGUI() {
        if (this._splitPane == null) {
            this._splitPane = new JSplitPane(0);
        }
        if (this._cardLayoutPanel == null) {
            this._cardLayoutPanel = new JPanel(this._cardLayout);
            this._cardLayoutPanel.add(this._busyLabel, GUI_BUSY);
            this._cardLayoutPanel.add((Component)this._splitPane, GUI_HISTORY);
        }
        return this._cardLayoutPanel;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this._node = context.getNode();
        context.setView((View)this);
        HistoryContext.setRealURL(context, this.getRealURL());
        URL nodeURL = this.getRealURL();
        URL parentURL = URLFileSystem.getParent((URL)nodeURL);
        String nodeFilename = URLFileSystem.getFileName((URL)nodeURL);
        String nodeDirectory = URLFileSystem.getPlatformPathName((URL)parentURL);
        AccessibleUtils.updateAccessibleName((Accessible)((Accessible)((Object)this.getGUI())), (String)MessageFormat.format(oracle.jdeveloper.resource.HistoryArb.getString(9), nodeFilename, nodeDirectory), (boolean)true);
        if (context != null && context.getNode() instanceof TextNode) {
            this._textBuffer = ((TextNode)context.getNode()).acquireTextBuffer();
        }
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null) {
            context.setNode(this._node);
            context.setView((View)this);
            HistoryContext.setRealURL(context, this.getRealURL());
        }
        return context;
    }

    public void open() {
        if (this.getRealURL() != null) {
            this.getGUI();
            this.installHistoryModel();
            this.initializeToolbars();
            Ide.addIdeListener((IdeListener)new IdeAdapter(){

                public void mainWindowClosing(IdeEvent e) {
                    HistoryViewer.this.detachForPersistentSettings();
                }
            });
            this._mouseListener = new ContextMenuMouseListener();
            this._leftHistoryComponent.addMouseListener(this._mouseListener);
            this._rightHistoryComponent.addMouseListener(this._mouseListener);
            this._historySelectionListener = new HistorySelectionListener();
            this._leftHistoryComponent.addListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._rightHistoryComponent.addListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._leftHistoryComponent.getTable().addFocusListener((FocusListener)this._historySelectionListener);
            this._rightHistoryComponent.getTable().addFocusListener((FocusListener)this._historySelectionListener);
            this._lastActiveHistoryComponent = this._leftHistoryComponent;
        }
    }

    protected void delayedDividerInitialization(JSplitPane splitPane) {
        splitPane.setDividerLocation(this.getDefaultDividerLocation());
        splitPane.validate();
        splitPane.repaint();
    }

    protected void initializeToolbars() {
        this.getToolbar().removeAll();
        if (this._filter != null) {
            this.addToolbarSeparator();
            this.getToolbar().add((Component)this._label);
            this.getToolbar().add((Component)this._filter);
        }
        this.addToolbarSeparator();
        this._toolbar.add((ToggleAction)this.getLocalAction(HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID)).setName("history_customize_filters");
        this.getToolbar().add((ToggleAction)this.getLocalAction(51)).setName("history_refresh");
        this.addToolbarSeparator();
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateFirst"))).setName("history_go_first");
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigatePrevious"))).setName("history_go_previous");
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateNext"))).setName("history_go_next");
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateLast"))).setName("history_go_last");
        if (this.isLocalHistoryView() || this.isEditableRHS()) {
            this.addToolbarSeparator();
        }
        if (this.isLocalHistoryView()) {
            this.getToolbar().add((ToggleAction)this.getLocalAction(HistoryAddin.PURGE_HISTORY_CMD_ID)).setName("history_purge");
        }
        if (this.isEditableRHS()) {
            this.getToolbar().add((ToggleAction)this.getLocalAction(HistoryManager.RESTORE_HISTORY_CMD_ID)).setName("history_restore");
        }
        this.getToolbar().repaint();
    }

    private void addToolbarSeparator() {
        if (this.getToolbar().getComponentCount() > 0) {
            this.getToolbar().addSeparator();
        }
    }

    protected boolean isEditableRHS() {
        return true;
    }

    protected double getDefaultDividerLocation() {
        return 0.25;
    }

    public void close() {
        this.detachForPersistentSettings();
        this.deinstallUndoableEditListener();
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).removeStatusListener(this._viewStatusListener);
        }
        if (this._compareView != null) {
            ((BaseCompareView)this._compareView).dispose();
        }
        for (CompareView compareView : this._compareViewCache.values()) {
            ((BaseCompareView)compareView).dispose();
        }
        this._compareViewCache.clear();
        this._leftUpdater = null;
        this._rightUpdater = null;
        this.disposeHistoryFilters();
        this._historyPanel = null;
        this._horizontalScrollWrapper = null;
        this._noHistoryPanel = null;
        this._compareView = null;
        this._toolbar = null;
        this._splitPane = null;
        this._label = null;
        this._filter = null;
        this._mouseListener = null;
        this._statusLabel = null;
        this._lhsColumnModelListener = null;
        this._rhsColumnModelListener = null;
        this._currentHistoryModel = null;
        if (this._historySelectionListener != null) {
            this._leftHistoryComponent.removeListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._rightHistoryComponent.removeListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._leftHistoryComponent.getTable().removeFocusListener((FocusListener)this._historySelectionListener);
            this._rightHistoryComponent.getTable().removeFocusListener((FocusListener)this._historySelectionListener);
        }
        this._historySelectionListener = null;
        this._lastActiveHistoryComponent = null;
        this._leftHistoryComponent = null;
        this._rightHistoryComponent = null;
        super.close();
    }

    @Override
    public CompareView getCompareView() {
        if (this._compareView != null && this._splitPane != null && this._splitPane.getBottomComponent() == this._compareView.getGUI()) {
            return this._compareView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompareView() throws Exception {
        HistoryEntry left = this._leftHistoryComponent.getSingleSelection();
        HistoryEntry right = this._rightHistoryComponent.getSingleSelection();
        CompareContributor leftContributor = null;
        CompareContributor rightContributor = null;
        boolean comparable = CompareManager.getCompareManager().isContentComparable(this.getRealURL());
        if (left != null && right != null && comparable && (leftContributor = left.getCompareContributor()) != null) {
            rightContributor = right.getCompareContributor();
        }
        if (this._compareView != null) {
            this.removeAllListeners();
        }
        if (leftContributor != null && rightContributor != null) {
            CompareInvocation invocationContext = CompareUtil.createInvocationContext(leftContributor, rightContributor, this.isLocalHistoryView() ? CompareUtil.getStreamType(rightContributor) : null);
            invocationContext.setContextNode(this.getRealURL() == this._node.getURL() ? this._node : NodeFactory.find((URL)this.getRealURL()));
            HistoryViewer historyViewer = this;
            synchronized (historyViewer) {
                if (this._compareViewUpdater != null) {
                    this._compareViewUpdater.cancel();
                }
                this._compareViewUpdater = new CompareViewUpdater(leftContributor, rightContributor, invocationContext);
            }
            if (invocationContext.getCurrentMethod().getCompareType() == CompareType.XML && (this.exceedsProgressFileSizeForXML(leftContributor) || this.exceedsProgressFileSizeForXML(rightContributor))) {
                ProgressPanel progressPanel = new ProgressPanel();
                progressPanel.setLabelText(HistoryArb.getString(54));
                progressPanel.setCancelingText(HistoryArb.getString(56));
                this.setBottomComponent((Component)progressPanel);
                HistoryViewer historyViewer2 = this;
                synchronized (historyViewer2) {
                    this._compareViewUpdater.initializeProgressPanel(progressPanel);
                }
            }
            historyViewer = this;
            synchronized (historyViewer) {
                this._compareViewUpdater.start();
            }
        }
        this._compareView = null;
        this.showNoHistoryPanel(oracle.jdeveloper.resource.HistoryArb.getString(25));
    }

    private void removeAllListeners() {
        this.deinstallUndoableEditListener();
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).removeStatusListener(this._viewStatusListener);
        }
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).removePositionListener(this._positionChangeListener);
        }
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).removePopupManager((ComparePopupManager)this);
        }
        if (this._compareView instanceof ListCompareView) {
            ((ListCompareView)this._compareView).removeDefaultActionListener(this._defaultActionListener);
        }
    }

    protected CompareView createCompareView(CompareModel model) {
        String key = "oracle.jdevimpl.history.HistoryViewer.createCompareView()";
        CompareView compareView = CompareViewFactory.createCompareView((CompareModel)model);
        return compareView;
    }

    private void postUpdateCompareView() {
        if (this._providerStatusListener != null) {
            this._providerStatusListener.stateChanged(new ChangeEvent(this));
        }
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).goToInitialDifference();
        }
        this.augmentToolbarComponents();
    }

    private void showNoHistoryPanel(String message) {
        if (this._noHistoryPanel == null) {
            this._noHistoryPanel = this.createNoHistoryPanel();
        }
        this.setNoHistoryText(this._noHistoryPanel, message);
        int split = this._splitPane.getDividerLocation();
        if (this._leftHistoryComponent != null) {
            this._leftHistoryComponent.getTable().requestFocusInWindow();
        }
        this.setBottomComponent(this._noHistoryPanel, split);
        this._statusLabel.setText(CompareArb.getString(34));
        this.postUpdateCompareView();
    }

    private boolean exceedsProgressFileSizeForXML(CompareContributor contributor) {
        return contributor instanceof TextCompareContributor && (double)((TextCompareContributor)contributor).getTextBuffer().getLength() > 16.0 * Math.pow(2.0, 10.0);
    }

    private final void setBottomComponent(Component c) {
        this.setBottomComponent(c, this._splitPane.getDividerLocation());
    }

    private final void setBottomComponent(Component c, int split) {
        this._splitPane.setBottomComponent(c);
        this._splitPane.setDividerLocation(split);
    }

    private void updateStatusLabel() {
        if (this._compareView == null || this._compareView.getModel() == null) {
            this._statusLabel.setText("");
            return;
        }
        int[] diffCount = this._compareView.getModel().getDifferenceTypeCounts();
        int diffs = this._compareView.getModel().getDifferenceCount();
        if (diffs == 0) {
            this._statusLabel.setText(CompareArb.getString(34));
        } else {
            this._statusLabel.setText(MessageFormat.format(CompareArb.getString(35), String.valueOf(diffs), String.valueOf(diffCount[0]), String.valueOf(diffCount[1]), String.valueOf(diffCount[2])));
        }
    }

    protected void installUndoableEditListener() {
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).addViewEditListener((ViewEditListener)this);
        }
    }

    protected void deinstallUndoableEditListener() {
        if (this._compareView instanceof BaseCompareView) {
            ((BaseCompareView)this._compareView).removeViewEditListener((ViewEditListener)this);
        }
    }

    public void viewEditHappened(ViewEditEvent vee) {
        NodeUpdater updater = vee.getContributorKind() == ContributorKind.FIRST ? this._leftUpdater : this._rightUpdater;
        UndoWrapperCommand command = new UndoWrapperCommand((UndoableEdit)vee.getViewEdit(), (Object)updater);
        command.setContext(this.getContext());
        try {
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateStatusLabel();
        IdeActions.getFileSaveAction().updateAction();
        IdeActions.getFileSaveAsAction().updateAction();
        IdeActions.getFileSaveAllAction().updateAction();
    }

    public HistoryElement[] getSelectionLHS() {
        return this.getSelection(this._leftHistoryComponent);
    }

    public HistoryElement[] getSelectionRHS() {
        return this.getSelection(this._rightHistoryComponent);
    }

    public HistoryElement[] getSelection(HistoryComponent historyComponent) {
        try {
            if (historyComponent == null) {
                return new HistoryElement[0];
            }
            HistoryEntry[] entries = historyComponent.getSelection();
            if (entries == null) {
                return new HistoryElement[0];
            }
            HistoryElement[] elements = new HistoryElement[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                elements[i] = new HistoryElement(entries[i]);
            }
            return elements;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HistoryElement[0];
        }
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._compareView instanceof EditorPaneView) {
            return ((EditorPaneView)this._compareView).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            HistoryContext.setHistoryEntrySelectorLHS(context, null);
            HistoryContext.setHistoryEntrySelectorRHS(context, null);
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup() {
    }

    public JComponent[] getCustomCells() {
        return new JComponent[]{this._statusLabel};
    }

    public boolean isExpandable(JComponent p0) {
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this._providerStatusListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        if (l == this._providerStatusListener) {
            this._providerStatusListener = null;
        }
    }

    protected IdeAction getLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        if (ideAction != null) {
            IdeAction local = ideAction.newLocalAction((View)this);
            return local;
        }
        throw new IllegalArgumentException("CMDID " + cmdId + " not found");
    }

    private static final class BufferHistoryModel
    extends DefaultHistoryModel {
        BufferHistoryModel(URL url, HistoryFilter filter) {
            BufferHistoryProvider provider = BufferHistoryProvider.getInstance();
            if (((HistoryProvider)provider).isProviderFor(url)) {
                this.addProperties(((HistoryProvider)provider).getProperties());
                HistoryEntry[] entries = ((HistoryProvider)provider).getEntries(url, null);
                this.addEntries(entries);
            }
        }
    }

    private class ContextMenuMouseListener
    extends MouseAdapter {
        private ContextMenuMouseListener() {
        }

        private void doIt(final MouseEvent me) {
            Object source = me.getSource();
            if (!(source instanceof JTable)) {
                return;
            }
            JTable table = (JTable)source;
            final ContextMenu menu = HistoryViewer.this.getContextMenu();
            if (me.isPopupTrigger()) {
                int row = table.rowAtPoint(me.getPoint());
                if (row >= 0 && !table.isRowSelected(row)) {
                    table.setRowSelectionInterval(row, row);
                }
                table.requestFocus();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        menu.show(HistoryViewer.this.getContext(me));
                    }
                });
            } else if (me.getClickCount() == 2 && me.getButton() == 1 && table.rowAtPoint(me.getPoint()) >= 0) {
                menu.fireDefaultAction(HistoryViewer.this.getContext(me));
                me.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.doIt(me);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.doIt(me);
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            this.doIt(me);
        }
    }

    private abstract class CompletionListener
    implements HistoryModelListener {
        private CompletionListener() {
        }

        protected abstract void complete();

        public void completenessChanged(HistoryModelEvent vhe) {
            try {
                HistoryModel model = (HistoryModel)vhe.getSource();
                if (model.isComplete()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CompletionListener.this.complete();
                        }
                    });
                    model.removeHistoryModelListener((HistoryModelListener)this);
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Context)HistoryViewer.this.getContext(), (Throwable)re);
            }
        }

        public void entriesChanged(HistoryModelEvent vhe) {
        }

        public void entriesInserted(HistoryModelEvent vhe) {
        }

        public void entriesRemoved(HistoryModelEvent vhe) {
        }
    }

    private class CompareViewUpdater
    extends oracle.ide.util.SwingWorker {
        private final CompareContributor _leftContributor;
        private final CompareContributor _rightContributor;
        private final CompareInvocation _invocationContext;
        private Exception _e;

        CompareViewUpdater(CompareContributor leftContributor, CompareContributor rightContributor, CompareInvocation invocationContext) {
            this._leftContributor = leftContributor;
            this._rightContributor = rightContributor;
            this._invocationContext = invocationContext;
        }

        void initializeProgressPanel(ProgressPanel progressPanel) {
            progressPanel.setCancelEnabled(this._invocationContext.isCancelable());
            progressPanel.addCancelActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CompareViewUpdater.this._invocationContext.cancel();
                }
            });
        }

        void cancel() {
            this._invocationContext.cancel();
        }

        public Object construct() {
            this._e = null;
            try {
                String key = "oracle.jdevimpl.history.HistoryViewer.CompareViewUpdater.construct()";
                CompareModel model = CompareUtil.createCompareModel(this._leftContributor, this._rightContributor, this._invocationContext);
                Node node = null;
                if (node == null && this._leftContributor instanceof IdeCompareContributor) {
                    node = ((IdeCompareContributor)this._leftContributor).getNode();
                }
                if (node == null && this._rightContributor instanceof IdeCompareContributor) {
                    node = ((IdeCompareContributor)this._rightContributor).getNode();
                }
                if (node != null && node.getURL() != null && DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)node.getURL())) == ContentType.BINARY && (this._leftContributor instanceof TextCompareContributor || this._rightContributor instanceof TextCompareContributor)) {
                    model = null;
                }
                return model;
            }
            catch (CompareFailedException cfe) {
                this._e = cfe;
                return null;
            }
            catch (Exception e) {
                this._e = e;
                e.printStackTrace();
                return null;
            }
        }

        public void finished() {
            CompareModel model;
            if (!HistoryViewer.this._node.isOpen()) {
                return;
            }
            if (HistoryViewer.this._positionChangeListener == null) {
                HistoryViewer.this._positionChangeListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ce) {
                        HistoryViewer.this.updateVisibleActions();
                    }
                };
            }
            if ((model = (CompareModel)this.getValue()) == null) {
                HistoryViewer.this._compareView = null;
                HistoryViewer.this.showNoHistoryPanel(CompareIdeViewer.getCompareNotAvailableMessage(this._invocationContext, (Exception)(this._invocationContext.getFailure() != null ? this._invocationContext.getFailure() : this._e)));
                return;
            }
            CompareView cacheCompareView = (CompareView)HistoryViewer.this._compareViewCache.get(model.getType());
            if (cacheCompareView != null) {
                HistoryViewer.this._compareView = cacheCompareView;
                HistoryViewer.this.removeAllListeners();
            }
            if (HistoryViewer.this._compareView == null || !HistoryViewer.this._compareView.getModel().getType().equals((Object)model.getType())) {
                CompareView oldCompareView = HistoryViewer.this._compareView;
                HistoryViewer.this._compareView = HistoryViewer.this.createCompareView(model);
                HistoryViewer.this._compareViewCache.put(model.getType(), HistoryViewer.this._compareView);
                if (oldCompareView instanceof BaseCompareView && HistoryViewer.this._compareView instanceof BaseCompareView) {
                    ((SplitPanelLayout)((BaseCompareView)HistoryViewer.this._compareView).getSplitPanel().getLayout()).copyWeightsFromLayout((SplitPanelLayout)((BaseCompareView)oldCompareView).getSplitPanel().getLayout());
                }
                HistoryViewer.this.setBottomComponent(HistoryViewer.this._compareView.getGUI());
                if (HistoryViewer.this._compareView instanceof BaseCompareView) {
                    HistoryViewer.this._horizontalScrollWrapper = new JPanel();
                    HistoryViewer.this._horizontalScrollWrapper.setLayout(new BorderLayout());
                    HistoryViewer.this._horizontalScrollWrapper.removeAll();
                    HistoryViewer.this._horizontalScrollWrapper.add(((BaseCompareView)HistoryViewer.this._compareView).getHorizontalScrollComponent(), "Center");
                }
                HistoryViewer.this._splitPane.repaint();
            } else {
                String key = "oracle.jdevimpl.history.HistoryViewer.CompareViewUpdater.finished()";
                HistoryViewer.this._compareView.setModel(model);
            }
            HistoryViewer.this.installUndoableEditListener();
            if (HistoryViewer.this._compareView instanceof BaseCompareView) {
                ((BaseCompareView)HistoryViewer.this._compareView).addStatusListener(HistoryViewer.this._viewStatusListener);
            }
            if (HistoryViewer.this._compareView instanceof BaseCompareView) {
                ((BaseCompareView)HistoryViewer.this._compareView).addPositionListener(HistoryViewer.this._positionChangeListener);
            }
            if (HistoryViewer.this._compareView instanceof BaseCompareView) {
                ((BaseCompareView)HistoryViewer.this._compareView).removePopupManager((ComparePopupManager)HistoryViewer.this);
                ((BaseCompareView)HistoryViewer.this._compareView).addPopupManager((ComparePopupManager)HistoryViewer.this);
            }
            if (HistoryViewer.this._compareView instanceof ListCompareView) {
                ((ListCompareView)HistoryViewer.this._compareView).removeDefaultActionListener(HistoryViewer.this._defaultActionListener);
                ((ListCompareView)HistoryViewer.this._compareView).addDefaultActionListener(HistoryViewer.this._defaultActionListener);
            }
            if (HistoryViewer.this._splitPane.getBottomComponent() != HistoryViewer.this._compareView.getGUI()) {
                HistoryViewer.this.setBottomComponent(HistoryViewer.this._compareView.getGUI());
            }
            HistoryViewer.this.updateStatusLabel();
            HistoryViewer.this.postUpdateCompareView();
        }
    }

    private class HistorySelectionListener
    extends FocusAdapter
    implements ListSelectionListener {
        private HistorySelectionListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.updateLastActiveHistoryComponent(e.getComponent());
            HistoryViewer.this.scheduleUpdateSelection();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.updateLastActiveHistoryComponent(e.getOppositeComponent());
            HistoryViewer.this.scheduleUpdateSelection();
        }

        private void updateLastActiveHistoryComponent(Component c) {
            if (HistoryViewer.this._leftHistoryComponent != null && c == HistoryViewer.this._leftHistoryComponent.getTable()) {
                HistoryViewer.this._lastActiveHistoryComponent = HistoryViewer.this._leftHistoryComponent;
            }
            if (HistoryViewer.this._rightHistoryComponent != null && c == HistoryViewer.this._rightHistoryComponent.getTable()) {
                HistoryViewer.this._lastActiveHistoryComponent = HistoryViewer.this._rightHistoryComponent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            try {
                HistoryViewer.this.updateCompareView();
            }
            catch (Exception cfe) {
                cfe.printStackTrace();
            }
            finally {
                HistoryViewer.this.scheduleUpdateSelection();
            }
        }
    }

    private class PersistenceTableColumnModelListener
    implements TableColumnModelListener {
        private final HistoryComponent _historyComponent;
        private final String _key;

        PersistenceTableColumnModelListener(HistoryComponent historyComponent, String key) {
            this._historyComponent = historyComponent;
            this._key = key;
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            this.storePersistentSettings();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            this.storePersistentSettings();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private void storePersistentSettings() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryProperty[] hiddenProperties = PersistenceTableColumnModelListener.this._historyComponent.getHiddenProperties();
                    ArrayList<String> hiddenPropertyNames = new ArrayList<String>();
                    for (int i = 0; i < hiddenProperties.length; ++i) {
                        hiddenPropertyNames.add(hiddenProperties[i].getName());
                    }
                    Ide.getDTCache().putData(PersistenceTableColumnModelListener.this._key, hiddenPropertyNames);
                }
            });
        }
    }
}

