/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.DefaultHistoryEntry;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.CompareArb;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.compare.XmlContextFactory;

class BufferHistoryProvider
extends HistoryProvider {
    private static BufferHistoryProvider _instance;
    private static final HistoryProperty[] _PROPERTIES;
    private static final HistoryFilter _TYPE_FILTER;
    private static final RevisionIdentifier _BUFFER_REVISION;

    public static final BufferHistoryProvider getInstance() {
        if (_instance == null) {
            _instance = new BufferHistoryProvider();
        }
        return _instance;
    }

    private BufferHistoryProvider() {
    }

    @Override
    public HistoryFilter getTypeFilter() {
        return _TYPE_FILTER;
    }

    @Override
    public HistoryProperty[] getProperties() {
        return _PROPERTIES;
    }

    @Override
    public boolean isProviderFor(URL url) {
        try {
            if (!URLFileSystem.isDirectory((URL)url)) {
                HistoryManager mgr = HistoryManager.getHistoryManager();
                Class cls = Recognizer.recognizeURL((URL)url);
                if (mgr != null && cls != null) {
                    return mgr.getRegisteredHistorian(cls) != null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
        ArrayList<BufferEntry> entries = new ArrayList<BufferEntry>();
        try {
            if (!URLFileSystem.isDirectory((URL)url)) {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node instanceof TextNode) {
                    entries.add(new BufferEntry((TextNode)node));
                } else if (node instanceof Node && DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url)) == ContentType.TEXT) {
                    entries.add(new BufferEntry(node));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HistoryEntry[] result = new HistoryEntry[entries.size()];
        entries.toArray(result);
        return result;
    }

    static {
        _PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), SharedProperties.getDescriptionProperty()};
        _TYPE_FILTER = new HistoryFilter(){

            @Override
            public String getShortLabel() {
                return HistoryArb.getString(14);
            }

            @Override
            public boolean accept(HistoryEntry entry) {
                return entry instanceof BufferEntry;
            }
        };
        _BUFFER_REVISION = new RevisionIdentifier(HistoryArb.getIcon(15), HistoryArb.getString(14));
    }

    private static final class BufferEntry
    extends DefaultHistoryEntry {
        private final Node _node;
        private CompareContributor _contributor;

        private BufferEntry(TextNode node) {
            this((Node)node);
        }

        private BufferEntry(Node node) {
            this._node = node;
            this.setValue(SharedProperties.getDateProperty(), HistoryComponent.LIVE_DATE);
            this.setValue(SharedProperties.getRevisionProperty(), _BUFFER_REVISION);
            this.setValue(SharedProperties.getDescriptionProperty(), HistoryArb.getString(18));
        }

        public CompareContributor getCompareContributor() {
            try {
                if (this._node instanceof TextNode) {
                    if (this._contributor == null) {
                        this._contributor = new TextNodeContributor((TextNode)this._node);
                    }
                    return this._contributor;
                }
                URL url = this._node.getURL();
                InputStreamTextContributor contributor = new InputStreamTextContributor(URLFileSystem.openInputStream((URL)url), CompareArb.format(3, URLFileSystem.getFileName((URL)url)), URLFileSystem.getPlatformPathName((URL)url), URLFileSystem.getSuffix((URL)url));
                contributor.getTextBuffer().setReadOnly(true);
                contributor.setDocumentModel(this.getXmlContext(this._node));
                return contributor;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private Object getXmlContext(Node node) {
            return XmlContextFactory.getXmlContextFactory().findOrCreateContext(new Context(node));
        }
    }
}

