/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.compare.IdeTextCompareContributor;
import oracle.jdeveloper.compare.TextNodeContributor;

public abstract class StreamTextProcessor {
    private static final Collection<StreamTextProcessor> _processors = new ArrayList<StreamTextProcessor>();

    public abstract void process(String var1, TextBuffer var2, URL var3);

    public static final synchronized void registerTextProcessor(StreamTextProcessor processor) {
        _processors.add(processor);
    }

    public static final synchronized void deregisterTextProcessor(StreamTextProcessor processor) {
        _processors.remove(processor);
    }

    static final synchronized Collection<StreamTextProcessor> getRegisteredProcessors() {
        return new ArrayList<StreamTextProcessor>(_processors);
    }

    public static final void process(CompareContributor contributor, URL referenceUrl) {
        if (contributor instanceof TextNodeContributor || !(contributor instanceof IdeTextCompareContributor)) {
            return;
        }
        if (((IdeTextCompareContributor)contributor).isTextProcessed()) {
            return;
        }
        if (referenceUrl == null) {
            return;
        }
        ((IdeTextCompareContributor)contributor).setTextProcessed(StreamTextProcessor.processTextForBug5929303(contributor.getType(), ((TextCompareContributor)contributor).getTextBuffer(), referenceUrl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean processTextForBug5929303(String type, TextBuffer textBuffer, URL referenceUrl) {
        boolean readOnly = textBuffer.isReadOnly();
        textBuffer.setReadOnly(false);
        textBuffer.writeLock();
        textBuffer.clearModified();
        try {
            for (StreamTextProcessor processor : StreamTextProcessor.getRegisteredProcessors()) {
                processor.process(type, textBuffer, referenceUrl);
            }
            boolean bl = textBuffer.isModified();
            return bl;
        }
        finally {
            textBuffer.writeUnlock();
            textBuffer.setReadOnly(readOnly);
        }
    }
}

