/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.SizeRequirements;

public final class EastWestToolbarLayout
implements LayoutManager2,
Serializable {
    public static final String EAST = "East";
    public static final String WEST = "West";
    private final Container target;
    private List<Component> _east = new ArrayList<Component>();
    private transient SizeRequirements[] _xChildren;
    private transient SizeRequirements[] _yChildren;
    private transient SizeRequirements _xTotal;
    private transient SizeRequirements _yTotal;

    public EastWestToolbarLayout(Container target) {
        this.target = target;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == EAST) {
            this._east.add(comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this._east.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension size;
        EastWestToolbarLayout eastWestToolbarLayout = this;
        synchronized (eastWestToolbarLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.preferred, this._yTotal.preferred);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    private final void checkContainer(Container target) {
        if (this.target != target) {
            throw new AWTError("ToolBarLayout can't be shared");
        }
    }

    private final void checkRequests() {
        if (this._xChildren == null || this._yChildren == null) {
            List<Component> components = this.getTargetComponents();
            ArrayList<SizeRequirements> _xChildren_ = new ArrayList<SizeRequirements>();
            ArrayList<SizeRequirements> _yChildren_ = new ArrayList<SizeRequirements>();
            this.getSizeRequirements(components, _xChildren_, _yChildren_);
            this._xChildren = _xChildren_.toArray(new SizeRequirements[0]);
            this._yChildren = _yChildren_.toArray(new SizeRequirements[0]);
            this.getSizeRequirements(this._east, _xChildren_, _yChildren_);
            this._xTotal = SizeRequirements.getTiledSizeRequirements(_xChildren_.toArray(new SizeRequirements[0]));
            this._yTotal = SizeRequirements.getAlignedSizeRequirements(_yChildren_.toArray(new SizeRequirements[0]));
        }
    }

    private final void getSizeRequirements(Collection<Component> components, Collection<SizeRequirements> xChildren, Collection<SizeRequirements> yChildren) {
        for (Component c : components) {
            if (!c.isVisible()) {
                xChildren.add(new SizeRequirements(0, 0, 0, c.getAlignmentX()));
                yChildren.add(new SizeRequirements(0, 0, 0, c.getAlignmentY()));
                continue;
            }
            Dimension min = c.getMinimumSize();
            Dimension typ = c.getPreferredSize();
            Dimension max = c.getMaximumSize();
            xChildren.add(new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX()));
            yChildren.add(new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension size;
        EastWestToolbarLayout eastWestToolbarLayout = this;
        synchronized (eastWestToolbarLayout) {
            this.checkContainer(target);
            this.checkRequests();
            size = new Dimension(this._xTotal.minimum, this._yTotal.minimum);
        }
        Insets insets = target.getInsets();
        size.width = (int)Math.min((long)size.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        size.height = (int)Math.min((long)size.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return size;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private final List<Component> getTargetComponents() {
        ArrayList<Component> components = new ArrayList<Component>(Arrays.asList(this.target.getComponents()));
        components.removeAll(this._east);
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Serializable c;
        this.checkContainer(target);
        List<Component> components = this.getTargetComponents();
        int nChildren = components.size();
        int[] xOffsets = new int[nChildren];
        int[] xSpans = new int[nChildren];
        int[] yOffsets = new int[nChildren];
        int[] ySpans = new int[nChildren];
        Dimension alloc = target.getSize();
        Insets in = target.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        EastWestToolbarLayout eastWestToolbarLayout = this;
        synchronized (eastWestToolbarLayout) {
            this.checkRequests();
            SizeRequirements.calculateTiledPositions(alloc.width, this._xTotal, this._xChildren, xOffsets, xSpans, true);
            SizeRequirements.calculateAlignedPositions(alloc.height, this._yTotal, this._yChildren, yOffsets, ySpans);
        }
        for (int i = 0; i < nChildren; ++i) {
            c = components.get(i);
            c.setBounds((int)Math.min((long)in.left + (long)xOffsets[i], Integer.MAX_VALUE), (int)Math.min((long)in.top + (long)yOffsets[i], Integer.MAX_VALUE), xSpans[i], ySpans[i]);
        }
        int minLeft = nChildren > 0 ? (int)Math.min((long)in.left + (long)xOffsets[nChildren - 1] + (long)xSpans[nChildren - 1], Integer.MAX_VALUE) : 0;
        nChildren = this._east.size();
        xOffsets = new int[nChildren];
        xSpans = new int[nChildren];
        yOffsets = new int[nChildren];
        ySpans = new int[nChildren];
        c = this;
        synchronized (c) {
            ArrayList<SizeRequirements> _xChildren_ = new ArrayList<SizeRequirements>();
            ArrayList<SizeRequirements> _yChildren_ = new ArrayList<SizeRequirements>();
            this.getSizeRequirements(this._east, _xChildren_, _yChildren_);
            SizeRequirements.calculateTiledPositions(alloc.width, this._xTotal, _xChildren_.toArray(new SizeRequirements[0]), xOffsets, xSpans, true);
            SizeRequirements.calculateAlignedPositions(alloc.height, this._yTotal, _yChildren_.toArray(new SizeRequirements[0]), yOffsets, ySpans);
        }
        int fullSpan = 0;
        for (int span : xSpans) {
            fullSpan += span;
        }
        for (int i = 0; i < nChildren; ++i) {
            Component c2 = this._east.get(i);
            int x = (int)Math.min((long)target.getSize().width - (long)in.right - (long)fullSpan + (long)xOffsets[i], Integer.MAX_VALUE);
            if (x < minLeft) {
                c2.setBounds(in.left, in.top, 0, 0);
                continue;
            }
            c2.setBounds(x, (int)Math.min((long)in.top + (long)yOffsets[i], Integer.MAX_VALUE), xSpans[i], ySpans[i]);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this._xTotal.alignment;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this._yTotal.alignment;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.checkContainer(target);
        this._xChildren = null;
        this._yChildren = null;
        this._xTotal = null;
        this._yTotal = null;
    }
}

