/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.resource.CompareArb;

public class ComparePreferencesPanel
extends DefaultTraversablePanel {
    private final JLabel _maxTextFileSizeLabel = new JLabel();
    private final JSpinner _maxTextFileSizeSpinner = new JSpinner();
    private final JCheckBox _ignoreWhitespace = new JCheckBox();
    private final JCheckBox _showCharDiff = new JCheckBox();
    private final JCheckBox _xmlCompareCheckBox = new JCheckBox();
    private final JCheckBox _javaCompareCheckBox = new JCheckBox();
    private final JLabel _maxFileSizeLabel = new JLabel();
    private final JSpinner _maxFileSizeSpinner = new JSpinner();
    private JPanel _panel;

    public ComparePreferencesPanel() {
        int step = (int)Math.pow(2.0, 2.0);
        this._maxTextFileSizeSpinner.setModel(new SpinnerNumberModel(step, step, Integer.MAX_VALUE, step));
        this._maxFileSizeSpinner.setModel(new SpinnerNumberModel(step, step, (int)Math.pow(2.0, 10.0), step));
        JComponent editor = this._maxTextFileSizeSpinner.getEditor();
        Dimension size = this._maxTextFileSizeSpinner.getEditor().getPreferredSize();
        size.width = SwingUtilities.computeStringWidth(editor.getFontMetrics(editor.getFont()), "1,234,567");
        this._maxTextFileSizeSpinner.getEditor().setPreferredSize(size);
        this._maxFileSizeSpinner.getEditor().setPreferredSize(size);
        JLabel textCompareLabel = new JLabel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)textCompareLabel, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._ignoreWhitespace, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._showCharDiff, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._maxTextFileSizeLabel, insets, 1, false, true);
        layoutBuilder.add((Component)this._maxTextFileSizeSpinner, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._javaCompareCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._xmlCompareCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._maxFileSizeLabel, insets, 1, false, true);
        layoutBuilder.add((Component)this._maxFileSizeSpinner, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        this._panel = new JPanel();
        layoutBuilder.addToPanel((Container)this._panel);
        ResourceUtils.resLabel((JLabel)textCompareLabel, (Component)textCompareLabel, (String)CompareArb.getString(28));
        ResourceUtils.resLabel((JLabel)this._maxTextFileSizeLabel, (Component)this._maxTextFileSizeSpinner, (String)CompareArb.getString(32));
        ResourceUtils.resButton((AbstractButton)this._ignoreWhitespace, (String)CompareArb.getString(29));
        ResourceUtils.resButton((AbstractButton)this._showCharDiff, (String)CompareArb.getString(30));
        ResourceUtils.resButton((AbstractButton)this._javaCompareCheckBox, (String)CompareArb.getString(57));
        ResourceUtils.resButton((AbstractButton)this._xmlCompareCheckBox, (String)CompareArb.getString(31));
        ResourceUtils.resLabel((JLabel)this._maxFileSizeLabel, (Component)this._maxFileSizeSpinner, (String)CompareArb.getString(33));
        this._xmlCompareCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ComparePreferencesPanel.this.updateComponentsEnabled();
            }
        });
        this.updateComponentsEnabled();
        this.setHelpID("f1_idedidesetcompare_html");
    }

    public Component getComponent() {
        if (this._panel != null) {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 5, 0, true, false));
            this.addToLayout();
            this.add(Box.createGlue());
            this._panel = null;
        }
        return this;
    }

    protected void addToLayout() {
        this.add(this._panel);
    }

    private void updateComponentsEnabled() {
        boolean xmlCompareEnabled = this._xmlCompareCheckBox.isSelected();
        this._maxFileSizeLabel.setEnabled(xmlCompareEnabled);
        this._maxFileSizeSpinner.setEnabled(xmlCompareEnabled);
    }

    public void onEntry(TraversableContext tc) {
        CompareOptions options = ComparePreferencesPanel.getCompareOptions(tc);
        this._maxTextFileSizeSpinner.setValue(options.getMaximumTextFileSize());
        this._ignoreWhitespace.setSelected(options.getIgnoreWhitespace());
        this._showCharDiff.setSelected(options.getShowCharDifferences());
        this._javaCompareCheckBox.setSelected(options.isJavaCompareEnabled());
        this._xmlCompareCheckBox.setSelected(options.isXMLCompareEnabled());
        this._maxFileSizeSpinner.setValue(options.getMaximumFileSize());
        this.updateComponentsEnabled();
    }

    public void onExit(TraversableContext tc) {
        CompareOptions options = ComparePreferencesPanel.getCompareOptions(tc);
        options.setMaximumTextFileSize(((Number)this._maxTextFileSizeSpinner.getValue()).intValue());
        options.setIgnoreWhitespace(this._ignoreWhitespace.isSelected());
        options.setShowCharDifferences(this._showCharDiff.isSelected());
        options.setJavaCompareEnabled(this._javaCompareCheckBox.isSelected());
        options.setXMLCompareEnabled(this._xmlCompareCheckBox.isSelected());
        options.setMaximumFileSize(((Number)this._maxFileSizeSpinner.getValue()).intValue());
    }

    private static CompareOptions getCompareOptions(TraversableContext tc) {
        return CompareOptions.getInstance(tc.getPropertyStorage());
    }
}

