/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.EventQueue;
import java.awt.Window;
import java.net.URL;
import java.util.BitSet;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.compare.CompareContext;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.FileNotComparableException;
import oracle.jdeveloper.compare.FileTooLargeException;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.resource.CompareArb;

public class CompareIdeViewer
extends CompareViewer {
    private CompareAddin _compareAddin;
    private JMenu m_mainCompareMenu;
    private JMenu m_contextCompareMenu;
    private MenuListener m_menuListener;

    public CompareIdeViewer(CompareAddin compareAddin) {
        this._compareAddin = compareAddin;
    }

    @Override
    public JMenu getMainCompareMenu() {
        if (this.m_mainCompareMenu == null) {
            this.m_mainCompareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.getString(0)), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(0))));
        }
        return this.m_mainCompareMenu;
    }

    @Override
    public JMenu getContextCompareMenu() {
        if (this.m_contextCompareMenu == null) {
            this.m_contextCompareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.getString(0)), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(0))), 0.2f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            this.m_menuListener = new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent me) {
                }

                @Override
                public void menuDeselected(MenuEvent me) {
                }

                @Override
                public void menuSelected(MenuEvent me) {
                    View active = Ide.getMainWindow().getLastActiveView();
                    Context context = active.getContext((EventObject)me);
                    IdeAction.find((int)((CompareIdeViewer)CompareIdeViewer.this)._compareAddin.m_eachOtherAction).updateAction(context);
                    IdeAction.find((int)((CompareIdeViewer)CompareIdeViewer.this)._compareAddin.m_otherFileAction).updateAction(context);
                    IdeAction.find((int)((CompareIdeViewer)CompareIdeViewer.this)._compareAddin.m_savedFileAction).updateAction(context);
                }
            };
            this.m_contextCompareMenu.addMenuListener(this.m_menuListener);
        }
        return this.m_contextCompareMenu;
    }

    @Override
    public void show(final CompareContributor left, final CompareContributor right, final Node contextNode) {
        Ide.getWaitCursor().show();
        Runnable r = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        new Thread(r).start();
    }

    private final void showOnFailure(final CompareContributor left, final CompareContributor right, final CompareInvocation invocationContext, CompareFailedException cfe) {
        invocationContext.setFailure(cfe);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareIdeViewer.this._show(left, right, null, invocationContext);
            }
        });
    }

    private void _show(CompareContributor left, CompareContributor right, CompareModel model, CompareInvocation invocationContext) {
        try {
            Context detailedContext = Context.newIdeContext();
            BitSet sequences = new BitSet();
            sequences.set(0);
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                URL url;
                if (!(editor instanceof CompareEditor) || !(url = editor.getContext().getNode().getURL()).getProtocol().startsWith("ide.compare")) continue;
                sequences.set(CompareURLHelper.getSequence(url));
            }
            URL u = CompareURLHelper.newCompareURL(left, right, sequences.nextClearBit(0));
            Node node = NodeFactory.find((URL)u);
            if (node != null && !(node instanceof CompareNode)) {
                Assert.println((String)"CompareIdeViewer: Warning: incompatible node cached against compare URL");
                NodeFactory.uncache((URL)u);
            }
            CompareNode cn = (CompareNode)NodeFactory.findOrCreate(CompareNode.class, (URL)u);
            cn.setSource(left);
            cn.setTarget(right);
            cn.setModel(model);
            if (model == null) {
                cn.setMessage(CompareIdeViewer.getCompareNotAvailableMessage(invocationContext, (Exception)((Object)invocationContext.getFailure())));
            }
            detailedContext.setNode((Node)cn);
            detailedContext.setElement((Element)cn);
            CompareContext.setContributors(detailedContext, new CompareContributor[]{left, right});
            EditorManager.getEditorManager().openEditorInFrame(CompareEditor.class, detailedContext);
        }
        catch (InstantiationException ie) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ie);
        }
        catch (IllegalAccessException ille) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ille);
        }
    }

    public static final String getCompareNotAvailableMessage(CompareInvocation invocationContext, Exception e) {
        if (invocationContext.isCanceled()) {
            return HistoryArb.getString(26);
        }
        if (e instanceof FileNotComparableException) {
            return HistoryArb.getString(29);
        }
        if (e instanceof FileTooLargeException) {
            return HistoryArb.getString(28);
        }
        if (e != null) {
            return HistoryArb.getString(27);
        }
        return HistoryArb.getString(25);
    }

    static /* synthetic */ void access$200(CompareIdeViewer x0, CompareContributor x1, CompareContributor x2, CompareInvocation x3, CompareFailedException x4) {
        x0.showOnFailure(x1, x2, x3, x4);
    }
}

