/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.ComparePopupManager;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdevimpl.compare.BaseCompareEditor;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.resource.CompareArb;

public class CompareEditor
extends BaseCompareEditor
implements StatusProvider,
FindableEditor,
ComparePopupManager {
    private JPanel _gui = new JPanel();
    private JLabel _statusLabel = new JLabel();
    private Toolbar _toolbar = new Toolbar();
    private CompareView _view;
    private ActionListener _defaultActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                IdeAction.find((int)CompareAddin.COMPARE_DIRECTORY_FILE_CMD_ID).performAction(CompareEditor.this.getContext());
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)CompareEditor.this.getGUI(), (Throwable)e);
            }
        }
    };
    private TextBuffer _textBuffer;

    public CompareEditor() {
        this._gui.setLayout(new BorderLayout());
        this._gui.add((Component)this._toolbar, "North");
    }

    public Component getDefaultFocusComponent() {
        if (!(this._view instanceof BaseCompareView)) {
            return super.getDefaultFocusComponent();
        }
        Component defaultFocusable = ((BaseCompareView)this._view).getFocusComponent();
        return defaultFocusable != null ? defaultFocusable : super.getDefaultFocusComponent();
    }

    @Override
    public CompareView getCompareView() {
        return this._view;
    }

    private void compare(CompareModel model) {
        int[] diffCount = model.getDifferenceTypeCounts();
        int total = model.getDifferenceCount();
        if (total == 0) {
            this._statusLabel.setText(CompareArb.getString(34));
        } else {
            this._statusLabel.setText(MessageFormat.format(CompareArb.getString(35), String.valueOf(total), String.valueOf(diffCount[0]), String.valueOf(diffCount[1]), String.valueOf(diffCount[2])));
        }
        this._view = CompareViewFactory.createCompareView((CompareModel)model);
        this._toolbar.removeAll();
        if (this._view instanceof BaseCompareView) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((BaseCompareView)CompareEditor.this._view).goToFirstDifference();
                }
            });
            final IdeAction goToPreviousAction = this.createLocalAction(Ide.findCmdID((String)"compare.navigatePrevious"));
            final IdeAction goToNextAction = this.createLocalAction(Ide.findCmdID((String)"compare.navigateNext"));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateFirst")));
            this._toolbar.add((ToggleAction)goToPreviousAction);
            this._toolbar.add((ToggleAction)goToNextAction);
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateLast")));
            ((BaseCompareView)this._view).addPositionListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    goToPreviousAction.updateAction();
                    goToNextAction.updateAction();
                }
            });
        }
        this.augmentToolbarComponents();
        if (this._view instanceof BaseCompareView) {
            ((BaseCompareView)this._view).addPopupManager((ComparePopupManager)this);
        }
        if (this._view instanceof ListCompareView) {
            ((ListCompareView)this._view).addDefaultActionListener(this._defaultActionListener);
        }
        this._gui.add(this._view.getGUI(), "Center");
    }

    protected IdeAction createLocalAction(int cmdId) {
        IdeAction ideAction = IdeAction.find((int)cmdId);
        return ideAction.newLocalAction((View)this);
    }

    public Component getBottomComponent() {
        if (this._view instanceof BaseCompareView) {
            return ((BaseCompareView)this._view).getHorizontalScrollComponent();
        }
        return super.getBottomComponent();
    }

    public Object getEditorAttribute(String attribute) {
        if (this._view instanceof BaseCompareView) {
            if ("scrollable".equals(attribute)) {
                return Boolean.FALSE;
            }
            if (attribute == "horizontal_scrollbar_policy") {
                return new Integer(31);
            }
            if (attribute == "vertical_scrollbar_policy") {
                return new Integer(21);
            }
        }
        if ("menu_id".equals(attribute)) {
            return CompareArb.getString(17);
        }
        return super.getEditorAttribute(attribute);
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null) {
            context.setView((View)this);
            context.setElement((Element)context.getNode());
        }
        return context;
    }

    public void open() {
        CompareModel model = ((CompareNode)this.getContext().getNode()).getModel();
        if (model == null) {
            String message = ((CompareNode)this.getContext().getNode()).getMessage();
            if (message == null) {
                CompareArb.getString(51);
            }
            this._gui.add((Component)new FocusableLabel(message), "Center");
            return;
        }
        this.compare(model);
        try {
            this.getContext().getNode().open();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void close() {
        if (this._view != null) {
            ((BaseCompareView)this._view).dispose();
        }
        super.close();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scscomparewindow_html");
    }

    public Component getGUI() {
        return this._gui;
    }

    public Controller getController() {
        return CompareController.getDefaultController();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public JComponent[] getCustomCells() {
        return new JComponent[]{this._statusLabel};
    }

    public boolean isExpandable(JComponent cell) {
        return true;
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._view instanceof EditorPaneView) {
            return ((EditorPaneView)this._view).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            Node element = context.getNode();
            context.setSelection(new Element[]{element});
            context.setElement((Element)element);
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup() {
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getNode() instanceof TextNode) {
            this._textBuffer = ((TextNode)context.getNode()).acquireTextBuffer();
        }
    }
}

