/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.history;

import oracle.ide.Context;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.history.DefaultHistoryEntry;

@FeedbackApi(value="BaseHistoryEntry")
public abstract class BaseHistoryEntry
extends DefaultHistoryEntry {
    public boolean canRestore(Context context) {
        return context.getNode() instanceof TextNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(Context context) throws Exception {
        Node node = context.getNode();
        CompareContributor contributor = this.getCompareContributor();
        if (!(contributor instanceof TextCompareContributor)) {
            if (FeedbackManager.isOn()) {
                FeedbackManager.reportException((Throwable)new IllegalStateException());
            }
            return;
        }
        if (!(context.getNode() instanceof TextNode)) {
            return;
        }
        TextBuffer inBuffer = ((TextCompareContributor)contributor).getTextBuffer();
        TextBuffer outBuffer = ((TextNode)node).acquireTextBuffer();
        inBuffer.readLock();
        outBuffer.beginEdit();
        try {
            outBuffer.removeToEnd(0);
            outBuffer.append(inBuffer.getChars(0, inBuffer.getLength()));
        }
        finally {
            inBuffer.readUnlock();
            outBuffer.endEdit();
        }
        node.save();
    }
}

