/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compare;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.Preferences;
import oracle.ide.model.ContentType;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdevimpl.compare.CompareOptions;
import oracle.jdevimpl.compare.CompareUtil;

public abstract class CompareMethod {
    public boolean recognizeContent(URL url) {
        return DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url)) != ContentType.BINARY;
    }

    public abstract boolean canCompare(CompareContributor var1, CompareContributor var2, StreamType var3);

    public boolean canMerge(CompareContributor left, CompareContributor right, CompareContributor ancestor) {
        return false;
    }

    public abstract CompareType getCompareType();

    public void processOptions() {
    }

    public boolean canFallBack(CompareFailedException cfe) {
        return true;
    }

    public CompareType[] getFallbackCompareTypes() {
        return null;
    }

    protected final StreamType getStreamType(CompareContributor contributor) {
        return CompareUtil.getStreamType(contributor);
    }

    protected final TextBuffer getTextBuffer(CompareContributor contributor) {
        return contributor instanceof TextCompareContributor ? ((TextCompareContributor)contributor).getTextBuffer() : null;
    }

    protected final String scanForXMLNamespaceURI(TextBuffer textBuffer, String name) {
        String s = textBuffer.getString(0, Math.min(512, textBuffer.getLength()));
        StringBuilder sb = new StringBuilder();
        sb.append("\\s*(<\\?[^\\?]*\\?>)?\\s*<[^>]*xmlns");
        if (name != null) {
            sb.append(":");
            sb.append(name);
        }
        sb.append("=\"([^\"]*).*");
        Matcher matcher = Pattern.compile(sb.toString(), 32).matcher(s);
        return matcher.matches() ? matcher.group(2) : null;
    }

    protected final CompareOptions getCompareOptions() {
        return CompareOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }
}

