/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServicesEnumeration
implements Enumeration<String> {
    private BufferedReader rdr = null;
    private String lastRead = null;
    private static final int COMMENT_CHAR = 35;
    private static final String XML_COMMENT_START = "<!--";
    private static final String XML_COMMENT_END = "-->";
    private static Logger logger = null;

    public ServicesEnumeration(Reader inRdr) {
        this.rdr = inRdr instanceof BufferedReader ? (BufferedReader)inRdr : new BufferedReader(inRdr);
        this.lastRead = this.readNextToken();
    }

    @Override
    public String nextElement() {
        String retThis = this.lastRead;
        this.lastRead = this.readNextToken();
        return retThis;
    }

    @Override
    public boolean hasMoreElements() {
        return this.lastRead != null;
    }

    public void close() {
        try {
            if (this.rdr != null) {
                this.rdr.close();
                this.rdr = null;
            }
        }
        catch (IOException e) {
            ServicesEnumeration.getLogger().log(Level.INFO, "close failed", e);
        }
    }

    private String readNextToken() {
        String lin2;
        try {
            lin2 = this.rdr.readLine();
            while (lin2 != null) {
                int pos = (lin2 = this.cleanHashComment(lin2)).indexOf(XML_COMMENT_START);
                if (pos != -1) {
                    int pos2 = lin2.indexOf(XML_COMMENT_END);
                    if (pos2 != -1) {
                        String rawLin = lin2;
                        lin2 = rawLin.substring(0, pos) + " " + rawLin.substring(pos2 + XML_COMMENT_END.length());
                    } else {
                        String otherLin = null;
                        while (pos2 == -1) {
                            otherLin = this.rdr.readLine();
                            if (otherLin == null) {
                                pos2 = -1;
                                lin2 = lin2.substring(0, pos);
                                break;
                            }
                            otherLin = this.cleanHashComment(otherLin);
                            pos2 = otherLin.indexOf(XML_COMMENT_END);
                        }
                        if (pos2 != -1) {
                            lin2 = lin2.substring(0, pos) + " " + otherLin.substring(pos2 + XML_COMMENT_END.length());
                        }
                    }
                }
                if ((lin2 = lin2.trim()).length() <= 0) {
                    lin2 = this.rdr.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            ServicesEnumeration.getLogger().log(Level.WARNING, "read failed", e);
            Object lin2 = null;
            throw new RuntimeException(e);
        }
        return lin2;
    }

    private final String cleanHashComment(String lin) {
        int pos = lin.indexOf(35);
        if (pos != -1) {
            lin = lin.substring(0, pos);
        }
        return lin.trim();
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(ServicesEnumeration.class.getName());
        }
        return logger;
    }
}

