/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.impl.URLUtil;
import oracle.adf.share.services.ServiceRef;
import oracle.adf.share.services.Services;
import oracle.adf.share.services.impl.URLStreamProviderFactory;

public class ServicesFactory {
    private static final String SERVICES_DIR = "META-INF/";
    private static final String SERVICES_EXT = ".sva";
    private static Logger logger = Logger.getLogger(ServicesFactory.class.getName());
    private static final boolean logging = !Beans.isDesignTime();

    public static List<ServiceRef> findServiceRefs(String serviceName, ClassLoader loader) throws IOException {
        boolean isLibServiceFile = false;
        if (serviceName == null || serviceName.length() == 0) {
            serviceName = Services.class.getName();
        }
        if (serviceName.equalsIgnoreCase("oracle.adf.common.services.ResourceService")) {
            isLibServiceFile = true;
        }
        String entryName = ServicesFactory.getServiceFileName(serviceName);
        if (loader == null) {
            loader = ClassUtils.getClassLoader(ServicesFactory.class);
        }
        Enumeration<URL> resources = loader.getResources(entryName);
        return new ResultCreator().getResults(resources, isLibServiceFile);
    }

    public static String getServiceFileName(String serviceName) {
        return SERVICES_DIR + serviceName + SERVICES_EXT;
    }

    private static class ServiceRefImpl
    implements ServiceRef {
        private static final Class[] SERVICE_CONSTRUCTOR_PARAM_TYPES = new Class[]{URL.class, Enumeration.class};
        URL url;
        boolean isLibServiceFile;
        private static final String ENUM_CLASS_NAME = "oracle.adf.share.services.impl.ServicesEnumeration";
        private static final String ENUM_METH_NAME = "close";
        private static Class ENUM_CLASS = null;
        private static Constructor ENUM_CTOR = null;
        private static final Class[] ENUM_CTOR_TYPES = new Class[]{Reader.class};
        private static Method ENUM_METH = null;
        private static final Class[] EMPTY_TYPES = new Class[0];
        private static final Object[] EMPTY_PARAMS = new Object[0];

        public ServiceRefImpl(URL url, boolean isLibServiceFile) {
            try {
                this.url = URLUtil.getURLForPath(url, false);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(String.valueOf(url), e);
            }
            this.isLibServiceFile = isLibServiceFile;
            if (logging) {
                logger.fine("ServiceRef created for: " + this.url);
            }
        }

        @Override
        public URL getServiceURL() {
            return this.url;
        }

        @Override
        public Services getService() {
            Enumeration<String> svcs = null;
            Class svcClass = null;
            Services svc = null;
            String svcImplClassName = null;
            InputStream ins = null;
            try {
                if (logging) {
                    logger.fine("Getting enum for: " + this.url);
                }
                ins = URLStreamProviderFactory.getProvider().openStream(this.url);
                svcs = ServiceRefImpl.openEnumeration(new InputStreamReader(ins, "UTF-8"));
                if (this.isLibServiceFile) {
                    svcImplClassName = "oracle.adf.share.services.impl.ADFServicesImpl";
                } else if (svcs.hasMoreElements()) {
                    svcImplClassName = svcs.nextElement();
                }
                if (svcImplClassName != null) {
                    if (logging) {
                        logger.fine("ServicesFactory init: " + svcImplClassName + " for " + this.url);
                    }
                    svcClass = ClassUtils.forName(svcImplClassName);
                    Constructor ctor = svcClass.getConstructor(SERVICE_CONSTRUCTOR_PARAM_TYPES);
                    svc = (Services)ctor.newInstance(this.url, svcs);
                    if (logging) {
                        logger.fine("ServicesFactory init done: " + svcImplClassName);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (svcs != null) {
                    if (logging) {
                        logger.fine("closing enumeration for: " + this.url);
                    }
                    ServiceRefImpl.closeEnumeration(svcs);
                } else if (ins != null) {
                    try {
                        if (logging) {
                            logger.fine("closing 'ins' in enumeration");
                        }
                        ins.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, this.url + " input stream close failed", e);
                    }
                }
            }
            return svc;
        }

        private static Enumeration<String> openEnumeration(Reader rdr) {
            try {
                if (ENUM_CTOR == null) {
                    ENUM_CLASS = ClassUtils.forName(ENUM_CLASS_NAME);
                    ENUM_CTOR = ENUM_CLASS.getConstructor(ENUM_CTOR_TYPES);
                }
                Object[] args = new Object[]{rdr};
                return (Enumeration)ENUM_CTOR.newInstance(args);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private static void closeEnumeration(Enumeration<String> svcEnum) {
            try {
                if (ENUM_METH == null) {
                    ENUM_METH = ENUM_CLASS.getMethod(ENUM_METH_NAME, EMPTY_TYPES);
                }
                ENUM_METH.invoke(svcEnum, EMPTY_PARAMS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ResultCreator {
        private ResultCreator() {
        }

        public List<ServiceRef> getResults(Enumeration<URL> resources, boolean isLibServiceFile) {
            ArrayList<ServiceRef> results = new ArrayList<ServiceRef>();
            while (resources.hasMoreElements()) {
                results.add(new ServiceRefImpl(resources.nextElement(), isLibServiceFile));
            }
            return results;
        }
    }
}

