/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResourceIcon
implements Icon {
    private boolean mIsIconResolved = false;
    private Icon mIcon = null;
    private String mSourceUri = null;
    private String mDescription = null;
    private String mRuntimeUri = null;
    private StackTraceElement[] mConstructorStackTrace = null;
    private IllegalStateException mRootCause = null;
    private String mExceptionMessage = null;

    public ResourceIcon(String source) {
        assert (source != null && source.length() > 0);
        this.mSourceUri = source;
        Exception e = new Exception();
        StackTraceElement[] fullStack = e.getStackTrace();
        int maxStackSize = 10;
        this.mConstructorStackTrace = new StackTraceElement[10];
        if (fullStack.length > 0) {
            int elementsToCopy = fullStack.length > 10 ? 10 : fullStack.length;
            System.arraycopy(fullStack, 0, this.mConstructorStackTrace, 0, elementsToCopy);
        }
    }

    public ResourceIcon(String source, String description) {
        this(source);
        this.mDescription = description;
    }

    @Override
    public int getIconWidth() {
        Icon icon = this.getIcon();
        return icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        Icon icon = this.getIcon();
        return icon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getIcon();
        icon.paintIcon(c, g, x, y);
    }

    public String getRuntimeUri() {
        if (this.mRuntimeUri == null) {
            int startIdx = this.mSourceUri.indexOf("META-INF");
            this.mRuntimeUri = startIdx >= 0 ? this.mSourceUri.substring(startIdx + 8) : this.mSourceUri;
        }
        return this.mRuntimeUri;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private Icon getIcon() {
        if (this.mIcon == null) {
            if (!this.mIsIconResolved) {
                this.mIsIconResolved = true;
                ClassLoader ldr = Thread.currentThread().getContextClassLoader();
                URL iconUrl = ldr.getResource(this.mSourceUri);
                if (iconUrl != null) {
                    this.mIcon = new ImageIcon(iconUrl, this.mDescription);
                    if (this.mIcon != null) {
                        this.mConstructorStackTrace = null;
                    }
                }
            }
            if (this.mIcon == null) {
                IllegalStateException ise = new IllegalStateException(this.getExceptionMessage());
                ise.initCause(this.getRootCause());
                throw ise;
            }
        }
        return this.mIcon;
    }

    private IllegalStateException getRootCause() {
        if (this.mRootCause == null) {
            this.mRootCause = new IllegalStateException(this.getExceptionMessage());
            this.mRootCause.setStackTrace(this.mConstructorStackTrace);
            this.mConstructorStackTrace = null;
        }
        return this.mRootCause;
    }

    private String getExceptionMessage() {
        if (this.mExceptionMessage == null) {
            StringBuilder builder = new StringBuilder(100);
            builder.append("Cannot resolve icon URI: ");
            builder.append(this.mSourceUri);
            this.mExceptionMessage = builder.toString();
        }
        return this.mExceptionMessage;
    }
}

