/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.beans.Beans;
import java.util.logging.Level;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.Noun;

public class Counter
extends ADFPerfSensor {
    private Event mEvent;
    public static final Counter DUMMY_COUNTER = new DummyCounter();

    private Counter(Level level, String sensorFullName, Event event) {
        super(level, sensorFullName);
        this.mEvent = event;
    }

    protected Counter() {
    }

    public void increase() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mEvent.occurred();
        if (this.mEnablePerfLog) {
            Object value = this.mEvent.getValue(2);
            this.log(System.currentTimeMillis(), value.toString(), null);
        }
    }

    public long getValue() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return -1L;
        }
        Object value = this.mEvent.getValue(2);
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public void reset() {
        if (this.mEvent != null) {
            this.mEvent.reset();
        }
    }

    public static Counter createCounter(Level level, String groupName, String name, String desc) {
        if (Beans.isDesignTime()) {
            return DUMMY_COUNTER;
        }
        String nounType = LoggingUtils.getNounType(groupName);
        return Counter.createCounter(level, groupName, name, nounType, desc);
    }

    public static Counter createCounter(Level level, String groupName, String name, String type, String desc) {
        if (Beans.isDesignTime()) {
            return DUMMY_COUNTER;
        }
        name = LoggingUtils.standardizeSensorName(name);
        StringBuffer groupNameBuf = LoggingUtils.standardizeGroupName(groupName);
        groupNameBuf.append('/').append(name).append(" ").append("c");
        String fullName = groupNameBuf.toString();
        ADFPerfSensor counter = SensorTable.getSensor(fullName);
        if (counter != null && counter instanceof Counter) {
            return (Counter)counter;
        }
        Event et = null;
        if (sLogger.isLoggable(level) || LoggingUtils.isDMSLoggingEnabled(level)) {
            Noun parentNoun = Noun.get((String)groupName);
            if (parentNoun == null) {
                parentNoun = Noun.create((String)groupName);
            }
            if (parentNoun.getType() == "n/a") {
                parentNoun.setType(type);
            }
            et = Event.create((Noun)parentNoun, (String)name, (String)desc);
            et.deriveMetric(511);
        }
        Counter tr = new Counter(level, fullName, et);
        tr = (Counter)SensorTable.putSensor(fullName, tr);
        return tr;
    }

    private static class DummyCounter
    extends Counter {
        private static final String sName = "Dummy Counter";

        private DummyCounter() {
        }

        @Override
        public void increase() {
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void reset() {
        }

        public String toString() {
            return sName;
        }

        @Override
        public long getValue() {
            return super.getValue();
        }
    }
}

