/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class ConsoleFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    private String getShortClassName(String clazz) {
        if (clazz == null) {
            return clazz;
        }
        String[] segs = clazz.split("\\.");
        return segs[segs.length - 1];
    }

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String clazzName = record.getSourceClassName();
        String methodName = record.getSourceMethodName();
        clazzName = this.getShortClassName(clazzName);
        String message = this.formatMessage(record);
        sb.append("<");
        sb.append(clazzName);
        sb.append(">").append(" ");
        sb.append("<");
        sb.append(methodName);
        sb.append("> ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

