/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.analytics;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import oracle.adf.share.logging.internal.LogLine;
import oracle.adf.share.logging.internal.LoggingConstants;

public class AnalyticsFormatter
extends Formatter {
    @Override
    public String formatMessage(LogRecord record) {
        if (!(record instanceof LogLine)) {
            return super.formatMessage(record);
        }
        LogLine line = (LogLine)record;
        LinkedList recordList = line.getRecordList();
        if (recordList != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(line.getMessage());
            sb.append(" ");
            ListIterator it = recordList.listIterator();
            while (it.hasNext()) {
                LogRecord lr = (LogRecord)it.next();
                sb.append(lr.getMessage());
                sb.append(" ");
            }
            sb.append(LoggingConstants.LINE_SEPARATOR);
            return sb.toString();
        }
        return null;
    }

    @Override
    public String format(LogRecord record) {
        return this.formatMessage(record);
    }
}

