/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jsp;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.LibraryUtils;
import oracle.adf.share.common.rc.util.LoaderUtil;

public class ADFLibUtils {
    private static final String INSTANCE_NAME = ADFLibUtils.class.getName();
    private static Logger logger = Logger.getLogger(INSTANCE_NAME);
    public static final String OVERRIDE_CLASS_NAME = INSTANCE_NAME + "_overrideClassName";
    private static final String DEFAULT_CLASS_NAME = "oracle.adf.library.webapp.LibraryUtils";
    private volatile ClassLoader _loader = null;
    protected volatile ServletContext _sc;

    public static ADFLibUtils getInstance(ServletContext sc) {
        String className;
        ADFLibUtils ut = null;
        if (sc != null) {
            ut = (ADFLibUtils)sc.getAttribute(INSTANCE_NAME);
        }
        if (ut != null) {
            return ut;
        }
        if (sc != null && (className = (String)sc.getAttribute(OVERRIDE_CLASS_NAME)) != null && className.length() > 0 && (ut = ADFLibUtils.newInstance(sc, className, Level.SEVERE)) != null) {
            sc.setAttribute(INSTANCE_NAME, (Object)ut);
            return ut;
        }
        ut = ADFLibUtils.newInstance(sc, DEFAULT_CLASS_NAME, sc != null ? Level.WARNING : Level.FINE);
        if (ut != null) {
            if (sc != null) {
                sc.setAttribute(INSTANCE_NAME, (Object)ut);
            }
            return ut;
        }
        return new ADFLibUtils(null);
    }

    private static ADFLibUtils newInstance(ServletContext sc, String className, Level level) {
        try {
            Constructor ctor = ClassUtils.forName(className, ADFLibUtils.class).getConstructor(ServletContext.class);
            ADFLibUtils utils = (ADFLibUtils)ctor.newInstance(sc);
            return utils;
        }
        catch (Exception e) {
            if (level.intValue() > Level.WARNING.intValue()) {
                throw new RuntimeException(e);
            }
            logger.log(level, "Failed to instantiate: " + className, e);
            return null;
        }
    }

    protected ADFLibUtils(ServletContext sc) {
        this._sc = sc;
    }

    public ClassLoader getADFLibraryLoader() {
        if (this._loader == null) {
            try {
                this._loader = LoaderUtil.getLoader(this.getADFLibraryURLs(), null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this._loader;
    }

    protected void setADFLibraryLoader(ClassLoader loader) {
        if (logger.isLoggable(Level.FINE) && this._loader != null && loader != null) {
            logger.fine("Replacing existing class loader!");
        }
        this._loader = loader;
    }

    public URL[] getADFLibraryURLs() throws IOException {
        ClassLoader lookup = Thread.currentThread().getContextClassLoader();
        if (lookup == null) {
            ADFLibUtils.class.getClassLoader();
        }
        return LibraryUtils.getADFLibraryURLs(lookup);
    }

    public URL[] getADFLibraryURLs(ClassLoader lookup) throws IOException {
        return LibraryUtils.getADFLibraryURLs(lookup);
    }
}

