/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.utils;

import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenKeyword;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataFilterApplyFor;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataProviderList;
import com.adbs.ast.MetadataRelationCardinality;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.SQLExpressionAnd;
import com.adbs.ast.SQLExpressionBrackets;
import com.adbs.ast.SQLExpressionConstant;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLogicalCollection;
import com.adbs.ast.SQLExpressionNot;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLExpressionOr;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.querybuilder.ConditionType;
import com.adbs.querybuilder.ItemSortType;
import com.adbs.querybuilder.LinkPainter;
import com.adbs.querybuilder.LinkPainterAccess;
import com.adbs.querybuilder.LinkPainterMSSQL;
import com.adbs.querybuilder.LinkPainterSimple;
import com.adbs.querybuilder.LinkPainters;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.AccessSyntaxProvider;
import com.adbs.syntax.AutoSyntaxProvider;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2SyntaxProvider;
import com.adbs.syntax.FirebirdSyntaxProvider;
import com.adbs.syntax.InformixSyntaxProvider;
import com.adbs.syntax.MSSQLSyntaxProvider;
import com.adbs.syntax.MySQLSyntaxProvider;
import com.adbs.syntax.OracleSyntaxProvider;
import com.adbs.syntax.PostgreSQLSyntaxProvider;
import com.adbs.syntax.SQL2003SyntaxProvider;
import com.adbs.syntax.SQL89SyntaxProvider;
import com.adbs.syntax.SQL92SyntaxProvider;
import com.adbs.syntax.SQLiteSyntaxProvider;
import com.adbs.syntax.SybaseSyntaxProvider;
import com.adbs.syntax.SyntaxProviderList;
import com.adbs.syntax.UniversalSyntaxProvider;
import com.adbs.utils.Localizer;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Helpers {
    public static final Localizer localizer = new Localizer();
    public static boolean collectDebugInfo = false;
    public static String[] sortTypeNames = new String[3];
    public static String[] conditionTypes = new String[3];
    public static final EnumSet<MetadataFilterApplyFor> metadataFilterApplyForAll = EnumSet.allOf(MetadataFilterApplyFor.class);
    public static final SyntaxProviderList syntaxProviderList = new SyntaxProviderList();
    public static final MetadataProviderList metadataProviderList = new MetadataProviderList();
    public static final EnumSet<ConditionType> conditionsWhereCompatible = EnumSet.of(ConditionType.None, ConditionType.Where);
    public static final EnumSet<ConditionType> conditionsHavingCompatible = EnumSet.of(ConditionType.None, ConditionType.Having);
    public static final EnumSet<ConditionType> conditionsAll = EnumSet.allOf(ConditionType.class);
    public static Icon accessLinkCardinality1;
    public static Icon accessLinkCardinalityMany;
    public static LinkPainter defaultLinkPainter;
    public static LinkPainters linkPainterList;
    public static int[] TFieldTypeConversionHelper;
    public static HashMap<String, Integer> DbTypeConversionHelper;

    public static String sqlQuoteString(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if (s.charAt(i) != '\'') continue;
            sb.append('\'');
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String sqlUnquoteString(String value) {
        if (value.length() > 1 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            String s = value.substring(1, value.length() - 1);
            return s.replace("''", "'");
        }
        return value;
    }

    public static String typeToString(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case -15: {
                return "NCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN";
    }

    public static JButton findOkButton(Container container) {
        assert (container != null);
        JButton result = null;
        for (Component c : container.getComponents()) {
            if (c == null) continue;
            if (c instanceof JButton) {
                String command = ((JButton)c).getActionCommand();
                if (command != null && command.equals("OK")) {
                    result = (JButton)c;
                }
            } else if (c instanceof Container) {
                result = Helpers.findOkButton((Container)c);
            }
            if (result != null) break;
        }
        return result;
    }

    public static void listMove(List list, int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= list.size()) {
            return;
        }
        if (newIndex < 0 || newIndex >= list.size()) {
            return;
        }
        Object item = list.get(oldIndex);
        list.remove(oldIndex);
        list.add(newIndex, item);
    }

    public static void listSetSize(List list, int newLength, boolean disposeOrphaned) {
        block6: {
            block5: {
                assert (newLength >= 0);
                if (list == null) {
                    return;
                }
                if (newLength >= list.size()) break block5;
                for (int i = list.size() - 1; i >= newLength; --i) {
                    Object o;
                    if (disposeOrphaned && (o = list.get(i)) instanceof Disposable) {
                        ((Disposable)o).dispose();
                    }
                    list.remove(i);
                }
                break block6;
            }
            if (newLength <= list.size()) break block6;
            for (int i = list.size(); i < newLength; ++i) {
                list.add(null);
            }
        }
    }

    public static void listExchange(List list, int first, int second) {
        Object item = list.get(first);
        list.set(first, list.get(second));
        list.set(second, item);
    }

    public static SQLExpressionItem transformExpression(SQLExpressionItem e) {
        SQLExpressionItem result;
        if (e instanceof SQLExpressionLogicalCollection) {
            SQLExpressionLogicalCollection lc = (SQLExpressionLogicalCollection)e;
            for (int i = lc.getCount() - 1; i >= 0; --i) {
                SQLExpressionItem ei = Helpers.transformExpression(lc.extract(i));
                if (ei == null) continue;
                lc.insert(i, ei);
            }
            result = e;
        } else if (e instanceof SQLExpressionNot) {
            result = e;
            SQLExpressionItem ei = ((SQLExpressionNot)result).lExpression;
            ((SQLExpressionNot)result).lExpression = Helpers.transformExpression(ei);
        } else if (e instanceof SQLExpressionBrackets) {
            result = e;
            SQLExpressionItem ei = ((SQLExpressionBrackets)result).lExpression;
            ((SQLExpressionBrackets)result).lExpression = Helpers.transformExpression(ei);
        } else if (e instanceof SQLExpressionOperatorBinary) {
            SQLExpressionOperatorBinary eb = (SQLExpressionOperatorBinary)e;
            if (eb.lExpression != null && eb.lExpression.isLogical() && eb.rExpression instanceof SQLExpressionConstant && eb.operatorObj.operatorName.equals("=")) {
                SQLExpressionConstant ec = (SQLExpressionConstant)eb.rExpression;
                if (ec.getCount() == 1 && ec.get(0) instanceof AstTokenKeyword) {
                    String s = ((AstTokenKeyword)ec.get(0)).getToken().toUpperCase();
                    if (s.equals("TRUE") || s.equals("FALSE")) {
                        boolean haveNot = s.equals("FALSE");
                        result = eb.lExpression;
                        eb.lExpression = null;
                        eb = null;
                        if (haveNot) {
                            result = new SQLExpressionNot(result.getSQLContext(), result);
                        }
                    } else {
                        result = e;
                    }
                } else {
                    result = e;
                }
            } else {
                result = e;
            }
        } else {
            result = e;
        }
        return result;
    }

    public static boolean tryStrToDouble(String s, Wrapper<Double> value) {
        boolean result = true;
        try {
            value.value = Double.parseDouble(s);
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static int guessTypeFromXMLValue(String value) {
        Integer result;
        block3: {
            result = null;
            try {
                result = Integer.parseInt(value);
            }
            catch (Exception ex) {
                result = DbTypeConversionHelper.get(value);
                if (result != null) break block3;
                result = 1111;
            }
        }
        if (result == null) {
            return 1111;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listAssign(List mainList, List listA, ListAssignOp oper, List listB) {
        List lSource;
        if (listB != null) {
            lSource = listB;
            Helpers.listAssign(mainList, listA, ListAssignOp.Copy, null);
        } else {
            lSource = listA;
        }
        switch (oper) {
            case Copy: {
                mainList.clear();
                for (int i = 0; i < lSource.size(); ++i) {
                    mainList.add(lSource.get(i));
                }
                break;
            }
            case And: {
                for (int i = mainList.size() - 1; i >= 0; --i) {
                    if (lSource.indexOf(mainList.get(i)) != -1) continue;
                    mainList.remove(i);
                }
                break;
            }
            case Or: {
                for (int i = 0; i < lSource.size(); ++i) {
                    if (mainList.indexOf(lSource.get(i)) != -1) continue;
                    mainList.add(lSource.get(i));
                }
                break;
            }
            case Xor: {
                ArrayList lTemp = new ArrayList();
                try {
                    int i;
                    for (i = 0; i < lSource.size(); ++i) {
                        if (mainList.indexOf(lSource.get(i)) != -1) continue;
                        lTemp.add(lSource.get(i));
                    }
                    for (i = mainList.size() - 1; i >= 0; --i) {
                        if (lSource.indexOf(mainList.get(i)) == -1) continue;
                        mainList.remove(i);
                    }
                    for (i = 0; i < lTemp.size(); ++i) {
                        mainList.add(lTemp.get(i));
                    }
                    break;
                }
                finally {
                    lTemp = null;
                }
            }
            case SrcUnique: {
                for (int i = mainList.size() - 1; i >= 0; --i) {
                    if (lSource.indexOf(mainList.get(i)) == -1) continue;
                    mainList.remove(i);
                }
                break;
            }
            case DestUnique: {
                ArrayList lTemp = new ArrayList();
                try {
                    for (int i = lSource.size() - 1; i >= 0; --i) {
                        if (mainList.indexOf(lSource.get(i)) != -1) continue;
                        lTemp.add(lSource.get(i));
                    }
                    Helpers.listAssign(mainList, lTemp, ListAssignOp.Copy, null);
                    break;
                }
                finally {
                    lTemp = null;
                }
            }
        }
    }

    public static boolean matchesMask(String mask, String text, boolean caseSensitive) {
        String expr = mask.replace("*", "\\*");
        expr = expr.replace(".", "\\.");
        expr = expr.replace("%", ".*");
        expr = expr.replace("_", ".");
        expr = expr.replace("$", "\\$");
        if (caseSensitive) {
            return Pattern.matches("^" + expr + "$", text);
        }
        return Pattern.matches("(?i)^" + expr + "$", text);
    }

    public static Element createNodeWithValue(Document doc, String nodeName, Object value) {
        Element result = doc.createElement(nodeName);
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                result.setTextContent("1");
            } else {
                result.setTextContent("0");
            }
        } else {
            result.setTextContent(value.toString());
        }
        return result;
    }

    public static String getValueFromChildNode(Node node, String childName) {
        Element child = Helpers.findChildElByName(childName, node);
        if (child != null) {
            return child.getTextContent();
        }
        return null;
    }

    public static Node findChildByName(String childName, Node where) {
        Node result = null;
        for (Node n = where.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals(childName)) continue;
            return n;
        }
        return result;
    }

    public static Element findChildElByName(String childName, Node where) {
        Node child = Helpers.findChildByName(childName, where);
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static Element findChildByNameAndAttribute(String nodeName, String attrName, Object attrValue, Node where) {
        Element result = null;
        for (Node i = where.getFirstChild(); i != null; i = i.getNextSibling()) {
            if (!(i instanceof Element)) continue;
            Element e = (Element)i;
            if (!i.getNodeName().equals(nodeName) || e == null || !e.getAttribute(attrName).equals((String)attrValue)) continue;
            result = e;
            break;
        }
        return result;
    }

    public static Element createNodeWithValueParent(Document doc, Element parent, String nodeName, Object value) {
        Element result = Helpers.createNodeWithValue(doc, nodeName, value);
        parent.appendChild(result);
        return result;
    }

    public static Element createNodeParent(Document doc, Element parent, String nodeName) {
        Element result = doc.createElement(nodeName);
        parent.appendChild(result);
        return result;
    }

    public static Object transformNodeValue(Object value) {
        Object result = value instanceof Boolean ? (((Boolean)value).booleanValue() ? Integer.valueOf(1) : Integer.valueOf(0)) : value;
        return result;
    }

    public static boolean isExpressionsEqual(SQLExpressionItem e1, SQLExpressionItem e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        assert (e1.getSQLContext() == e2.getSQLContext());
        assert (e1.getSQLContext() != null);
        BaseSQLContext context = e1.getSQLContext();
        String se1 = e1.getSimpleSQL(context.getSQLBuilderExpressionForServer());
        String se2 = e2.getSimpleSQL(context.getSQLBuilderExpressionForServer());
        return se1.equals(se2);
    }

    public static boolean isQualifiedNameEmpty(SQLQualifiedName name) {
        return name == null || name.getCount() == 0 && Helpers.isQualifiedNameEmpty(name.dbLink);
    }

    public static int simpleCompareTokens(AstToken token1, AstToken token2) {
        assert (token1 != null);
        assert (token2 != null);
        return token1.getToken().compareToIgnoreCase(token2.getToken());
    }

    public static int simpleCompareQualifiedNames(SQLQualifiedName name1, SQLQualifiedName name2) {
        assert (name1 != null);
        assert (name2 != null);
        int result = name1.dbLink == null && name2.dbLink != null ? -1 : (name1.dbLink != null && name2.dbLink == null ? 1 : (name1.dbLink == null && name2.dbLink == null ? 0 : Helpers.simpleCompareQualifiedNames(name1.dbLink, name2.dbLink)));
        if (result != 0) {
            return result;
        }
        if (name1.getCount() < name2.getCount()) {
            result = -1;
        } else if (name1.getCount() > name2.getCount()) {
            result = 1;
        } else if (name1.getCount() == 0 && name2.getCount() == 0) {
            result = 0;
        } else {
            for (int i = name1.getCount() - 1; i >= 0; --i) {
                AstToken t1 = name1.get(i);
                AstToken t2 = name2.get(i);
                assert (t1 != null);
                assert (t2 != null);
                result = Helpers.simpleCompareTokens(t1, t2);
                if (result == 0) continue;
                return result;
            }
        }
        return result;
    }

    public static SQLExpressionItem expressionRemoveBrackets(SQLExpressionItem expression) {
        SQLExpressionItem result = expression;
        while (result != null && result instanceof SQLExpressionBrackets) {
            result = ((SQLExpressionBrackets)result).lExpression;
        }
        return result;
    }

    public static SQLExpressionItem expressionExtractFromBrackets(SQLExpressionItem expression) {
        SQLExpressionBrackets parentBrackets = null;
        SQLExpressionItem result = expression;
        while (result != null && result instanceof SQLExpressionBrackets) {
            parentBrackets = (SQLExpressionBrackets)result;
            result = parentBrackets.lExpression;
        }
        if (parentBrackets != null) {
            parentBrackets.lExpression = null;
        }
        return result;
    }

    public static SQLExpressionItem prepareLogicalExpressionForLoading(SQLExpressionItem e) {
        SQLExpressionItem ei = Helpers.expressionExtractFromBrackets(e);
        if (ei != e) {
            e.dispose();
        }
        ei = Helpers.simplifyLogicalExpression(ei);
        return ei;
    }

    public static SQLExpressionItem simplifyLogicalExpression(SQLExpressionItem expressionItem) {
        SQLExpressionItem result = Helpers.expressionRemoveBrackets(expressionItem);
        if (result != null && result instanceof SQLExpressionNot || result instanceof SQLExpressionLogicalCollection) {
            Wrapper<SQLExpressionItem> ei;
            result = Helpers.removeNots(expressionItem);
            if (Helpers.canMoveNotsInItems(result, ei = new Wrapper<SQLExpressionItem>(expressionItem))) {
                expressionItem = (SQLExpressionItem)ei.value;
                result = Helpers.moveNotInLogicalCollection((SQLExpressionNot)result, (SQLExpressionLogicalCollection)expressionItem);
            }
            if (result != null && result instanceof SQLExpressionLogicalCollection) {
                Helpers.processItems((SQLExpressionLogicalCollection)result);
                if (((SQLExpressionLogicalCollection)result).getCount() == 0) {
                    result = null;
                }
            }
            if (result != null && result instanceof SQLExpressionLogicalCollection) {
                if (result instanceof SQLExpressionOr) {
                    Helpers.removeBracketsInORExpression((SQLExpressionOr)result);
                } else if (result instanceof SQLExpressionAnd) {
                    Helpers.removeBracketsInAndExpression((SQLExpressionAnd)result);
                }
            }
        } else {
            result = expressionItem;
        }
        return result;
    }

    private static SQLExpressionItem removeExternalBrackets(SQLExpressionItem ei) {
        SQLExpressionItem result = ei;
        while (result != null && result instanceof SQLExpressionBrackets) {
            SQLExpressionBrackets b = (SQLExpressionBrackets)result;
            result = b.lExpression;
            b.lExpression = null;
            b.dispose();
        }
        return result;
    }

    private static boolean canRemove2Nots(SQLExpressionItem s, Wrapper<SQLExpressionItem> ei) {
        boolean result;
        while (s != null && s instanceof SQLExpressionBrackets) {
            s = ((SQLExpressionBrackets)s).lExpression;
        }
        boolean bl = result = s != null && s instanceof SQLExpressionNot && ((SQLExpressionNot)s).lExpression != null;
        if (result) {
            ei.value = ((SQLExpressionNot)s).lExpression;
            while (ei.value != null && ei.value instanceof SQLExpressionBrackets) {
                ei.value = ((SQLExpressionBrackets)ei.value).lExpression;
            }
            result = ei.value != null && ei.value instanceof SQLExpressionNot;
        } else {
            ei.value = null;
        }
        return result;
    }

    private static SQLExpressionItem removeNots(SQLExpressionItem s) {
        Wrapper<SQLExpressionItem> ei = new Wrapper<SQLExpressionItem>();
        while (Helpers.canRemove2Nots(s, ei)) {
            SQLExpressionItem ei2 = ((SQLExpressionNot)ei.value).lExpression;
            ((SQLExpressionNot)ei.value).lExpression = null;
            s.dispose();
            s = ei2;
        }
        return s;
    }

    private static boolean canMoveNotsInItems(SQLExpressionItem s, Wrapper<SQLExpressionItem> ei) {
        boolean result;
        while (s != null && s instanceof SQLExpressionBrackets) {
            s = ((SQLExpressionBrackets)s).lExpression;
        }
        boolean bl = result = s != null && s instanceof SQLExpressionNot && ((SQLExpressionNot)s).lExpression != null;
        if (result) {
            ei.value = ((SQLExpressionNot)s).lExpression;
            while (ei.value != null && ei.value instanceof SQLExpressionBrackets) {
                ei.value = ((SQLExpressionBrackets)ei.value).lExpression;
            }
            result = ei.value != null && ei.value instanceof SQLExpressionLogicalCollection;
        } else {
            ei.value = null;
        }
        return result;
    }

    private static SQLExpressionLogicalCollection moveNotInLogicalCollection(SQLExpressionNot expressionNot, SQLExpressionLogicalCollection collection) {
        SQLExpressionLogicalCollection result = collection instanceof SQLExpressionAnd ? new SQLExpressionOr(collection.getSQLContext()) : new SQLExpressionAnd(collection.getSQLContext());
        result.takeItemsFrom(collection, true);
        expressionNot.dispose();
        return result;
    }

    private static void processItems(SQLExpressionLogicalCollection collection) {
        for (int i = collection.getCount() - 1; i >= 0; --i) {
            SQLExpressionItem ei = collection.extract(i);
            if ((ei = Helpers.simplifyLogicalExpression(ei)) == null) continue;
            if (ei instanceof SQLExpressionLogicalCollection && ei.getClass() == collection.getClass()) {
                for (int j = ((SQLExpressionLogicalCollection)ei).getCount() - 1; j >= 0; --j) {
                    collection.insert(i, ((SQLExpressionLogicalCollection)ei).extract(j));
                }
                ei.dispose();
                continue;
            }
            collection.insert(i, ei);
        }
    }

    public static void removeBracketsInAndExpression(SQLExpressionAnd and) {
        for (int i = 0; i < and.getCount(); ++i) {
            SQLExpressionItem ei = and.get(i);
            SQLExpressionItem ei2 = Helpers.expressionRemoveBrackets(ei);
            if (ei2 instanceof SQLExpressionOr || ei == (ei2 = Helpers.expressionExtractFromBrackets(ei))) continue;
            and.set(i, ei2);
        }
    }

    public static void removeBracketsInORExpression(SQLExpressionOr or) {
        for (int i = 0; i < or.getCount(); ++i) {
            SQLExpressionItem ei2;
            SQLExpressionItem ei = or.get(i);
            if (ei != (ei2 = Helpers.expressionExtractFromBrackets(ei))) {
                or.set(i, ei2);
            }
            if (!(ei2 instanceof SQLExpressionAnd)) continue;
            Helpers.removeBracketsInAndExpression((SQLExpressionAnd)ei2);
        }
    }

    public static int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static String extractQuotedIdentifier(String identifier, String quoteBegin, String quoteEnd) {
        assert (!Str.IsNullOrEmpty(identifier));
        assert (!Str.IsNullOrEmpty(quoteBegin) && quoteBegin.length() == 1);
        assert (!Str.IsNullOrEmpty(quoteEnd) && quoteEnd.length() == 1);
        StringBuilder sb = new StringBuilder();
        if (identifier.charAt(0) == quoteBegin.charAt(0)) {
            for (int i = 1; i < identifier.length() - 1; ++i) {
                sb.append(identifier.charAt(i));
                if (identifier.charAt(i) != quoteEnd.charAt(0) || identifier.charAt(i + 1) != quoteEnd.charAt(0)) continue;
                ++i;
            }
        } else {
            sb.append(identifier);
        }
        return sb.toString();
    }

    public static String createQuotedIdentifier(String identifier, String quoteBegin, String quoteEnd) {
        assert (!Str.IsNullOrEmpty(identifier)) : "identifier should not be empty";
        return quoteBegin + identifier.replace(quoteEnd, quoteEnd + quoteEnd) + quoteEnd;
    }

    public static Class autodetectSyntaxProvider(BaseMetadataProvider metadataProvider) {
        BaseSyntaxProvider sp = null;
        if (metadataProvider != null && metadataProvider.canExecSQL()) {
            ArrayList<Class> maybeSupportList = new ArrayList<Class>();
            for (int i = 0; i < syntaxProviderList.getCount(); ++i) {
                if (syntaxProviderList.get(i) == AutoSyntaxProvider.class) continue;
                try {
                    sp = (BaseSyntaxProvider)syntaxProviderList.get(i).newInstance();
                    SyntaxSupportsConectedServer support = sp.isSupportConectedServer(metadataProvider);
                    if (support == SyntaxSupportsConectedServer.Yes) {
                        return syntaxProviderList.get(i);
                    }
                    if (support != SyntaxSupportsConectedServer.Maybe) continue;
                    maybeSupportList.add(syntaxProviderList.get(i));
                    sp = null;
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(Helpers.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (maybeSupportList.size() > 0) {
                return (Class)maybeSupportList.get(0);
            }
        }
        return null;
    }

    public static boolean isValueLikeObject(Object value, Object obj) {
        assert (!(value instanceof Array));
        if (obj instanceof String[]) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                if (!value.toString().equals(Array.get(obj, i).toString())) continue;
                return true;
            }
        } else if (obj != null && value != null) {
            return value.toString().equals(obj.toString());
        }
        return false;
    }

    public static boolean tryStrToInt(String s, Wrapper<Integer> value) {
        boolean result = true;
        try {
            value.value = Integer.parseInt(s);
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static ImageIcon createImageIcon(String path) {
        URL imgURL = QueryBuilder.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static int getTypeIndex(MetadataObject mo) {
        if (mo instanceof MetadataTable) {
            return 0;
        }
        if (mo instanceof MetadataView) {
            return 1;
        }
        if (mo instanceof MetadataProcedure) {
            return 2;
        }
        if (mo instanceof MetadataSynonym) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public static int compareObjectTypes(MetadataObject mo1, MetadataObject mo2) {
        if (mo1.getClass() == mo2.getClass()) {
            return 0;
        }
        if (Helpers.getTypeIndex(mo1) < Helpers.getTypeIndex(mo2)) {
            return -1;
        }
        return 1;
    }

    public static String shortenQuery(String s) {
        String result = s.replaceAll("SELECT ", "SEL ");
        if ((result = result.replaceAll(" FROM ", " FRM ")).length() > 25) {
            result = result.substring(0, 25) + " ...";
        }
        return result;
    }

    public static int[] getXPoints(Point[] line) {
        int[] xx = new int[line.length];
        for (int i = 0; i < line.length; ++i) {
            xx[i] = line[i].x;
        }
        return xx;
    }

    public static int[] getYPoints(Point[] line) {
        int[] yy = new int[line.length];
        for (int i = 0; i < line.length; ++i) {
            yy[i] = line[i].y;
        }
        return yy;
    }

    public static JMenuItem makeMenuItem(ActionListener actionListener, String command) {
        JMenuItem item = new JMenuItem(command);
        item.addActionListener(actionListener);
        return item;
    }

    public static String unquoteString(String s) {
        if (s != null && !s.isEmpty() && (s.startsWith("'") || s.startsWith("\""))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String metadataRelationCardinalityToString(MetadataRelationCardinality value) {
        switch (value) {
            case Unknown: {
                return "";
            }
            case One: {
                return "1";
            }
            case Many: {
                return "*";
            }
        }
        return "";
    }

    public static MetadataRelationCardinality stringToMetadataRelationCardinality(String value) {
        String tmp = value.trim();
        if (tmp.equals("1")) {
            return MetadataRelationCardinality.One;
        }
        if (tmp.equals("*")) {
            return MetadataRelationCardinality.Many;
        }
        return MetadataRelationCardinality.Unknown;
    }

    public static void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error attempting to launch web browser:\n" + e.getLocalizedMessage());
        }
    }

    public static String getFileExtension(String name) {
        String ext = null;
        int i = name.lastIndexOf(46);
        if (i > 0 && i < name.length() - 1) {
            ext = name.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isQueryEmpty(SQLSelectStatement selectStatementAst) {
        if (null == selectStatementAst) {
            return true;
        }
        if (selectStatementAst.getCount() == 1 && selectStatementAst.get(0) instanceof SQLSubQuerySelectExpression) {
            SQLSubQuerySelectExpression ssqse = (SQLSubQuerySelectExpression)selectStatementAst.get(0);
            if (!(ssqse.selectItems == null || ssqse.selectItems.getCount() != 0 && (ssqse.selectItems.getCount() != 1 || !(ssqse.selectItems.get(0) instanceof SQLSelectItemAllColumns)) || ssqse.from != null && ssqse.from.getCount() != 0 || selectStatementAst.withClause != null && selectStatementAst.withClause.getCount() != 0)) {
                return true;
            }
        }
        return false;
    }

    public static AstToken extractNameFromFullName(SQLQualifiedName name) {
        if (!Helpers.isQualifiedNameEmpty(name) && !name.get(0).isEmpty()) {
            return name.get(0).clone(name.getSQLContext());
        }
        return null;
    }

    public static AstToken extractSchemaFromFullName(SQLQualifiedName name) {
        if (name.getSQLContext().getSyntaxProvider() == null) {
            throw new QueryBuilderException(localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        }
        if (!Helpers.isQualifiedNameEmpty(name) && name.getSQLContext().getSyntaxProvider().isSupportSchemas() && name.getCount() > 1 && !name.get(1).isEmpty()) {
            return name.get(1).clone(name.getSQLContext());
        }
        return null;
    }

    public static SQLQualifiedName extractDatabaseFromFullName(SQLQualifiedName name) {
        if (!Helpers.isQualifiedNameEmpty(name)) {
            SQLQualifiedName result = name.clone(name.getSQLContext());
            if (result.getCount() >= 1) {
                result.extractName().dispose();
            }
            if (result.getSQLContext().getSyntaxProvider().isSupportSchemas() && result.getCount() >= 1) {
                result.extractName().dispose();
            }
            if (Helpers.isQualifiedNameEmpty(result)) {
                result.dispose();
                result = null;
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLQualifiedNameList generatePossibleFullNamesList(SQLQualifiedName name) {
        assert (!Helpers.isQualifiedNameEmpty(name));
        BaseSQLContext sqlcontext = name.getSQLContext();
        SQLQualifiedNameList result = new SQLQualifiedNameList(sqlcontext);
        AstToken nm = Helpers.extractNameFromFullName(name);
        try {
            AstToken sch = Helpers.extractSchemaFromFullName(name);
            try {
                SQLQualifiedName db = Helpers.extractDatabaseFromFullName(name);
                try {
                    if (db == null) {
                        db = sqlcontext.getMetadataContainer().getDefaultDatabaseName().clone(sqlcontext);
                    }
                    result.add(name.clone(sqlcontext));
                    if (sqlcontext.getSyntaxProvider().isSupportSchemas()) {
                        if (sch == null) {
                            SQLIdentifiersCollection defSchemas = sqlcontext.getMetadataContainer().getDefaultSchemaNames();
                            for (int i = 0; i < defSchemas.getCount(); ++i) {
                                SQLQualifiedName qn = db.clone(sqlcontext);
                                qn.addName(defSchemas.get(i).clone(sqlcontext));
                                qn.addName(nm.clone(sqlcontext));
                                result.add(qn);
                            }
                        } else {
                            SQLQualifiedName qn = db.clone(sqlcontext);
                            qn.addName(sch.clone(sqlcontext));
                            qn.addName(nm.clone(sqlcontext));
                            result.add(qn);
                        }
                    } else {
                        SQLQualifiedName qn = db.clone(sqlcontext);
                        qn.addName(nm.clone(sqlcontext));
                        result.add(qn);
                    }
                }
                finally {
                    if (db != null) {
                        db.dispose();
                    }
                }
            }
            finally {
                if (sch != null) {
                    sch.dispose();
                }
            }
        }
        finally {
            nm.dispose();
        }
        return result;
    }

    public static SQLExpressionOperatorBinary expressionGetTompostBinaryOperator(SQLExpressionItem expression) {
        SQLExpressionItem ei = Helpers.expressionRemoveBrackets(expression);
        if (ei != null && ei instanceof SQLExpressionOperatorBinary) {
            return (SQLExpressionOperatorBinary)ei;
        }
        return null;
    }

    public static int skipSeparators(String str, int index) {
        while (index < str.length() && (str.charAt(index) < '0' || str.charAt(index) > '9')) {
            ++index;
        }
        return index;
    }

    public static String getDigits(String str, int index) {
        String result = "";
        while (index < str.length() && str.charAt(index) >= '0' && str.charAt(index) <= '9') {
            result = result + str.charAt(index);
            ++index;
        }
        return result;
    }

    public static boolean arrayContains(Object array, Object value) {
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (!Array.get(array, i).equals(value)) continue;
            return true;
        }
        return false;
    }

    static {
        defaultLinkPainter = new LinkPainterAccess(null);
        linkPainterList = new LinkPainters();
        TFieldTypeConversionHelper = new int[]{1111, 12, 5, 4, 5, 16, 6, 3, 3, 91, 92, 93, -2, -3, 4, 2004, 2005, 2004, 2005, 1111, 1111, -2, 1111, 1, -9, -5, 1111, 2003, 2006, 1111, 2004, 2005, 1111, 1111, 1111, 1111, 93, 3};
        DbTypeConversionHelper = new HashMap<String, Integer>(){
            {
                this.put("AnsiString", 12);
                this.put("Binary", -2);
                this.put("Byte", -6);
                this.put("Boolean", 16);
                this.put("Currency", 3);
                this.put("Date", 91);
                this.put("DateTime", 93);
                this.put("Decimal", 3);
                this.put("Double", 8);
                this.put("Guid", -2);
                this.put("Int16", 5);
                this.put("Int32", 4);
                this.put("Int64", -5);
                this.put("Object", 1111);
                this.put("SByte", -2);
                this.put("Single", 6);
                this.put("String", -9);
                this.put("Time", 92);
                this.put("UInt16", 5);
                this.put("UInt32", 4);
                this.put("UInt64", -5);
                this.put("VarNumeric", 2);
                this.put("AnsiStringFixedLength", 1);
                this.put("StringFixedLength", -15);
                this.put("Xml", 2005);
                this.put("DateTime2", 93);
                this.put("DateTimeOffset", 93);
            }
        };
        syntaxProviderList.registerSyntaxProvider(AutoSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(DB2SyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(FirebirdSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(InformixSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(AccessSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(MSSQLSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(MySQLSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(OracleSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(PostgreSQLSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(SQL2003SyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(SQL89SyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(SQL92SyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(SQLiteSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(SybaseSyntaxProvider.class);
        syntaxProviderList.registerSyntaxProvider(UniversalSyntaxProvider.class);
        Helpers.sortTypeNames[ItemSortType.None.ordinal()] = "";
        Helpers.sortTypeNames[ItemSortType.Asc.ordinal()] = localizer.getString("strSortTypeAscending", "Ascending");
        Helpers.sortTypeNames[ItemSortType.Desc.ordinal()] = localizer.getString("strSortTypeDescending", "Descending");
        Helpers.conditionTypes[ConditionType.None.ordinal()] = "";
        Helpers.conditionTypes[ConditionType.Where.ordinal()] = localizer.getString("strConditionTypeWhere", "For values");
        Helpers.conditionTypes[ConditionType.Having.ordinal()] = localizer.getString("strConditionTypeHaving", "For groups");
        linkPainterList.registerPainter(LinkPainterSimple.class);
        linkPainterList.registerPainter(LinkPainterMSSQL.class);
        linkPainterList.registerPainter(LinkPainterAccess.class);
        accessLinkCardinality1 = Helpers.createImageIcon("images/cardinalityone.png");
        accessLinkCardinalityMany = Helpers.createImageIcon("images/cardinalitymany.png");
    }

    public static enum ListAssignOp {
        Copy,
        And,
        Or,
        Xor,
        SrcUnique,
        DestUnique;

    }
}

